<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Transaction extends ROCKERS_Controller

{
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('equity_model');
        $this->load->model('equity_model');
        $this->load->model('follower_model');
        $this->load->model('following_model');
        $this->load->model('transaction_model');
        $this->load->library('securimage');
        $this->load->library('pagination');
        $this->load->helper('download');
        $this->load->model('account_model');
        $this->load->model('repayment_model');
         $this->load->model('startequity_model');
          $this->load->model('investment_step_model');
    }

    /*
    Function name :index()
    Parameter :No parameter
    Return : none
    Use : this is used in transaction_history page
     will show you list of transaction
    */
    function index()
    {
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        if ($site_setting['payment_gateway'] == 0) {
            redirect('home/main_dashboard');
        }
        $user_id = check_user_authentication(true);
        $limit = 25;
        $offset = 0;
        $meta = meta_setting();

        $user_id = $this->session->userdata('user_id');
        $email = '';
        $category_id = '';
        $equity = '';
        $status = '';
        if (isset($_SESSION['search_variable'])) unset($_SESSION['search_variable']);
        $email = SecurePostData($this->input->post('email'));
        $category_id = SecurePostData($this->input->post('category_id'));
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $status = SecurePostData($this->input->post('status'));
        if ($category_id == 'Project') {
            $file_name_transaction = 'tran_equity_' . $user_id;
        } elseif ($category_id == 'Email') {
            $file_name_transaction = 'tran_email_' . $user_id;
        } elseif ($category_id == 'Status') {
            $file_name_transaction = 'tran_status_' . $user_id;
        } else {
            $file_name_transaction = 'transaction_' . $user_id;
        }
        $search_criteria = array(
            'email' => $email,
            'status' => $status,
            'equity_id' => $equity_id
        );
        $file_name = $file_name_transaction;
        $data['file_name'] = $file_name_transaction;
        $data['email'] = $email;
        $data['category_id'] = $category_id;
        $data['equity_id'] = $equity_id;
        $data['status'] = $status;
        $totalRows = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), 0, $order = array(
            'transaction_id' => 'desc'
        ), 'company_name', $search_criteria, 0, 'yes', 'yes', 'on_equity_donation');
        $data['limit'] = $limit;
        $data['totalRows'] = $totalRows;
        $varaible = base64_encode($email . "/" . $category_id . "/" . $equity_id . "/" . $status);
        $_SESSION['search_variable'] = $varaible;
        $config['base_url'] = site_url('transaction/trans_list/');
        $config['total_rows'] = $totalRows;
        $config['per_page'] = $limit;
        $this->pagination->initialize($config);
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();
        $this->pagination->initialize_js_function($jsFunction);
        $data['base_url'] = $config['base_url'];
        $data['page_link'] = $this->pagination->create_js_links();

        $data['donation_on_my_equity'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit, $order = array(
            'transaction_id' => 'desc'
        ), 'company_name', $search_criteria, $offset, '', 'yes', 'on_equity_donation');


        $donation_on_equity_data = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), 0, $order = array(
            'company_name' => 'asc'
        ), 'company_name', $search_criteria, $offset, '', 'yes', 'on_equity_donation');
        if ($donation_on_equity_data) {
            // code to write to the csv file....
            $fichier = base_path() . "upload/user/user_docs/" . $file_name . ".csv";

            $fp = fopen($fichier, 'w');
            fputcsv($fp, array(
                'Date Of Transaction',
                'Project Name',
                'Amount',
                'Service Fees',
            ));
            foreach ($donation_on_equity_data as $donation_on_mine_equity) {
                $equity_date_time = dateformat($donation_on_mine_equity['transaction_date_time']);

               
                $transaction_id = $donation_on_mine_equity['transaction_id'];
                $preapproval_status = $donation_on_mine_equity['preapproval_status'];
                if ($preapproval_status == "") $preapproval_status = $donation_on_mine_equity['preapproval_status'];
                if ($donation_on_mine_equity['amount'] > 0) {
                    $amount = set_currency($donation_on_mine_equity['amount'], '');
                } else {
                    $amount = set_currency(0, '');
                }
                $pay_fee = set_currency($donation_on_mine_equity['pay_fee'], '');
                $company_name = $donation_on_mine_equity['company_name'];
                $equity_url = $donation_on_mine_equity['equity_url'];
                $equity_id = $donation_on_mine_equity['equity_id'];
                $perk_title = SecureShowData($donation_on_mine_equity['perk_title']);
                $preapproval_key = $donation_on_mine_equity['preapproval_key'];
                
               
                $equity_user_id = $donation_on_mine_equity['user_id'];
                $equity_funder_name = '';
                if ($equity_user_id > 0) $equity_funder_name = $donation_on_mine_equity['user_name'] . ' ' . $donation_on_mine_equity['last_name'];

                $tr_type = "Dr";
                $sign = '+';
                if ($this->session->userdata('user_id') == $donation_on_mine_equity['donor_id']) {
                    $tr_type = "Cr";
                    $sign = '-';
                    $email = $donation_on_mine_equity['email'];
                }
                $array = array(
                    'ON_HOLD' => 'Pending',
                    'FAIL' => 'Fail',
                    'SUCCESS' => 'Success'
                );
                $preapproval_status = ($donation_on_mine_equity['preapproval_status'] != "") ? $array[$donation_on_mine_equity['preapproval_status']] : "";
                // write data into the csv file...
//				));
                fputcsv($fp, array(
                    $equity_date_time,
                    $company_name,
                    $sign . ' ' . $amount,
                    $pay_fee,
                ));
            }
            // close the csv file after write operation is complete...
            fclose($fp);
        }

        $data['get_email'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit, $order = array(
            'transaction_id' => 'desc'
        ), '', '', $offset, '', '', 'on_equity_donation');

        ///////////////display all seperately entry/////////////////
        $show_transaction_details = $this->transaction_model->TransactionHistory('', '', $equity_id, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), 0, $order = array(
            'transaction_id' => 'desc'
        ), '', '', 0);
        $data['donation_equity'] = $show_transaction_details;
        ///////////////////////////////////////////////////////////
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'transaction/index', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    function my_donation()
    {

        redirect('transaction/my_investment/');
    }

    
    /*
    Function name :my_donation()
    Parameter :No parameter
    Return : none
    Use : this is used in transaction_history page
         list of transaction on which logged in user  made donation
     */
    function my_investment()
    {
        $user_id = check_user_authentication(true);
        $limit = 25;
        $offset = 0;
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $payment_gateway = $site_setting['payment_gateway'];

        $user_id = $this->session->userdata('user_id');
        $email = '';
        $category_id = '';
        $equity = '';
        $status = '';
        if (isset($_SESSION['search_variable'])) unset($_SESSION['search_variable']);
        $email = SecurePostData($this->input->post('email'));
        $category_id = SecurePostData($this->input->post('category_id'));
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $status = SecurePostData($this->input->post('status'));
        if ($category_id == PROJECT && $equity_id!='') {
            $file_name_transaction = 'my-investment-on-project-';
        } elseif ($category_id == 'Email') {
            $file_name_transaction = 'investment' . $user_id;
        } elseif ($category_id == 'Status') {
            $file_name_transaction = 'investment' . $user_id;
        } else {
            $file_name_transaction = 'investment_' . $user_id;
        }
        $search_criteria = array(
            'email' => $email,
            'status' => $status,
            'equity_id' => $equity_id
        );
        $file_name = $file_name_transaction;
        $data['file_name'] = $file_name_transaction;
        $data['email'] = $email;
        $data['category_id'] = $category_id;
        $data['equity_id'] = $equity_id;
        $data['status'] = $status;
        $totalRows = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), 0, $order = array(
            'transaction_id' => 'desc'
        ), 'company_name', $search_criteria, 0, 'yes', 'yes', 'my_donation');
        $data['limit'] = $limit;
        $data['totalRows'] = $totalRows;
        $varaible = base64_encode($email . "/" . $category_id . "/" . $equity_id . "/" . $status);
        $_SESSION['search_variable'] = $varaible;
        $config['base_url'] = site_url('transaction/trans_list_donation/');
        $config['total_rows'] = $totalRows;
        $config['per_page'] = $limit;
        $this->pagination->initialize($config);
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();
        $this->pagination->initialize_js_function($jsFunction);
        $data['base_url'] = $config['base_url'];
        $data['page_link'] = $this->pagination->create_js_links();

        $data['donation_on_my_equity'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '2,3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit, $order = array(
            'transaction_id' => 'desc'
        ), 'transaction.equity_id', $search_criteria, $offset, '', 'yes', 'my_donation');
        $data['decimal_points'] = $site_setting['decimal_points'];
         $data['donation_on_my_equity_dropdown'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '2,3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), '', $order = array(
            'transaction_id' => 'desc'
        ), 'transaction.equity_id', '', $offset, '', 'yes', 'my_donation');

        
      
        
        $donation_on_equity_data = $this->transaction_model->TransactionHistory_download(0, $user_id, 0, '2,3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), 1000, $order = array(
            'company_name' => 'asc'
        ), '', $search_criteria, $offset, '', '', 'my_donation');
        // echo '<pre>';
        // var_dump($donation_on_equity_data);die;
        if ($donation_on_equity_data) {
            // code to write to the csv file....
            $fichier = base_path() . "upload/user/user_docs/" . $file_name . ".csv";


            $fp = fopen($fichier, 'w');
            fputcsv($fp, array(
                DATE,
                PROJECT,
                PROJECT.' '.STATUS,
                EMAIL,
                PERKS,
                AMOUNT,
                TRANSACTION_ID,
                STATUS,


            ));
            foreach ($donation_on_equity_data as $donation_on_mine_equity) {
                $equity_date_time = dateformat($donation_on_mine_equity['transaction_date_time']);
                // $email=$donation_on_mine_equity['paypal_email'];
                $email = $donation_on_mine_equity['email'];
                $transaction_id = $donation_on_mine_equity['transaction_id'];
                $equity_id = $donation_on_mine_equity['equity_id'];
                $preapproval_status = $donation_on_mine_equity['preapproval_status'];
                if ($preapproval_status == "") $preapproval_status = $donation_on_mine_equity['preapproval_status'];
                if ($donation_on_mine_equity['preapproval_total_amount'] > 0) {
                    $amount = set_currency($donation_on_mine_equity['preapproval_total_amount'], $equity_id);
                } else {
                    $amount = set_currency(0, $equity_id);
                }
                
               
                
                $pay_fee = set_currency($donation_on_mine_equity['pay_fee'], '');
                $company_name = SecureShowData($donation_on_mine_equity['company_name']);
                $equity_url = $donation_on_mine_equity['equity_url'];
                $equity_id = $donation_on_mine_equity['equity_id'];
                $perk_title = SecureShowData($donation_on_mine_equity['perk_title']);
                if($perk_title=='') $perk_title='N/A';
                $status = $donation_on_mine_equity['status'];
                $equity_status = status_name($status);
                $preapproval_key = $donation_on_mine_equity['preapproval_key'];

                $equity_user_id = $donation_on_mine_equity['user_id'];
                $equity_funder_name = '';

                if ($equity_user_id > 0) $equity_funder_name = $donation_on_mine_equity['user_name'] . ' ' . $donation_on_mine_equity['last_name'];

                $tr_type = "Dr";
                $sign = '+';
                if ($this->session->userdata('user_id') == $donation_on_mine_equity['donor_id']) {
                    $tr_type = "Cr";
                    $sign = '-';
                    $email = $donation_on_mine_equity['email'];
                }
                $array = getTranesctionStatusArray();
                $preapproval_status = ($donation_on_mine_equity['preapproval_status'] != "") ? $array[$donation_on_mine_equity['preapproval_status']] : "";
                // write data into the csv file...
                fputcsv($fp, array(
                    $equity_date_time,
                    $company_name,
                    $equity_status,
                    $email,
                    $perk_title,
                    $amount,
                    $preapproval_key,
                    $preapproval_status,

                ));
            }
            // close the csv file after write operation is complete...
            fclose($fp);
        }
        
        
       
        
        $data['get_email'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit, $order = array(
            'transaction_id' => 'desc'
        ), '', '', $offset, '', '', 'my_donation');
        
        
        
        //==
        
        //==


        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'transaction/tran_my_donation', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }
    
     function investment_document($equity_id=0,$equity_investment_process_id='')
    {
        $user_id = check_user_authentication(true);
        $limit = 2500;
        $offset = 0;
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $payment_gateway = $site_setting['payment_gateway'];
        $data['equity_id'] = $equity_id;
        
        $user_id = $this->session->userdata('user_id');
        $equity_data = GetOneEquity($equity_id);
        $data['result'] = $equity_data;
        $equity_file_gallery_data = $this->startequity_model->equity_file_gallery_data($equity_id);
        $data['equity_file_gallery_data'] = $equity_file_gallery_data;
        $where = array('id'=>$equity_investment_process_id,'user_id' => $user_id,'equity_id' => $equity_id );
        $investor_doc = $this->investment_step_model->get_equity_process('equity_investment_process', $where);
         $data['document_name'] =  $investor_doc['document_name'];
         $data['acknowledge_doc'] = $investor_doc['acknowledge_doc']; 
            $data['document_verified'] = $investor_doc['document_verified']; 
             $data['equity_investment_process_id'] = $investor_doc['id']; 
              // $data['id'] = $investor_doc['id']; 
         // var_dump($investor_doc); die;
         // var_dump($equity_investment_process_id);
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'transaction/investment_document', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }
     function send_document($equity_id=0,$type='')
    {
        $user_id = check_user_authentication(true);
        $limit = 2500;
        $offset = 0;
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $payment_gateway = $site_setting['payment_gateway'];
        $data['equity_id'] = $equity_id;
        
        $user_id = $this->session->userdata('user_id');
        $result = GetOneEquity($equity_id);
        $data['result'] = $result;
        $equity_file_gallery_data = $this->startequity_model->equity_file_gallery_data($equity_id);
        $data['equity_file_gallery_data'] = $equity_file_gallery_data;
        $where = array('user_id' => $user_id,'equity_id' => $equity_id );
        $investor_doc = $this->investment_step_model->get_equity_process('equity_investment_process', $where);
         $data['document_name'] =  $investor_doc['document_name'];
         $data['acknowledge_doc'] = $investor_doc['acknowledge_doc']; 
         $attache_file='';
       switch ($type) 
       {
            case "5":
                    $attache_file = base_url() . "upload/equity/investor/" . $result['contract_copy_file'];
                    break;
            case "10":
                    $attache_file = base_url() . "upload/equity/investor/" . $result['executive_summary_file'];
                    break;
            case "15":
                    $attache_file = base_url() . "upload/equity/investor/" . $result['term_sheet_file'];
                    break;
            case "20":
                    $attache_file = base_url('upload/doc/' . $investor_doc['document_name']);
                    break;   
            case "25":
                    $attache_file =  base_url('upload/doc/' . $investor_doc['acknowledge_doc']);
                    break; 
             default:
                        $arr=explode("_", $type);
                         foreach ($equity_file_gallery_data as $fg) 
                        {
                             $file_name = $fg['file_name'];
                              $id = $fg['id'];
                            $file_path = $fg['file_path'];
                            $file_status = $fg['status'];
                            if ($file_name != '') {
                                $fname = $file_name;
                            } else {
                                $fname = $file_path;
                            }
                            if($arr[1]==$id)$attache_file =  base_url('upload/equity/investor/' . $file_path);
                        }    
                    break;                                     
        }
        $template='Send Equity File';
        $click_here = '<a href="' . $attache_file . '" target="_blank">click here</a>';
        $user_details = UserData( $user_id);
        $user_name = $user_details[0]['user_name'].' '.$user_details[0]['last_name'];
        $user_email = $user_details[0]['email'];
                    $language_id = GetUserLangCode($user_id);
                    $email_template = $this->db->query("select * from `email_template` where task='".$template."' and language_id=".$language_id);

                    $email_temp = $email_template->row();

                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_subject = $email_temp->subject;
                    $email_message = $email_temp->message;
                    $email_to = $user_email;                   
                    $site_setting = site_setting();
                    $site_name = $site_setting['site_name'];
                    $taxonomy_setting = taxonomy_setting();
                    $project_name = $taxonomy_setting['project_name'];
                    $funds = $taxonomy_setting['funds'];

                    $email_subject = str_replace('{site_name}', $site_name, $email_subject);
                    $email_message = str_replace('{investor_name}', $user_name, $email_message);
                    $email_message = str_replace('{user_name}', $user_name, $email_message);
                    $email_message = str_replace('{funds}', $funds, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);
                    $email_message = str_replace('{click_here}', $click_here, $email_message);

                    $str = $email_message;
                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

                    echo "success";
    }
    
   function investment_dashboard()
    {
        $user_id = check_user_authentication(true);
        $limit = 2500;
        $offset = 0;
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $payment_gateway = $site_setting['payment_gateway'];
        
        $user_id = $this->session->userdata('user_id');
        $results = $this->repayment_model->investmentProfile(0, $user_id, 0, $join = array('equity','user'), $limit, $order = array('transaction_id' => 'desc'),$offset,"'SUCCESS'");
      // var_dump($this->db->last_query());die;
        $data['results'] = $results;

        
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'transaction/investment_dashboard', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }
    
    function investment_repayment($equity_id)
    {
        $user_id = check_user_authentication(true);
        $limit = 25;
        $offset = 0;
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $payment_gateway = $site_setting['payment_gateway'];
        $result = GetOneEquity($equity_id);
        $data['company_name'] = $result['company_name'];
        $return_term_length = $result['return_term_length'];
        $return_investment_interest = $result['return_investment_interest'];
        $amount_get = $result['amount_get'];
        $data['equity_id'] = $equity_id;
        $user_id = $this->session->userdata('user_id');
        $results = $this->repayment_model->investmentProfile(0, $user_id, $equity_id, $join = array('equity','user','repayments_distribution'), $limit, $order = array('transaction_id' => 'desc'),$offset,"'SUCCESS'");

        $data['results'] = $results;

        $rePaymentsPaid = $this->repayment_model->getSumDistributionDetailsByuser($equity_id,"'SUCCESS'",$this->session->userdata('user_id'));        
        if( $rePaymentsPaid['system_calculated']>0)
        {
            $total_sum= $rePaymentsPaid['system_calculated'];
         }
         if( $rePaymentsPaid['inprogress']>0)
         {
            $total_distibuted= $rePaymentsPaid['inprogress'];
          }
                    
         $next_due_date =  $this->repayment_model->calculateNextDistributionDate($equity_id);
          $data['next_due_date'] = $next_due_date;
          $data['total_sum'] = $total_sum;
          $data['total_distibuted'] = $total_distibuted;
        if($return_term_length>0){
            $data['next_payment'] = ($return_investment_interest*$amount_get/100)/$return_term_length;  
        }else{
            $data['next_payment'] =0;
        }
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'transaction/investment_repayment', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }
    
    
     /*
    Function name :runningprocess()
    Parameter :No parameter
    Return : none
    Use : this is used in current running investor process page
         list of running investor process on which logged in user made donation
     */
    function runningprocess(){
        
        $user_id = check_user_authentication(true);
        $limit = 25;
        $offset = 0;
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $payment_gateway = $site_setting['payment_gateway'];

        $user_id = $this->session->userdata('user_id');
        $email = '';
        $category_id = '';
        $equity = '';
        $status = '';
        if (isset($_SESSION['search_variable'])) unset($_SESSION['search_variable']);
        $email = SecurePostData($this->input->post('email'));
        $category_id = SecurePostData($this->input->post('category_id'));
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $status = SecurePostData($this->input->post('status'));
       
        $search_criteria = array();
     
        $data['file_name'] = '';
        $data['email'] = $email;
        $data['category_id'] = $category_id;
        $data['equity_id'] = $equity_id;
        $data['status'] = $status;
        $totalRows = $this->transaction_model->InvestorRunningProcessHistory($user_id, 0, '2,3', $join = array(
            'user',
            'equity',
            'perk'
        ), 0, $order = array(
            'equity_investment_process.created_date' => 'desc',
            'equity_investment_process.id' => 'desc'
        ), '', $search_criteria, 0, 'yes', 'my_donation');
        
       
        
        $data['limit'] = $limit;
        $data['totalRows'] = $totalRows;
        $varaible = base64_encode($email . "/" . $category_id . "/" . $equity_id . "/" . $status);
        $_SESSION['search_variable'] = $varaible;
        $config['base_url'] = site_url('transaction/trans_list_donation/');
        $config['total_rows'] = $totalRows;
        $config['per_page'] = $limit;
        $this->pagination->initialize($config);
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();
        $this->pagination->initialize_js_function($jsFunction);
        $data['base_url'] = $config['base_url'];
        $data['page_link'] = $this->pagination->create_js_links();

        $data['my_running_investor_process'] = $this->transaction_model->InvestorRunningProcessHistory($user_id, 0, '2,3', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit, $order = array(
            'equity_investment_process.created_date' => 'desc',
            'equity_investment_process.id' => 'desc'
        ), '', $search_criteria, $offset, 'no', 'my_donation');

        
        
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'transaction/running_investor_process', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
    Function name :tran_report_csv()
    Parameter :No parameter
    Return : none
    Use :Export to CSV
     */
    function tran_report_csv($file_name = '', $csv_equity = '')
    {
        $user_id = check_user_authentication(true);
        $data = file_get_contents(base_path() . "upload/user/user_docs/" . $file_name . ".csv");

        if (is_numeric($csv_equity) && $csv_equity != '') {
            $equity_data = GetOneEquity($csv_equity);
            $company_name = SecureShowData($equity_data['company_name']);
            $name = $company_name . "_" . date('d-m-Y') . ".csv";
        } elseif (is_string($csv_equity) && $csv_equity != '') {
            $name = $csv_equity . "_" . date('d-m-Y') . ".csv";
        } else {
            $name = $file_name . "_" . date('d-m-Y') . ".csv";
        }
        force_download($name, $data);
    }

    /*
    Function name :trans_list()
    Parameter :No parameter
    Return : none
    Use :List of transction which user's equity recieve donation
     */
    function trans_list($offset = 0)
    {
        $limit = 25;
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $user_id = $this->session->userdata('user_id');
        $email = '';
        $category_id = '';
        $equity_id = '';
        $status = '';
        $varaible = explode("/", base64_decode($_SESSION['search_variable']));
        if (is_array($varaible)) {
            if (isset($varaible[0])) $email = $varaible[0];
            if (isset($varaible[1])) $category_id = $varaible[1];
            if (isset($varaible[2])) $equity_id = $varaible[2];
            if (isset($varaible[3])) $status = $varaible[3];
        }

        $search_criteria = array(
            'email' => $email,
            'status' => $status,
            'equity_id' => $equity_id
        );

        $data['search_criteria'] = $search_criteria;
        $data['email'] = $email;
        $data['category_id'] = $category_id;
        $data['equity_id'] = $equity_id;
        $data['status'] = $status;
        $totalRows = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), 0, $order = array(
            'transaction_id' => 'desc'
        ), 'company_name', $search_criteria, 0, 'yes', 'yes', 'on_equity_donation');
        $config['base_url'] = site_url('transaction/trans_list/');
        $config['total_rows'] = $totalRows;
        $config['per_page'] = $limit;
        $this->pagination->initialize($config);
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();
        $this->pagination->initialize_js_function($jsFunction);
        $data['offset'] = $offset;
        $data['base_url'] = $config['base_url'];
        $data['page_link'] = $this->pagination->create_js_links();
        $data['donation_on_my_equity'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit, $order = array(
            'transaction_id' => 'desc'
        ), 'company_name', $search_criteria, $offset, '', 'yes', 'on_equity_donation');
        $data['allemails'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit = 1000, $order = array(
            'transaction_id' => 'desc'
        ), 'transaction.paypal_email', '', '', '', '', 'on_equity_donation');
        $data['allequitys'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit = 1000, $order = array(
            'transaction_id' => 'desc'
        ), 'equity.company_name', '', '', '', '', 'on_equity_donation');
        $this->load->view(THEME_LOCATION.'transaction/trans_list', $data);
    }

    /*
    Function name :trans_list_donation()
    Parameter :No parameter
    Return : none
    Use :List of transction which user made donation
     */
    function trans_list_donation($offset = 0)
    {
        $limit = 25;
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $user_id = $this->session->userdata('user_id');
        $email = '';
        $category_id = '';
        $equity_id = '';
        $status = '';
        $varaible = explode("/", base64_decode($_SESSION['search_variable']));
        if (is_array($varaible)) {
            if (isset($varaible[0])) $email = $varaible[0];
            if (isset($varaible[1])) $category_id = $varaible[1];
            if (isset($varaible[2])) $equity_id = $varaible[2];
            if (isset($varaible[3])) $status = $varaible[3];
        }

        $search_criteria = array(
            'email' => $email,
            'status' => $status,
            'equity_id' => $equity_id
        );

        $data['search_criteria'] = $search_criteria;
        $data['email'] = $email;
        $data['category_id'] = $category_id;
        $data['equity_id'] = $equity_id;
        $data['status'] = $status;
        $totalRows = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), 0, $order = array(
            'transaction_id' => 'desc'
        ), 'company_name', $search_criteria, 0, 'yes', 'yes', 'my_donation');
        $config['base_url'] = site_url('transaction/trans_list/');
        $config['total_rows'] = $totalRows;
        $config['per_page'] = $limit;
        $this->pagination->initialize($config);
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();
        $this->pagination->initialize_js_function($jsFunction);
        $data['offset'] = $offset;
        $data['base_url'] = $config['base_url'];
        $data['page_link'] = $this->pagination->create_js_links();
        $data['donation_on_my_equity'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit, $order = array(
            'transaction_id' => 'desc'
        ), 'company_name', $search_criteria, $offset, '', 'yes', 'my_donation');
        $data['allemails'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit = 1000, $order = array(
            'transaction_id' => 'desc'
        ), 'transaction.paypal_email', '', '', '', '', 'my_donation');
        $data['allequitys'] = $this->transaction_model->TransactionHistory(0, $user_id, 0, '3,4,5', $join = array(
            'user',
            'equity',
            'perk'
        ), $limit = 1000, $order = array(
            'transaction_id' => 'desc'
        ), 'equity.company_name', '', '', '', '', 'my_donation');
        $this->load->view(THEME_LOCATION.'transaction/trans_list', $data);
    }

    /*
    Function name :show_donation()
    Parameter :equity_id
    Return : none
    Use : This function is use to show the equity donation detail list in all currency.
    */
    function show_transaction_detail($trans_id = '')
    {
        $user_id = check_user_authentication(true);
        $show_transaction_details = $this->transaction_model->TransactionHistory($trans_id, $user_id, 0, '', $join = array(
            'user',
            'equity',
            'perk'
        ), 0, $order = array(
            'transaction_id' => 'desc'
        ), '', '', 0, '');
        $data['donation_on_mine_equity'] = $show_transaction_details[0];
        $this->template->front_write_view('main_content', 'transaction/show_transaction_detail', $data, TRUE);
        $this->template->render();
    }


    /*
    Function name :report()
    Parameter :No parameter
    Return : none
    Use : List of transaction with wallet withdraw list

    */
    function report($msg = '')
    {
        $user_id = $this->session->userdata('user_id');
        if ($user_id == '') {
            redirect('home/login');
        }
        $meta = meta_setting();
        if ($msg != '') {
            $data['msg'] = $msg;
            $data['tab'] = 'withdraw_amount';
        } else {
            $data['msg'] = '';
            $data['tab'] = '';
        }
        $data['site_setting'] = site_setting();
        $data['total_wallet_amt'] = wallet_amount();
        $data['withdraw_details'] = $this->transaction_model->my_withdraw_list($user_id);
        $data['wallet_details'] = $this->transaction_model->wallet_details();
        $data['error'] = '';
        $data['method'] = "";
        $data['amount'] = "";
        $data['withdraw_id'] = "";
        $data['bank_name'] = "";
        $data['bank_account_holder_name'] = "";
        $data['bank_account_number'] = "";
        $data['bank_branch'] = "";
        $data['bank_ifsc_code'] = "";
        $data['bank_address'] = "";
        $data['bank_city'] = "";
        $data['bank_state'] = "";
        $data['bank_country'] = "";
        $data['bank_zipcode'] = "";
        $data['cheque_bank_name'] = "";
        $data['cheque_account_holder_name'] = "";
        $data['cheque_bank_account_number'] = "";
        $data['cheque_bank_branch'] = "";
        $data['cheque_bank_ifsc_code'] = "";
        $data['cheque_bank_address'] = "";
        $data['cheque_bank_city'] = "";
        $data['cheque_bank_state'] = "";
        $data['cheque_bank_country'] = "";
        $data['cheque_bank_zipcode'] = "";
        $data['gateway_name'] = " ";
        $data['gateway_account'] = " ";
        $data['gateway_city'] = " ";
        $data['gateway_state'] = " ";
        $data['gateway_country'] = " ";
        $data['gateway_zip'] = " ";
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'transaction/tran_report', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
    Function name :detail()
    Parameter :ID
    Return : none
    Use :Show Transacion detail
     */
    function detail($id)
    {
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $data["trans_details"] = $this->transaction_model->transaction_details($id);
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'transaction/tran_detail', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();

    }

    /*
    Function name :withdraw_wallet()
    Parameter :No parameter
    Return : none
    Use :Request Wallet withdraw amount
     */
    function withdraw_wallet()
    {
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $data['msg'] = '';
        $user_id = $this->session->userdata('user_id');
        $wallet_setting = wallet_setting();
        $data['site_setting'] = site_setting();
        if ($wallet_setting->wallet_enable == 0) {
            redirect('home/main_dashboard');
        }
        if ($this->session->userdata('user_id') == '') {
            redirect('home/login');
        }
        $total_wallet_amount = $this->home_model->my_wallet_amount();
        $minimum_amount = $wallet_setting->wallet_minimum_amount;
        $chk_amt = SecurePostData($this->input->post('amount'));
        $own_amount_error = 'success';
        // =====check minimum amount
        if ($this->input->post('amount')) {
            if ($chk_amt > $total_wallet_amount) {
                $own_amount_error = 'fail';
            }
        }
        $amount_error = 'success';
        if ($this->input->post('amount')) {
            if ($chk_amt < $minimum_amount) {
                $amount_error = 'fail';
            }
        }
        $this->load->library('form_validation');
        $this->form_validation->set_rules('amount', "Amount", 'required');
        $this->form_validation->set_rules('method', "Withdraw method", 'required');
        if ($this->input->post('method') == 'bank') {
            $this->form_validation->set_rules('bank_name', "Bank name", 'required|alpha_space');
            $this->form_validation->set_rules('bank_account_holder_name', "Account holder name", 'required|alpha_space');
            $this->form_validation->set_rules('bank_account_number', "Bank account number", 'required|alpha_numeric');
            $this->form_validation->set_rules('bank_branch', "Bank branch", 'required|alpha_space');
            $this->form_validation->set_rules('bank_ifsc_code', "Bank IFSC code", 'required|alpha_numeric');
            $this->form_validation->set_rules('bank_address', "Bank address", 'required');
            $this->form_validation->set_rules('bank_city', "Bank city", 'required|alpha_space');
            $this->form_validation->set_rules('bank_state', "Bank state", 'required|alpha_space');
            $this->form_validation->set_rules('bank_country', "Bank country", 'required|alpha_space');
            $this->form_validation->set_rules('bank_zipcode', "Bank zipcode", 'required|numeric');
        }
        if ($this->input->post('method') == 'cheque') {
            $this->form_validation->set_rules('cheque_bank_name', "Bank name", 'required|alpha_space');
            $this->form_validation->set_rules('cheque_account_holder_name', "Account holder name", 'required|alpha_space');
            $this->form_validation->set_rules('cheque_bank_account_number', "Bank account number", 'required|alpha_numeric');
            $this->form_validation->set_rules('cheque_bank_branch', "Bank branch", 'required|alpha_space');
            $this->form_validation->set_rules('cheque_bank_ifsc_code', "Bank IFSC code", 'required|alpha_numeric');
            $this->form_validation->set_rules('cheque_bank_address', "Bank address", 'required');
            $this->form_validation->set_rules('cheque_bank_city', "Bank city", 'required|alpha_space');
            $this->form_validation->set_rules('cheque_bank_state', "Bank state", 'required|alpha_space');
            $this->form_validation->set_rules('cheque_bank_country', "Bank country", 'required|alpha_space');
            $this->form_validation->set_rules('cheque_bank_zipcode', "Bank zipcode", 'required|numeric');
        }
        if ($this->input->post('method') == 'gateway') {
            $this->form_validation->set_rules('gateway_name', "Gateway name", 'required|alpha_space');
            $this->form_validation->set_rules('gateway_account', "Gateway account", 'required');
            $this->form_validation->set_rules('gateway_city', "Gateway city", 'required|alpha_space');
            $this->form_validation->set_rules('gateway_state', "Gateway state", 'required|alpha_space');
            $this->form_validation->set_rules('gateway_country', "Gateway country", 'required|alpha_space');
            $this->form_validation->set_rules('gateway_zip', "Gateway zip", 'required|numeric');
        }
        if ($this->form_validation->run() == FALSE || $amount_error == 'fail' || $own_amount_error == 'fail') {
            if ($amount_error == 'fail') {
                $amount_error = "<p>" . sprintf("Wallet cant't add amount less than minimum amount", set_currency($minimum_amount)) . "</p>";
            } else {
                $amount_error = '';
            }
            if ($own_amount_error == 'fail') {
                $own_error = "<p>" . sprintf("Wallet withdraw request amount can't be greater than earn amount or total wallet amount", set_currency($total_wallet_amount)) . "</p>";
            } else {
                $own_error = '';
            }
            if (validation_errors() || $amount_error != '' || $own_error != '') {
                $data['error'] = validation_errors() . $amount_error . $own_error;
            } else {
                $data["error"] = "";
            }
            $data['total_wallet_amount'] = $this->home_model->my_wallet_amount();
            $data['wallet_setting'] = wallet_setting();
            if ($_POST) {
                $data['amount'] = SecurePostData($this->input->post('amount'));
                $data['method'] = SecurePostData($this->input->post('method'));
                $data['withdraw_id'] = SecurePostData($this->input->post('withdraw_id'));
                $data['bank_name'] = SecurePostData($this->input->post('bank_name'));
                $data['bank_account_holder_name'] = SecurePostData($this->input->post('bank_account_holder_name'));
                $data['bank_account_number'] = SecurePostData($this->input->post('bank_account_number'));
                $data['bank_branch'] = SecurePostData($this->input->post('bank_branch'));
                $data['bank_ifsc_code'] = SecurePostData($this->input->post('bank_ifsc_code'));
                $data['bank_address'] = SecurePostData($this->input->post('bank_address'));
                $data['bank_city'] = SecurePostData($this->input->post('bank_city'));
                $data['bank_state'] = SecurePostData($this->input->post('bank_state'));
                $data['bank_country'] = SecurePostData($this->input->post('bank_country'));
                $data['bank_zipcode'] = SecurePostData($this->input->post('bank_zipcode'));
                $data['cheque_bank_name'] = SecurePostData($this->input->post('cheque_bank_name'));
                $data['cheque_account_holder_name'] = SecurePostData($this->input->post('cheque_account_holder_name'));
                $data['cheque_bank_account_number'] = SecurePostData($this->input->post('cheque_bank_account_number'));
                $data['cheque_bank_branch'] = SecurePostData($this->input->post('cheque_bank_branch'));
                $data['cheque_bank_ifsc_code'] = SecurePostData($this->input->post('cheque_bank_ifsc_code'));
                $data['cheque_bank_address'] = SecurePostData($this->input->post('cheque_bank_address'));
                $data['cheque_bank_city'] = SecurePostData($this->input->post('cheque_bank_city'));
                $data['cheque_bank_state'] = SecurePostData($this->input->post('cheque_bank_state'));
                $data['cheque_bank_country'] = SecurePostData($this->input->post('cheque_bank_country'));
                $data['cheque_bank_zipcode'] = SecurePostData($this->input->post('cheque_bank_zipcode'));
                $data['gateway_name'] = SecurePostData($this->input->post('gateway_name'));
                $data['gateway_account'] = SecurePostData($this->input->post('gateway_account'));
                $data['gateway_city'] = SecurePostData($this->input->post('gateway_city'));
                $data['gateway_state'] = SecurePostData($this->input->post('gateway_state'));
                $data['gateway_country'] = SecurePostData($this->input->post('gateway_country'));
                $data['gateway_zip'] = SecurePostData($this->input->post('gateway_zip'));
            } else {
                $withdrawid = $this->transaction_model->get_last_detail($this->session->userdata('user_id'));
                $bank = $this->transaction_model->get_bank_detail($this->session->userdata('user_id'));
                $getway = $this->transaction_model->get_payment_getway_detail($this->session->userdata('user_id'));
                $cheque = $this->transaction_model->get_cheque_detail($this->session->userdata('user_id'));
                // print_r($check);
                $data['method'] = SecurePostData($this->input->post('method'));
                $data['amount'] = SecurePostData($this->input->post('amount'));
                $data['withdraw_id'] = SecurePostData($this->input->post('withdraw_id'));
                if ($bank) {
                    $data['bank_name'] = $bank['bank_name'];
                    $data['bank_account_holder_name'] = $bank['bank_account_holder_name'];
                    $data['bank_account_number'] = $bank['bank_account_number'];
                    $data['bank_branch'] = $bank['bank_branch'];
                    $data['bank_ifsc_code'] = $bank['bank_ifsc_code'];
                    $data['bank_address'] = $bank['bank_address'];
                    $data['bank_city'] = $bank['bank_city'];
                    $data['bank_state'] = $bank['bank_state'];
                    $data['bank_country'] = $bank['bank_country'];
                    $data['bank_zipcode'] = $bank['bank_zipcode'];
                } else {
                    $data['bank_name'] = "";
                    $data['bank_account_holder_name'] = "";
                    $data['bank_account_number'] = "";
                    $data['bank_branch'] = "";
                    $data['bank_ifsc_code'] = "";
                    $data['bank_address'] = "";
                    $data['bank_city'] = "";
                    $data['bank_state'] = "";
                    $data['bank_country'] = "";
                    $data['bank_zipcode'] = "";
                }
                if ($getway) {
                    $data['gateway_name'] = $getway['gateway_name'];
                    $data['gateway_account'] = $getway['gateway_account'];
                    $data['gateway_city'] = $getway['gateway_city'];
                    $data['gateway_state'] = $getway['gateway_state'];
                    $data['gateway_country'] = $getway['gateway_country'];
                    $data['gateway_zip'] = $getway['gateway_zip'];
                } else {
                    $data['gateway_name'] = " ";
                    $data['gateway_account'] = " ";
                    $data['gateway_city'] = " ";
                    $data['gateway_state'] = " ";
                    $data['gateway_country'] = " ";
                    $data['gateway_zip'] = " ";
                }
                if ($check) {
                    $data['cheque_bank_name'] = $cheque['bank_name'];
                    $data['cheque_account_holder_name'] = $cheque['bank_account_holder_name'];
                    $data['cheque_bank_account_number'] = $cheque['bank_account_number'];
                    $data['cheque_bank_branch'] = $cheque['bank_branch'];
                    $data['cheque_bank_ifsc_code'] = $cheque['bank_unique_id'];
                    $data['cheque_bank_address'] = $cheque['bank_address'];
                    $data['cheque_bank_city'] = $cheque['bank_city'];
                    $data['cheque_bank_state'] = $cheque['bank_state'];
                    $data['cheque_bank_country'] = $cheque['bank_country'];
                    $data['cheque_bank_zipcode'] = $cheque['bank_zipcode'];
                } else {
                    $data['cheque_bank_name'] = "";
                    $data['cheque_account_holder_name'] = "";
                    $data['cheque_bank_account_number'] = "";
                    $data['cheque_bank_branch'] = "";
                    $data['cheque_bank_ifsc_code'] = "";
                    $data['cheque_bank_address'] = "";
                    $data['cheque_bank_city'] = "";
                    $data['cheque_bank_state'] = "";
                    $data['cheque_bank_country'] = "";
                    $data['cheque_bank_zipcode'] = "";
                }
            }
            $data['tab'] = 'withdraw_amount';

            $user = UserData($this->session->userdata('user_id'));
            $this->home_model->select_text($this->session->userdata('lang_id'));
            $this->template->write('meta_title', $meta['title'], TRUE);
            $this->template->write('meta_description', $meta['meta_description'], TRUE);
            $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
            $this->template->front_write_view('header', 'common/header', $data, TRUE);
            $this->template->front_write_view('main_content', 'transaction/tran_report', $data, TRUE);
            $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
            $this->template->render();
        } else {
            if ($this->input->post('withdraw_id') != '') {
                $this->transaction_model->update_withdraw_request();
                $msg = 'update';
            } else {
                $id = $this->transaction_model->add_withdraw_request();
                /********** email **********/
                $u = UserData($this->session->userdata('user_id'));
                $w = $this->transaction_model->get_withdraw_detail($id);
                $wallet_setting = wallet_setting();
                $donation_charge = $wallet_setting->wallet_donation_fees;
                if ($donation_charge == 0) {
                    $amount = $w->withdraw_amount;
                } else {
                    $donation_charge_fee = number_format((($w->withdraw_amount * $donation_charge) / 100), 2);
                    $amount = number_format(($w->withdraw_amount - $donation_charge_fee), 2);
                }
                if ($w->withdraw_method == 'bank') {
                    $withdraw_method = 'By Net Banking';
                }
                if ($w->withdraw_method == 'cheque') {
                    $withdraw_method = 'By Check';
                }
                if ($w->withdraw_method == 'gateway') {
                    $withdraw_method = 'By Payment Gateway';
                }
                $site = site_setting();
                /****** admin notification ********/
                  $language_id=$site_setting['site_language'];
                $email_template = $this->db->query("select * from `email_template` where task='Wallet Withdraw Request' and language_id=".$language_id);
                $email_temp = $email_template->row();
                $email_address_from = $email_temp->from_address;
                $email_address_reply = $email_temp->reply_address;
                $email_subject = $email_temp->subject;
                $email_message = $email_temp->message;
                $email_to = $email_address_from;
                $name = $u['user_name'];
                $details = '<table border="0" cellpadding="3" cellspacing="0">
			<tr><td> ' . NAME . ': </td><td>' . $u["user_name"] . ' ' . $u["last_name"] . '</td></tr>
			<tr><td>' . YOUR_EMAIL . ' : </td><td>' . $u["email"] . '</td></tr>
			<tr><td>' . REQUESTED_AMOUNT . ' : </td><td>' . set_currency($w->withdraw_amount) . '</td></tr>
			<tr><td>' . AMOUNT_PAY . ' : </td><td>' . set_currency($amount) . '</td></tr>
			<tr><td> ' . WITHDRAW_METHOD . ' : </td><td>' . $withdraw_method . '</td></tr>';
                $email_message = str_replace('{break}', '<br/>', $email_message);
                $email_message = str_replace('{name}', $name, $email_message);
                $email_message = str_replace('{details}', $details, $email_message);
                $str = $email_message;
                email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                /************* email end *********/
                $msg = 'success';
            }
            redirect('transaction/report/' . $msg);
        }
    }
}

?>
