<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Repayment extends ROCKERS_Controller
{
    function __construct()
    {
        parent::__construct();
        

        $this->load->model('repayment_model');
        $this->load->model('equity_model');
        // if ($this->session->userdata('admin_id') == '') {
        //         redirect('admin/home');
        // }
        

    }

      function list_repayment($equity_id = '')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $check_rights = get_rights('list_equity');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $data['equity_id'] = $equity_id;

        if(empty($equity_id) || $equity_id == ''){
            redirect('admin/equity/list_equity');
        }


        $data['site_setting'] = site_setting();

        $data['equity_detail'] = $this->equity_model->GetAllEquities(0, $equity_id, 0, '', array('user'), $limit = 1000, array(
            'equity_id' => 'desc'
        ));
        $equity_id = $data['equity_detail'][0]['equity_id'];
         $data['equity_url'] = $data['equity_detail'][0]['equity_url'];


        $data['rePayments'] = $this->repayment_model->getAllRepayments($equity_id);
        
         //paid payment
         $rePaymentsPaid = $this->repayment_model->getDuePaidRePayemnt($equity_id,"'SUCCESS'");        
         
         $total_paid=0;
         if( $rePaymentsPaid){
            $total_paid= $rePaymentsPaid['total'];
         }
         $data['total_paid'] =$total_paid;

         //due payment
         $rePaymentsDue = $this->repayment_model->getDuePaidRePayemnt($equity_id,"'PROCESS','PENDING'");        
         $total_due=0;
         if( $rePaymentsDue){
            $total_due= $rePaymentsDue['total'];;
         }
         $data['total_due'] =$total_due;

         $return_investment_interest = $data['equity_detail'][0]['return_investment_interest'];
         $return_payment_frequency = $data['equity_detail'][0]['return_payment_frequency'];
        $return_term_length = $data['equity_detail'][0]['return_term_length'];
        $irr_percentage = $data['equity_detail'][0]['irr_percentage'];
        $amount_get= $data['equity_detail'][0]['amount_get'];
        if($return_term_length>0){

        $data['next_payment'] = ($return_investment_interest*$amount_get/100)/$return_term_length;  
        }else{
            $data['next_payment'] =0;
        }
        $data['next_due_date'] =  $this->repayment_model->calculateNextRepaymentDate($equity_id);

         $this->load->view('admin/equity/repayment-tab', $data);

    }


     function add_repayment($equity_id='')
    {
        
        $data1['equity_id'] = SecurePostData($this->input->post('equity_id'));
        
        $this->form_validation->set_rules('amount', AMOUNT, 'required');
        $this->form_validation->set_rules('period_start_date', PERIOD_START_DATE, 'required');
        $this->form_validation->set_rules('period_end_date', PERIOD_END_DATE, 'required');
        $this->form_validation->set_rules('payment_desc', PAYMENT_DESC, 'required');
        $this->form_validation->set_rules('payment_type', PAYMENT_TYPE, 'required');

       
        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';

        if ($this->form_validation->run() == FALSE ) {
            if (validation_errors()) {
                $data["msg"]['error'] = validation_errors();
            } else {
                $data["msg"]['error'] = "";
            }
           
        } else {
            $datetime = date('Y-m-d H:i:s');
          
            $period_start_date=date('Y-m-d H:i:s',strtotime($this->input->post('period_start_date')));

            $period_end_date=date('Y-m-d H:i:s',strtotime($this->input->post('period_end_date')));
            $transaction_key=  'RE' . randomNumber(12);
            $repayment_array = array( 
                'equity_id' => $equity_id,
                'amount'=>SecurePostData($this->input->post('amount')),
                'period_start_date'=>SecurePostData($period_start_date),
                'period_end_date'=>SecurePostData($period_end_date),
                'payment_desc'=>SecurePostData($this->input->post('payment_desc')),
                'payment_type'=>SecurePostData($this->input->post('payment_type')),
                'created_at'=>$datetime,
                'transaction_key'=>$transaction_key,
                'payment_method'=>'Offline',
                                       
        );

            $success= $this->repayment_model->AddInsertUpdateTable('repayments',"","", $repayment_array);
            $data["msg"]['success'] = true;


            
        }
        
        echo json_encode($data);

    }
    
      function list_distribution($equity_id = '')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $check_rights = get_rights('list_equity');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $data['equity_id'] = $equity_id;

        if(empty($equity_id) || $equity_id == ''){
            redirect('admin/equity/list_equity');
        }


        $data['site_setting'] = site_setting();

        $data['equity_detail'] = $this->equity_model->GetAllEquities(0, $equity_id, 0, '', array('user'), $limit = 1000, array(
            'equity_id' => 'desc'
        ));
        $equity_id = $data['equity_detail'][0]['equity_id'];


        $data['rePayments'] = $this->repayment_model->getAllRepayments($equity_id);
        
         //paid payment
         $rePaymentsPaid = $this->repayment_model->getDuePaidDistributions($equity_id,"'SUCCESS'");        
        
         $total_paid=0;
         if( $rePaymentsPaid){
            $total_paid= $rePaymentsPaid['total'];
         }
         $data['total_paid'] =$total_paid;

         //due payment
         $rePaymentsDue = $this->repayment_model->getDuePaidDistributions($equity_id,"'PROCESS','PENDING'");        
         $total_due=0;
         if( $rePaymentsDue){
            $total_due= $rePaymentsDue['total'];;
         }
         $data['total_due'] =$total_due;
        
        $return_investment_interest = $data['equity_detail'][0]['return_investment_interest'];
        $return_payment_frequency = $data['equity_detail'][0]['return_payment_frequency'];
        $return_term_length = $data['equity_detail'][0]['return_term_length'];
        $irr_percentage = $data['equity_detail'][0]['irr_percentage'];
        $amount_get= $data['equity_detail'][0]['amount_get'];

        if($return_term_length>0){

        $data['next_payment'] = ($return_investment_interest*$amount_get/100)/$return_term_length;  
        }else{
            $data['next_payment'] =0;
        }

        $data['next_due_date'] =  $this->repayment_model->calculateNextDistributionDate($equity_id);

        $data['distributions'] = $this->repayment_model->getAllDistributions($equity_id);


        //distribution details 
        $results = $this->repayment_model->DistributionDetails("", 0, '',  $join = array(
            'equity','repayments_distribution'
        ), 10000, $order = array(
            'id' => 'desc'
        ), '', '');
       
        //stroing all details data by distributionNo
      

        $this->load->view('admin/equity/distribution-tab', $data);

    }


     
    function distribution_details($equity_id = '',$distributionNo='')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $check_rights = get_rights('list_equity');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $data['equity_id'] = $equity_id;

        if(empty($equity_id) || $equity_id == ''){
            redirect('admin/equity/list_equity');
        }


        $data['site_setting'] = site_setting();

        $data['equity_detail'] = $this->equity_model->GetAllEquities(0, $equity_id, 0, '', array('user'), $limit = 1000, array(
            'equity_id' => 'desc'
        ));
        $equity_id = $data['equity_detail'][0]['equity_id'];


        $data['rePayments'] = $this->repayment_model->getAllRepayments($equity_id);
        
        $rePaymentsPaid = $this->repayment_model->getSumDistributionDetailss($equity_id,"'SUCCESS'");        
        //print_r( $rePaymentsPaid);
         $total_sum=0; $total_distibuted=0; $total_percentage=0;
         if( $rePaymentsPaid['system_calculated']>0){
            $total_sum= $rePaymentsPaid['system_calculated'];
         }
         $data['total_sum'] =$total_sum;
         if( $rePaymentsPaid['inprogress']>0){
            $total_distibuted= $rePaymentsPaid['inprogress'];
         }
         $data['total_distibuted'] =$total_distibuted;
         if($total_sum>0)$total_percentage=($total_distibuted/$total_sum)*100;
        $data['total_percentage'] =ceil($total_percentage);
        
        $return_investment_interest = $data['equity_detail'][0]['return_investment_interest'];
        $return_payment_frequency = $data['equity_detail'][0]['return_payment_frequency'];
        $return_term_length = $data['equity_detail'][0]['return_term_length'];
        $irr_percentage = $data['equity_detail'][0]['irr_percentage'];
        $amount_get= $data['equity_detail'][0]['amount_get'];

        if($return_term_length>0){

        $data['next_payment'] = ($return_investment_interest*$amount_get/100)/$return_term_length;  
        }else{
            $data['next_payment'] =0;
        }

        $data['next_due_date'] = $data['equity_detail'][0]['return_starts'];

        $data['distributions'] = $this->repayment_model->getAllDistributions($equity_id);


        //distribution details 
        $distributionDetails = $this->repayment_model->DistributionDetails($distributionNo, 0, '',  $join = array(
            'equity','repayments_distribution','user'
        ), 10000, $order = array(
            'id' => 'desc'
        ), '', '');
       
        $data['distributionDetails'] =$distributionDetails;

        $this->load->view('admin/equity/distribution-details', $data);

    }

    function distribution_delete($equity_id = '',$distributionNo='')
    {
        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';
        $check_rights = get_rights('list_transaction');
        if ($check_rights == 0)
        {
            $data["msg"]['error'] = 'Invalid Request';
            echo json_encode($data);die;
        }


        

        $query = $this->db->query("delete from repayments_distribution where  distributionNo='".$distributionNo."'");
         $data["msg"]['success'] = RECORD_DELETED_SUCCESSFULLY;
         echo json_encode($data);

    }


     function add_distribution($equity_id='')
    {
        // $user_id=check_user_authentication(true);
         $data1['equity_id'] = SecurePostData($this->input->post('equity_id'));
        
        $this->form_validation->set_rules('amount', AMOUNT, 'required');
        $this->form_validation->set_rules('send_date', 'Distribution Send Date', 'required');
        $this->form_validation->set_rules('period_start_date', PERIOD_START_DATE, 'required');
        $this->form_validation->set_rules('period_end_date', PERIOD_END_DATE, 'required');
        $this->form_validation->set_rules('distribution_desc', PAYMENT_DESC, 'required');
        $this->form_validation->set_rules('distribution_type', PAYMENT_TYPE, 'required');

       
        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';

        if ($this->form_validation->run() == FALSE ) {
            if (validation_errors()) {
                $data["msg"]['error'] = validation_errors();
            } else {
                $data["msg"]['error'] = "";
            }
           
        } else {
            $datetime = date('Y-m-d H:i:s');
            
            $send_date=date('Y-m-d H:i:s',strtotime($this->input->post('send_date')));

          
            $period_start_date=date('Y-m-d H:i:s',strtotime($this->input->post('period_start_date')));

            $period_end_date=date('Y-m-d H:i:s',strtotime($this->input->post('period_end_date')));
            

             $id=$this->input->post('id');
             if($id>0)
             {
                $results = $this->repayment_model->getDistributionsById($id);
                $distributionNo =  $results['distributionNo'];
                $repayments_distribution_array = array( 
                    'amount'=>SecurePostData($this->input->post('amount')),
                    'send_date'=>SecurePostData($send_date),
                    'period_start_date'=>SecurePostData($period_start_date),
                    'period_end_date'=>SecurePostData($period_end_date),
                    'distribution_desc'=>SecurePostData($this->input->post('distribution_desc')),
                    'distribution_type'=>SecurePostData($this->input->post('distribution_type')),
                    'created_at'=>$datetime,
                                           
                );
                $success= $this->repayment_model->AddInsertUpdateTable('repayments_distribution',"id",$id, $repayments_distribution_array);
                $query = $this->db->query("delete from  repay_distribution_details where  distributionNo='".$distributionNo."'");
             }else
             {
                $distributionNo = 'DIST' . randomNumber(12);
                $repayments_distribution_array = array( 
                    'equity_id' => $equity_id,
                     'distributionNo' => $distributionNo,
                    'amount'=>SecurePostData($this->input->post('amount')),
                    'send_date'=>SecurePostData($send_date),
                    'period_start_date'=>SecurePostData($period_start_date),
                    'period_end_date'=>SecurePostData($period_end_date),
                    'distribution_desc'=>SecurePostData($this->input->post('distribution_desc')),
                    'distribution_type'=>SecurePostData($this->input->post('distribution_type')),
                    'created_at'=>$datetime,
                                           
                );
                $success= $this->repayment_model->AddInsertUpdateTable('repayments_distribution',"","", $repayments_distribution_array);
             }
             
            $repayment_distrubtion_id= $success;
            //add distribution details data
              //equity details
             $equity_detail = $this->equity_model->GetAllEquities(0, $equity_id, 0, '', array('user'), 1, array(
            'equity_id' => 'desc'));
             $equity_detail =  $equity_detail[0];
             $amount_get= $equity_detail['amount_get'];
             $adjustment=0; $ownership=0;
             $distribution_amount=$this->input->post('amount');
            
           

             $donations = $this->equity_model->get_donations($equity_id);
             foreach ($donations as $row)
             {
                $amount = $row['amount'];$preapproval_status = $row['preapproval_status'];
                $user_id = $row['user_id'];$preapproval_total_amount = $row['preapproval_total_amount'];
                 //calcaulate ownership
                 $ownership=round(($preapproval_total_amount/$amount_get)*100);
                   //calcaulate system_calculated
                 $system_calculated=($ownership/100)*$distribution_amount;
                if($preapproval_status=='SUCCESS')
                { 
                    $query = $this->db->query("select * from repay_distribution_details where status='SUCCESS' and user_id='".$user_id."' and equity_id=".$equity_id);
                    if ($query->num_rows() > 0) 
                    {  
                        $query = $this->db->query("select sum(inprogress) as past_distribution from repay_distribution_details where status='SUCCESS' and user_id='".$user_id."' and equity_id=".$equity_id);
                        $result = $query->row_array();
                        $past_distribution =  $result['past_distribution'];
                    } 
                    else 
                    {
                        $past_distribution = 0;
                    }
                    $transaction_id = 'TR' . randomNumber(12);
                     $repayments_distribution_details_array = array( 
                        'equity_id' => $equity_id,
                         'distributionNo' => $distributionNo,
                         'transaction_id' => $transaction_id,
                        'adjustment'=>$adjustment,
                        'user_id'=>SecurePostData($user_id),
                        'inprogress'=>SecurePostData($system_calculated),
                        'investment'=>SecurePostData($amount),
                        'past_distribution'=>$past_distribution,
                        'system_calculated'=>SecurePostData($system_calculated),
                        'ownership'=>$ownership,
                        'created'=>$datetime,
                        'modified'=>$datetime,                      
                    );
                    $success= $this->repayment_model->AddInsertUpdateTable('repay_distribution_details',"","", $repayments_distribution_details_array);
                }
            } 
            $data["msg"]['success'] = true;


            
        }
        echo json_encode($data);

    }


    function markrecieved($repayment_id=0)
    {

        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';
        $check_rights = get_rights('list_transaction');
        if ($check_rights == 0)
        {
            $data["msg"]['error'] = 'Invalid Request';
            echo json_encode($data);die;
        }

        $results = $this->repayment_model->RepaymentHistory($repayment_id, 0, 0, '', $join = array(
            'equity',
        ), 1, $order = array(
            'id' => 'desc'
        ), '', '');
     
        foreach($results as $res)
        $paymentData=$res;

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];
        $transaction_status = $paymentData['transaction_status'];
       if($transaction_status=='PENDING' or $transaction_status=='PROCESS') 
        {
            $repayments_distribution_array = array('transaction_status' => 'SUCCESS');
            $success= $this->repayment_model->AddInsertUpdateTable('repayments',"id", $in_process_id , $repayments_distribution_array);
            $data["msg"]['success'] = true;

            
           
        }else
        {
             $data["msg"]['error'] = 'Invalid Transaction Status';
            
        }
         echo json_encode($data);
    }    

    function action_repayment($id = '', $oneaction = '', $check_page = '')
    {

        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';
        $check_rights = get_rights('list_transaction');
        if ($check_rights == 0)
        {
            $data["msg"]['error'] = 'Invalid Request';
            echo json_encode($data);die;
        }
        $site_setting = site_setting();
        $site_name = $site_setting['site_name'];
        $taxonomy_setting = taxonomy_setting();
        $project_name = $taxonomy_setting['project_name'];
        $offset = SecurePostData($this->input->post('offset'));
        $taxonomy_setting = taxonomy_setting();
        $taxonomy_project_url = $taxonomy_setting['project_url'];
       
        $actionRepayment = SecurePostData($this->input->post('actionRepayment'));
        $repaymentid = SecurePostData($this->input->post('chk'));

       
        $temp = array();
        
        switch ($actionRepayment)
         {

            case 'confirm':
                $distribution_details_id=0;
                foreach ($repaymentid as $id) 
                {
                    $distribution_details_id=$id;
                    $results = $this->repayment_model->getDistributionsDetailsById($distribution_details_id);
                     $user_id =  $results['user_id'];
                      $equity_id =  $results['equity_id'];
                    
                    $query = $this->db->query("select * from repay_distribution_details where status='SUCCESS' and user_id='".$user_id."' and equity_id=".$equity_id);
                    if ($query->num_rows() > 0) 
                    {  
                        $query = $this->db->query("select sum(inprogress) as past_distribution from repay_distribution_details where status='SUCCESS' and user_id='".$user_id."' and equity_id=".$equity_id);
                        $result = $query->row_array();
                        $past_distribution =  $result['past_distribution'];
                    } 
                    else 
                    {
                        $past_distribution = 0;
                    }
                    $this->db->query("update repay_distribution_details set past_distribution='" . $past_distribution . "',status = 'SUCCESS' where id='" . $id . "'");
                    //send email
                     
                    $user_details = UserData( $user_id);
                    $user_name = $user_details[0]['user_name'].' '.$user_details[0]['last_name'];
                    $user_email = $user_details[0]['email'];

                     $template='Repayment distributed successfully';
                     $language_id = GetUserLangCode($user_id);
                    $email_template = $this->db->query("select * from `email_template` where task='".$template."' and language_id=".$language_id);

                    $email_temp = $email_template->row();

                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_subject = $email_temp->subject;
                    $email_message = $email_temp->message;
                    $email_to =  $user_email;                   
                    $site_setting = site_setting();
                    $site_name = $site_setting['site_name'];
                    $taxonomy_setting = taxonomy_setting();
                    $project_name = $taxonomy_setting['project_name'];
                    $funds = $taxonomy_setting['funds'];

                    $email_subject = str_replace('{site_name}', $site_name, $email_subject);
                    $email_message = str_replace('{user_name}', $user_name, $email_message);
                    
                    $str = $email_message;
                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                } 

                //update repayment distribution table
                $results = $this->repayment_model->getDistributionsDetailsById($distribution_details_id);
                 $distributionNo =  $results['distributionNo'];
                 $query = $this->db->query("select * from repay_distribution_details where status = 'PENDING' and distributionNo='".$distributionNo."'");
                 if ($query->num_rows() <= 0) 
                {  
                   
                    $query = $this->db->query("update repayments_distribution set    transaction_status='SUCCESS' where  distributionNo='".$distributionNo."'");
                         
                }
                 break;
            case 'edit':
                  $edit_id = SecurePostData($this->input->post('edit_id'));

                  $adjustment = SecurePostData($this->input->post('adjust_amount'));
                   $results = $this->repayment_model->getDistributionsDetailsById($edit_id);
                   if(is_array( $results))
                   {
                     $inprogress =  SecurePostData($this->input->post('inprogress_'.$edit_id ));
                     $query = $this->db->query("update repay_distribution_details set   inprogress='".$inprogress."',adjustment='".$adjustment."' where  id='".$edit_id."'");
                   }
                  
                  break;

   
        }
          $data["msg"]['success'] = RECORD_UPDATED_SUCCESSFULLY;
         echo json_encode($data);
               
    }               
}

?>
