<?php

class Payments_gateways extends ROCKERS_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('payments_gateway_model');
        $this->load->model('transaction_type_model');
        $this->load->model('home_model');

    }

    function index()
    {
        redirect('admin/payments_gateways/list_payment_gateway');
    }


    function list_payment_gateway($msg = '')

    {

        $check_rights = get_rights('list_transaction');
        if ($check_rights == 0) {

            redirect('admin/home/dashboard/no_rights');

        }
        //$data['result'] = $this->transaction_type_model->get_paypal_result($offset, $limit);
        $data['result'] = get_table_data('payments_gateways', array('payments_gateways.id' => 'desc'));
        //print_r($data['result']);die;
        $data['msg'] = $msg;

        //$data['offset'] = $offset;
        $data['site_setting'] = site_setting();

        $theme = 'admin';

        $this->template->set_master_template($theme . '/template.php');

        $this->template->write('title', 'Paypal Adaptive Payment Gateway', '', TRUE);

        $this->template->write_view('header', 'header', $data, TRUE);

        $this->template->write_view('main_content', 'payment_gateways/list_payment_gateway', $data, TRUE);

        $this->template->write_view('footer', 'footer', '', TRUE);

        $this->template->render();

    }



    function edit_payment($id = 0)

    {

        $check_rights = get_rights('list_transaction');

        if ($check_rights == 0) {

            redirect('admin/home/dashboard/no_rights');

        }


        $one_pay = $this->payments_gateway_model->get_one_payment($id);
        //print_r($one_pay);

        $data["error"] = "";
        $data["offset"] = "";

        $data["id"] = $id;

        $data["name"] = $one_pay['name'];
        $data["status"] = $one_pay['status'];
        $data["image"] = $one_pay['image'];
        $data["function_name"] = $one_pay['function_name'];
       


        $site_setting = site_setting();


        $data['site_setting'] = $site_setting;

        $theme = 'admin';

        $this->template->set_master_template($theme . '/template.php');

        $this->template->write('title', 'Edit Payment Gateway', '', TRUE);

        $this->template->write_view('header', 'header', $data, TRUE);

        $this->template->write_view('main_content', 'payment_gateways/add_payment_gateway', $data, TRUE);

        $this->template->write_view('footer', 'footer', '', TRUE);

        $this->template->render();

    }


    function add_payment()

    {


        $data["active"] = "";
        $data["offset"] = "";
        $check_rights = get_rights('list_transaction');

        if ($check_rights == 0) {

            redirect('admin/home/dashboard/no_rights');

        }

        $this->load->library('form_validation');

        $this->form_validation->set_rules('name', NAMES, 'required');
        $this->form_validation->set_rules('status', STATUS, 'required');
        $this->form_validation->set_rules('function_name', FUNCTION_NAMES, 'required');
        
        
        
        $image_error = '';
        if ($_FILES && $_POST){

            if ($_FILES['image']['name'] != '') {

                if ($_FILES['image']['tmp_name']) {
                    $needheight = 1300;
                    $needwidth = 600;
                    $fn = $_FILES['image']['tmp_name'];
                    $size = getimagesize($fn);
                    $actualwidth = $size[0];
                    $actualheight = $size[0];

                     $image_settings = get_image_setting_data();
                    if ($_FILES["image"]["type"] != "image/jpeg" and $_FILES["image"]["type"] != "image/pjpeg" and $_FILES["image"]["type"] != "image/png" and $_FILES["image"]["type"] != "image/x-png" and $_FILES["image"]["type"] != "image/gif") {
                        $image_error = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
                    } else if ($_FILES["image"]["size"] > $image_settings['upload_limit']*1000000) {
                        $image_error =  sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);

                    } else {
                        $image_error = '';
                    }
                }
            }
        }
        if ($this->form_validation->run() == FALSE || $image_error) {
            $data["error"] = validation_errors() . $image_error;
            if($this->input->post('id')) {
                $one_pay = $this->payments_gateway_model->get_one_payment($this->input->post('id'));
                $data["image"] = $one_pay["image"];
            } else {
                $data["image"] = '';
            }

            $data["id"] = SecurePostData($this->input->post('id'));
            $data["name"] = SecurePostData($this->input->post('name'));
            $data["status"] = SecurePostData($this->input->post('status'));
            $data["function_name"] = SecurePostData($this->input->post('function_name'));
           


            $data['site_setting'] = site_setting();


            $theme = 'admin';

            $this->template->set_master_template($theme . '/template.php');

            $this->template->write('title', 'Add Payment Gateway', '', TRUE);

            $this->template->write_view('header', 'header', $data, TRUE);

            $this->template->write_view('main_content', 'payment_gateways/add_payment_gateway', $data, TRUE);

            $this->template->write_view('footer', 'footer', '', TRUE);

            $this->template->render();

        } else {


            if ($this->input->post('id')) {

                $this->payments_gateway_model->payment_update();

                $msg = "update";

            } else {

                $this->payments_gateway_model->payment_insert();

                $msg = "insert";

            }


            redirect('admin/payments_gateways/list_payment_gateway/' . $msg);


        }

    }

    function list_gateway_detail($msg = '')

    {

        $check_rights = get_rights('list_transaction');
        if ($check_rights == 0) {

            redirect('admin/home/dashboard/no_rights');

        }
        //$data['result'] = $this->transaction_type_model->get_paypal_result($offset, $limit);
        //$data['result'] =get_table_data('gateways_details',array('gateways_details.id'=>'desc'));
        $data['result'] = get_payment_gateway($msg);

        $data['msg'] = $msg;

        $data['offset'] = '';
        $data['site_setting'] = site_setting();

        $theme = 'admin';

        $this->template->set_master_template($theme . '/template.php');

        $this->template->write('title', 'Gateway Details', '', TRUE);

        $this->template->write_view('header', 'header', $data, TRUE);

        $this->template->write_view('main_content', 'payment_gateways/list_gateway_detail', $data, TRUE);

        $this->template->write_view('footer', 'footer', '', TRUE);

        $this->template->render();

    }
     function delete_detail($id = 0, $offset = 0)
    {

        $check_rights = get_rights('list_transaction');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $this->db->delete('gateways_details', array('id' => $id));
        redirect('admin/payment_gateways/list_gateway_detail/' . $pay . '/' . $offset . '/delete');

    }


    function edit_detail($id = 0,$temp = 0)

    {

        $check_rights = get_rights('list_transaction');

        if ($check_rights == 0) {

            redirect('admin/home/dashboard/no_rights');

        }

        $one_pay = $this->payments_gateway_model->get_one_detail($id);
        $data["error"] = "";
        $data["id"] = $id;
        $data["name"] = $one_pay['name'];
        $data["payment_gateway_id"] = isset($one_pay['payment_gateway_id']);
        $data["description"] = $one_pay['description'];
        $data["value"] = $one_pay['value'];
        $data["label"] = $one_pay['label'];

        $this->load->library('form_validation');

        $this->form_validation->set_rules('payment_gateway_id', PAYMENT_GATEWAY, 'required|numeric');
        $this->form_validation->set_rules('description', DESCRIPTION, 'required');
        $this->form_validation->set_rules('name', NAME, 'required');
        $this->form_validation->set_rules('value', VALUE, 'required');
        $this->form_validation->set_rules('label', LABEL, 'required');

        if ($this->form_validation->run() == FALSE) {

            if (validation_errors()) {
                $data["error"] = validation_errors();
            } else {
                $data["error"] = "";
            }
            if ($_POST) {
                $data['value'] = SecurePostData($this->input->post('value'));
            } else {
                $data['value'] = $one_pay['value'];
            }
        } else {

            $update_array = array(
                'value' => SecurePostData($this->input->post('value')),'description' => SecurePostData($this->input->post('description'))
            );

            gateway_update($update_array, $id);
            redirect('admin/payments_gateways/list_gateway_detail/' . $data["payment_gateway_id"]);
        }


        //echo  '<pre>';
        //print_r($one_pay);
        $site_setting = site_setting();

        $data['site_setting'] = $site_setting;

        $theme = 'admin';

        $this->template->set_master_template($theme . '/template.php');

        $this->template->write('title', 'Edit Gateway Details', '', TRUE);

        $this->template->write_view('header', 'header', $data, TRUE);

        $this->template->write_view('main_content', 'payment_gateways/edit_gateway_detail', $data, TRUE);

        $this->template->write_view('footer', 'footer', '', TRUE);

        $this->template->render();

    }


    function add_detail()

    {


        $check_rights = get_rights('list_transaction');

        $site_setting = site_setting();

        if ($check_rights == 0) {

            redirect('admin/home/dashboard/no_rights');

        }

        $this->load->library('form_validation');

        $this->form_validation->set_rules('payment_gateway_id', 'Payment Gateway', 'required|numeric');
        $this->form_validation->set_rules('description', 'Description', 'required');
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('value', 'Value', 'required');
        $this->form_validation->set_rules('label', 'Label', 'required');


        if ($this->form_validation->run() == FALSE) {

            if (validation_errors()) {
                $data["error"] = validation_errors();
            } else {
                $data["error"] = "";
            }


            $data["id"] = SecurePostData($this->input->post('id'));
            $data["name"] = SecurePostData($this->input->post('name'));
            $data["payment_gateway_id"] = $id;
            $data["value"] = SecurePostData($this->input->post('value'));
            $data["label"] = SecurePostData($this->input->post('label'));
            $data["description"] = SecurePostData($this->input->post('description'));


            $data['site_setting'] = site_setting();


            $theme = 'admin';

            $this->template->set_master_template($theme . '/template.php');

            $this->template->write('title', 'Add Gateway Details', '', TRUE);

            $this->template->write_view('header', 'header', $data, TRUE);

            $this->template->write_view('main_content', 'payment_gateways/add_gateway_detail', $data, TRUE);

            $this->template->write_view('footer', 'footer', '', TRUE);

            $this->template->render();

        } else {


            if ($this->input->post('id')) {

                $this->payments_gateway_model->detail_update();

                $msg = "update";

            } else {

                $this->payments_gateway_model->detail_insert();

                $msg = "insert";

            }


            redirect('admin/payments_gateways/list_gateway_detail/' . $msg);


        }

    }


}
/* end of file */