<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * ExiteCMS
 *
 * An open source application development framework for PHP 4.3.2 or newer
 * ExiteCMS is based on CodeIgniter, Copyright (c) Ellislab Inc.
 *
 * Extension to the form validation library, to inform the library which
 * object contains your callback methods. Default, the CI superobject is
 * used.
 *
 * @package		ExiteCMS
 * @author		WanWizard
 * @copyright	Copyright (c) 2010, ExiteCMS.org
 * @link		http://www.exitecms.org
 * @since		Version 8.0
 * @filesource
 */

// ---------------------------------------------------------------------

class ROCKERS_Form_validation extends CI_Form_validation
{
	private $callback;

	// -----------------------------------------------------------------

	/**
	 * Constructor
	 *
	 * @return void
	 * @access public
	 */
	function __construct()
	{
		// call the parent constructor
		parent::__construct();

		// set the default callback object to the CI superobject
		$this->callback =& get_instance();
	}

	// -----------------------------------------------------------------

	/**
	 * Inform the form validation library which object contains
	 * the callback methods used in the validation rules.
	 *
	 * Only one object per set of rules can be defined.
	 *
	 * @param	object
	 * @return	void
	 * @access	public
	 */
	function set_callback_object(&$obj = NULL)
	{
		if ( is_object($obj) )
		{
			// set the callback object
			$this->callback =& $obj;

			// make sure the callback object has access to the language library
			if ( ! isset($this->callback->lang) OR ! is_object($this->callback->lang) )
			{
				$this->callback->lang =& $this->CI->lang;
			}
		}
	}

	// -----------------------------------------------------------------

	/**
	 * Executes the Validation routines
	 *
	 * @access	private
	 * @param	array
	 * @param	array
	 * @param	mixed
	 * @param	integer
	 * @return	void
	 */
	function _execute($row, $rules, $postdata = NULL, $cycles = 0)
	{
		// save the current CI object
		$CI = $this->CI;

		// set the CI object to our custom callback object
		$this->CI = $this->callback;

		parent::_execute($row, $rules, $postdata, $cycles);

		// restore the saved CI object
		$this->CI = $CI;
	}
	
	/**
	 * Unique except. Check if a specific value is in use except when the value is attached to a specific row ID
	 *
	 * @param	string
	 * @param	field
	 * @return	bool
	 */
	public function unique_exclude($str, $field)
	{
		list($table, $column, $fld, $id) = explode(',', $field, 4);
	 
		$this->CI->form_validation->set_message('unique_exclude', THE_FILED_THAT_YOU_REQUESTED_IS_ALREADY_IN_USE);
		 if($id!=''){
			$query = $this->CI->db->query("SELECT COUNT(*) AS dupe FROM {$this->CI->db->dbprefix($table)} WHERE {$column} = '$str' AND {$fld} <> {$id}");
		 }else {
		 	$query = $this->CI->db->query("SELECT COUNT(*) AS dupe FROM {$this->CI->db->dbprefix($table)} WHERE {$column} = '$str'");
		 }
		$row = $query->row();
	 
		return ($row->dupe > 0) ? FALSE : TRUE;
	}
	function valid_slug($str){
		  $this->CI->form_validation->set_message('valid_slug', THE_FIELD_ARE_NOT_VALID_FOR_URL);
		    return(preg_match('/^[a-zA-Z][-a-z0-9A-Z_]*$/', $str))? TRUE : FALSE;
		 
	}



	// --------------------------------------------------------------------
	
	/**
	 * Validate URL Address
	 *
	 * @access	public
	 * @param	string
	 * @return	string
	 */
	 
	 
	function valid_url($str)
	{
		    
       $this->callback->form_validation->set_message('valid_url', 'The %s field must contain a valid url.');
		
		// return ( ! preg_match('/^(http|https|ftp):\/\/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i', $str)) ? FALSE : TRUE;
		return ( ! preg_match('/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i', $str)) ? FALSE : TRUE;
	} 
	/**
	 * Minimum Length
	 *
	 * @access	public
	 * @param	string
	 * @param	value
	 * @return	bool
	 */
	public function min_word($str, $val)
	{
		$this->callback->form_validation->set_message('min_word', 'First and Last name are required.');
		return (str_word_count($str) < $val) ? FALSE : TRUE;
	}
	function editor_required($string) {
			$this->callback->form_validation->set_message('editor_required', 'The %s field is required.');
			$string=strip_tags($string);
	      return ($string!='')? TRUE : FALSE ;
	}
	function at_least_one_letter($string) {
		$this->callback->form_validation->set_message('at_least_one_letter', 'The %s field contain at least one alphabetical characters.');
      return (preg_match('#[a-zA-Z]#', $string))? TRUE : FALSE ;
}

	function valid_email_team($string) {
		$this->callback->form_validation->set_message('valid_email_team', EMAIL_VALID_EMAIL);
		     return (!filter_var($string, FILTER_VALIDATE_EMAIL)) ? FALSE : TRUE ;
		 	}

	public function valid_urls($str)
	{
		 $this->callback->form_validation->set_message('valid_urls', 'The %s field must contain a valid urls.');
		 
		 if (strpos($str, ',') === FALSE)
		{
			return $this->valid_url(trim($str));
		}

		foreach (explode(',', $str) as $url)
		{
			if (trim($url) != '' && $this->valid_url(trim($url)) === FALSE)
			{
				return FALSE;
			}
		}

		return TRUE;
	}

	
	
	function alpha_space($str)
	{
		$this->callback->form_validation->set_message('alpha_space', 'The %s field must contain only alphabet and space.');
		return ( ! preg_match("/^([-a-zA-Z ])+$/i", $str)) ? FALSE : TRUE;
	}
	
	
	function alpha_numeric_space($str)
	{
		$this->callback->form_validation->set_message('alpha_numeric_space', 'The %s field must contain only alphabet, numeric and space.');
		return ( ! preg_match("/^([-a-zA-Z 0-9])+$/i", $str)) ? FALSE : TRUE;
	}
	
	
	
	function alpha_numeric_space_special_char($str)
	{
		$this->callback->form_validation->set_message('alpha_numeric_space_special_char', 'The %s field must contain only alphabet, numeric,space and special character(&,!,@).');
		return ( ! preg_match("/^([-a-zA-Z!&@ 0-9])+$/i", $str)) ? FALSE : TRUE;
	}
	
	
	
	
	/**
	 * PCI compliance password
	 *
	 * @access  public
	 * @param   $str
	 * @return  bool
	 */
	 
	public function pci_password($str)
	{
		$special = '!@#$%*-_=+.';
	 
		$this->CI->form_validation->set_message('pci_password', 'For PCI compliance, %s must be between 6 and 99 characters in length, must not contain two consecutively repeating characters, contain at least one upper-case letter, at least one lower-case letter, at least one number, and at least one special character ('.$special.')');
	 
		return (preg_match('/^(?=^.{6,99}$)(?=.*[0-9])(?=.*[A-Z])(?=.*[a-z])(?=.*['.$special.'])(?!.*?(.)\1{1,})^.*$/', $str)) ? TRUE : FALSE;
	}
		 /**
     * Validate the password
     *
     * @param string $password
     *
     * @return bool
     */
    public function valid_password($password = '')
    {
        $password = trim($password);
        $regex_lowercase = '/[a-z]/';
        $regex_uppercase = '/[A-Z]/';
        $regex_number = '/[0-9]/';
        $regex_special = '/[!@#$%^&*()\-_=+{};:,<.>§~]/';
        if (empty($password))
        {
            $this->callback->form_validation->set_message('valid_password', 'The {field} field is required.');
            return FALSE;
        }
        if (preg_match_all($regex_lowercase, $password) < 1)
        {
            $this->callback->form_validation->set_message('valid_password', 'The {field} field must be at least one lowercase letter.');
            return FALSE;
        }
        if (preg_match_all($regex_uppercase, $password) < 1)
        {
            $this->callback->form_validation->set_message('valid_password', 'The {field} field must be at least one uppercase letter.');
            return FALSE;
        }
        if (preg_match_all($regex_number, $password) < 1)
        {
            $this->callback->form_validation->set_message('valid_password', 'The {field} field must have at least one number.');
            return FALSE;
        }
        if (preg_match_all($regex_special, $password) < 1)
        {
            $this->callback->form_validation->set_message('valid_password', 'The {field} field must have at least one special character.' . ' ' . htmlentities('!@#$%^&*()\-_=+{};:,<.>§~'));
            return FALSE;
        }
        if (strlen($password) < 8)
        {
            $this->callback->form_validation->set_message('valid_password', 'The {field} field must be at least 8 characters in length.');
            return FALSE;
        }
        if (strlen($password) > 20)
        {
            $this->callback->form_validation->set_message('valid_password', 'The {field} field cannot exceed 20 characters in length.');
            return FALSE;
        }
        return TRUE;
    }

    /**
	* Unique except for slug content page. Check if a specific value is in use except when the value is attached to a specific row ID
	*
	* @param	string
	* @param	field
	* @return	bool
	*/

	function slugexist($str, $field){       

	       list($table, $column, $fld, $id,$language_id, $language) = explode(',', $field, 6);
	    
	       $this->CI->form_validation->set_message('slugexist', THE_FILED_THAT_YOU_REQUESTED_IS_ALREADY_IN_USE);
	        if($id!='' && $language_id!=''){
	           $query = $this->CI->db->query("SELECT COUNT(*) AS dupe FROM {$this->CI->db->dbprefix($table)} WHERE {$column} = '$str' AND {$fld} <> {$id} AND {$language_id} = {$language}");
	        }else {
	           $query = $this->CI->db->query("SELECT COUNT(*) AS dupe FROM {$this->CI->db->dbprefix($table)} WHERE {$column} = '$str'");
	        }
	       $row = $query->row();
	    
	       return ($row->dupe > 0) ? FALSE : TRUE;

	   }



       /**
		* Unique except for slug content page. Check if a specific value is in use except when the value is attached to a specific row ID
		*
		* @param	string
		* @param	field
		* @return	bool
		*/

		function langslugexist($str, $field){       

		       list($table, $column, $language_id, $language) = explode(',', $field, 4);
		    
		       $this->CI->form_validation->set_message('langslugexist', THE_FILED_THAT_YOU_REQUESTED_IS_ALREADY_IN_USE);
		        if($language_id!=''){
		           $query = $this->CI->db->query("SELECT COUNT(*) AS dupe FROM {$this->CI->db->dbprefix($table)} WHERE {$column} = '$str' AND {$language_id} = {$language}");
		        }else {
		           $query = $this->CI->db->query("SELECT COUNT(*) AS dupe FROM {$this->CI->db->dbprefix($table)} WHERE {$column} = '$str'");
		        }
		       $row = $query->row();
		    
		       return ($row->dupe > 0) ? FALSE : TRUE;

		   }

}
