<?php
 /*
    Function name :LoginUserOwnership()
    Parameter : tables-> table name,whereArr-> where condition parameter in array.
    Return : fetch data if true or return 0 when false
    Use : check user ownership
    */
    function LoginUserOwnership($tables='user',$whereArr='')
    {
        $user_id = check_user_authentication(true);
        $CI =& get_instance();
        
        if(is_array($whereArr))
        {
            foreach ($whereArr as $key => $val) 
            {
                    $CI->db->where($key, $val);
            }
        }else
        {
            $CI->db->where('user_id', $user_id);
        }
        
        $query = $CI->db->get($tables);
        if ($query->num_rows() > 0) {

            return true;
        } else {
          $redirectUrl="home/index/invalid_user";
          redirect($redirectUrl);
        }
    }
    /*
    Function name :encrypt()
    Parameter : string-> to encrypt value
    Return : encripted value
    Use : get encrypted value from string
    */
    function encrypt($string) 
    {
       $result = '';$key="F28RERcdw23232@%@VGHGH";
       for($i=0; $i<strlen($string); $i++) {
         $char = substr($string, $i, 1);
         $keychar = substr($key, ($i % strlen($key))-1, 1);
         $char = chr(ord($char)+ord($keychar));
         $result.=$char;
       }
       return base64_encode($result);
    }
     /*
    Function name :decrypt()
    Parameter : string-> to decryt value
    Return : original value
    Use : get orginal value from encrypt
    */
    function decrypt($string) 
    {
       $result = '';$key="F28RERcdw23232@%@VGHGH";
       $string = base64_decode($string);
       for($i=0; $i<strlen($string); $i++) {
          $char = substr($string, $i, 1);
          $keychar = substr($key, ($i % strlen($key))-1, 1);
          $char = chr(ord($char)-ord($keychar));
          $result.=$char;
       }
       return $result;
    }
//image cleaner function
function image_clener_db()
{

    // error_reporting(0);
    $CI =& get_instance();

    $tables = array('equity','company_profile', 'user', 'equity_gallery', 'site_setting', 'invite_members', 'company_category', 'investors', 'deal_type_setting', 'file_gallery', 'equity_investment_process');
    $columns = array(
        array('cover_photo', 'contract_copy_file', 'executive_summary_file', 'term_sheet_file'),
        array('company_logo' ),
        array('image'),
        array('image'),
        array('site_logo', 'site_logo_hover', 'favicon_image', 'accredential_file'),
    
        array('member_image'),
        array('image'),
        array('investor_image'),
        array('deal_type_icon'),
        array('file_path'),
        array('document_name'),
    );
    $paths = array(
        array('upload/equity/large', 'upload/equity/medium', 'upload/equity/commoncard', 'upload/equity/small', 'upload/orig', 'upload/equity/investor'),

         array( 'upload/equity/logo' ),
        array('upload/user/user_small_image', 'upload/orig', 'upload/user/user_big_image', 'upload/user/user_medium_image'),
        array('upload/gallery'),
        array('upload/orig', 'upload/doc'),
        
        array('upload/equity/team_member'),
        array('upload/category'),
        array('upload/equity/investor'),
        array('upload/equity/deal_icon'),
        array('upload/equity/investor'),
        array('upload/doc'),
    );


    $allpaths = array();


    $t = 0;
    $datacolumn = array();

    if ($tables) {

        foreach ($tables as $table) {

            $dataimage = array();

            if ($paths[$t]) {

                $pathcount = 0;
                foreach ($paths[$t] as $path) {

                    if (in_array($path, $allpaths)) {
                        $pathcount = 1;
                    }
                    $allpaths = array_unique(array_merge($allpaths, array($path)));

                    if ($columns[$t]) {

                        foreach ($columns[$t] as $column) {

                            $dataimage = array();
                            $query = $CI->db->query("SELECT $column FROM $table where $column != ''");

                            if ($query->num_rows() > 0) {
                                $images = $query->result_array();

                                if ($images) {
                                    foreach ($images as $img) {
                                        $dataimage[] = $img[$column];
                                    }
                                }
                            }

                            $datacolumn[$path][$column] = $dataimage;
                        }
                    }

                }
            }

            $t++;
        }
    }
    //  echo '<pre>'; print_r($datacolumn);
    // die;
    if ($datacolumn) {
        foreach ($datacolumn as $key => $value) {
            $folderimages = find_files($key);

            if (is_array($value)) {

                $arraycount = count($value);

                if ($arraycount == 1) {
                    foreach ($value as $cat => $res) {

                        if (is_array($folderimages) && is_array($res)) {
                            $removeimg[$key] = array_diff($folderimages, $res);
                        }
                    }
                } else {

                    $alldataimage = array();

                    foreach ($value as $cat => $res) {
                        $alldataimage = array_merge($alldataimage, $res);
                    }
                    $removeimg[$key] = array_diff($folderimages, $alldataimage);
                }

            }

        }
    }

    // echo '<pre>'; print_r($removeimg);
    //die();
    $count = 0;
    if (is_array($removeimg)) {
        foreach ($removeimg as $path => $image) {
            foreach ($image as $id => $img) {
                //echo $img.'<br>';
                if ($img == 'no_img.jpg' || $img == 'no_man.gif' || $img == 'no_man.jpg') {
                    continue;
                }
                $link = base_path() . $path . '/' . $img;
                // echo $link.'<br>';
                unlink($link);
                $count++;
            }
        }

    }
//echo $count.' files where removed or unlinked';
//die();
}

function find_files($dir)
{
    $CI =& get_instance();

    if (is_dir($dir)) {
        $root = scandir($dir);
        $result = array();
        foreach ($root as $value) {
            if ($value === '.' || $value === '..') {
                continue;
            }
            if (is_file("$dir/$value")) {
                $result[] = $value;
                continue;
            }
        }
        return $result;
    }
    return array();
}

//gets the data from a URL
function get_tiny_url($url)
{
    $ch = curl_init();
    $timeout = 5;
    curl_setopt($ch, CURLOPT_URL, 'http://tinyurl.com/api-create.php?url=' . $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}


//===========check follower================
function check_is_follower($follow_user_id, $follow_by_user_id)
{
    $CI =& get_instance();
    $query = $CI->db->query('select * from user_follow where follow_user_id=' . $follow_user_id . ' and follow_by_user_id=' . $follow_by_user_id);
    if ($query->num_rows() > 0) {
        return 1;
    } else {
        return 0;
    }

}

//=================== CHECK EQUITY FOLLOW=============

function check_is_equity_follower($equity_id, $equity_follow_user_id)
{
    $CI =& get_instance();
    $query = $CI->db->query('select * from equity_follower where equity_id=' . $equity_id . ' and equity_follow_user_id=' . $equity_follow_user_id);
    if ($query->num_rows() > 0) {
        return 1;
    } else {
        return 0;
    }

}

function getcurrenturl()
{
    if (isset($_SERVER["HTTPS"]) && strtolower($_SERVER["HTTPS"]) == "on") {
        $pageURL = (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
    } else {
        $pageURL = "http://";
    }

    if ($_SERVER["SERVER_PORT"] != "80") {
        $pageURL .= $_SERVER["SERVER_NAME"] . ":" . $_SERVER["SERVER_PORT"] . $_SERVER["REQUEST_URI"];
    } else {
        $pageURL .= $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
    }
    return $pageURL;
}

/*
    Function name :check_user_authentication()
    Parameter : none
    Return : true or false
    Use : check user login or logout
  */
function check_user_authentication($redirect = false)
{
    $CI =& get_instance();
    if ($CI->session->userdata('user_id') != '') {
        if (!stristr($_SERVER['REQUEST_URI'], "home/step1")) {
            $userdata = UserData($CI->session->userdata('user_id'));
            $user_password = $userdata[0]['password'];
            if ($user_password == '') redirect('home/step1');
            //if($CI->session->userdata('email')=='')redirect('home/step1');
        }
        return $CI->session->userdata('user_id');
    } else {

        if ($redirect == true) {
            $page = base64_encode(getcurrenturl());
            redirect('home/login/' . $page);

        }
        return false;
    }

}

/*
    Function name :get_authenticateUserID()
    Parameter : none
    Return : session id
    Use : it use for session id
  */
function get_authenticateUserID()
{
    $CI =& get_instance();
    return $CI->session->userdata('user_id');
}


/*
     Function name :GetDaysLeft()
     Parameter : dateg for days or hours or minutes left
     Return : days or hours or minutes or seconds
     Use : find for days


   */
function GetDaysLeft($dateg = '',$project_timezone='')
{
    $site_settings = site_setting();

    $time_zone = $site_settings['time_zone'];

    if ($project_timezone != '')
    {
        
        date_default_timezone_set($project_timezone);
    }
    else
    {
        date_default_timezone_set($time_zone);
    }

    $date1 = $dateg;
    $date2 = date("Y-m-d H:i:s");
    $diff = strtotime($date1) - strtotime($date2);
    //return $diff;
   $test = floor($diff / (60 * 60 * 24));
   $no_time='';
    $str ='';
    if (strtotime(date('Y-m-d', strtotime($dateg))) > strtotime(date('Y-m-d'))) {
       
        $temp = floor($diff / (60 * 60 * 24));
        $diff2 = abs(strtotime($date1) - strtotime($date2));
    
        $hours = floor(($diff2 - $temp * 60 * 60 * 24) / (60 * 60));
        if ($temp > 1) {
            
            $str = ($dateg != "0000-00-00 00:00:00") ? $test . ' ' . "<span>" . DAYS_LEFT . "</span>" : "<span>0 </span>" . DAYS_LEFT;
        } 
        else if($temp == 1){
           
            $str = ($dateg != "0000-00-00 00:00:00") ? $test . ' ' . "<span>" . DAY_LEFT . "</span>" : "<span>0 </span>" . DAY_LEFT;
        }
        else if($temp == 0 and $hours > 0 and $hours < 24){
            
            $str = ($dateg != "0000-00-00 00:00:00") ? $hours . ' ' . "<span>" . HOURS_LEFT . "</span>" : "<span>0 </span>" . DAY_LEFT;
        }
        else if($hours == 1){
             
            $str = ($dateg != "0000-00-00 00:00:00") ? $hours . ' ' . "<span>" . HOUR_LEFT . "</span>" : "<span>0 </span>" . DAY_LEFT;
        }
        else if($temp < 0 && $hours < 0){
            $str = ($dateg != "0000-00-00 00:00:00") ? $no_time . ' ' . "<span>" . NO_TIME_LEFT . "</span>" : "<span>0 </span>" . DAY_LEFT;
        }
        else {
            $str = " <span>" . NO_TIME_LEFT . "</span>";
        }
        

    } else {
        
        $dategg = $dateg;
        $date2 = date('Y-m-d H:i:s');

        if (strtotime(date('Y-m-d H:i:s', strtotime($dateg))) > strtotime(date('Y-m-d H:i:s'))) {

            $diff2 = abs(strtotime($dategg) - strtotime($date2));
            $day1 = floor($diff2 / (60 * 60 * 24)).'days';


            $hours = floor(($diff2 - $day1 * 60 * 60 * 24) / (60 * 60));
            $minuts = floor(($diff2 - $day1 * 60 * 60 * 24 - $hours * 60 * 60) / 60);
            $seconds = floor(($diff2 - $day1 * 60 * 60 * 24 - $hours * 60 * 60 - $minuts * 60));

            // if ($hours != 0 && $hours > 1 || $minuts != 0 || $seconds != 0) {


            //     if ($hours != 0) {
            //         $str = "" . $hours . ' ' . "<span>" . HOURS_LEFT . "</span>";
            //     } elseif ($minuts != 0) {
            //         $str = "" . $minuts . ' ' . "<span>" . MINUTES_LEFT . "</span>";
            //     } else {
            //         $str = "" . $seconds . ' ' . "<span>" . SECONDS_LEFT . "</span>";
            //     }

            // } 
            if($day1 == 0 and $hours > 0 and $hours < 24)
            {
                $str = ($dateg != "0000-00-00 00:00:00") ? $hours . ' ' . "<span>" . HOURS_LEFT . "</span>" : "<span>0 </span>" . DAY_LEFT;
            }
            else if($hours == 1){
                $str = ($dateg != "0000-00-00 00:00:00") ? $hours . ' ' . "<span>" . HOUR_LEFT . "</span>" : "<span>0 </span>" . DAY_LEFT;
            }
            else if($hours < 1 && $minuts > 0){
                  $str = ($dateg != "0000-00-00 00:00:00") ? $minuts . ' ' . "<span>" . MINUTES_LEFT . "</span>" : "<span>0 </span>" . DAY_LEFT;
            }
            else if($day1 < 0 && $hours < 0){
                $str = ($dateg != "0000-00-00 00:00:00") ? $no_time . ' ' . "<span>" . NO_TIME_LEFT . "</span>" : "<span>0 </span>" . DAY_LEFT;
            }

            else {
                $str = " <span>" . NO_TIME_LEFT . "</span>";
            }
        } else {
            $str = " <span>" . NO_TIME_LEFT . "</span>";
        }

    }
     date_default_timezone_set($time_zone);
    return $str;
}
/*
Function name :ImageUpload()
Parameter : files
Return : secure file
Use : image uploading
*/
function ImageUpload($files, $gallery = false, $pitch = false)
{
    $new_img = '';
    $rand = rand(0, 100000);
    $image_settings = get_image_setting_data();
    if (trim($files["userfile"]["tmp_name"]) != "") {

        $CI =& get_instance();

        $base_path = $CI->config->slash_item('base_path');
       
        $path_parts = pathinfo($_FILES['userfile']['name']);
        $date = new DateTime();
        
        $file_extention = $path_parts['extension'];
        $new_img = $rand .'-equity-'.$date->getTimestamp().'.'.$file_extention;

        move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/orig/" . $new_img);
        $image_info = getimagesize($base_path . "upload/orig/" . $new_img);
        $image_width = $image_info[0];
        $image_height = $image_info[1];


        require_once $base_path . 'thumbgenerator/ThumbLib.inc.php';


        if ($gallery == false) {

            $case = 1;
            if ($pitch == true) $case = 2;//for pitch image

            switch ($case) {
                case 1:
                    $new_w = $image_settings['p_thumb_width']; //You can change these to fit the width and height you want
                    $new_h = $image_settings['p_thumb_height'];
                    $aspect_ratio = $image_settings['p_ratio'];

                    if ($aspect_ratio) {
                        if ($image_height > $image_width) {
                            $ratio = $new_h / $image_height;
                            $new_h = $new_h;
                            $new_w = $image_width * $ratio;
                        } else {
                            $ratio = $new_w / $image_width;
                            $new_w = $new_w;
                            $new_h = $image_height * $ratio;
                        }
                    }

                    $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
                    $thumb->adaptiveResize($new_w, $new_h);
                    $cache_path = $base_path . "upload/equity/commoncard/" . $new_img;
                    $thumb->save($cache_path);


                    $new_w = $image_settings['p_small_width']; //You can change these to fit the width and height you want
                    $new_h = $image_settings['p_small_height'];

                    if ($aspect_ratio) {
                        if ($image_height > $image_width) {
                            $ratio = $new_h / $image_height;
                            $new_h = $new_h;
                            $new_w = $image_width * $ratio;
                        } else {
                            $ratio = $new_w / $image_width;
                            $new_w = $new_w;
                            $new_h = $image_height * $ratio;
                        }
                    }

                    $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
                    $thumb->adaptiveResize($new_w, $new_h);
                    $cache_path = $base_path . "upload/equity/small/" . $new_img;
                    $thumb->save($cache_path);


                    $new_w = $image_settings['p_medium_width']; //You can change these to fit the width and height you want
                    $new_h = $image_settings['p_medium_height'];

                    if ($aspect_ratio) {
                        if ($image_height > $image_width) {
                            $ratio = $new_h / $image_height;
                            $new_h = $new_h;
                            $new_w = $image_width * $ratio;
                        } else {
                            $ratio = $new_w / $image_width;
                            $new_w = $new_w;
                            $new_h = $image_height * $ratio;
                        }
                    }

                    $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
                    $thumb->adaptiveResize($new_w, $new_h);
                    $cache_path = $base_path . "upload/equity/medium/" . $new_img;
                    $thumb->save($cache_path);

                    $new_w = $image_settings['p_large_width']; //You can change these to fit the width and height you want
                    $new_h = $image_settings['p_large_height'];

                    if ($aspect_ratio) {
                        if ($image_height > $image_width) {
                            $ratio = $new_h / $image_height;
                            $new_h = $new_h;
                            $new_w = $image_width * $ratio;
                        } else {
                            $ratio = $new_w / $image_width;
                            $new_w = $new_w;
                            $new_h = $image_height * $ratio;
                        }
                    }

                    $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
                    $thumb->adaptiveResize($new_w, $new_h);
                    $cache_path = $base_path . "upload/equity/large/" . $new_img;
                    $thumb->save($cache_path);
                    break;
                case 2:

                    $new_w = 670; //You can change these to fit the width and height you want
                    $new_h = 400;
                    $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);

                    $thumb->adaptiveResize($new_w, $new_h);
                    $cache_path = $base_path . "upload/equity/medium/" . $new_img;
                    $thumb->save($cache_path);
                    break;

            }
        } else {

            $oldWidth = $image_width;
            $height = $image_height;
            $newWidth = 642;
            $percentChange = $newWidth / $oldWidth;
            $newHeight = round(($percentChange * $height));


            $new_w = $image_settings['p_small_width']; //You can change these to fit the width and height you want
            $new_h = $image_settings['p_small_height'];

            $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
            $thumb->adaptiveResize($new_w, $new_h);
            $cache_path = $base_path . "upload/equity/small/" . $new_img;
            $thumb->save($cache_path);


            if ($image_width > 620) {
                $new_w = $newWidth; //You can change these to fit the width and height you want
                $new_h = $newHeight;
                $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
                $thumb->adaptiveResize($new_w, $new_h);
                $cache_path = $base_path . "upload/equity/medium/" . $new_img;
                $thumb->save($cache_path);


                if ($new_h > 1000) {
                    $new_h = 1000;
                    $thumb = PhpThumbFactory::create($base_path . "upload/equity/medium/" . $new_img);
                    $thumb->cropFromCenter($new_w, $new_h);
                    $cache_path = $base_path . "upload/equity/medium/" . $new_img;
                    $thumb->save($cache_path);

                }

            } else {
                //echo $image_height;die;
                if ($image_height < 1000) {
                    move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/equity/medium/" . $new_img);
                } else {
                    $new_w = $image_width; //You can change these to fit the width and height you want
                    $new_h = $newHeight;
                    $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
                    $thumb->adaptiveResize($new_w, $new_h);
                    $cache_path = $base_path . "upload/equity/medium/" . $new_img;
                    $thumb->save($cache_path);

                }
            }


        }

    }

    return $new_img;


}




/*
Function name :ImageUpload()
Parameter : files
Return : secure file
Use : image uploading
*/
function UserImageUpload($files, $facebook = false)
{
    $new_img = '';
    $rand = rand(0, 100000);
    $image_settings = get_image_setting_data();
    $CI =& get_instance();
    $base_path = $CI->config->slash_item('base_path');
    require_once $base_path . 'thumbgenerator/ThumbLib.inc.php';
    if (trim($files["userfile"]["tmp_name"]) != "") {

        
        $path_parts = pathinfo($_FILES['userfile']['name']);
        $date = new DateTime();
        
        $file_extention = $path_parts['extension'];
        $new_img = $rand .'-user-'.$date->getTimestamp().'.'.$file_extention;

        move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/orig/" . $new_img);
        $image_info = getimagesize($base_path . "upload/orig/" . $new_img);
        $image_width = $image_info[0];
        $image_height = $image_info[1];

        $new_w = $image_settings['u_b_width']; //You can change these to fit the width and height you want
        $new_h = $image_settings['u_b_height'];
        $aspect_ratio = $image_settings['u_ratio'];

        if ($aspect_ratio) {
            if ($image_height > $image_width) {
                $ratio = $new_h / $image_height;
                $new_h = $new_h;
                $new_w = $image_width * $ratio;
            } else {
                $ratio = $new_w / $image_width;
                $new_w = $new_w;
                $new_h = $image_height * $ratio;
            }
        }

        $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
        $thumb->adaptiveResize($new_w, $new_h);
        $cache_path = $base_path . "upload/user/user_big_image/" . $new_img;
        $thumb->save($cache_path);

        $new_w = $image_settings['u_s_width']; //You can change these to fit the width and height you want
        $new_h = $image_settings['u_s_height'];

        if ($aspect_ratio) {
            if ($image_height > $image_width) {
                $ratio = $new_h / $image_height;
                $new_h = $new_h;
                $new_w = $image_width * $ratio;
            } else {
                $ratio = $new_w / $image_width;
                $new_w = $new_w;
                $new_h = $image_height * $ratio;
            }
        }

        $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
        $thumb->adaptiveResize($new_w, $new_h);
        $cache_path = $base_path . "upload/user/user_small_image/" . $new_img;
        $thumb->save($cache_path);

        $new_w = $image_settings['u_m_width']; //You can change these to fit the width and height you want
        $new_h = $image_settings['u_m_height'];

        if ($aspect_ratio) {
            if ($image_height > $image_width) {
                $ratio = $new_h / $image_height;
                $new_h = $new_h;
                $new_w = $image_width * $ratio;
            } else {
                $ratio = $new_w / $image_width;
                $new_w = $new_w;
                $new_h = $image_height * $ratio;
            }
        }

        $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
        $thumb->adaptiveResize($new_w, $new_h);
        $cache_path = $base_path . "upload/user/user_medium_image/" . $new_img;
        $thumb->save($cache_path);
    }
    if ($facebook == true) {
        $new_img = $files["userfile"]["name"];
        //$new_img =$fb_uid.'.jpg';
        $outPath = $base_path . 'upload/orig/' . $new_img;
        $new_w = $image_settings['u_b_width']; //You can change these to fit the width and height you want
        $new_h = $image_settings['u_b_height'];
        $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
        $thumb->adaptiveResize($new_w, $new_h);
        $cache_path = $base_path . "upload/user/user_big_image/" . $new_img;
        $thumb->save($cache_path);

        $new_w = $image_settings['u_s_width']; //You can change these to fit the width and height you want
        $new_h = $image_settings['u_s_width'];

        $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
        $thumb->adaptiveResize($new_w, $new_h);
        $cache_path = $base_path . "upload/user/user_small_image/" . $new_img;
        $thumb->save($cache_path);

        $new_w = $image_settings['u_m_width']; //You can change these to fit the width and height you want
        $new_h = $image_settings['u_m_width'];

        $thumb = PhpThumbFactory::create($base_path . "upload/orig/" . $new_img);
        $thumb->adaptiveResize($new_w, $new_h);
        $cache_path = $base_path . "upload/user/user_medium_image/" . $new_img;
        $thumb->save($cache_path);
    }

    return $new_img;


}

/*
     Function name :GetProjectPercentage()
     Parameter : data for percentage count
     Return : percentage
     Use : find percentave for progress bar


   */
function GetProjectPercentage($data = array())
{
    $w = 0;
    //print_r($data);
    if ($data['amount'] == '0' or $data['amount'] == '') {
        $w = 0;
    } else {
        /*if($data['amount_get']>=$data['amount'])
        {
            $w=100;
        }
        else
        {*/
        $w = ($data['amount_get'] / $data['amount']) * 100;
        if ($w > 0 && $w < 1) {
            $w = 1;
        }
        //}
    }
    return $w;
}

/*
Function name :SecurePostData()
Parameter : string
Return : secure string
Use : all input post or get data wil be purify for sql injection and cross scripting
*/
function SecurePostData($string = '')
{
    $CI =& get_instance();
    $string = html_purify($CI->db->escape_str($string));
    $string = preg_replace('/(\r\n\r\n)$/', '', $string);
    $string = preg_replace("/\n+/", "", $string);
    $string = str_replace("\n", "<br>", $string);
    $string = str_replace("\r", "", $string);
    //$string = strip_slashes($string);
    $string = str_replace(PHP_EOL, null, $string);

    return $string;

}

/*
Function name :EditorSecurePostData()
Parameter : string
Return : secure string
Use : all input post or get data wil be purify for sql injection and cross scripting
*/
/**
 * @param string $string
 * @return array|mixed|string
 */
function EditorSecurePostData($string = '')
{   
    if(is_array($string)){

        return $string;
    } 
    $CI =& get_instance();
    $string = $CI->security->xss_clean($string);
    $string = $CI->db->escape_str($string);
    
  

    return $string;

}


/*
Function name :SecureShowData()
Parameter : string
Return : secure string
Use : all input post or get data wil be purify for sql injection and cross scripting
*/
/**
 * @param string $string
 * @return string
 */
function SecureShowData($string = '')
{
    // var_dump(($string));die;
    // $string= htmlentities($string);
    $string = nl2br($string);
    $string = str_replace(array('\r\n', '\r', '\n'), "", $string); 
    $string = stripslashes($string);
    $string = htmlspecialchars_decode($string);

    // $string = str_replace('rn', '', $string);
    // $string = str_replace('rnrn', '', $string);
       

    return $string;

}

/*
Function name :RemoveHtmltag()
Parameter : string
Return : secure string
Use : all input post or get data wil be purify for sql injection and cross scripting
*/
function RemoveHtmltag($string = '')
{
    $string = strip_tags($string);


    return $string;

}

/*End one project Details*/

/*
Function name :UserData()
Parameter : id, join table in array.
Return : user data
Use : user data of particular id and use this function to any where in site to get the user detail.
*/
function UserData($id = 0, $join = array())
{
    $CI =& get_instance();
    $cache_file_name = 'user_detail' . $id;
    $selectfields = 'user.profile_slug, user.user_id, user.user_name, user.last_name, user.email, user.password, user.image, user.address, user.zip_code, user.user_about, user.user_occupation, user.user_interest, user.user_skill, user.unique_code ,user.tw_screen_name, user.tw_id, user.fb_uid , user.date_added,user.enable_facebook_stream, user.facebook_url, user.facebook_wall_post, user.fb_access_token, user.enable_twitter_stream, user.twitter_url, user.autopost_site, user.tw_oauth_token_secret, user.tw_oauth_token, user.user_website, user.linkedln_url, user.googleplus_url, user.bandcamp_url, user.youtube_url, user.myspace_url, user.forgot_unique_code, user.confirm_key, user.reference_user_id,user.paypal_email,user.active,user.suspend_reason,user.profile_slug,user.phone';

    if (in_array('user_notification', $join)) {
        $selectfields .= ',user_notification.id,user_notification.you_back_alert,user_notification.you_follow_alert,user_notification.new_pledge_alert,user_notification.new_comment_alert,user_notification.new_follow_alert,user_notification.new_updates_alert,user_notification.social_notification_alert,user_notification.creator_pledge_alert,user_notification.creator_comment_alert,user_notification.creator_follow_alert,user_notification.creator_newup_alert,user_notification.user_alert,user_notification.add_fund,user_notification.project_alert,user_notification.comment_alert,user_notification.update_alert,user_notification.comment_reply_alert';
        $cache_file_name = 'user_detail_notification' . $id;
    }


    $data = false;
    if (!$CI->simple_cache->is_cached($cache_file_name)) {

        // not cached, do our things that need caching
        $CI->db->select($selectfields);
        $CI->db->from('user');
        if (in_array('user_notification', $join)) {
            $CI->db->join('user_notification', 'user.user_id=user_notification.user_id', 'left');
        }

        if ($id > 0) {
            $CI->db->where('user.user_id', $id);
        }

        $query = $CI->db->get();
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            $data = $result;

        }

        // store in cache
        $CI->simple_cache->cache_item($cache_file_name, $data);
    } else {
        //$data =$CI->simple_cache->get_item($cache_file_name);
        $CI->db->select($selectfields);
        $CI->db->from('user');
        if (in_array('user_notification', $join)) {
            $CI->db->join('user_notification', 'user.user_id=user_notification.user_id', 'left');
        }

        if ($id > 0) {
            $CI->db->where('user.user_id', $id);
        }

        $query = $CI->db->get();
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            $data = $result;

        }

        // store in cache
        $CI->simple_cache->cache_item($cache_file_name, $data);
    }


    return $data;
}


/*
Function name :GetOneProject()
Parameter : files
Return : secure file
Use : image uploading
*/
function GetOneEquity($id)
{
    $CI =& get_instance();

    
    $data = 0;
    if (!$CI->simple_cache->is_cached('equity_detail'.$id))
          {
              // not cached, do our things that need caching
             $selectfields = 'equity.*,company_profile.company_name,company_profile.company_url,company_profile.company_overview,company_profile.company_logo,company_profile.headquater_country,company_profile.headquater_state,company_profile.headquater_city,company_profile.company_linkedin_url,company_profile.company_facebook_url,company_profile.company_twitter_url,company_profile.website_url, company_category.company_category_name as company_category';

              $CI->db->select($selectfields);
              $CI->db->where('equity_id', $id);
              $CI->db->from('equity');
              $CI->db->join('company_profile', 'company_profile.company_id=equity.company_id', 'left');
              $CI->db->join('company_category', 'company_category.id=company_profile.company_category_id', 'left');
              $query = $CI->db->get();

        if ($query->num_rows() > 0)
        {
             $data= $query->row_array();
        }
              // store in cache
              $CI->simple_cache->cache_item('equity_detail'.$id, $data);
          }
          else
          {
              $data =$CI->simple_cache->get_item('equity_detail'.$id);
          }


    return $data;
}


/*
Function name :validatestatus_isedit()
Parameter : is_status
Return : true for active
Use : getting status for project
*/
function validatestatus_isedit($is_status = '')
{
    $status = array(0, 1);
    if (in_array($is_status, $status)) {

        return false;
    } else {
        return true;
    }
}

/*
Function name :GetOneOutsideLink()
Parameter : id
Return : single outside link
Use : getting single outside link detail
*/

function GetOneOutsideLink($id = null)
{
    $CI =& get_instance();
    $project_cnt = $CI->db->get_where("outside_link", array("project_id" => $id));

    if ($project_cnt->num_rows() > 0) {
        return $project_cnt->row_array();
    }
    return 0;

}

/**
 * Function name :goToByScroll()
 * Parameter : null
 * Return :null
 * Use : move cursor to top
 * Description :
 * mover user to particular box position
 **/
function goToByScroll($id)
{
    "$('html,body').animate({scrollTop: $('#" . $id . "').offset().top},'slow')";
}

/*
Function name :paypal_pre_failure_email()
Parameter : donar_email,
Return : secure string
Use : all failure transaction email fire from here
*/
function paypal_failure_email($donar_email, $donar_name, $project_owner_email, $project_id, $project_title, $paypal_msg1 = '', $paypal_msg2 = '', $paypal_msg3 = '')
{


    $CI =& get_instance();
    //fetch email template
      $language_id=$site_setting['site_language'];
    $email_template = $CI->db->query("select * from `email_template` where task='New Fund Admin Notification' and language_id=".$language_id);
    $email_temp = $email_template->row();

    $email_address_from = $email_temp->from_address;
    $email_address_reply = $email_temp->reply_address;
    $email_subject = YOUR_PAYMENT_FAILED;
    $email_to = $donar_email;


    $str = $paypal_msg1;
    //send email to donor
    if ($paypal_msg1 != "") email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

    //send email to project owner
    $email_to = $project_owner_email;
    $str = $paypal_msg2;
    if ($paypal_msg2 != "") email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);


    $email_subject = YOUR_PAYMENT_FAILED . " on Project" . $project_title . "(" . $project_id . ")";
    $email_to = $email_address_from;
    //send email to admin
    $str = $paypal_msg3;
    if ($paypal_msg3 != "") email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
}


/*
    Function name :get_one_country()
    Parameter : id
    Return : single country detail
    Use : getting single country detail
    */

function get_one_country($id)
{
    $CI =& get_instance();
    $query = $CI->db->query("select * from country where country_id='" . $id . "'");
    if ($query->num_rows() > 0) {
        return $query->row_array();
    }
    return 0;
}



/*Get user last login detail*/
/*
Function name :GetLastLogin()
Parameter : id
Return : user last login detail
Use : Get user last login detail
*/
function GetLastLogin($id)
{
    $CI =& get_instance();
    $last_login = $CI->db->get_where('user_login', array('user_id' => $id));

    if ($last_login->num_rows() > 1) {

        $CI->db->where(array('user_id' => $id));
        $CI->db->order_by('login_id', 'desc');
        $CI->db->limit(1, 1);
        $query = $CI->db->get('user_login');

        $get_last_login = $query->row_array();
    } else {
        $CI->db->where(array('user_id' => $id));
        $CI->db->order_by('login_id', 'desc');
        $query = $CI->db->get('user_login');

        $get_last_login = $query->row_array();
    }

    return $get_last_login;
}


function wallet_amount()
{
    $CI = get_instance();
    $user_id = get_authenticateUserID();
    $query = $CI->db->query("SELECT SUM( debit ) AS debit, SUM( credit ) AS credit
				FROM wallet
				WHERE user_id ='" . $user_id . "'");
    /*
    echo $CI->db->last_query();
    die();	*/
    if ($query->num_rows() > 0) {
        $result = $query->row();
        $debit = $result->debit;
        $credit = $result->credit;
        $total = $debit - $credit;
        return $total;
    } else {
        return 0;
    }
}

function learn_more_category($active = 0, $footer = '')
{

    $CI =& get_instance();


    $CI->db->select('*');
    $CI->db->where('learn_more_category.active', $active);
    if ($footer != '')
        $CI->db->where('learn_more_category.footer', $footer);

    if ($_SESSION['lang_code'] != '')
        $CI->db->where('iso2', $_SESSION['lang_code']);
    if ($_SESSION['lang_folder'] != '')
        $CI->db->where('language_folder', $_SESSION['lang_folder']);

    $CI->db->from('learn_more_category');
    $CI->db->join('language', 'language.language_id = learn_more_category.language_id', 'inner');

    $CI->db->order_by('category_name', 'asc');
    //$CI->db->group_by('learn_category');
    $query = $CI->db->get();//echo $CI->db->last_query();
    if ($query->num_rows() > 0) {
        $data = $query->result_array();
    } else {
        $data = 0;
    }

    return $data;


}

function learn_more_category_right_side($active = 0, $right_menu = '')
{

    $CI =& get_instance();


    $CI->db->select('*');
    $CI->db->where('learn_more_category.active', $active);
    if ($right_menu != '')
        $CI->db->where('learn_more_category.right_side', $right_menu);

    if ($_SESSION['lang_code'] != '')
        $CI->db->where('iso2', $_SESSION['lang_code']);
    if ($_SESSION['lang_folder'] != '')
        $CI->db->where('language_folder', $_SESSION['lang_folder']);

    $CI->db->from('learn_more_category');
    $CI->db->join('language', 'language.language_id = learn_more_category.language_id', 'inner');

    $CI->db->order_by('category_name', 'asc');
    //$CI->db->group_by('learn_category');

    $query = $CI->db->get();
    if ($query->num_rows() > 0) {
        $data = $query->result_array();
    } else {
        $data = 0;
    }

    return $data;


}


function learnmore_menu($active = 0)
{
    $CI =& get_instance();
    $CI->db->select('pages_id,pages_title,slug,learn_category');
    $CI->db->where('active', $active);
    $CI->db->from('learn_more');

    $CI->db->group_by('learn_category');
    $query = $CI->db->get();

    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return 0;
    }
}

function pages_menu($active = 0, $footer = '')
{
    $CI =& get_instance();


    $CI->db->select('pages_id,pages_title,slug');
    $CI->db->where('pages.active', $active);
    $CI->db->where('footer_bar', $footer);

    if ($_SESSION['lang_code'] != '')
        $CI->db->where('iso2', $_SESSION['lang_code']);
    if ($_SESSION['lang_folder'] != '')
        $CI->db->where('language_folder', $_SESSION['lang_folder']);

    $CI->db->from('pages');

    $CI->db->join('language', 'language.language_id = pages.language_id', 'inner');
    $CI->db->order_by('pages_title', 'asc');

    $query = $CI->db->get();
    if ($query->num_rows() > 0) {
        $data = $query->result_array();
    } else {
        $data = 0;
    }
//echo '<pre>'; echo $CI->db->last_query(); die;
    return $data;


}

function pages_right_menu($active = 0, $footer = '')
{
    $CI =& get_instance();
    setting_deletecache('pages_right_menu');


    $CI->db->select('pages_id,pages_title,slug');
    $CI->db->where('pages.active', $active);
    $CI->db->where('right_side', $footer);
    $CI->db->from('pages');
    if ($_SESSION['lang_code'] != '')
        $CI->db->where('iso2', $_SESSION['lang_code']);
    if ($_SESSION['lang_folder'] != '')
        $CI->db->where('language_folder', $_SESSION['lang_folder']);
    $CI->db->join('language', 'language.language_id = pages.language_id', 'inner');

    $CI->db->order_by('pages_title', 'asc');

    $query = $CI->db->get();
    if ($query->num_rows() > 0) {
        $data = $query->result_array();
    } else {
        $data = 0;
    }

    return $data;


}

/*
Function name :status_name()
Parameter : status
Return : status name in place of numeric value
Use :
*/
function status_name($status)
{
    $array = array(0 => DRAFT,
        '1' => PENDING,
        '2' => ACTIVE,
        '3' => SUCCESSFUL,
        '4' => FAILURE,
        '5' => FAILURE,
        '6' => DECLINE,
        '7' => INACTIVE_VISIBLE,
        '8' => INACTIVE_HIDDEN
    );
    return $array[$status];
}

/*
Function name :comment_status_name()
Parameter : status
Return : status name in place of numeric value
Use :
*/
function comment_status_name($status)
{
    $array = array(0 => PENDING,
        '1' => APPROVED,
        '2' => DECLINE,
        '3' => SPAM
    );
    return $array[$status];
}


/*
Function name :first_and_last_day()
Parameter : date
Return : return week_first_day and week_last_day fo week

*/
function first_and_last_day()
{
    $date = date('Y-m-d');
    $first_day = get_first_day_of_week($date);
    $last_day = get_last_day_of_week($date);
    $str = date('D m/d', strtotime($first_day)) . ' - ' . date('D m/d', strtotime($last_day));

    return $str;
}

function my_total_week_project_count($uid)
{
    $CI =& get_instance();

    $date = date('Y-m-d');
    $first_day = get_first_day_of_week($date);
    $last_day = get_last_day_of_week($date);

    $query = $CI->db->query("select * from project where user_id='" . $uid . "' and DATE(date_added) >= '" . $first_day . "' and DATE(date_added) <= '" . $last_day . "'");

    return $query->num_rows();
}

/*
Function name :is_allow_contribute()
Parameter : user_id,status,endate
Return : return true or false

use: will check the donor to allow donate or not

*/
function is_allow_contribute($user_id, $is_status, $endate)
{

    $CI =& get_instance();

    if ($user_id == $CI->session->userdata('user_id')) {

        return false;
    }
    $status = array(0, 1, 3, 4, 5, 6);
    if (in_array($is_status, $status)) {

        return false;
    }
    $start_date = time();
    $end_date = strtotime($endate);
    if ($start_date > $end_date) {

        return false;

    }

    return true;
}

function set_amount($amt = null)
{

    $CI =& get_instance();

    $site_setting = site_setting();

    $decimal_points = $site_setting['decimal_points'];

    $amt = number_format($amt, $decimal_points);

    return $amt;


}

function get_one_transaction($id)
{
    $CI =& get_instance();
    $query = $CI->db->get_where('transaction', array('transaction_id' => $id));
    if ($query->num_rows() > 0) {
        return $query->row_array();
    }
    return 0;
}

function get_payment_gateway($id = '')
{
    $CI =& get_instance();
    $query = $CI->db->get_where('gateways_details', array('payment_gateway_id' => $id));
    if ($query->num_rows() > 0) {
        return $query->result();
    }
    return 0;
}

function gateway_update($update_array = '', $id = '')
{
    $CI =& get_instance();
    $CI->db->where('id', $id);
    $CI->db->update('gateways_details', $update_array);
}

function delete_all_cache()
{
    $dir = scandir(base_path() . 'application/cache');
    // var_dump($dir);
    // die;
    foreach ($dir as $file) {
        if (!is_dir($file)) {
            //echo $file.'<br>';
            if (unlink(base_path() . 'application/cache/' . $file)) {
                //echo 'DELETED: '.$file.'<br>';
            }
        }
    }
    return 1;
}

function delete_cach()
{
    $dir = scandir(base_path() . 'application/cache');
    // var_dump($dir);
    // die;
    foreach ($dir as $file) {
        if (!is_dir($file)) {
            //echo $file.'<br>';
            if (unlink(base_path() . 'application/cache/' . $file)) {
                //echo 'DELETED: '.$file.'<br>';
            }
        }
    }
}

/*
Fetch username from user table
 *  */
function users_url_exists($url_username = '')
{
    $CI = &get_instance();
    $query = $CI->db->query("select user_name from user where user_name='" . $url_username . "'");
    if ($query->num_rows() > 0) {
        $data = $query->row_array();
        return $data['user_name'];
    }
    return '';
}

/*
Fetch slug from pages table
 *  */
function pages_url_exists($url_slug = '')
{
    $CI = &get_instance();
    $query = $CI->db->query("select slug from pages where slug='" . $url_slug . "'");
    if ($query->num_rows() > 0) {
        $data = $query->row_array();
        return $data['slug'];
    }
    return '';
}

/*
Fetch slug from learn_more table
 *  */
function learnmore_url_exists($url_slug = '')
{
    $CI = &get_instance();
    $query = $CI->db->query("select slug from learn_more where slug='" . $url_slug . "'");
    if ($query->num_rows() > 0) {
        $data = $query->row_array();
        return $data['slug'];
    }
    return '';
}


function getAllchildofcomment($id = '')
{
    $CI =& get_instance();
    //$query = $CI->db->get_where('comment',array('parent_id' => $id));
    $query = $CI->db->query("select user.*, comment.* from user inner join comment on user.user_id = comment.user_id where comment.parent_id ='" . $id . "'");
    //print_r($CI->db->last_query()); die;
    if ($query->num_rows() > 0) {
        return $query->result();
    }
    return 0;
}

/**
 * @param integer $id
 * @return int
 */
function getAllchildofcomment_details($id = '')
{
    $CI =& get_instance();
    //$query = $CI->db->get_where('comment',array('parent_id' => $id));
    $query = $CI->db->query("select user.*, comment.* from user inner join comment on user.user_id = comment.user_id where comment.status=1 and comment.parent_id ='" . $id . "'");
    //print_r($CI->db->last_query()); die;
    if ($query->num_rows() > 0) {
        return $query->result();
    }
    return 0;
}


/* this function is use for get the withdraw amount from wallet*/
function walletWithdrawamount()
{
    $userid = get_authenticateUserID();
    $CI =& get_instance();
    $query = $CI->db->query("select withdraw_amount from wallet_withdraw where user_id='" . $userid . "' order by withdraw_id DESC limit 1 ");

    if ($query->num_rows() > 0) {
        $submit_amount = $query->row();
        $amount = $submit_amount->withdraw_amount;
        return $amount;
    }
    return 0;

}

function get_learn_category_name($count = 'no', $category_id = '')
{
    $CI =& get_instance();
    //$query = $CI->db->query("select * from learn_more_category where active='1'");

    $CI->db->select('*');
    $CI->db->where('learn_more_category.active', '1');

    // if ($_SESSION['lang_code'] != '')
    //     $CI->db->where('iso2', $_SESSION['lang_code']);
    // if ($_SESSION['lang_folder'] != '')
    //     $CI->db->where('language_folder', $_SESSION['lang_folder']);

    $CI->db->from('learn_more_category');

    // $CI->db->join('language', 'language.language_id = learn_more_category.language_id', 'inner');
    if($category_id != '')
    {
        $CI->db->where('learn_more_category.category_id', $category_id);
    }
    $CI->db->order_by('category_name', 'asc');

    $query = $CI->db->get();


    if ($count == 'yes') {
        return $query->num_rows();
    } else {
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return 0;
        }
    }


}

function get_title_learn_more($id = '')
{
    $CI =& get_instance();
    if(is_numeric($id)){
        $query = $CI->db->query("select * from learn_more_category where category_id='" . $id . "'");
    }else{

        $query = $CI->db->query("select * from learn_more_category where slug='" . $id . "'");
    }

    if ($query->num_rows() > 0) {
        return $query = $query->row();
        // return $amount = $query->category_name;
    }
    return 0;

}

function inboxCount($id)
{
    $CI =& get_instance();
    $query = $CI->db->query("select * from message_conversation where  receiver_id ='" . $id . "' and is_read=0 and ( (admin_replay='admin' and (type=1 OR type=2) ) OR (type=0 and (admin_replay!='admin' OR admin_replay is NULL ) ) )");
    //echo  $CI->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->num_rows();
    }
    return 0;
}

function getMessageUnreadCount($message_id,$user_id){
     $CI =& get_instance();
    $query = $CI->db->query("select * from message_conversation where  (message_id ='" . $message_id . "' OR  reply_message_id ='" . $message_id . "' ) and is_read=0 and receiver_id='".$user_id."'  ");
    //echo  $CI->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->num_rows();
    }
    return 0;
}

///////////////// For activities added by ritu/////////////////
function add_activities($data = array(), $date = '')
{
    $CI =& get_instance();

    if ($data) {
        $activitydate = $data['activity_date'];
        $date1 = strtotime($activitydate);
        $date2 = strtotime($date);
        //echo $data['act'] .', ';

        if ($date1 == $date2) {
            $data['is_read'] = 0;

            $value = array(

                'act' => $data['act'],
                'activity_date' => $data['activity_date'],
                'user_id' => $data['key_id'],
                'user_name' => $data['user_name'],
                'is_read' => 0
            );

            $CI->db->insert('activities', $value);

        }

    }
}


function unread_activities($user_id = '')
{

    $CI =& get_instance();
    $query = $CI->db->get_where('user_activity', array('user_id' => $user_id, 'read' => 0));
    return $query->num_rows();

}

function read_activities($user_id = '')
{
    $CI =& get_instance();
    $CI->db->where('user_id', $user_id);
    $CI->db->update('user_activity', array('read' => 1));
}

function adminsendmsg($id)
{
    $CI =& get_instance();
    $query = $CI->db->query("select * from admin where  admin_id ='" . $id . "'");
    //echo  $CI->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->row();
    } else {
        return 0;
    }

}

function adminmsgCount()
{
    $CI =& get_instance();
    $query = $CI->db->query("select * from message_conversation where type in(1,2) and (admin_replay!='admin' OR admin_replay is NULL )  and message_content != '' and is_read=0");

    if ($query->num_rows() > 0) {
        return $query->num_rows();
    }
    return null;
}


function getAdminMessageUnreadCount($message_id){
     $CI =& get_instance();
    $query = $CI->db->query("select * from message_conversation where type in(1,2) and (admin_replay!='admin' OR admin_replay is NULL )  and is_read=0 and (message_id ='" . $message_id . "' OR  reply_message_id ='" . $message_id . "' )   ");
    //echo  $CI->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->num_rows();
    }
    return 0;
}

function activity_unread()
{
    $CI =& get_instance();
    $data_unread = array('read' => '0');
    $query = $CI->db->get_where('admin_activity', $data_unread);
    //echo  $CI->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->num_rows();
    }
    return null;
}

function get_font($id)
{
    $CI =& get_instance();
    $query = $CI->db->get_where('font_type', array('font_type_id' => $id));
    if ($query->num_rows() > 0) {
        return $query->row_array();
    }
    return 0;

}

/*
Function name :is_allow_request_access()
Parameter : user_id,type,status
Return : return data or 0

use: will check the login user to allow send request access

*/
function is_allow_request_access($user_id, $equity_id, $type)
{
    $CI =& get_instance();

    $status = array(0, 1, 2);

    $CI->db->where_in($type, $status);
    $CI->db->where('user_id', $user_id);
    $CI->db->where('equity_id', $equity_id);
    $query = $CI->db->get('access_request');

    if ($query->num_rows() > 0) {
        return $query->result_array();
    }
    return 0;
}

/*
Function name :investor_status()
Parameter :user_id ,equity_id;
Return : array
Use : check investor status ;
*/
function investor_status($user_id = 0, $equity_id = 0, $equity_url = '',$perk_id=0)
{

    $CI =& get_instance();
    $site_setting = site_setting();
    $taxonomy_setting = taxonomy_setting();
    $project_url = $taxonomy_setting['project_url'];

    $button_text = INVEST_NOW;
    $button_link = '<a href="#requestAccess-popup" class="btn-contribute mfPopup-inline">' . $button_text . '</a>';
    //anchor('#requestAccess-popup', , array('class' => 'btn-contribute mfPopup-inline'));
    $common_text_for_status = THIS_COMPANY_MAY_BE_INTERESTED;
    $class_add_pending = '';
    $interest_status = 0; //0==incomplete profile 1=not accreditation user ,2=verify accreditation user  ,3-interest request pending ,4=interest request approve ,5 =interest request rejected
    
    $investment_process_id='';
    
    $perk_button_href='#requestAccess-popup';
    $perk_button_class='mfPopup-inline';
    $perk_button_onclick='';
    
    
    $perk_attach=0;
    
    if ($user_id > 0) {
        $query = $CI->db->get_where('equity', array('equity_id' => $equity_id));


        $row = $query->row_array();
        $equity_owner_id = $row['user_id'];
        $status = $row['status'];
        $endate = $row['end_date'];
        $start_date = time();
        $end_date = strtotime($endate);

        if ($status != 2 || $start_date > $end_date) {

            $button_text = INVEST_NOW;
            $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute disabled'));
            $common_text_for_status = THIS_COMPANY_MAY_BE_INTERESTED;
            $interest_status = 0; //0==incomplete profile 1=not accreditation user ,2=verify accreditation user  ,3-interest request pending ,4=interest request approve ,5 =interest request rejected
            
            $perk_button_href='javascript://';
            $perk_button_class='disabled';
            $perk_button_onclick='';
    
    

        } else if ($equity_owner_id == $user_id) {
            $button_text = INVEST_NOW;
            $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute disabled'));
            $common_text_for_status = THIS_COMPANY_MAY_BE_INTERESTED;
            $interest_status = 0; //0==incomplete profile 1=not accreditation user ,2=verify accreditation user  ,3-interest request pending ,4=interest request approve ,5 =interest request rejected
            
            $perk_button_href='javascript://';
            $perk_button_class='disabled';
            $perk_button_onclick='';

        } else {

               $accrediation_manage = 'no';
              
            if($site_setting['accredential_status'] == 0 && $site_setting['accrediated_manage'] == 0)
            {
                
                $accrediation_manage = 'yes';
            }
           else if($site_setting['accredential_status'] == 0 && $site_setting['accrediated_manage'] == 1)
            
            {
               
                if($row['allowed_investor'] == 'yes')
                {
                     
                     $accrediation_manage = 'yes';
                }
                else
                {
                    $accrediation_manage = 'no';
                }
            }


            if ($accrediation_manage == 'yes') {

                $interest_status = 1;
                $button_text = VERIFY_INVESTOR_STATUS;

                $button_link = anchor('accreditation/personal', $button_text, array('class' => 'btn-contribute'));
                
                
                $perk_button_href=site_url('accreditation/personal');
                $perk_button_class='';
                $perk_button_onclick='';
            
            

                //check accreditation user status
                $query = $CI->db->get_where('accreditation', array('user_id' => $user_id));
                if ($query->num_rows() > 0) {
                    $row = $query->row_array();
                    $accreditation_status = $row['accreditation_status'];  //0=pending ,1=approve ,2-rejected
                    //we update status if user is accreditation and if rejected or pending then its redirect to accreditation status page
                    $intrest_status_update = '';
                    $query = $CI->db->get_where('interest_request', array('user_id' => $user_id, 'equity_id' => $equity_id));
                    if ($query->num_rows() > 0) {
                        $row = $query->row_array();
                        $intrest_status_update = $row['status'];  //0=pending ,1=approve ,2-rejected
                        //we update status if user is accreditation and if rejected or pending then its redirect to accreditation status page
                    }
                    if ($accreditation_status == 1) {
                        if ($intrest_status_update != 2) {
                            $interest_status = 2;
                            $button_text = I_AM_INTRESTED;
                            $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute', 'onclick' => 'interest_request(' . $equity_id . ');'));
                            
                            $perk_button_href='javascript://';
                            $perk_button_class='';
                            $perk_button_onclick='interest_request(' . $equity_id . ');';
                            
                        } else {
                            $interest_status = 4;
                            $button_text = INVEST_NOW;
                            
                            $perk_attach=1;
                            $investment_page='investment/investment_step_1/';
                            $enc_equity_id=encrypt($equity_id);
                            $button_link = anchor($investment_page . $enc_equity_id, $button_text, array('class' => 'btn-contribute'));
                            
                            
                            $perk_button_href=site_url('startinvest/index/' . $enc_equity_id);
                            $perk_button_class='';
                            $perk_button_onclick='';
                            
                        }


                    }

                


                //check interest request status
                $query = $CI->db->get_where('interest_request', array( 'user_id' => $user_id, 'equity_id' => $equity_id));
                if ($query->num_rows() > 0) {
                    $row = $query->row_array();
                   $intrest_status_update = $row['status'];  //0=pending ,1=pending  ,2-approve ,3 - rejected
                    //we update status if user is accreditation and if rejected or pending then its redirect to accreditation status page
                    if ($intrest_status_update == 2) {
                        $interest_status = 4;
                        $button_text = INVEST_NOW;
                        
                        $perk_attach=1;
                        $investment_page='investment/investment_step_1/';
                        $enc_equity_id=encrypt($equity_id);
                        $button_link = anchor($investment_page . $enc_equity_id, $button_text, array('class' => 'btn-contribute'));
                        
                        
                        
                        $perk_button_href=site_url($investment_page. $enc_equity_id);
                        $perk_button_class='';
                        $perk_button_onclick='';
                        
                        
                        //check investment processs
                       // $query = $CI->db->get_where('equity_investment_process', array('user_id' => $user_id,'equity_id'=>$equity_id, 'status' => 0 ,'invest_status_id < 7' ));
                       
                        $CI->db->select('*');
                        $CI->db->from('equity_investment_process');
                        $CI->db->where('user_id', $user_id);
                        $CI->db->where('equity_id', $equity_id);
                        $CI->db->where('status', '0');
                        $CI->db->where('invest_status_id <', 7);
                        $query = $CI->db->get();

                        if ($query->num_rows() > 0) {
                            
                            $investment_process_result=$query->row();
                            
                            $investment_process_id=$investment_process_result->id;
                            $interest_status = 4;
                            $button_text = INVESTMENT_IN_PROCESS;
                            
                            $perk_attach=0;
                            $investment_page='investment/investment_step_1/';
                            $enc_equity_id=encrypt($equity_id);
                            $enc_investment_process_id=encrypt($investment_process_id);
                            $button_link = anchor($investment_page . $enc_equity_id.'/'.$enc_investment_process_id, $button_text, array('class' => 'btn-contribute'));
                            
                            
                            $perk_button_href=site_url($investment_page . $enc_equity_id.'/'.$enc_investment_process_id);
                            $perk_button_class='';
                            $perk_button_onclick='';
                        
                            
                            
                        }
                    }


                    if ($intrest_status_update == 1) {
                        $interest_status = 3;  //process in pending ,you request is pending ,please contact owner(<Send message Link>)
                        $button_text = INVEST_NOW; ///diable button
                        $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute disabled'));
                        $common_text_for_status = YOU_REQUEST_IS_STILL_PENDING;
                        $class_add_pending = 'interested-request';
                        
                        $perk_attach=0;
                        
                        $perk_button_href='javascript://';
                        $perk_button_class='disabled';
                        $perk_button_onclick='';
                        
                        
                    }

                    if ($intrest_status_update == 3) {
                        $interest_status = 5;  //You can not access this page,you request is reejcted by project owner,please contact him(<Send message Link>)
                        $button_text = INVEST_NOW;  ///diable button
                        
                        $perk_attach=0;
                        
                        $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute disabled'));
                        $common_text_for_status = YOU_REQUEST_IS_REJECTED_BY_OWNER;
                        $class_add_pending = 'interested-request_rejected';
                        
                        
                        $perk_button_href='javascript://';
                        $perk_button_class='disabled';
                        $perk_button_onclick='';
                        
                    }
                }
            }


            } else {
               
                $interest_status = 1;
                $button_text = I_AM_INTRESTED;

                $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute', 'onclick' => 'interest_request(' . $equity_id . ');'));
                
                $perk_attach=0;
                
                $perk_button_href='javascript://';
                $perk_button_class='';
                $perk_button_onclick='interest_request(' . $equity_id . ');';
                
                
                $intrest_status_update = '';
                $query = $CI->db->get_where('interest_request', array('user_id' => $user_id, 'equity_id' => $equity_id));
                if ($query->num_rows() > 0) {
                    $row = $query->row_array();
                    $intrest_status_update = $row['status'];  //0=pending ,1=approve ,2-rejected
                    //we update status if user is accreditation and if rejected or pending then its redirect to accreditation status page
                }

                if ($intrest_status_update != 2) {
                    $interest_status = 1;
                    $button_text = I_AM_INTRESTED;
                    $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute', 'onclick' => 'interest_request(' . $equity_id . ');'));
                    $perk_attach=0;
                    $perk_button_href='javascript://';
                    $perk_button_class='';
                    $perk_button_onclick='interest_request(' . $equity_id . ');';
                
                    
                    
                } else {
                    $interest_status = 4;
                    $button_text = INVEST_NOW;
                    
                    $perk_attach=1;
                    $investment_page='investment/investment_step_1/';
                    $enc_equity_id=encrypt($equity_id);
                    ///$enc_investment_process_id=encrypt($investment_process_id);
                    $button_link = anchor($investment_page . $enc_equity_id, $button_text, array('class' => 'btn-contribute'));
                    
                    
                    $perk_button_href=site_url($investment_page . $enc_equity_id);
                    $perk_button_class='';
                    $perk_button_onclick='';
                
                    
                    
                }


                //check interest request status
                $query = $CI->db->get_where('interest_request', array('user_id' => $user_id, 'equity_id' => $equity_id));
                if ($query->num_rows() > 0) {
                    $row = $query->row_array();

                    $intrest_status_update = $row['status'];  //0=pending ,1=approve ,2-rejected
                    //we update status if user is accreditation and if rejected or pending then its redirect to accreditation status page
                    if ($intrest_status_update == 2) {
                        $interest_status = 4;
                        $button_text = INVEST_NOW;
                        
                        $perk_attach=1;
                         $investment_page='investment/investment_step_1/';
                        $enc_equity_id=encrypt($equity_id);
                    ///$enc_investment_process_id=encrypt($investment_process_id);
                        $button_link = anchor($investment_page . $enc_equity_id, $button_text, array('class' => 'btn-contribute'));
                        
                        
                        
                        
                        $perk_button_href=site_url($investment_page . $enc_equity_id);
                        $perk_button_class='';
                        $perk_button_onclick='';
                        
                        
                        //check investment processs
                       // $query = $CI->db->get_where('equity_investment_process', array('user_id' => $user_id, 'equity_id' => $equity_id, 'status' => '0'));
                       
                        $CI->db->select('*');
                        $CI->db->from('equity_investment_process');
                        $CI->db->where('user_id', $user_id);
                        $CI->db->where('equity_id', $equity_id);
                        $CI->db->where('status', '0');
                        $CI->db->where('invest_status_id <', 7);
                        $query = $CI->db->get();

                        if ($query->num_rows() > 0) {
                            
                            $investment_process_result=$query->row();
                            
                            $investment_process_id=$investment_process_result->id;
                            
                            $interest_status = 4;
                            $button_text = INVESTMENT_IN_PROCESS;
                            
                            $perk_attach=0;
                             $investment_page='investment/investment_step_1/';
                            $enc_equity_id=encrypt($equity_id);
                           $enc_investment_process_id=encrypt($investment_process_id);
                            $button_link = anchor($investment_page . $enc_equity_id.'/'.$enc_investment_process_id, $button_text, array('class' => 'btn-contribute'));
                            
                            $perk_button_href=site_url($investment_page . $enc_equity_id.'/'.$enc_investment_process_id);
                            $perk_button_class='';
                            $perk_button_onclick='';
                            
                            
                            
                        }
                    }


                    if ($intrest_status_update == 1) {
                        $interest_status = 3;  //process in pending ,you request is pending ,please contact owner(<Send message Link>)
                        $button_text = INVEST_NOW; ///diable button
                        $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute disabled'));
                        $common_text_for_status = YOU_REQUEST_IS_STILL_PENDING;
                        
                        $perk_attach=0;
                        
                        $class_add_pending = 'interested-request';
                        
                        $perk_button_href='javascript://';
                        $perk_button_class='disabled';
                        $perk_button_onclick='';
                        
                        
                    }

                    if ($intrest_status_update == 3) {
                        $interest_status = 5;  //You can not access this page,you request is reejcted by project owner,please contact him(<Send message Link>)
                        $button_text = INVEST_NOW;  ///diable button
                        
                        $perk_attach=0;
                        
                        $button_link = anchor('javascript://', $button_text, array('class' => 'btn-contribute disabled'));
                        $common_text_for_status = YOU_REQUEST_IS_REJECTED_BY_OWNER;
                        $class_add_pending = 'interested-request_rejected';
                        
                        
                        $perk_button_href='javascript://';
                        $perk_button_class='disabled';
                        $perk_button_onclick='';
                        

                    }
                }
            }
        }


    } else {
        $return_url = base64_encode($project_url.'/' . $equity_url);
        $button_text = INVEST_NOW;
        
        $perk_attach=0;
        
        $button_link = anchor('home/login/' . $return_url, $button_text, array('class' => 'btn-contribute'));
        $common_text_for_status = THIS_COMPANY_MAY_BE_INTERESTED;
        $interest_status = 0; //0==incomplete profile 1=not accreditation user ,2=verify accreditation user  ,3-interest request pending ,4=interest request approve ,5 =interest request rejected
        
        
        $perk_button_href=site_url('home/login/' . $return_url);
        $perk_button_class='';
        $perk_button_onclick='';
        
    }
    $ret_array = array('button_text' => $button_text, 'button_link' => $button_link, 'common_text_for_status' => $common_text_for_status, 'interest_status' => $interest_status, 'class_add_pending' => $class_add_pending,'investment_process_id'=>$investment_process_id,'perk_attach'=>$perk_attach,'perk_button_href'=>$perk_button_href,'perk_button_class'=>$perk_button_class,'perk_button_onclick'=>$perk_button_onclick);
    return $ret_array;

}
 
function getCategoryTitle($type,$search_msg='',$status='',$category_id_search ='')
{
    $CI =& get_instance();
    //$query = $CI->db->get_where('comment',array('parent_id' => $id));
    //$query = $CI->db->query("select * from project_category where project_category.url_category_title ='" . $type . "'");
    //print_r($CI->db->last_query()); die;
    $CI->db->select('*');
    $CI->db->from('company_category');
    if($type != '')
    {
        $CI->db->where('company_category.url_company_category', $type);
    }
    if($category_id_search > 0)
    {
        $CI->db->where('company_category.id', $category_id_search);
    }
    if($status != '')
    {
         $CI->db->where('company_category.status', $status);
    }    
    $query = $CI->db->get();
   
    if ($query->num_rows() > 0) {

        return $result = $query->result_array();
    } else {
        //return str_replace("_", " ", $type);
        return $search_msg;
    }

}


function GetDealTypeName($deal_name = '')
{
    $CI =& get_instance();
    $query = $CI->db->query("select deal_type_name,deal_type_icon from deal_type_setting where slug='" . $deal_name . "'");
    $data = $query->row_array();
    return $data;
}


/*
	Function name :GetAccessRequest()
	Parameter :user_id,GetAccessRequest,joinarr,limit,order,offset,count,is_interest_request_status
	Return : Return all access request
	Use : Fetch all request from detail page
	
			
	*/

function GetPendingRequest($access_request_id = 0, $equity_id = 0)
{
    $CI =& get_instance();
    $CI->db->select('*');

    $CI->db->from('access_request');

    $CI->db->where('access_request_id', $access_request_id);
    $CI->db->where('equity_id', $equity_id);
    $CI->db->where('comments in (1)');
    $CI->db->where('updates in (1)');
    $CI->db->where('funders in (1)');
    $CI->db->where('docs_media in (1)');

    $query = $CI->db->get();
    //echo $CI->db->last_query();die;

    return $query->num_rows();

}

function CheckValue($value = '')
{
    if ($value != '') return $value;
    else return NA;
}

function addhttp($url) {
    if($url != '')
    {
        return (substr($url, 0, 7) == 'http://' || substr($url, 0, 8) == 'https://')
        ? $url 
        : 'http://'.$url;
    }
    else
    {
        return '';
    }
}


function GetInvestorStatus($user_id = '',$equity_id='')
{
    $CI =& get_instance();
    $query = $CI->db->query("select invest_status_id from equity_investment_process where user_id='" . $user_id . "' and equity_id = '".$equity_id."'");

    if ($query->num_rows() > 0) {
        return $query->row_array();
    }
    return 0;

}

// create slug
    function my_str_split($string)
   {
      $slen=strlen($string);
      for($i=0; $i<$slen; $i++)
      {
         $sArray[$i]=$string{$i};
      }
      return $sArray;
   }

   function noDiacritics($string)
   {
      //cyrylic transcription
      $cyrylicFrom = array('?', 'Б', 'В', 'Г', 'Д', 'Е', '?', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', '?', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я', 'а', 'б', 'в', 'г', 'д', 'е', 'ё', 'ж', 'з', 'и', 'й', 'к', 'л', 'м', 'н', 'о', 'п', 'р', '?', 'т', 'у', 'ф', 'х', 'ц', 'ч', 'ш', 'щ', 'ъ', 'ы', 'ь', '?', 'ю', '?');
      $cyrylicTo   = array('A', 'B', 'W', 'G', 'D', 'Ie', 'Io', 'Z', 'Z', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'F', 'Ch', 'C', 'Tch', 'Sh', 'Shtch', '', 'Y', '', 'E', 'Iu', 'Ia', 'a', 'b', 'w', 'g', 'd', 'ie', 'io', 'z', 'z', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'f', 'ch', 'c', 'tch', 'sh', 'shtch', '', 'y', '', 'e', 'iu', 'ia'); 
 
      
      $from = array("?", "À", "Â", "Ä", "Ă", "Ā", "Ã", "Å", "Ą", "Æ", "Ć", "Ċ", "Ĉ", "Č", "Ç", "Ď", "?", "?", "É", "È", "Ė", "Ê", "Ë", "Ě", "Ē", "Ę", "?", "Ġ", "Ĝ", "Ğ", "Ģ", "á", "à", "â", "ä", "ă", "?", "ã", "å", "ą", "æ", "ć", "ċ", "ĉ", "?", "ç", "?", "đ", "ð", "é", "è", "ė", "ê", "ë", "ě", "ē", "ę", "ə", "ġ", "?", "ğ", "ģ", "Ĥ", "Ħ", "I", "?", "Ì", "İ", "Î", "?", "Ī", "Į", "Ĳ", "Ĵ", "Ķ", "Ļ", "?", "Ń", "Ň", "Ñ", "Ņ", "Ó", "Ò", "Ô", "Ö", "Õ", "?", "Ø", "Ơ", "Œ", "ĥ", "ħ", "ı", "í", "ì", "i", "î", "ï", "ī", "į", "ĳ", "ĵ", "ķ", "ļ", "ł", "ń", "ň", "ñ", "ņ", "ó", "ò", "ô", "ö", "õ", "ő", "ø", "ơ", "œ", "Ŕ", "Ř", "Ś", "Ŝ", "Š", "Ş", "Ť", "Ţ", "Þ", "Ú", "Ù", "Û", "Ü", "Ŭ", "Ū", "Ů", "Ų", "Ű", "Ư", "Ŵ", "?", "Ŷ", "Ÿ", "Ź", "Ż", "Ž", "ŕ", "ř", "ś", "?", "š", "ş", "ß", "ť", "ţ", "þ", "ú", "ù", "û", "ü", "ŭ", "ū", "ů", "ų", "ű", "ư", "ŵ", "ý", "ŷ", "ÿ", "ź", "ż", "ž");
      $to   = array("A", "A", "A", "A", "A", "A", "A", "A", "A", "AE", "C", "C", "C", "C", "C", "D", "D", "D", "E", "E", "E", "E", "E", "E", "E", "E", "G", "G", "G", "G", "G", "a", "a", "a", "a", "a", "a", "a", "a", "a", "ae", "c", "c", "c", "c", "c", "d", "d", "d", "e", "e", "e", "e", "e", "e", "e", "e", "g", "g", "g", "g", "g", "H", "H", "I", "I", "I", "I", "I", "I", "I", "I", "IJ", "J", "K", "L", "L", "N", "N", "N", "N", "O", "O", "O", "O", "O", "O", "O", "O", "CE", "h", "h", "i", "i", "i", "i", "i", "i", "i", "i", "ij", "j", "k", "l", "l", "n", "n", "n", "n", "o", "o", "o", "o", "o", "o", "o", "o", "o", "R", "R", "S", "S", "S", "S", "T", "T", "T", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "W", "Y", "Y", "Y", "Z", "Z", "Z", "r", "r", "s", "s", "s", "s", "B", "t", "t", "b", "u", "u", "u", "u", "u", "u", "u", "u", "u", "u", "w", "y", "y", "y", "z", "z", "z");
      
      
      $from = array_merge($from, $cyrylicFrom);
      $to   = array_merge($to, $cyrylicTo);
      
      $newstring=str_replace($from, $to, $string);   
      return $newstring;
   }

   function makeSlugs($string, $maxlen=0)
   {
      $newStringTab=array();
      $string=strtolower(noDiacritics($string));
      if(function_exists('str_split'))
      {
         $stringTab=str_split($string);
      }
      else
      {
         $stringTab=my_str_split($string);
      }

      $numbers=array("0","1","2","3","4","5","6","7","8","9","-");
      //$numbers=array("0","1","2","3","4","5","6","7","8","9");

      foreach($stringTab as $letter)
      {
         if(in_array($letter, range("a", "z")) || in_array($letter, $numbers))
         {
            $newStringTab[]=$letter;
            //print($letter);
         }
         elseif($letter==" ")
         {
            $newStringTab[]="-";
         }
      }

      if(count($newStringTab))
      {
         $newString=implode($newStringTab);
         if($maxlen>0)
         {
            $newString=substr($newString, 0, $maxlen);
         }
         
         $newString = removeDuplicates('--', '-', $newString);
      }
      else
      {
         $newString='';
      }      
      
      return $newString;
   }
   
   
   function checkSlug($sSlug)
   {
      if(ereg ("^[a-zA-Z0-9]+[a-zA-Z0-9\_\-]*$", $sSlug))
      {
         return true;
      }
      
      return false;
   }
   
   function removeDuplicates($sSearch, $sReplace, $sSubject)
   {
      $i=0;
      do{
      
         $sSubject=str_replace($sSearch, $sReplace, $sSubject);         
         $pos=strpos($sSubject, $sSearch);
         
         $i++;
         if($i>100)
         {
            die('removeDuplicates() loop error');
         }
         
      }while($pos!==false);
      
      return $sSubject;
   }
   
   ///////////////// For php supported timezone added by kashyap/////////////////

function tz_list() {
  $zones_array = array();
  $timestamp = time();
  foreach(timezone_identifiers_list() as $key => $zone) {
    date_default_timezone_set($zone);
    $zones_array[$key]['zone'] = $zone;
    $zones_array[$key]['diff_from_GMT'] = 'UTC/GMT ' . date('P', $timestamp);
  }
  return $zones_array;
}
function check_is_company_follower($company_id, $company_follow_user_id)
{
    $CI =& get_instance();
    $query = $CI->db->query('select * from company_follower where company_id=' . $company_id . ' and company_follow_user_id=' . $company_follow_user_id);
    if ($query->num_rows() > 0) {
        return 1;
    } else {
        return 0;
    }

}

function make_unique($equity_id ,$equity_url)
{
    $CI =& get_instance();
    $query = $CI->db->query("select equity_id from equity where equity_id!='" . $equity_id ."'  and equity_url = '".$equity_url."'" );
   $i= $query->num_rows();

    if ( $i > 0) {
         
       return make_unique($equity_id,$equity_url.'-'.++$i);
    } else {
        return $equity_url;
    }
}
function create_project_url($equity_url = '',$equity_id =0)
{
    global $equity_url_counter;
    $CI = &get_instance();
   if($equity_id > 0) $query = $CI->db->query("select equity_url from equity where equity_url='" . $equity_url . "' and equity_id !=" . $equity_id);
    else $query = $CI->db->query("select equity_url from equity where equity_url='" . $equity_url . "'");
    //echo $CI->db->last_query();die;
    if ($query->num_rows() > 0) {
        $data = $query->row_array();
        $equity_url= $data['equity_url']; 
        $equity_url_counter=$equity_url_counter+1;
        
        $str = $equity_url;
        $number=$equity_url_counter;
        $substr=substr(trim($str), -1);
        //checking that last character should be numeric then only add number
        if(is_numeric($substr))
        {
            preg_match_all('!\d+!', $str, $matches);
            if(isset($matches[0]))
            {
                $count=count($matches[0]);
                if($count>0)
                {
                    $number=$matches[0][$count-1];
                    $equity_url=str_lreplace($number,"",$equity_url);//replace last occurrence only;
                    $number=intval($number)+1;
                }
            }
        }   
        

        $equity_url = $equity_url . $number;
        $equity_url=create_project_url($equity_url ,$equity_id)  ;               
                            
    }
    return $equity_url;
}
function str_lreplace($search, $replace, $subject)
{
    return preg_replace('~(.*)' . preg_quote($search, '~') . '~', '$1' . $replace, $subject, 1);
}
function getTranesctionStatusArray()
{
   return $status_array = array('ON_HOLD' => PENDING,
                                'FAIL' => FAIL,
                                'SUCCESS' => SUCCESS,
                                'REFUNDED' =>REFUNDED,
                                'PENDING' => PENDING,// for offline payment
                                'CANCELLED' => CANCELLED,
                                                );
}

function GetPaymentGatewayName($id="")
{
    switch ($id) {
        case 0:
            $payment_gateway_name = 'wallet';
            break;
        case 1:
            $payment_gateway_name = 'Paypal Adaptive';
            break;
        case 2:
            $payment_gateway_name = '';
            break;
        case 3:
            $payment_gateway_name = '';
            break; 
        case 4:
            $payment_gateway_name = 'Stripe';
            break;
        case 5:
            $payment_gateway_name = 'Offline';
            break;
        case 6:
            $payment_gateway_name = 'Wepay';
            break;    
        default:
            $payment_gateway_name = '';
            break;        
                 } 

    return $payment_gateway_name;                                      
}

/*
    Function name :GetHigherCategoriesCompany()
    Parameter : no
    Return : Return all company Category
    Use : Fetch all company category

    */

    function GetHigherCategoriesCompany($limit=5)
    {
         $CI =& get_instance();
        
       $CI->db->where(array('company_category.status' => 1));
        //$this->db->order_by('project_category_name','asc');
       if ($_SESSION['lang_code'] != '')
            $CI->db->where('iso2', $_SESSION['lang_code']);
        if ($_SESSION['lang_folder'] != '')
            $CI->db->where('language_folder', $_SESSION['lang_folder']);

        $CI->db->from('company_category');

        $CI->db->join('language', 'language.language_id = company_category.language_id', 'inner');
        
        $CI->db->order_by('id', 'RANDOM');
       
        $CI->db->limit($limit);
        $query = $CI->db->get();
       //cho $this->db->last_query();die;
        if ($query->num_rows()) {
            return $result = $query->result();
        } else {
            return 0;
        }
    }

    function check_company_can_delete($company_id) {
         $CI =& get_instance();
        $CI->db->where_in('status', array('2','3','4','5','6','7','8'));
        $equity = $CI->db->get_where('equity', array('company_id' => $company_id))->row_object();
        return ($equity) ? false : true;
    }


    function slugify($text)
    {
      // replace non letter or digits by -
      $text = preg_replace('~[^\pL\d]+~u', '-', $text);

      // transliterate
      $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

      // remove unwanted characters
      $text = preg_replace('~[^-\w]+~', '', $text);

      // trim
      $text = trim($text, '-');

      // remove duplicate -
      $text = preg_replace('~-+~', '-', $text);

      // lowercase
      $text = strtolower($text);

      if (empty($text)) {
        return 'n-a';
      }

      return $text;
    }
    
    function newsletterApiSubscribe($type,$email,$first_name='',$last_name='')
    {
        try
        {
          $CI =& get_instance();
           $result_array= $CI->db->where('active',1)->get('newsletter_apis')->result_array();

          if($result_array){
            foreach ($result_array as $result) {
               
                           $newsletter_apis_name=$result['newsletter_apis_name'];
                           switch ($newsletter_apis_name) {
                               case 'mailchimp':


                                 $settings=unserialize($result['settings']);

                                if($type=='donation'){
                                    $list_id=$settings['donation_list_id'];
                                }else if($type=='sign_up'){
                                    $list_id=$settings['signup_list_id'];
                                }else{
                                    $list_id=$settings['footer_subscribe_list_id'];
                                }
                                 $api_key =  $settings['api_key'];
                                $api_url = $settings['api_endpoint'];
                         if($api_key !='' &&  $api_url !='' &&  $list_id != '' )
                            {
                                $CI->load->library('mailChimp', array('api_key' => $settings['api_key'],'api_endpoint'=>$settings['api_endpoint']) );
                                $m_result = $CI->mailchimp->post("lists/$list_id/members", array(
                                    'email_type'                => 'text',
                                    'status'            => "subscribed",
                                    'email_address'     => $email,
                                    'merge_fields'      => array('FNAME'=>$first_name, 'LNAME'=>$last_name),
                                    'double_optin'      => false,
                                    'update_existing'   => true,
                                    'replace_interests' => false,
                                    'send_welcome'      => false,
                                ));
                                // echo '<pre>';
                                 // var_dump($m_result); 
                                }
                                
                                   break;
                                   case 'getresponse':
                                   
                                    require(base_path().'/application/libraries/JsonRPCClient.php');

                                     $settings=unserialize($result['settings']);


                                        if($type=='donation'){
                                            $list_name=$settings['donation_list_name'];
                                        }else if($type=='sign_up'){
                                            $list_name=$settings['signup_list_name'];
                                        }else{
                                            $list_name=$settings['footer_subscribe_list_name'];
                                        }
                                    # your API key is available at
                                    # https://app.getresponse.com/my_api_key.html
                                    $api_key =  $settings['api_key'];
                                    # API 2.x URL
                                    $api_url = $settings['api_endpoint'];
                                    # initialize JSON-RPC client
                                    $client = new JsonRPCClient($api_url);
                                    //echo "<pre>";
                                    if($api_key !='' &&  $api_url !='' &&  $list_name != '' )
                                    {
                                         try{
                                            # find campaign named 'test'
                                            $campaigns = $client->get_campaigns(
                                                $api_key,
                                                array (
                                                    # find by name literally
                                                    'name' => array ( 'EQUALS' =>$list_name )
                                                )
                                            );
                                            # uncomment following line to preview Response
                                             //print_r($campaigns);

                                             $campaign_list=array_keys($campaigns);


                                            # because there can be only one campaign of this name
                                            # first key is the CAMPAIGN_ID required by next method
                                            # (this ID is constant and should be cached for future use)
                                            $CAMPAIGN_ID = $campaign_list[0];
                                            # add contact to the campaign
                                           

                                                $result = $client->add_contact(
                                                    $api_key,
                                                    array (
                                                        # identifier of 'test' campaign
                                                        'campaign'  => $CAMPAIGN_ID,
                                                        # basic info
                                                        'name'      => $first_name.' '.$last_name,
                                                        'email'     => $email,
                                                       
                                                    )
                                                );
                                                }
                                           catch (Exception $e) {
                                                        echo 'Caught exception: ',  $e->getMessage(), "\n";
                                                    }


                                }
                                   
                                     
                              break;
                               
                               default:
                                    $CI->load->model('newsletter_model');
                                      $make_subscribe = $CI->newsletter_model->make_new_subscription($email);
                                   break;
                           }    
                }
              
            return 1;
       }
       return false;
        }
        catch (Exception $e) {
            //echo 'Caught exception: ',  $e->getMessage(), "\n";
        }
    }
     function getTermsLenght($return_payment_frequency,$return_term_length) {

        
        
       
      switch($return_payment_frequency) {
                case 'days':
                    return $return_term_length.' '.DAYS;
                    break;  

                    case 'monthly':
                    return $return_term_length.' '.MONTH;
                    break;  

                    case 'quarterly':
                    return $return_term_length.' '.YEARS;
                    break;

                case 'yearly':
                    return $return_term_length.' '.YEARS;
                    break;

                default:
                    return $return_term_length;
                   break;
            }   

  }

  function GetUserDonationOrg($user_id = 0)
    {
         
      
        $selectfields = 'transaction.name,transaction.paypal_adaptive_status,transaction.user_id as donor_id,transaction.transaction_date_time,transaction.email,transaction.pay_fee,transaction.amount,transaction.comment,transaction.trans_anonymous,transaction.shipping,transaction.transaction_id,transaction.perk_delivered,transaction.perk_id,transaction.project_id, transaction.projects_sub_amounts as donar_amount,transaction.beneficiary_id,transaction.transaction_id,user.user_name, user.last_name,user.image,user.address,user.profile_slug,user.user_type,user.email as owner_email,organization.*';

        $this->db->select($selectfields);
        $this->db->from('transaction');
        
        $this->db->join('user', 'transaction.receiver_user_id=user.user_id', 'left');

         $this->db->join('organization', 'organization.user_id=user.user_id', 'left');

        
        $this->db->where('transaction.receiver_user_id', $user_id);
        
        $this->db->where('transaction.paypal_adaptive_status ', 'SUCCESS');
               
        $query = $this->db->get();
     
        if ($query->num_rows() > 0) {
            
            
            $result = $query->result_array();
           
          
            return $result;
        } else {
            return 0;
        }
    }
?>
