<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Startinvest extends ROCKERS_Controller

{
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('equity_model');
        $this->load->model('follower_model');
        $this->load->model('following_model');
        $this->load->model('account_model');
        $this->load->model('startequity_model');
        $this->load->library('securimage');
    }

    /*
    Function name :index()
    Parameter :equity_id ,perk_id
    Return : none
    Use : when user click on Invest now button from equity detail then its come here
     to complete paymanet process by choosing  particular payment gateway
    */
    function index($equity_id = 0, $perk_id = 0)
    {

        $data = array();
        $offset = 0;
        $limit = 3;
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $payment_gateway = $site_setting['payment_gateway'];
        $equity = GetOneEquity($equity_id);
        $user_id = check_user_authentication(true);
        $investor_manage = investor_status($user_id, $equity_id);
        $taxonomy_setting = taxonomy_setting();
        $project_url = $taxonomy_setting['project_url'];
        if ($investor_manage['interest_status'] != 4) {
            redirect($project_url . '/' . $equity['equity_url']);
        }
        if ($perk_id == '' || $perk_id == 0) {
            $data['is_perks'] = 0;
        } else {
            $data['is_perks'] = 1;
        }

        if ($_POST) {
            foreach (array_keys($_POST) as $key) {
                $_POST[$key] = SecurePostData($_POST[$key]);
            }
        }
        if ($_GET) {
            foreach (array_keys($_GET) as $key) {
                $_GET[$key] = SecurePostData($_GET[$key]);
            }
        }
        $this->load->helper('htmlpurifier');
        // this function used before data goes to db
        $dataarray = array();
        $category_equities = '';

        $page_term_array = array('slug' => 'help');
        $helps_data = $this->startequity_model->getTableData('pages', $page_term_array);
        $data['helps_data'] = $helps_data[0];


        $data['company_category'] = $equity['company_category'];
        $category_equities = $this->equity_model->GetAllEquities(0, $equity_id, 0, '', array(
            'user'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        $data['category_equities'] = $category_equities;
        $dataarray['amount'] = SecurePostData($this->input->post('amount'));
        $dataarray['payment_gateway'] = $payment_gateway;
        $min_amount_error = '';
        $min_amount = '';
        $max_amount_error = '';
        $max_amount = '';
        if ($dataarray['amount'] > 0) {

            if ($this->input->post('amount') < $equity['minimum_raise']) {
                $min_amount_error = 'min';
                $donation_amount = set_currency($equity['minimum_raise']);
                $min_amount = sprintf(DONATION_MIN_AMOUNT, $donation_amount);
            }
            if ($this->input->post('amount') > $equity['goal']) {
                $max_amount_error = 'max';
                $maximum_donation_amount = set_currency($equity['goal']);
                $max_amount = sprintf(DONATION_MAX_AMOUNT, $maximum_donation_amount);
            }
        }
        $dataarray['perks'] = SecurePostData($this->input->post('perks'));

        $dataarray['email'] = SecurePostData($this->input->post('email'));
        $dataarray['anonymous'] = SecurePostData($this->input->post('anonymous'));

        $dataarray['payment_gateway'] = SecurePostData($this->input->post('payment_gateway'));
        $dataarray['wallet_gateway'] = SecurePostData($this->input->post('wallet_gateway'));
        $dataarray['equity_id'] = SecurePostData($this->input->post('equity_id'));
        $dataarray['perk_id'] = SecurePostData($this->input->post('perk_id'));
        $dataarray['docomment'] = SecurePostData($this->input->post('docomment'));
        // $equity_data = GetOneEquity($equity_id);
        $data['company_name'] = $equity['company_name'];
        $data['equity_user_id'] = $equity['user_id'];

        $_SESSION["donatedata"] = $dataarray;

        $this->form_validation->set_rules('amount', DONATION_AMOUNT, 'required|is_numeric');
        if ($this->session->userdata('user_id') == '') {
            $this->form_validation->set_rules('email', EMAIL, 'required|matches[co-email]');
            $this->form_validation->set_rules('co-email', CONFIRM_EMAIL, 'required');
        }
        if ($this->form_validation->run() == FALSE || $min_amount_error == "min" || $max_amount_error == 'max') {
            if (validation_errors()) {
                $data['error'] = validation_errors();
            } elseif ($min_amount_error == "min") {
                $data['error'] = $min_amount;
            } elseif ($max_amount_error == "max") {
                $data['error'] = $max_amount;
            } else {
                $data['error'] = "";
            }
            $data['amount'] = SecurePostData($this->input->post('amount'));
            $data['perks'] = SecurePostData($this->input->post('perks'));
            if ($data['perks'] > 0) {
                $data['chk'] = 'checked=checked';
            }
            $data['email'] = SecurePostData($this->input->post('email'));
            $data['confemail'] = SecurePostData($this->input->post('co-email'));
            $data['anonymous'] = SecurePostData($this->input->post('anonymous'));
            $data['payment_gateway'] = SecurePostData($this->input->post('payment_gateway'));
            $data['wallet_gateway'] = SecurePostData($this->input->post('wallet_gateway'));
            $data['equity_id'] = SecurePostData($this->input->post('equity_id'));
            $data['perk_id'] = SecurePostData($this->input->post('perk_id'));
            $data['docomment'] = SecurePostData($this->input->post('docomment'));

        } else {
            if ($_POST) {
                $gateway = $dataarray['payment_gateway'];
                  $first_name=$this->session->userdata('user_name');
                    $last_name=$this->session->userdata('last_name');
                    $email=$this->session->userdata('email');
                    newsletterApiSubscribe('donation',$email,$first_name,$last_name);

                switch ($gateway) {


                    case 5:
                        redirect("investment/investor/" . $equity_id);
                        break;

                    default:
                        echo "No gateway found";
                        die;
                }
            }
        }

        $perk = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'perk'
        ), $limit = 10, $group = array(), $order = array(
            'perk.perk_amount' => 'asc'
        ));
        $data['perk'] = $perk;
        $data['perk_id'] = $perk_id;
        $data['equity_id'] = $equity_id;
        $data['equity_url'] = $equity['equity_url'];
        //$gateways = $this->active_gateway();
        //$data['gateways'] = $gateways;
        $data['gateways'] = '';
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'startinvest/index', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }


}

?>
