<?php


/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Start_Equity extends ROCKERS_Controller
{
    /**
     *
     */
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('account_model');
        $this->load->model('startequity_model');
        $this->load->model('activity_model');
        $this->load->model('equity_model');
        $this->load->library('securimage');
        $this->load->library('ROCKERS_Form_validation');
        $this->load->helper('download');

    }

    /*
	Function name :index()
	Parameter :none
	Return : none
	Use : none;
	*/
    function index()
    {
        $this->create_prestep();
    }

    /*
	Function name :create_prestep()
	Parameter :none
	Return : none
	Use : none;
	*/
    function create_prestep($equity_id = '')
    {

        $data = array();
        $user_id = check_user_authentication(true);
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;

        $taxonomy_setting = taxonomy_setting();
        $project_url = $taxonomy_setting['project_url'];
        //Start :Check equity Limitation 

        $query = $this->db->get_where('equity', array('user_id' => $user_id, 'YEAR(date_added)' => date('Y')));
       
        if($equity_id == 0 || $equity_id == '')
        {
        
            if ($query->num_rows() >= $site_setting['maximum_project_per_year']) {
                redirect('home/index/cannot_equity_limit');
            }
        }
        //End :Check equity Limitation 


        $company_data = $this->startequity_model->GetUserCompnaies($user_id);

        if ($equity_id) {
            $chech_id_array = array("equity_id" => $equity_id);
            $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
            $equity = $equity_data[0];
            $equity_id = $equity['equity_id'];
            redirect('start_equity/create_step1/' . $equity_id);
        }
        $data['id'] = $equity_id;

        $meta = meta_setting();
        $page_term_array = array('slug' => 'Terms-of-service');
        $terms_data = $this->startequity_model->getTableData('pages', $page_term_array);
        $data['terms_data'] = $terms_data[0];

        $page_guide_array = array('slug' => 'project-guidelines');
        $equity_guideline_data = $this->startequity_model->getTableData('pages', $page_guide_array);
        $data['project_guideline_data'] = $equity_guideline_data[0];

        $this->load->library('form_validation');
        $this->form_validation->set_rules('terms_service', TERMS_OF_SERVICE, 'required|trim');

        require(base_path().'/application/libraries/ReCaptcha/src/autoload.php'); 
        $secret = $site_setting['captcha_private_key']; 
        $captcha_result = '';
         $cat_err ='';
        if ($_POST) {
            if ($site_setting['contact_us_captcha'] == 1) {
                $recaptcha = new \ReCaptcha\ReCaptcha($secret);
                $session_ip_address = $this->session->userdata('ip_address');
                $resp = $recaptcha->verify($_POST['g-recaptcha-response'], $session_ip_address);

                if ($resp->isSuccess()) {
                    $captcha_result = '';
                } else {
                   $cat_err .= '<p>' . IMAGE_VERIFICATION_WRONG . '</p>';
                }
            }
        }

        if ($this->form_validation->run() === FALSE || $cat_err != '' ) {
            $data['error'] = $cat_err;
        } else {
            $equity_id = SecurePostData($this->input->post('id'));
            if ($equity_id == '') {
                $terms_step_array = array(
                    'user_id' => $this->session->userdata('user_id'),
                    'terms_service' => SecurePostData($this->input->post('terms_service')),
                    'date_added' => date('Y-m-d H:i:s'),
                    'host_ip' => $_SERVER['REMOTE_ADDR'],
                    'status' => 0
                );
                $this->startequity_model->AddInsertUpdateTable('equity', '', '', $terms_step_array);
                $equity_id =$this->db->insert_id();

                ///////// add latest activities	
                project_activity('draft_project', $this->session->userdata('user_id'), '', $equity_id);
                ///////// end 
                $userdetail = UserData($user_id, array());

                $equity['user_name'] = $userdetail[0]['user_name'] . ' ' . $userdetail[0]['last_name'];
                $equity['email'] = $userdetail[0]['email'];
                $equity['equity_name'] = 'Untitle';
                $equity['complete_my_campaign'] = '<a href="' . site_url('start_equity/create_step1/' . $equity_id) . '">' . COMPLETE_MY_COMPAIGN . '</a>';;
                 $equity['user_id']=$userdetail[0]['user_id'];
                $this->EquityMailAlerts('equity_draft', '', $equity, '', 'New Equity Draft Successful Alert');

               

                if (is_array($company_data)) {

                    redirect('start_equity/select_company/' . $equity_id);
                } else {

                    redirect('start_equity/select_company_new/' . $equity_id);
                }
            } else {
                $terms_step_array = array(
                    'user_id' => $this->session->userdata('user_id'),
                    'terms_service' => SecurePostData($this->input->post('terms_service')),

                );


                $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $terms_step_array);
                 project_deletecache($equity_id);


                if (is_array($company_data)) {

                    redirect('start_equity/select_company/' . $equity_id);
                } else {

                    redirect('start_equity/create_step1/' . $equity_id);
                }
            }

        }

        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/create_prestep1', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :create_step1()
	Parameter :id;
	Return : none
	Use : Creating a equity step1 ;
	*/
    function select_company_new($id = '')
    {

        $user_id = check_user_authentication(true);
        $userdetail = UserData($user_id, array());
        $data['id'] = $id;
        $equity_id = $id;

        if (!$id) {
            redirect('start_equity/create_prestep');
        }

        if ($id > 0) {
            if (!$this->startequity_model->is_equity_owner($id, false)) {
                redirect('home/notedit_equity');
            }
        }
          $company_profile = array(
                    'user_id' => $this->session->userdata('user_id'),
                    'created' =>date('Y-m-d h:i:s')
                    
                );
             $company_id=   $this->startequity_model->AddInsertUpdateTable('company_profile', '', '', $company_profile);

              $equity_data = array(
                    'company_id' => $company_id,
                                        
                );
             $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $id, $equity_data);

              if ($userdetail[0]['image'] == '' || !is_file(base_url() . 'upload/user/user_small_image/' . $userdetail[0]['image'])) {
                    $data_array = array('team_member_name' => $userdetail['user_name'], 'team_member_type' => 'Leadership', 'member_role' => 'Owner', 'company_id' => $company_id, 'invite_user_id' => $user_id, 'visible_profile' => 1);

                } else {
                    $data_array = array('team_member_name' => $userdetail['user_name'], 'team_member_type' => 'Leadership', 'member_role' => 'Owner', 'company_id' => $company_id, 'member_image' => $userdetail[0]['image'], 'invite_user_id' => $user_id, 'visible_profile' => 1);

                    $user_image = base_url() . 'upload/user/user_small_image/' . $userdetail[0]['image'];
                    $new_team_member_image = base_url() . 'upload/equity/team_member/' . $userdetail[0]['image'];
                    copy($user_image, $new_team_member_image);
                }

               $invite_members_id= $this->startequity_model->AddInsertUpdateTable('invite_members', '', '', $data_array);
                $equity_team  = array( 'company_id' => $company_id, 'equity_id'=>$id, 'user_id'=>$user_id ,'invited_member_id'=>$invite_members_id,'edit_right'=>1 );
                 $this->startequity_model->AddInsertUpdateTable('equity_team_member', '', '', $equity_team);

        redirect('start_equity/create_step1/' . $equity_id);
         
    }


    function select_company($id = '')
    {

        $user_id = check_user_authentication(true);
        $data['id'] = $id;
        $equity_id = $id;

        if (!$id) {
            redirect('start_equity/create_prestep');
        }

        if ($id > 0) {
            if (!$this->startequity_model->is_equity_owner($id, false)) {
                redirect('home/notedit_equity');
            }
        }

        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $meta = meta_setting();

         $company_data = $this->startequity_model->GetUserCompnaies($user_id);
        $data['company_data'] = $company_data;
        $equity_data = $this->equity_model->GetAllEquities($user_id = 0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user','company_profile')); // store in cache

        $equity = $equity_data[0];
       
        if ($equity['status'] > 1) {
            redirect('start_equity/create_step1/' . $equity_id);
        }
       
        $company_select_error = '';
        $data['error'] = '';
        if ($this->input->post('company_id') == 0 || SecurePostData($this->input->post('company_id')) == '') {
            $company_select_error = PLEASE_SELECT_A_COMPANY_OR_ADD_NEW_COMPANY;
        }

        if ($_POST) {

            if ($company_select_error != '') {
                $data['error'] = $company_select_error;
            } else {
                $company_id= SecurePostData($this->input->post('company_id'));
                $company_select = array('company_id' => SecurePostData($this->input->post('company_id')));
                $company_profile_data = $this->startequity_model->getTableData('company_profile', $company_select);
                $company_select_data = $company_profile_data[0];


                $equity_data = $this->startequity_model->getTableData('equity', $company_select);
                $equity_select_data = $equity_data[0];


                $equity_id_array = array('company_id' => $equity_select_data['company_id']);
               

                $company_url = makeSlugs($company_select_data['company_url']);

                $chk_url_exists = $this->db->query("select MAX(company_url) as company_url from company_profile where company_url like '" . $company_url . "%' and company_id !=" . $id);

                $strre = '0';
                if ($chk_url_exists->num_rows() > 0) {
                    $get_pr = $chk_url_exists->row();
                    $strre = str_replace($company_url, '', $get_pr->company_url);

                    if (($strre == '0' || $strre == '') && is_null($get_pr->company_url)) {

                        $newcnt = '';
                    } else {

                        $newcnt = (int)$strre + 1;
                    }
                    $company_url = $company_url . $newcnt;
                }

               $equity_data_array = array(
                    'user_id' => $this->session->userdata('user_id'),
                    'company_id' => $company_select_data['company_id'],
                    
                );

                $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $equity_data_array);
                 project_deletecache($equity_id);


                redirect('start_equity/create_step1/' . $equity_id);
            }
        }
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/select_company', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :create_step1()
	Parameter :id;
	Return : none
	Use : Creating a equity step1 ;
	*/
    function create_step1($id = '')
    {
        $user_id = check_user_authentication(true);

        $data['id'] = $id;
        $equity_id = $id;

        if (!$id) {
            redirect('start_equity/create_prestep');
        }

        if ($id > 0) {
            if (!$this->startequity_model->is_equity_owner($id, false)) {
                redirect('home/notedit_equity');
            }
        }

        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $meta = meta_setting();


        $country_data = $this->startequity_model->getTableData('country', array('active' => 1));
        $data['country_data'] = $country_data;
        
        $lang = $this->startequity_model->getTableData('language', array('iso2' => $_SESSION['lang_code']));
        $company_category_data = $this->startequity_model->getTableData('company_category', array('status' => 1, 'language_id' => $lang[0]['language_id']));
        $data['company_category_data'] = $company_category_data;

        $company_industry_data = $this->startequity_model->getTableData('company_industry', array('status' => 1));
        $data['company_industry_data'] = $company_industry_data;

        $equity_company_industry_data = $this->startequity_model->equity_company_industry_data($equity_id);
        $data['equity_company_industry_data'] = $equity_company_industry_data;

        $team_member_type_data = $this->startequity_model->getTableData('team_member_type', array('status' => 1));
        $data['team_member_type_data'] = $team_member_type_data;

        $chech_id_array = array("equity_id" => $equity_id);
         $equity_data = $this->equity_model->GetAllEquities(0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user','company_profile')); // store in cache

        $equity = $equity_data[0];
       // var_dump($equity);die;
        if(intval($equity['company_id']) <= 0 ){
             redirect('start_equity/select_company/'.$id);
        }
        /*any team member not able to edit company page*/
        if($user_id!=$equity['user_id']){
            redirect('start_equity/create_step2/'.$id);
        }
        $status = $equity['status'];
        $status_check = validatestatus_isedit($status);
        $data['status_check'] = $status_check;
        
        
       

        $is_allow_edit = true;
        $edit_status = array(0, 1, 2);
        $edit_page = '';
        
        if (!in_array($status, $edit_status)) {
            $is_allow_edit = false;
        }       
        if (!in_array($status, $edit_status)) {
            $edit_page = 'yes';
        }


        if ($is_allow_edit == true and $edit_page != 'yes') {
            
        } else {
            //redirect to dash
            redirect('equity/dashboard/' . $equity_id);
        }
        




        // Display Data
        $data['equity_save_url'] = $equity['equity_url'];
        $data['company_name'] = $equity['company_name'];
        $data['company_url'] = $equity['company_url'];
        $data['website_url'] = $equity['website_url'];
        $data['year_founded'] = $equity['year_founded'];
        $data['headquater_city'] = $equity['headquater_city'];
        $data['headquater_state'] = $equity['headquater_state'];
        $data['headquater_country'] = $equity['headquater_country'];
        $data['company_category_id'] = $equity['company_category_id'];
        // $data['company_industry_id'] = $equity['company_industry_id'];
        $data['assets_under_management'] = $equity['assets_under_management'];
        $data['square_footage'] = $equity['square_footage'];
        $data['company_overview'] = $equity['company_overview'];
        $data['company_email'] = ($equity['company_email']) ? $equity['company_email'] : $this->session->userdata('email');
        $data['company_facebook_url'] = $equity['company_facebook_url'];
        $data['company_twitter_url'] = $equity['company_twitter_url'];
        $data['company_linkedin_url'] = $equity['company_linkedin_url'];
        $data['company_logo'] = $equity['company_logo'];
        $data['company_cover_photo'] = $equity['company_cover_photo'];

        // validation


        $this->load->library('form_validation');
        $this->form_validation->set_rules('company_name', COMPANY_NAME, 'required|trim');
        $this->form_validation->set_rules('company_url', EQUITY_CROWDFUNDING_URL, 'required|trim');
        $this->form_validation->set_rules('website_url', WEBSITE_URLC, 'valid_url');
        $this->form_validation->set_rules('year_founded', YEAR_FOUNDED, 'required|numeric|required|min_length[4]|max_length[4]');
        $this->form_validation->set_rules('headquater_city', HEADQUATER_CITY, 'required|trim|alpha_numeric_spaces');
        $this->form_validation->set_rules('headquater_state', HEADQUATER_STATE, 'required|trim|alpha_numeric_spaces');
        $this->form_validation->set_rules('headquater_country', HEADQUATER_COUNTRY, 'required|trim');
        if (!is_array($equity_company_industry_data)) {
            $this->form_validation->set_rules('company_industry', COMPANY_INDUSTRY, 'required|trim');
        }
        $this->form_validation->set_rules('company_category_id', COMPANY_CATEGORY, 'required|trim');
        $this->form_validation->set_rules('company_overview_text', COMPANY_OVERVIEW, 'required|trim|editor_required');
        $year_error = '';
        if ($this->input->post('year_founded') != '') {
            $date1 = date('Y-m-d h:i:s');

            $ts1 = strtotime($date1);


            $year1 = date('Y', $ts1);

            $diff = SecurePostData($this->input->post('year_founded')) - $year1;
            if ($diff > 0) {
                $year_error = YEAR_FOUNDED_CANNOT_BE;
            }

        }
        $this->form_validation->set_rules('company_email', EMAIL_CONTACT, 'required|trim|valid_email');
        if ($this->input->post('square_footage') > 0) {
            $this->form_validation->set_rules('square_footage', SQUARE_FOOTAGE_DEVELOPED, 'required|trim|is_numeric|integer');
        } else {
            $this->form_validation->set_rules('square_footage', SQUARE_FOOTAGE_DEVELOPED, 'required|trim|is_natural_no_zero|integer');
        }
        if ($this->input->post('assets_under_management') > 0) {
            $this->form_validation->set_rules('assets_under_management', ASSETS_UNDER_MANAGEMENT, 'required|trim|is_numeric');
        } else {
            $this->form_validation->set_rules('assets_under_management', ASSETS_UNDER_MANAGEMENT, 'required|trim|is_natural_no_zero');
        }

        $facebook_link = SecurePostData($this->input->post('company_facebook_url'));
        $twitter_link = SecurePostData($this->input->post('company_twitter_url'));
        $linkedln_url = SecurePostData($this->input->post('company_linkedin_url'));
        $fb_error = '';
        $tw_error = '';
        $lin_error = '';
        $secondCheck = '/home((\/)?\.[a-zA-Z0-9])?/';
        if ($facebook_link !== '') {
            if (!substr_count($facebook_link, 'facebook.com')) {
                $fb_error = INVALID_FACEBOOK_LINK . '<br/>';
            }
                  if(!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?facebook\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $facebook_link) && preg_match($secondCheck, $facebook_link) == 0){
                        $fb_error = INVALID_FACEBOOK_LINK . '<br/>';
                    }
        }
        if ($twitter_link != '') {
            if (!substr_count($twitter_link, 'twitter.com')) {
                $tw_error = INVALID_TWITTER_LINK . '<br/>';
            }
             if(!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?twitter\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $twitter_link) ){
                       $tw_error = INVALID_TWITTER_LINK . '<br/>';
                    }

        }
        if ($linkedln_url != '') {
            if (!substr_count($linkedln_url, 'linkedin.com')) {
                $lin_error = INVALID_LINKEDIN_LINK . '<br/>';
            }
             if(!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?linkedin\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $linkedln_url)){
                         $lin_error = INVALID_LINKEDIN_LINK . '<br/>';
                    }
        }
        $company_name_error = '';
        if ($this->input->post('company_name') != '' && $equity['company_name'] == '') {
            $c_name = SecurePostData($this->input->post('company_name'));
            $c_name = str_replace('"', "'", $c_name);
            $company_name_data = $this->startequity_model->getTableData('company_profile', array('company_name' => $c_name));

            if (is_array($company_name_data)) {
                $company_name_error = COMPANY_NAME_ALREADY_EXISTS;
            }
        }
        $company_logo_error = '';
        if ($equity['company_logo'] == '') {

            $company_logo_error = THE_COMPANY_ASSETS_FIEID_IS_REQUIRED;

        }
         $company_cover_photo_error = '';
        if ($equity['company_cover_photo'] == '') {

            $company_cover_photo_error = THE_COMPANY_COVER_FIEID_IS_REQUIRED;

        }
        $data['fb_error'] = '';
        $data['tw_error'] = '';
        $data['lin_error'] = '';
        $data['year_error'] = '';
        $data['company_name_error'] = '';
        $data['company_logo_error'] = '';
        $data['check_url'] = '';
         $data['company_cover_photo_error'] = '';
        $company_url = makeSlugs($this->input->post('company_url'));

        $chk_url_exists = $this->db->query("select MAX(company_url) as company_url from company_profile where company_url like '" . $company_url . "%' and company_id !=" . $equity['company_id']);
        $data['company_id'] = $equity['company_id'];
        $fetch_url_data = $chk_url_exists->row_array();

        $check_url = '';

        if ($fetch_url_data['company_url'] == $company_url) {
            $check_url = URL_ALREADY_EXISTS;
        }
        if ($_POST) {
            if ($this->form_validation->run() === FALSE || $fb_error != '' || $tw_error != '' || $lin_error != '' || $company_name_error != '' || $check_url != '' || $company_logo_error != '' || $year_error != '') {
                $data['error'] = '';
                $data['fb_error'] = $fb_error;
                $data['tw_error'] = $tw_error;
                $data['lin_error'] = $lin_error;
                $data['check_url'] = $check_url;
                $data['company_name_error'] = $company_name_error;
                $data['company_logo_error'] = $company_logo_error;
                if (form_error('year_founded') != '') {
                    $data['year_error'] = form_error('year_founded');
                } else {
                    $data['year_error'] = $year_error;
                }


                $c_name = SecurePostData($this->input->post('company_name'));
                $data['company_name'] = str_replace('"', "'", $c_name);
                $data['company_url'] = $company_url;
                $data['website_url'] = SecurePostData($this->input->post('website_url'));
                $data['year_founded'] = SecurePostData($this->input->post('year_founded'));
                $data['headquater_city'] = SecurePostData($this->input->post('headquater_city'));
                $data['headquater_state'] = SecurePostData($this->input->post('headquater_state'));
                $data['headquater_country'] = SecurePostData($this->input->post('headquater_country'));
                $data['company_category_id'] = SecurePostData($this->input->post('company_category_id'));

                $data['assets_under_management'] = SecurePostData($this->input->post('assets_under_management'));
                $data['square_footage'] = SecurePostData($this->input->post('square_footage'));
                $data['company_overview'] = EditorSecurePostData($this->input->post('company_overview_text'));
                $data['company_email'] = SecurePostData($this->input->post('company_email'));
                $data['company_facebook_url'] = SecurePostData($this->input->post('company_facebook_url'));
                $data['company_twitter_url'] = SecurePostData($this->input->post('company_twitter_url'));
                $data['company_linkedin_url'] = SecurePostData($this->input->post('company_linkedin_url'));

            } else {

                //update data 
                if($status_check)
                {

                     $company_data_array = array(
                        'user_id' => $this->session->userdata('user_id'),
                        'company_email' => SecurePostData($this->input->post('company_email')),
                        'company_facebook_url' => addhttp($this->input->post('company_facebook_url')),
                        'company_twitter_url' => addhttp($this->input->post('company_twitter_url')),
                        'company_linkedin_url' => addhttp($this->input->post('company_linkedin_url')),
                    );
                }
                else
                {   

                    $c_name = SecurePostData($this->input->post('company_name'));
                    $c_name = str_replace('"', "'", $c_name);
                    $company_data_array = array(
                        'user_id' => $this->session->userdata('user_id'),
                        'company_name' => SecurePostData($c_name),
                        'company_url' => $company_url,
                        'website_url' => SecurePostData($this->input->post('website_url')),
                        'year_founded' => SecurePostData($this->input->post('year_founded')),
                        'headquater_city' => SecurePostData($this->input->post('headquater_city')),
                        'headquater_state' => SecurePostData($this->input->post('headquater_state')),
                        'headquater_country' => SecurePostData($this->input->post('headquater_country')),
                        'company_category_id' => SecurePostData($this->input->post('company_category_id')),

                        'assets_under_management' => SecurePostData($this->input->post('assets_under_management')),
                        'square_footage' => SecurePostData($this->input->post('square_footage')),
                        'company_overview' => EditorSecurePostData($this->input->post('company_overview_text')),
                        'company_email' => SecurePostData($this->input->post('company_email')),
                        'company_facebook_url' => addhttp($this->input->post('company_facebook_url')),
                        'company_twitter_url' => addhttp($this->input->post('company_twitter_url')),
                        'company_linkedin_url' => addhttp($this->input->post('company_linkedin_url')),
                    );
                    $company_data_array['assets_under_management'] = round((float)$company_data_array['assets_under_management'], 2); 
                }
                // $equity_data_array  = array('equity_url' => $equity_url);
                // $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $equity_data_array);
                 // project_deletecache($equity_id, $equity_url);

                $user_equity_data = $this->startequity_model->getTableData('equity', array('equity_id' => $equity_id));

                $company_equity_id = $user_equity_data[0]['company_id'];

                if ($company_equity_id > 0) {
                    $this->startequity_model->AddInsertUpdateTable('company_profile', 'company_id', $company_equity_id, $company_data_array);
                } else {
                    $this->startequity_model->AddInsertUpdateTable('company_profile', '', '', $company_data_array);
                    $company_id =$this->db->insert_id();
                    $company_data_update = array('company_id' => $company_id);
                    $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $company_data_update);
                }
                project_deletecache($equity_id);
                redirect('start_equity/create_step2/' . $equity_id);

            }
        }
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/create_step1', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :create_step1_ajax()
	Parameter :id 
	Return : Image name
	Use : Company Logo upload using ajax;
	*/
    function create_step1_ajax($id = null)
    {
        $site_setting = site_setting();
        $this->load->library('form_validation');
        $data = array();
        $data["msg"]["error"] = '';
        $data["msg"]["success"] = '';
        $data["redirect"]["url"] = '';
        $data["image"]["path"] = '';

        if ($this->session->userdata('user_id') == '') {
            $data["redirect"]["url"] = 'home/login';
        } else if ($id == null || $id == '' || $id == '0') {
            $data["redirect"]["url"] = "start_equity/create_prestep";
        } else {


            $_FILES['userfile']['name'] = $_FILES['file1']['name'];
            $_FILES['userfile']['type'] = $_FILES['file1']['type'];
            $_FILES['userfile']['tmp_name'] = $_FILES['file1']['tmp_name'];
            $image_info = getimagesize($_FILES['file1']['tmp_name']);
            $image_width = $image_info[0];
            $image_height = $image_info[1];
            $_FILES['userfile']['error'] = $_FILES['file1']['error'];
            $_FILES['userfile']['size'] = $_FILES['file1']['size'];
            $_FILES['userfile']['max_width'] = $image_width;
            $_FILES['userfile']['max_height'] = $image_height;
            // image validation
             $image_settings = get_image_setting_data();
            if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif") {
                $data["msg"]["error"] = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
            } else if ($_FILES["userfile"]["size"] >$image_settings['upload_limit']*1000000) {
                $data["msg"]["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);
            } else {

                $files = $_FILES;
                $base_path = $this->config->slash_item('base_path');
                $rand = rand(0, 100000);
              
                  
                $path_parts = pathinfo($_FILES['file1']['name']);
                $date = new DateTime();
                
                $file_extention = $path_parts['extension'];
                $new_img = $rand .'-company-'.$date->getTimestamp().'.'.$file_extention;
                move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/equity/logo/" . $new_img);
                $imagename = $new_img;
               $data_gallery = array(

                    'company_logo' => $imagename
                );
                // save data
              
                $chech_id_array = array("equity_id" => $id);
                $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
                $equity = $equity_data[0];

                if($equity['company_id'] == '' || $equity['company_id'] == 0)
                {
                    $this->startequity_model->AddInsertUpdateTable('company_profile', '','', $data_gallery);
                    $company_id = $this->db->insert_id();
                    $data_equity = array('company_id' => $company_id);
                     $new_logo = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id',$id, $data_equity);
                      project_deletecache($id);
                }
                else
                {
                     $new_logo = $this->startequity_model->AddInsertUpdateTable('company_profile', 'company_id', $equity['company_id'], $data_gallery);
                }

                if ($new_logo) {
                    $data["image"]["path"] = base_url() . "upload/equity/logo/" . $imagename;
                    $data["msg"]["success"] = 'success';
                } else {
                    $data["msg"]["error"] = THERE_IS_SOME_PROBLEM_SITE_TRY_AFTER_SOMETIME;
                }
            }
            echo json_encode($data);


        }

    }

    /*
	Function name :save_company_industry()
	Parameter :id;
	Return : Array for company industries with equity
	Use :company industries for equity
	Auther:Rakesh
	*/
    function save_company_industry()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
       
        $chech_id_array = array("equity_id" => $equity_id);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        $equity = $equity_data[0];
        $company_id =$equity['company_id'];
        $company_industry_id = SecurePostData($this->input->post('company_industry_id'));
        $max_select_limit = 3;
        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($company_industry_id == null || $company_industry_id == '' || $company_industry_id == '0') {
            $data["msg"] = PLEASE_SELECT_COMPANY_INDUSTRY;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check same data exits in table or not
        $equity_company_industry_data = $this->startequity_model->equity_company_industry_data($equity_id, $company_industry_id);
        //print_r($equity_company_industry_data);
        if (is_array($equity_company_industry_data)) {
            $data["msg"] = YOU_HAVE_ALREADY_APPLIED_THAT;
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else {
            $equity_company_industry_data = $this->startequity_model->equity_company_industry_data($equity_id);

            $count_data = count($equity_company_industry_data);
            if ($count_data >= $max_select_limit) {
                $data["msg"] = sprintf(YOU_MAY_ONLY_SELECT_UP_TO, $max_select_limit);
                $data["error"] = true;
                echo json_encode($data);
                die;
            }
        }

        $data_array = array('company_industry_id' => $company_industry_id, 'company_id' => $company_id);
        $this->startequity_model->AddInsertUpdateTable('equity_company_industry', '', '', $data_array);
        $equity_company_industry_data = $this->startequity_model->equity_company_industry_data($equity_id, $company_industry_id);

        $data["record"] = $equity_company_industry_data[0];
        $data["ele"] = '<li class="company-industries-industry company_industries_industry_'.$data["record"]['id'].'">' . $data["record"]['company_industry_name'] . ' <a onClick="set_company_industries_id(this);" href="javascript:void(0)" rel="' . $data["record"]['id'] . '" class="company_industries_industry_link" title="'.DELETE.'" href="javascript:void(0);" data-toggle="modal" data-target="#confirmDeletecompany_industry"><img alt="Delete" src="' . base_url() . 'images/icon-keyword-delete.png"></a> </li>';
        echo json_encode($data);

    }

    /*
	Function name :delete_company_industry()
	Parameter :none;
	Return : none
	Use : Delete Company industries for equity ;
	Auther:Rakesh
	*/
    function delete_company_industry()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $company_industry_id = SecurePostData($this->input->post('company_industry_id'));
        $chech_id_array = array("equity_id" => $equity_id);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        $equity = $equity_data[0];
        $company_id =$equity['company_id'];
        $max_select_limit = 3;
        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($company_industry_id == null || $company_industry_id == '' || $company_industry_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_COMPANY_INDUSTRY;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $sql = "delete from equity_company_industry where company_industry_id='" . $company_industry_id . "' and  company_id='" . $company_id . "'";
        $this->db->query($sql);
        echo json_encode($data);
    }

    /*
	Function name :team_member_save()
	Parameter :none;
	Return : Array for company industries with equity
	Use :company industries for equity
	Auther:Rakesh
	*/
    function team_member_save()
    {

        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $site_setting = site_setting();
        $taxonomy_setting = taxonomy_setting();
        $taxx_company_url = $taxonomy_setting['company_url'];
        $equity_id = SecurePostData($this->input->post('team_member_equity_id'));

        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }

        $chech_id_array = array("equity_id" => $equity_id);
         $equity_data = $this->equity_model->GetAllEquities($user_id = 0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user','company_profile')); // store in cache
        $equity = $equity_data[0];
        $company_id = $equity['company_id'];
        $team_member_id = SecurePostData($this->input->post('team_member_id'));

        $team_member_type = SecurePostData($this->input->post('team_member_type'));

        $team_member_name = SecurePostData($this->input->post('team_member_name'));
        $member_role = SecurePostData($this->input->post('member_role'));
        $email = SecurePostData($this->input->post('email'));
        $team_member_description = SecurePostData($this->input->post('team_member_description'));
        $visible_admin = SecurePostData($this->input->post('visible_admin'));
        $visible_profile = SecurePostData($this->input->post('visible_profile'));

        $this->load->library('form_validation');
        $this->form_validation->set_rules('team_member_name', FIRST_AND_LAST_NAME, 'required|trim|min_length[3]|max_length[40]|min_word[2]');
        $this->form_validation->set_rules('member_role', ROLE_TITLE, 'at_least_one_letter');
        $this->form_validation->set_rules('team_member_description', TEAM_MEMBER_BIO, 'at_least_one_letter');
        $this->form_validation->set_rules('company_name', COMPANY_NAME, 'required|trim');
        $this->form_validation->set_rules('company_url', EQUITY_CROWDFUNDING_URL, 'required|trim');
        $this->form_validation->set_rules('email', EMAIL_ADDRESS, 'required|trim|valid_email');
        $check_email = '';
        $same_email_error = '';
        // if ($team_member_id == 0) {


            if ($_POST) {

                
                
                if (!$this->team_member_email_check($email, $equity_id, $team_member_id)) {
                    $check_email = YOU_HAVE_ALREADY_SENT_INVITATION;
                }
            }


        // }
        $userdata = UserData($this->session->userdata('user_id'));
        if ($userdata[0]['email'] == $email) {
            $same_email_error = YOU_CAN_NOT_INVITE_YOURSELF;
        }
        $check_team_member_type = '';
        if ($_POST) {
            if ($this->input->post('team_member_type') == '') {
                $check_team_member_type = PLEASE_SELECT_THE_ROLE_FOR_THIS_MEMBER;
            }
        }

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $data['check_team_member_type'] = '';
        //   Check validations
        if ($this->form_validation->run($this) == FALSE || $check_email != '' || $same_email_error != '' || $check_team_member_type != '') {

            $data['company_name_error'] = strip_tags( form_error('company_name'));
            $data['company_url_error'] = strip_tags( form_error('company_url'));
            $data['team_member_name_error'] = form_error('team_member_name');
            $data['team_member_description_error'] = form_error('team_member_description');
            $data['email_error'] = form_error('email');
            $data['member_role_error'] = form_error('member_role');
            if ($data['email_error'] == '') {
                $data['email_error'] = $check_email;
            }
            if ($same_email_error != '') {
                $data['email_error'] = $same_email_error;
            }
            $data['check_team_member_type'] = $check_team_member_type;
            $data["error"] = true;
            echo json_encode($data);
            die;

        }
        $imagename = '';


        if (isset($_FILES['member_image']['name'])) {
            $_FILES['userfile']['name'] = $_FILES['member_image']['name'];
            $_FILES['userfile']['type'] = $_FILES['member_image']['type'];
            $_FILES['userfile']['tmp_name'] = $_FILES['member_image']['tmp_name'];
            $image_info = getimagesize($_FILES['member_image']['tmp_name']);
            $image_width = $image_info[0];
            $image_height = $image_info[1];
            $_FILES['userfile']['error'] = $_FILES['member_image']['error'];
            $_FILES['userfile']['size'] = $_FILES['member_image']['size'];
            $_FILES['userfile']['max_width'] = $image_width;
            $_FILES['userfile']['max_height'] = $image_height;
            // image validation
            $image_settings = get_image_setting_data();
            if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif") {
                $data["image_error"] = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
                $data["error"] = true;
                echo json_encode($data);
                die;
            } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                $data["image_error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);
                $data["error"] = true;
                echo json_encode($data);
                die;
            } else {


                $files = $_FILES;
                $base_path = $this->config->slash_item('base_path');
                $rand = rand(0, 100000);
                  
                $path_parts = pathinfo($_FILES['member_image']['name']);
                $date = new DateTime();
                
                $file_extention = $path_parts['extension'];
                $new_img = $rand .'-team-member-'.$date->getTimestamp().'.'.$file_extention;
               
                move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/equity/team_member/" . $new_img);
                $imagename = $new_img;

                $data["image"]["image_name"] = $imagename;
                $data["image"]["path"] = base_url() . "upload/equity/team_member/" . $imagename;


            }
        }
        $code = rand(1000000, 1000000000);
        $data_array = array('team_member_name' => $team_member_name, 'team_member_type' => $team_member_type, 'member_role' => $member_role, 'team_memberd_description' =>
            $team_member_description, 'email' => $email, 'admin' => $visible_admin, 'visible_profile' => $visible_profile, 'company_id' => $company_id, 'code' => $code);

        //echo $imagename;die;
        if ($imagename != '') {

            $data_array = array('team_member_name' => $team_member_name, 'team_member_type' => $team_member_type, 'member_role' => $member_role, 'team_memberd_description' => $team_member_description, 'email' => $email, 'admin' => $visible_admin, 'visible_profile' => $visible_profile, 'company_id' => $company_id, 'member_image' => $imagename, 'code' => $code);
        }

        if ($team_member_id > 0) {
            $this->startequity_model->AddInsertUpdateTable('invite_members', 'id', $team_member_id, $data_array);

        } else {
            $this->startequity_model->AddInsertUpdateTable('invite_members', '', '', $data_array);
            $company_url =  SecurePostData($this->input->post('company_url'));
            $company_name =  SecurePostData($this->input->post('company_name'));
            $equity_page_link = site_url($taxx_company_url . '/' . $company_url );
            $equity_title_anchor = '<a href="' . $equity_page_link . '">' . SecureShowData($company_name) . '</a>';
            $user_data = UserData($equity['user_id']);
            $company_owner_name = $user_data[0]['user_name'] . ' ' . $user_data[0]['last_name'];


            $company_owner_page_link = site_url('user/' . $user_data[0]['profile_slug']);
            $company_owner_title_anchor = '<a href="' . $company_owner_page_link . '">' . $company_owner_name . '</a>';

            $email_to = $email;

            $login_link = '<a href="' . site_url('start_equity/confirm_invite/' . $code) . '">' . site_url('start_equity/confirm_invite/' . $code) . '</a>';


            $site_name = $site_setting['site_name'];

            $project_name = $taxonomy_setting['project_name'];
            if (intval($visible_profile) == 1) $visible_profile = "Yes";
            else $visible_profile = "No";
            if (intval($visible_admin) == 1) $visible_admin = "Yes";
            else $visible_admin = "No";
            $language_id=GetUserLangCode();
            $email_template = $this->db->query("select * from `email_template` where task='Member Invitation' and language_id=".$language_id);
            $email_temp = $email_template->row();
            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_subject = $email_temp->subject;
            $email_subject = str_replace('{site_name}', $site_name, $email_subject);
            $email_subject = str_replace('{project_name}', $project_name, $email_subject);
            $email_message = $email_temp->message;

            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $team_member_name, $email_message);
            $email_message = str_replace('{access_status}', $visible_profile, $email_message);
            $email_message = str_replace('{visible_admin}', $visible_admin, $email_message);
            $email_message = str_replace('{equity_owner_name}', $company_owner_title_anchor, $email_message);
            $email_message = str_replace('{project_name}', $project_name, $email_message);
            $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
            $email_message = str_replace('{user_role}', $team_member_type, $email_message);
            $email_message = str_replace('{login_link}', $login_link, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);


            $str = $email_message; 

            email_send($email_address_from, $email_address_reply, $email, $email_subject, $str);

         


        }
        echo json_encode($data);


    }

    /*
	Function name :delete_team_member()
	Parameter :none;
	Return : none
	Use : Delete Team Member for equity ;
	Auther:Rakesh
	*/
    function delete_team_member()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $team_member_id = SecurePostData($this->input->post('team_member_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($team_member_id == null || $team_member_id == '' || $team_member_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_TEAM_MEMBER_TO_DELETE;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        $site_setting = site_setting();
        $site_name = $site_setting['site_name'];
        $taxonomy_setting = taxonomy_setting();
        $project_name = $taxonomy_setting['project_name'];
        $project_url = $taxonomy_setting['project_url'];


        $chech_id_array = array("equity_id" => $equity_id);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        $equity = $equity_data[0];

        $invite_id_array = array("id" => $team_member_id);
        $member_data = $this->startequity_model->getTableData('invite_members', $invite_id_array);
        $team_member_data = $member_data[0];

        $email = $team_member_data['email'];
        $team_member_type = $team_member_data['team_member_type'];
        $team_member_name = $team_member_data['team_member_name'];
        $company_name = SecureShowData($equity['company_name']);
        $equity_url = $equity['equity_url'];
        $equity_page_link = site_url($project_url . '/' . $equity_url . '/' . $equity_id);
        $equity_title_anchor = '<a href="' . $equity_page_link . '">' . $company_name . '</a>';

        $user_data = UserData($equity['user_id']);
        $company_owner_name = $user_data[0]['user_name'] . ' ' . $user_data[0]['last_name'];
        $profile_page_link = site_url('user/' . $user_data[0]['profile_slug']);
        $project_owner_link = '<a href="' . $profile_page_link . '">' . $company_owner_name . '</a>';
         $language_id=GetUserLangCode( $team_member_data['user_id']);
        $email_template = $this->db->query("select * from `email_template` where task='Deleted Team Member' and language_id=".$language_id);
        $email_temp = $email_template->row();
        $email_to = $email;
        $email_address_from = $email_temp->from_address;
        $email_address_reply = $email_temp->reply_address;
        $email_subject = $email_temp->subject;

        $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
        $email_message = $email_temp->message;

        $email_message = str_replace('{break}', '<br/>', $email_message);
        $email_message = str_replace('{user_name}', $team_member_name, $email_message);

        $email_message = str_replace('{project_owner_link}', $project_owner_link, $email_message);
        $email_message = str_replace('{project_name}', $project_name, $email_message);
        $email_message = str_replace('{company_name_link}', $equity_title_anchor, $email_message);
        $email_message = str_replace('{team_member_type}', $team_member_type, $email_message);
        $email_message = str_replace('{site_name}', $site_name, $email_message);


        $str = $email_message;

        email_send($email_address_from, $email_address_reply, $email, $email_subject, $str);
        $sql = "delete from invite_members where id='" . $team_member_id . "' ";
        $this->db->query($sql);
         $sql = "delete from equity_team_member where invited_member_id='" . $team_member_id . "' ";
        $this->db->query($sql);
        echo json_encode($data);
    }

    /*
	Function name :list_team_member()
	Parameter :none;
	Return : Result array
	Use : Show Team Member list for equity ;
	Auther:Rakesh
	*/
    function list_team_member()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $data['equity_id'] = $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $equity_team_member_data = $this->startequity_model->equity_team_member_data($equity_id);
        $data["equity_team_member_data"] = $equity_team_member_data;
        $data['id']=$this->input->post('equity_id');
        $this->load->view(THEME_LOCATION.'start_equity/list_team_member', $data);
    }

    /*
	Function name :list_team_member()
	Parameter :none;
	Return : Result array
	Use : Show Team Member list for equity ;
	Auther:Rakesh
	*/
    function edit_team_member()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $company_id = SecurePostData($this->input->post('company_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $team_member_id = SecurePostData($this->input->post('team_member_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($team_member_id == null || $team_member_id == '' || $team_member_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_TEAM_MEMBER_TO_EDIT;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $company_team_member_data = $this->startequity_model->company_team_member_data($company_id, $team_member_id);
        $data["team_member"] = $company_team_member_data[0];
        echo json_encode($data);
        die;

    }

    /*
	Function name :team_memmber_email_check()
	Parameter :none
	Return : none
	Use : This is a callback function which is use to check this team member email exist or not.
	*/
    function team_member_email_check($email = '', $equity_id = '', $id = '')
    {

        $username = $this->startequity_model->member_validate($email, $equity_id, $id);
        if (is_array($username)) {
            //$this->form_validation->set_message('memberemail_check', EXISTS_ACCOUNT_ASSOCIATE_WITHMAIL);
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /*
	Function name :create_step2()
	Parameter :id;
	Return : none
	Use : save data draft your compaign section ;
	*/
    function create_step2($id = '')
    {

        $user_id = check_user_authentication(true);
        if ($id > 0) {
            if (!$this->startequity_model->is_equity_owner($id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $data['id'] = $id;
        $equity_id = $id;
        

        if (!$id) {
            redirect('start_equity/create_prestep');
        }
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $meta = meta_setting();

        // Display Data

        $chech_id_array = array("equity_id" => $equity_id);
        // $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        // $equity = $equity_data[0];
        $equity=GetOneEquity($id);
       
        $status = $equity['status'];
        $status_check = validatestatus_isedit($status);
        $data['status_check'] = $status_check;
        
          $investor_array = array("status" => "1");
        $investment_tax_relief_data = $this->startequity_model->getTableData('investment_tax_relief', $investor_array);
        $data['investment_tax_relief_data'] = $investment_tax_relief_data;
        
        
        
        $is_allow_edit = true;
        $edit_status = array(0, 1, 2);
        $edit_page = '';
        
        if (!in_array($status, $edit_status)) {
            $is_allow_edit = false;
        }       
        if (!in_array($status, $edit_status)) {
            $edit_page = 'yes';
        }


        if ($is_allow_edit == true and $edit_page != 'yes') {
            
        } else {
            //redirect to dash
            redirect('equity/dashboard/' . $equity_id);
        }
        
        $data['deal_data'] = $this->startequity_model->getTableData('deal_type_setting', array('status' => 1));
      
        $data['equity_stages_list'] = $this->startequity_model->getTableData('equity_stages', array('status' => 1));
        $data['equity_funding_rounnds'] = $this->startequity_model->getTableData('equity_funding_rounds', array('status' => 1));

        $currency_code_data = $this->startequity_model->getTableData('currency_code', array('active'=>1), array('currency_code' => 'desc'));
        $data['currency_code_data'] = $currency_code_data;

        //Deal Setting Equity Type
        $deal_equity_array = array("slug" => "equity");
        $deal_equity_data = $this->startequity_model->getTableData('deal_type_setting', $deal_equity_array);
        $deal_equity_setting = $deal_equity_data[0];

        //Deal Setting Convertible Note Type
        $deal_convertible_note_array = array("slug" => "convertible_note");
        $deal_convertible_note_data = $this->startequity_model->getTableData('deal_type_setting', $deal_convertible_note_array);
        $deal_convertible_setting = $deal_convertible_note_data[0];

        //Deal Setting debt Type
        $deal_debt_array = array("slug" => "debt");
        $deal_debt_data = $this->startequity_model->getTableData('deal_type_setting', $deal_debt_array);
        $deal_debt_setting = $deal_debt_data[0];

        //Deal Setting Revenue Share Type
        $deal_revenue_share_array = array("slug" => "revenue_share");
        $deal_revenue_share_data = $this->startequity_model->getTableData('deal_type_setting', $deal_revenue_share_array);
        $deal_revenue_share_setting = $deal_revenue_share_data[0];

        //$data['time_zone_list'] = get_table_data('timezone', '', 'yes');
        $data['time_zone_list'] = tz_list();

         $equity_currency_data = $this->startequity_model->getTableData('currency_code', array('currency_code' => $equity['equity_currency_code']));

        $equity_currency_code_id = $equity_currency_data[0]['currency_code_id'];
        if($equity['project_timezone'] == '')
        {
            $data['project_timezone']= $data['site_setting']['time_zone'];
        }
        else
        {
            $data['project_timezone']= $equity['project_timezone'];
        }

        $data['minimum_raise'] = $equity['minimum_raise'];
        $data['allowed_investor'] = $equity['allowed_investor'];
        $data['maximum_raise'] = $equity['maximum_raise'];
        $data['goal'] = $equity['goal'];
        $data['currency_code_id'] = $equity_currency_code_id;
        $data['end_date'] = $equity['end_date'];
        $data['company_fundraising'] = $equity['company_fundraising'];
        $data['amount_raise_current_round'] = $equity['amount_raise_current_round'];
        $data['date_round_open'] = $equity['date_round_open'];
        $data['deal_type'] = $equity['deal_type_name'];
        $data['equity_stage_id'] = $equity['equity_stage_id'];
        $data['equity_funding_round_id'] = $equity['equity_funding_round_id'];

        $data['price_per_share'] = $equity['price_per_share'];
        $data['equity_available'] = $equity['equity_available'];
        $data['company_valuation'] = $equity['company_valuation'];
        $data['interest'] = $equity['interest'];
        $data['term_length'] = $equity['term_length'];
        $data['valuation_cap'] = $equity['valuation_cap'];
        $data['conversation_discount'] = $equity['conversation_discount'];
        $data['warrant_coverage'] = $equity['warrant_coverage'];
        $data['debt_interest'] = $equity['debt_interest'];
        $data['debt_term_length'] = $equity['debt_term_length'];

        $data['return_investment_interest'] = $equity['return_investment_interest'];
        $data['return_starts'] = $equity['return_starts'];
        $data['return_payment_frequency'] = $equity['return_payment_frequency'];
        $data['return_term_length'] = $equity['return_term_length'];

        $data['return'] = $equity['return'];
        $data['return_percentage'] = $equity['return_percentage'];
        $data['maximum_return'] = $equity['maximum_return'];

        $data['payment_frequency'] = $equity['payment_frequency'];
        $data['payment_start_date_text'] = $equity['payment_start_date_text'];
        $data['funding_type'] = $equity['funding_type'];
        $data['tax_relief_type'] = $equity['tax_relief_type'];
        $data['payment_exact_date'] = $equity['payment_start_date'];
        $data['payment_number_of_months'] = '';
        if ($data['payment_start_date_text'] == 'number_month') {
            $date1 = date('Y-m-d h:i:s');
            $date2 = $equity['payment_start_date'];

            $ts1 = strtotime($date1);
            $ts2 = strtotime($date2);

            $year1 = date('Y', $ts1);
            $year2 = date('Y', $ts2);

            $month1 = date('m', $ts1);
            $month2 = date('m', $ts2);

            $diff = (($year2 - $year1) * 12) + ($month2 - $month1);

            $data['payment_number_of_months'] = $diff;
        }


        $this->load->library('form_validation');
        $this->form_validation->set_rules('minimum_raise', MINIMUM_RAISE, 'required|is_numeric');
        $this->form_validation->set_rules('maximum_raise', MAXIMUM_RAISE, 'trim|is_numeric');
        $this->form_validation->set_rules('goal', FUNDRAISING_GOAL, 'required|is_numeric');
        $this->form_validation->set_rules('end_date', CLOSING_DATE, 'required|trim');
        $this->form_validation->set_rules('funding_type', FUNDING_TYPE, 'required');

        $this->form_validation->set_rules('equity_stage_id', PROJECT_STAGE, 'required');

        $this->form_validation->set_rules('return_investment_interest', INTEREST, 'required');
        $this->form_validation->set_rules('return_starts', PAYMENT_START_DATE, 'required');
        $this->form_validation->set_rules('return_payment_frequency', PAYMENT_FREQUENCY, 'required');
        $this->form_validation->set_rules('return_term_length', TERM_LENGTH, 'required');

        $this->form_validation->set_rules('equity_funding_round_id', FUNDING_ROUNDS, 'required');

    

        $this->form_validation->set_rules('company_fundraising', COMPANY_CURRENTLY_FUNDRAISING, 'required|trim');
        if ($this->input->post('company_fundraising') == 1) {
            $this->form_validation->set_rules('amount_raise_current_round', AMOUNT_RAISED_IN_CURRENT_ROUND, 'required|is_numeric');
            $this->form_validation->set_rules('date_round_open', DATE_ROUND_OPENED, 'required|trim');
        }


        if ($this->input->post('deal_type') == 'equity') {
            $this->form_validation->set_rules('available_shares', AVAILABLE_SHARES, 'required|numeric');
            $this->form_validation->set_rules('price_per_share', PRICE_PER_SHARE, 'required|numeric');
            $this->form_validation->set_rules('equity_available', EQUITY_AVAILABLE, 'required|numeric');
            $this->form_validation->set_rules('company_valuation', COMPANY_VALUATION, 'required|numeric');
        }
        if ($this->input->post('deal_type') == 'convertible_note') {
            $this->form_validation->set_rules('interest', INTEREST, 'required|numeric');
            $this->form_validation->set_rules('term_length', TERM_LENGTH, 'required|is_natural_no_zero');
            $this->form_validation->set_rules('valuation_cap', VALUATION_CAP, 'required|numeric');
            $this->form_validation->set_rules('warrant_coverage', WARRANT_COVERAGE, 'required|numeric');
            $this->form_validation->set_rules('conversation_discount', CONVERSATION_DISCOUNT, 'required|numeric');
        }
        if ($this->input->post('deal_type') == 'debt') {
            $this->form_validation->set_rules('debt_interest', INTEREST, 'required|numeric');
            $this->form_validation->set_rules('debt_term_length', TERM_LENGTH, 'required|is_natural_no_zero');
        }
        if ($this->input->post('deal_type') == 'revenue_share') {
            $this->form_validation->set_rules('return', RETURNT, 'required|trim');
            $this->form_validation->set_rules('return_percentage', RETURN_PERCENTAGE, 'required|numeric');
            $this->form_validation->set_rules('maximum_return', MAXIMUM_RETURN, 'required|numeric');
            $this->form_validation->set_rules('payment_frequency', PAYMENT_FREQUENCY, 'required|trim');
            $this->form_validation->set_rules('payment_start_date_text', PAYMENT_START_DATE, 'required|trim');
            if ($this->input->post('payment_start_date_text') != '') {
                if ($this->input->post('payment_start_date_text') == 'exact_date') {
                    $this->form_validation->set_rules('payment_exact_date', EXACT_DATE, 'required|trim');
                }
                if ($this->input->post('payment_start_date_text') == 'number_month') {
                    $this->form_validation->set_rules('payment_number_of_months', NUMBER_OF_MONTHS, 'required|trim');
                }
            }
        }

        if($site_setting['accredential_status'] == '0' && $site_setting['accrediated_manage'] == 1) {
           $this->form_validation->set_rules('allowed_investor', ALLOWED_INVESTOR, 'required');     
        }

        $goal = SecurePostData($this->input->post('goal'));
        $minimum_raise = SecurePostData($this->input->post('minimum_raise'));
        $maximum_raise = SecurePostData($this->input->post('maximum_raise'));
        //Deal Equity varible
        $price_per_share = SecurePostData($this->input->post('price_per_share'));
        $equity_available = SecurePostData($this->input->post('equity_available'));
        $company_valuation = SecurePostData($this->input->post('company_valuation'));
        //Deal Convertible note varible
        $interest = SecurePostData($this->input->post('interest'));
        $term_length = SecurePostData($this->input->post('term_length'));
        $valuation_cap = SecurePostData($this->input->post('valuation_cap'));
        $warrant_coverage = SecurePostData($this->input->post('warrant_coverage'));
        $conversation_discount = SecurePostData($this->input->post('conversation_discount'));
        //Deal Debt varible
        $debt_interest = SecurePostData($this->input->post('debt_interest'));
        $debt_term_length = SecurePostData($this->input->post('debt_term_length'));
        //Deal Revenue Shares varible
        $return_percentage = SecurePostData($this->input->post('return_percentage'));
        $maximum_return = SecurePostData($this->input->post('maximum_return'));

        $goal_err = '';
        $minimum_raise_err = '';
        $maximum_raise_err = '';
        $data['deal_type_error'] = '';
        $price_per_share_error = '';
        $equity_available_error = '';
        $company_valuation_error = '';
        $interest_error = '';
        $term_length_error = '';
        $valuation_cap_error = '';
        $warrant_coverage_error = '';
        $conversation_discount_error = '';
        $debt_interest_error = '';
        $debt_term_length_error = '';
        $return_percentage_error = '';
        $maximum_return_error = '';
        $return_investment_interest_error='';
        $return_term_length_error='';
        

        $data['goal_err'] = '';
        $data['minimum_raise_err'] = '';
        $data['maximum_raise_err'] = '';
        $data['price_per_share_error'] = '';
        $data['equity_available_error'] = '';
        $data['company_valuation_error'] = '';
        $data['interest_error'] = '';
        $data['term_length_error'] = '';
        $data['valuation_cap_error'] = '';
        $data['warrant_coverage_error'] = '';
        $data['conversation_discount_error'] = '';
        $data['debt_interest_error'] = '';
        $data['debt_term_length_error'] = '';
        $data['return_percentage_error'] = '';
        $data['maximum_return_error'] = '';

        $data['return_investment_interest_error'] = '';
        $data['return_term_length_error'] = '';
      
       
        //$data['currency_code_id'] = SecurePostData($this->input->post('currency_code_id'));
        $equity_currency_data = $this->startequity_model->getTableData('currency_code', array('currency_code_id' => SecurePostData($this->input->post('currency_code_id'))));
                
        $data['equity_currency_symbol'] = $equity_currency_data[0]['currency_symbol'];
        $equity_currency_symbol = $data['equity_currency_symbol'];      

        $deal_type_error = '';
        if ($this->input->post('deal_type') == '') {
            $deal_type_error = PLEASE_SELECT_ONE_DEAL_TYPE;
        }
        if ($this->input->post('maximum_raise') != '') {
            if ($this->input->post('maximum_raise') > SecurePostData($this->input->post('goal'))) {

                $maximum_raise_err = MAXIMUM_RAISE_AMOUNT_MUST_NOT_BE_GREATER_THAN_YOUR_GOAL;
            }
        }

        if ($goal != '' && is_numeric($goal)) {
            if ($goal < $site_setting['minimum_goal'] || $goal > $site_setting['maximum_goal']) {

                $goal_err = '<p>' . GOAL_SHOUID_BE_BETWEEN . ' ' . $equity_currency_symbol . $site_setting['minimum_goal'] . ' ' . TO . ' ' . $equity_currency_symbol . $site_setting['maximum_goal'] . '.</p>';
            }
        }
        if ($minimum_raise != '' && is_numeric($minimum_raise)) {
            if ($minimum_raise < $site_setting['minimum_goal']) {
                $minimum_raise_err = '<p>' . MINIMUM_RAISE_SHOULD_NOT_BE_LESS_THAN . ' ' . $equity_currency_symbol . $site_setting['minimum_goal'] . '.</p>';
            }
        }
        if ($this->input->post('minimum_raise') != '') {
            if ($this->input->post('minimum_raise') > SecurePostData($this->input->post('maximum_raise'))) {

                $minimum_raise_err = MIMIMUM_RAISE_AMOUNT_MUST_NOT_BE_GREATER_THAN_YOUR_MAXIMUM_AMOUNT;
            }
        }
        //Deal Equity Validation

        if ($this->input->post('deal_type') == 'equity') {
            if ($price_per_share != '') {
                if ($price_per_share < $deal_equity_setting['min_price_per_share'] || $price_per_share > $deal_equity_setting['max_price_per_share']) {
                    $price_per_share_error = '<p>' . PRICE_PER_SHARE_SHOULD_BE_BETWEEN . ' ' . $equity_currency_symbol . $deal_equity_setting['min_price_per_share'] . ' ' . TO . ' ' . $equity_currency_symbol . $deal_equity_setting['max_price_per_share'] . '.</p>';
                }
            }
            if ($equity_available != '') {
                if ($equity_available < $deal_equity_setting['min_equity_available'] || $equity_available > $deal_equity_setting['max_equity_available']) {
                    $equity_available_error = '<p>' . EQUITY_AVAILABLE_SHOULD_BE_BETWEEN . ' ' . $deal_equity_setting['min_equity_available'] . ' ' . TO . ' ' . $deal_equity_setting['max_equity_available'] . '.</p>';
                }
            }
            if ($company_valuation != '') {
                if ($company_valuation < $deal_equity_setting['min_company_valuation'] || $company_valuation > $deal_equity_setting['max_company_valuation']) {
                    $company_valuation_error = '<p>' . COMPANY_VALUATION_SHOULD_BE_BETWEEN . ' ' . $equity_currency_symbol . $deal_equity_setting['min_company_valuation'] . ' ' . TO . ' ' . $equity_currency_symbol . $deal_equity_setting['max_company_valuation'] . '.</p>';
                }
            }
        }
        //Deal Convertible Note Validation
        if ($this->input->post('deal_type') == 'convertible_note') {
            if ($interest != '') {
                if ($interest < $deal_convertible_setting['min_convertible_interest'] || $interest > $deal_convertible_setting['max_convertible_interest']) {
                    $interest_error = '<p>' . INTEREST_SHOULD_BE_BETWEEN . ' ' . $deal_convertible_setting['min_convertible_interest'] . ' ' . TO . ' ' . $deal_convertible_setting['max_convertible_interest'] . '.</p>';
                }
            }
            if ($term_length != '') {
                if ($term_length < $deal_convertible_setting['min_convertible_term_length'] || $term_length > $deal_convertible_setting['max_convertible_term_length']) {
                    $term_length_error = '<p>' . TERM_LENGTH_SHOULD_BE_BETWEEN . ' ' . $deal_convertible_setting['min_convertible_term_length'] . ' ' . TO . ' ' . $deal_convertible_setting['max_convertible_term_length'] . '.</p>';
                }
            }
            if ($valuation_cap != '') {
                if ($valuation_cap < $deal_convertible_setting['min_valuation_cap'] || $valuation_cap > $deal_convertible_setting['max_valuation_cap']) {
                    $valuation_cap_error = '<p>' . VALUATION_CAP_SHOULD_BE_BETWEEN . ' ' . $equity_currency_symbol . $deal_convertible_setting['min_valuation_cap'] . ' ' . TO . ' ' . $equity_currency_symbol . $deal_convertible_setting['max_valuation_cap'] . '.</p>';
                }
            }
            if ($warrant_coverage != '') {
                if ($warrant_coverage < $deal_convertible_setting['min_warrant_coverage'] || $warrant_coverage > $deal_convertible_setting['max_warrant_coverage']) {
                    $warrant_coverage_error = '<p>' . WARRANT_COVERAGE_SHOULD_BE_BETWEEN . ' ' . $deal_convertible_setting['min_warrant_coverage'] . ' ' . TO . ' ' . $deal_convertible_setting['max_warrant_coverage'] . '.</p>';
                }
            }
            if ($conversation_discount != '') {
                if ($conversation_discount < $deal_convertible_setting['min_conversation_discount'] || $conversation_discount > $deal_convertible_setting['max_conversation_discount']) {
                    $conversation_discount_error = '<p>' . CONVERSATION_SHOULD_BE_BETWEEN . ' ' . $deal_convertible_setting['min_conversation_discount'] . ' ' . TO . ' ' . $deal_convertible_setting['max_conversation_discount'] . '.</p>';
                }
            }

        }

        //Deal Equity Validation

        if ($this->input->post('deal_type') == 'debt') {
            if ($debt_interest != '') {
                if ($debt_interest < $deal_debt_setting['min_debt_interest'] || $debt_interest > $deal_debt_setting['max_debt_interest']) {
                    $debt_interest_error = '<p>' . INTEREST_SHOULD_BE_BETWEEN . ' ' . $deal_debt_setting['min_debt_interest'] . ' ' . TO . ' ' . $deal_debt_setting['max_debt_interest'] . '.</p>';
                }
            }
            if ($debt_term_length != '') {
                if ($debt_term_length < $deal_debt_setting['min_debt_term_length'] || $debt_term_length > $deal_debt_setting['max_debt_term_length']) {
                    $debt_term_length_error = '<p>' . TERM_LENGTH_SHOULD_BE_BETWEEN . ' ' . $deal_debt_setting['min_debt_term_length'] . ' ' . TO . ' ' . $deal_debt_setting['max_debt_term_length'] . '.</p>';
                }
            }

        }
        if ($this->input->post('deal_type') == 'revenue_share') {
            if ($return_percentage != '') {
                if ($return_percentage < $deal_revenue_share_setting['min_return_percentage'] || $return_percentage > $deal_revenue_share_setting['max_return_percentage']) {
                    $return_percentage_error = '<p>' . RETURN_PERCENTAGE_SHOULD_BE_BETWEEN . ' ' . $deal_revenue_share_setting['min_return_percentage'] . ' ' . TO . ' ' . $deal_revenue_share_setting['max_return_percentage'] . '.</p>';
                }
            }
            if ($maximum_return != '') {
                if ($maximum_return < $deal_revenue_share_setting['min_maximum_return'] || $maximum_return > $deal_debt_setting['max_maximum_return']) {
                    $maximum_return_error = '<p>' . MAXIMUM_RETURN_SHOULD_BE_BETWEEN . ' ' . $deal_revenue_share_setting['min_maximum_return'] . ' ' . TO . ' ' . $deal_revenue_share_setting['max_maximum_return'] . '.</p>';
                }
            }
        }
        if ($_POST) {

            if ($this->form_validation->run() === FALSE || $goal_err != '' || $minimum_raise_err != '' || $maximum_raise_err != '' || $price_per_share_error != '' || $equity_available_error != '' || $company_valuation_error != '' || $interest_error != '' || $term_length_error != '' || $valuation_cap_error != '' || $warrant_coverage_error != '' || $conversation_discount_error != '' || $debt_interest_error != '' || $debt_term_length_error != '' || $return_percentage_error != '' || $maximum_return_error != '' || $deal_type_error != '' || $return_investment_interest_error != ''|| $return_term_length_error != '') {

                $data['error'] = '';
                if (form_error('goal') == '') {
                    $data['goal_err'] = $goal_err;
                } else {
                    $data['goal_err'] = form_error('goal');
                }
                if (form_error('minimum_raise') == '') {
                    $data['minimum_raise_err'] = $minimum_raise_err;
                } else {
                    $data['minimum_raise_err'] = form_error('minimum_raise');
                }
                if (form_error('maximum_raise') == '') {
                    $data['maximum_raise_err'] = $maximum_raise_err;
                } else {
                    $data['maximum_raise_err'] = form_error('maximum_raise');
                }
                if (form_error('price_per_share') == '') {
                    $data['price_per_share_error'] = $price_per_share_error;
                } else {
                    $data['price_per_share_error'] = form_error('price_per_share');
                }
                if (form_error('equity_available') == '') {
                    $data['equity_available_error'] = $equity_available_error;
                } else {
                    $data['equity_available_error'] = form_error('equity_available');
                }
                if (form_error('company_valuation') == '') {
                    $data['company_valuation_error'] = $company_valuation_error;
                } else {
                    $data['company_valuation_error'] = form_error('company_valuation');
                }
                if (form_error('interest') == '') {
                    $data['interest_error'] = $interest_error;
                } else {
                    $data['interest_error'] = form_error('interest');
                }
                if (form_error('term_length') == '') {
                    $data['term_length_error'] = $term_length_error;
                } else {
                    $data['term_length_error'] = form_error('term_length');
                }
                if (form_error('valuation_cap') == '') {
                    $data['valuation_cap_error'] = $valuation_cap_error;
                } else {
                    $data['valuation_cap_error'] = form_error('valuation_cap');
                }
                if (form_error('conversation_discount') == '') {
                    $data['conversation_discount_error'] = $conversation_discount_error;
                } else {
                    $data['conversation_discount_error'] = form_error('conversation_discount');
                }
                if (form_error('warrant_coverage') == '') {
                    $data['warrant_coverage_error'] = $warrant_coverage_error;
                } else {
                    $data['warrant_coverage_error'] = form_error('warrant_coverage');
                }
                if (form_error('debt_interest') == '') {
                    $data['debt_interest_error'] = $debt_interest_error;
                } else {
                    $data['debt_interest_error'] = form_error('debt_interest');
                }
                if (form_error('debt_term_length') == '') {
                    $data['debt_term_length_error'] = $debt_term_length_error;
                } else {
                    $data['debt_term_length_error'] = form_error('debt_term_length');
                }
                if (form_error('return_percentage') == '') {
                    $data['return_percentage_error'] = $return_percentage_error;
                } else {
                    $data['return_percentage_error'] = form_error('return_percentage');
                }
                if (form_error('maximum_return') == '') {
                    $data['maximum_return_error'] = $maximum_return_error;
                } else {
                    $data['maximum_return_error'] = form_error('maximum_return');
                }
                if (form_error('return_investment_interest') == '') {
                    $data['return_investment_interest_error'] = $return_investment_interest_error;
                } else {
                    $data['return_investment_interest_error'] = form_error('return_investment_interest');
                }
                if (form_error('return_term_length') == '') {
                    $data['return_term_length_error'] = $return_term_length_error;
                } else {
                    $data['return_term_length_error'] = form_error('return_term_length');
                }
                if ($deal_type_error != '') {
                    $data['deal_type_error'] = $deal_type_error;
                } else {
                    $data['deal_type_error'] = '';
                }
                
                $data['minimum_raise'] = SecurePostData($this->input->post('minimum_raise'));
                $data['maximum_raise'] = SecurePostData($this->input->post('maximum_raise')); 
                $data['currency_code_id'] = SecurePostData($this->input->post('currency_code_id'));
                $data['goal'] = SecurePostData($this->input->post('goal'));
                $data['equity_stage_id'] = SecurePostData($this->input->post('equity_stage_id'));
                $data['equity_funding_round_id'] = SecurePostData($this->input->post('equity_funding_round_id'));


                $data['end_date'] = SecurePostData($this->input->post('end_date'));
                $data['company_fundraising'] = SecurePostData($this->input->post('company_fundraising'));
                $data['amount_raise_current_round'] = SecurePostData($this->input->post('amount_raise_current_round'));
                $data['date_round_open'] = SecurePostData($this->input->post('date_round_open'));
                $data['deal_type'] = SecurePostData($this->input->post('deal_type'));

                $data['price_per_share'] = SecurePostData($this->input->post('price_per_share'));
                $data['equity_available'] = SecurePostData($this->input->post('equity_available'));
                $data['company_valuation'] = SecurePostData($this->input->post('company_valuation'));
                $data['interest'] = SecurePostData($this->input->post('interest'));
                $data['term_length'] = SecurePostData($this->input->post('term_length'));
                $data['valuation_cap'] = SecurePostData($this->input->post('valuation_cap'));
                $data['conversation_discount'] = SecurePostData($this->input->post('conversation_discount'));
                $data['warrant_coverage'] = SecurePostData($this->input->post('warrant_coverage'));

                $data['debt_interest'] = SecurePostData($this->input->post('debt_interest'));
                $data['debt_term_length'] = SecurePostData($this->input->post('debt_term_length'));
                $data['return'] = SecurePostData($this->input->post('return'));
                $data['return_percentage'] = SecurePostData($this->input->post('return_percentage'));
                $data['maximum_return'] = SecurePostData($this->input->post('maximum_return'));
                $data['payment_frequency'] = SecurePostData($this->input->post('payment_frequency'));
                $data['payment_start_date_text'] = SecurePostData($this->input->post('payment_start_date_text'));
                $data['payment_exact_date'] = SecurePostData($this->input->post('payment_exact_date'));
                $data['payment_number_of_months'] = SecurePostData($this->input->post('payment_number_of_months'));
                $data['funding_type'] = SecurePostData($this->input->post('funding_type'));
                $data['allowed_investor'] = SecurePostData($this->input->post('allowed_investor'));
                $data['project_timezone'] = SecurePostData($this->input->post('project_timezone'));

                $data['return_investment_interest']=$this->input->post('return_investment_interest');
                $data['return_starts']=$this->input->post('return_starts');
                $data['return_payment_frequency']=$this->input->post('return_payment_frequency');
                $data['return_term_length']=$this->input->post('return_term_length');


            } else {

                if ($this->input->post('payment_exact_date') != '') {
                    $payment_start_date = SecurePostData($this->input->post('payment_exact_date'));
                } else {

                    $number_of_months = SecurePostData($this->input->post('payment_number_of_months'));
                    $payment_start_date = date('Y-m-d h:i:s', strtotime("+" . $number_of_months . " months"));
                }

                $equity_currency_data = $this->startequity_model->getTableData('currency_code', array('currency_code_id' => SecurePostData($this->input->post('currency_code_id'))));
                $equity_currency_code = $equity_currency_data[0]['currency_code'];
                $equity_currency_symbol = $equity_currency_data[0]['currency_symbol'];

                if($status_check)
                {

                    $deal_type_array = array(
                        'minimum_raise' => SecurePostData($this->input->post('minimum_raise')),
                        'maximum_raise' => SecurePostData($this->input->post('maximum_raise')),
                       
                        'company_fundraising' => SecurePostData($this->input->post('company_fundraising')),
                        'amount_raise_current_round' => SecurePostData($this->input->post('amount_raise_current_round')),
                        'date_round_open' => SecurePostData($this->input->post('date_round_open')),
                         'project_timezone' => SecurePostData($this->input->post('project_timezone')),
                         'tax_relief_type' => SecurePostData($this->input->post('tax_relief_type')),
                        
                    );
                }
                else
                {
                    
                     $equity_stages_name='';
                    $equity_funding_rounnds_name='';
                    if($data['equity_stages_list']){
                        foreach ($data['equity_stages_list'] as $stages) {
                            if($stages['id']==$this->input->post('equity_stage_id')){
                                $equity_stages_name=$stages['equity_stage'];
                            }
                        }
                    }
                      if($data['equity_funding_rounnds']){
                        foreach ($data['equity_funding_rounnds'] as $funding_rounnds) {
                            if($funding_rounnds['id']==$this->input->post('equity_funding_round_id')){
                                $equity_funding_rounnds_name=$funding_rounnds['funding_round_name'];
                            }
                        }
                    }
                     $equity_url_start = makeSlugs(trim($equity['company_url'].'-'.$equity_stages_name.'-'.$equity_funding_rounnds_name)); 
                    if($id == '' || $id == '0')
                    {
                        $equity_url =create_project_url($equity_url_start);
                    } else {
                        $equity_url =create_project_url($equity_url_start ,$equity_id);
                    }
                    $deal_type_array = array(
                        'minimum_raise' => SecurePostData($this->input->post('minimum_raise')),
                        'maximum_raise' => SecurePostData($this->input->post('maximum_raise')),
                        'equity_stage_id' => SecurePostData($this->input->post('equity_stage_id')),
                        'equity_funding_round_id' => SecurePostData($this->input->post('equity_funding_round_id')),
                        'goal' => SecurePostData($this->input->post('goal')),
                        'equity_currency_code' => $equity_currency_code,
                        'equity_currency_symbol' => $equity_currency_symbol,
                        'end_date' => SecurePostData($this->input->post('end_date')),
                        'company_fundraising' => SecurePostData($this->input->post('company_fundraising')),
                        'amount_raise_current_round' => SecurePostData($this->input->post('amount_raise_current_round')),
                        'deal_type_name' => SecurePostData($this->input->post('deal_type')),
                        'date_round_open' => SecurePostData($this->input->post('date_round_open')),
                        'available_shares' => SecurePostData($this->input->post('available_shares')),
                        'price_per_share' => SecurePostData($this->input->post('price_per_share')),
                        'equity_available' => SecurePostData($this->input->post('equity_available')),
                        'company_valuation' => SecurePostData($this->input->post('company_valuation')),
                        'interest' => SecurePostData($this->input->post('interest')),
                        'term_length' => SecurePostData($this->input->post('term_length')),
                        'valuation_cap' => SecurePostData($this->input->post('valuation_cap')),
                        'conversation_discount' => SecurePostData($this->input->post('conversation_discount')),
                        'warrant_coverage' => SecurePostData($this->input->post('warrant_coverage')),
                        'debt_interest' => SecurePostData($this->input->post('debt_interest')),
                        'debt_term_length' => SecurePostData($this->input->post('debt_term_length')),
                        'return' => SecurePostData($this->input->post('return')),
                        'return_percentage' => SecurePostData($this->input->post('return_percentage')),
                        'maximum_return' => SecurePostData($this->input->post('maximum_return')),
                        'payment_frequency' => SecurePostData($this->input->post('payment_frequency')),
                        'payment_start_date_text' => SecurePostData($this->input->post('payment_start_date_text')),
                        'payment_start_date' => $payment_start_date,
                        'funding_type' => SecurePostData($this->input->post('funding_type')),
                        'allowed_investor' => SecurePostData($this->input->post('allowed_investor')),
                        'project_timezone' => SecurePostData($this->input->post('project_timezone')),
                        'tax_relief_type' => SecurePostData($this->input->post('tax_relief_type')),
                        'return_investment_interest' => SecurePostData($this->input->post('return_investment_interest')),
                        'return_starts' => SecurePostData($this->input->post('return_starts')),
                        'return_payment_frequency' => SecurePostData($this->input->post('return_payment_frequency')),
                        'return_term_length' => SecurePostData($this->input->post('return_term_length')),
                        'equity_url'=> $equity_url,
                    );
                }
                $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $deal_type_array);

                 project_deletecache($equity_id, $equity_url);

                redirect('start_equity/create_step3/' . $equity_id);

            }
        }

        // validation

        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/create_step2', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :create_step3()
	Parameter :id;
	Return : none
	Use : Creating a equity step3 ;
	*/
    function create_step3($id = '')
    {

        $data = array();
        $user_id = check_user_authentication(true);
        if ($id > 0) {
            if (!$this->startequity_model->is_equity_owner($id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $data['id'] = $id;
        $equity_id = $id;
        if (!$id) {
            redirect('start_equity/create_prestep');
        }

        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $meta = meta_setting();

        $chech_id_array = array("equity_id" => $equity_id);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        $equity = $equity_data[0];
        
       
        $status = $equity['status'];
        $status_check = validatestatus_isedit($status);
        $data['status_check'] = $status_check;
        
        $is_allow_edit = true;
        $edit_status = array(0, 1, 2);
        $edit_page = '';
        
        if (!in_array($status, $edit_status)) {
            $is_allow_edit = false;
        }       
        if (!in_array($status, $edit_status)) {
            $edit_page = 'yes';
        }


        if ($is_allow_edit == true and $edit_page != 'yes') {
            
        } else {
            //redirect to dash
            redirect('equity/dashboard/' . $equity_id);
        }


        $data['elevator_pitch'] = $equity['elevator_pitch'];
        $data['deal_highlight1'] = $equity['deal_highlight1'];
        $data['deal_highlight2'] = $equity['deal_highlight2'];
        $data['deal_highlight3'] = $equity['deal_highlight3'];
        $data['deal_highlight4'] = $equity['deal_highlight4'];
        $data['cover_photo'] = $equity['cover_photo'];
        $data['video_url'] = $equity['video_url'];
        $data['video_image'] = $equity['video_image'];

        $this->load->library('form_validation');
        $this->form_validation->set_rules('elevator_pitch', ELEVATOR_PITCH, 'required|trim|editor_required');
        $this->form_validation->set_rules('cover_photo_name', COVER_PHOTO, 'required'); 
        $this->form_validation->set_rules('deal_highlight1', DEAL_HIGHLIGHTS, 'at_least_one_letter');
        $this->form_validation->set_rules('deal_highlight2', DEAL_HIGHLIGHTS, 'at_least_one_letter');
        $this->form_validation->set_rules('deal_highlight3', DEAL_HIGHLIGHTS, 'at_least_one_letter');
        $this->form_validation->set_rules('deal_highlight4', DEAL_HIGHLIGHTS, 'at_least_one_letter');

        $error = '';
        $video_image = '';
        $Ins = 'true';
        $data['video_error'] = '';

        if ($this->input->post('video_url') != '') {
            $url = SecurePostData($this->input->post('video_url'));
            if (substr_count($url, 'youtu.be') > 0) {
                $url = str_replace('youtu.be', 'www.youtube.com/v', $url);
                $url = str_replace(array(
                    "v=",
                    "v/",
                    "vi/"
                ), "v=", $url);
                preg_match("#(?<=v=)[a-zA-Z0-9-]+(?=&)|(?<=v/)[^&\n]+(?=\?)|(?<=v=)[^&\n]+|(?<=youtu.be/)[^&\n]+#", $url, $matches);
                if (isset($matches[0])) {
                    $item = $this->parse_youtube_url('http://www.youtube.com/embed/' . $matches[0], 'hqthumb');
                    $video_image = $item;
                }
             } elseif (substr_count($url, 'youtube.com/embed/') > 0) {
               
                                $item = $this->parse_youtube_url($url, 'hqthumb');
                                $video_image = $item;
            } elseif (substr_count($url, 'youtube') > 0) {
                $url = str_replace(array(
                    "v=",
                    "v/",
                    "vi/"
                ), "v=", $url);
                preg_match("#(?<=v=)[a-zA-Z0-9-]+(?=&)|(?<=v/)[^&\n]+(?=\?)|(?<=v=)[^&\n]+|(?<=youtu.be/)[^&\n]+#", $url, $matches);
                if (isset($matches[0])) {
                    $item = $this->parse_youtube_url('http://www.youtube.com/embed/' . $matches[0], 'hqthumb');
                    $video_image = $item;
                }

            } elseif (substr_count($url, 'vimeo') > 0) {
                $vid_code = explode("/", $url);
                $vid = $vid_code[count($vid_code) - 1];
                $item = $this->getVimeoInfo($vid, 'thumbnail_large');
                $video_image = $item;

            } else {
                $Ins == 'false';
                $error = INVALID_VIDEO_URL;
            }
            if($video_image==''){
                $Ins == 'false';
                $error = INVALID_VIDEO_URL;

            }
        }
        if ($_POST) {
            if ($this->form_validation->run() === FALSE || $error != '' || $Ins == 'false') {
                $data['error'] = '';

                $data['video_error'] = $error;
                $data['elevator_pitch'] = EditorSecurePostData($this->input->post('elevator_pitch'));
                $data['deal_highlight1'] = SecurePostData($this->input->post('deal_highlight1'));
                $data['deal_highlight2'] = SecurePostData($this->input->post('deal_highlight2'));
                $data['deal_highlight3'] = SecurePostData($this->input->post('deal_highlight3'));
                $data['deal_highlight4'] = SecurePostData($this->input->post('deal_highlight4'));
                $data['video_url'] = SecurePostData($this->input->post('video_url'));
            } else {

                if($status_check)
                {
                    $enhance_campaign_array = array(
                  
                    'deal_highlight1' => SecurePostData($this->input->post('deal_highlight1')),
                    'deal_highlight2' => SecurePostData($this->input->post('deal_highlight2')),
                    'deal_highlight3' => SecurePostData($this->input->post('deal_highlight3')),
                    'deal_highlight4' => SecurePostData($this->input->post('deal_highlight4')),
                    'video_url' => SecurePostData($this->input->post('video_url')),
                    'video_image' => $video_image,
                );
                }
                else
                {
                    $enhance_campaign_array = array(
                    'elevator_pitch' => EditorSecurePostData($this->input->post('elevator_pitch')),
                    'deal_highlight1' => SecurePostData($this->input->post('deal_highlight1')),
                    'deal_highlight2' => SecurePostData($this->input->post('deal_highlight2')),
                    'deal_highlight3' => SecurePostData($this->input->post('deal_highlight3')),
                    'deal_highlight4' => SecurePostData($this->input->post('deal_highlight4')),
                    'video_url' => SecurePostData($this->input->post('video_url')),
                    'video_image' => $video_image,
                );
                }
                

                $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $enhance_campaign_array);

                 project_deletecache($equity_id, $equity['equity_url']);

                redirect('start_equity/create_step4/' . $equity_id);
            }
        }
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/create_step3', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }
    /*
	Function name :getVimeoInfo()
	Parameter :$id
	Return : none
	Use : Fetch the vimeo video information using ID
	*/
    // Vimeo video code:
    function getVimeoInfo($id, $info = 'thumbnail_medium')
    {
        if (!function_exists('curl_init')) die('CURL is not installed!');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "http://vimeo.com/api/v2/video/$id.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $output = unserialize(curl_exec($ch));
        // $output = curl_exec($ch);
        $output = $output[0][$info];
        curl_close($ch);
        return $output;
    }

    /*
	Function name :create_step3_ajax()
	Parameter :id 
	Return : Image name
	Use : Cover Photo upload using ajax;
	*/
    function create_step3_ajax($id = null)
    {
        $site_setting = site_setting();
        $this->load->library('form_validation');
        $data = array();
        $data["msg"]["error"] = '';
        $data["msg"]["success"] = '';
        $data["redirect"]["url"] = '';
        $data["image"]["path"] = '';

        if ($this->session->userdata('user_id') == '') {
            $data["redirect"]["url"] = 'home/login';
        } else if ($id == null || $id == '' || $id == '0') {
            $data["redirect"]["url"] = "start_equity/create_prestep";
        } else {


            $_FILES['userfile']['name'] = $_FILES['image']['name'];
            $_FILES['userfile']['type'] = $_FILES['image']['type'];
            $_FILES['userfile']['tmp_name'] = $_FILES['image']['tmp_name'];
            $image_info = getimagesize($_FILES['image']['tmp_name']);
            $image_width = $image_info[0];
            $image_height = $image_info[1];
            $_FILES['userfile']['error'] = $_FILES['image']['error'];
            $_FILES['userfile']['size'] = $_FILES['image']['size'];
            $_FILES['userfile']['max_width'] = $image_width;
            $_FILES['userfile']['max_height'] = $image_height;
            // image validation
             $image_settings = get_image_setting_data();
            if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif") {
                $data["msg"]["error"] = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
            } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                $data["msg"]["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);
            } else if ($_FILES['userfile']['max_width'] < 800) {
                $data["msg"]["error"] = IMAGE_MUST_BE_GREATER_THAN;
            } else if ($_FILES['userfile']['max_height'] < 450) {
                $data["msg"]["error"] = IMAGE_MUST_BE_GREATER_THAN;
            } else {

                $imagename = ImageUpload($_FILES, false, false);
                $data_gallery = array(

                    'cover_photo' => $imagename
                );
                // save data
                $new_cover_photo = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $id, $data_gallery);

                 project_deletecache($id);

                if ($new_cover_photo) {
                    $data["image"]["path"] = base_url() . "upload/equity/small/" . $imagename;
                    $data["msg"]["success"] = 'success';
                } else {
                    $data["msg"]["error"] = THERE_IS_SOME_PROBLEM_SITE_TRY_AFTER_SOMETIME;
                }
            }
            echo json_encode($data);
            die;


        }

    }


    /*
	Function name :perk_ajax_save()
	Parameter :none;
	Return : Array for perk with equity
	Use :Perk for equity
	*/
    function perk_ajax_save()
    {

        $site_setting = site_setting();
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('perk_equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }

        $perk_description = stripslashes($this->input->post('perk_description'));


        $perk_id = SecurePostData($this->input->post('perk_id'));
        $perk_amount = SecurePostData($this->input->post('perk_amount'));
        $perk_title = SecurePostData($this->input->post('perk_title'));
        $perk_title = str_replace('"', "'", $perk_title);
        $perk_title = SecurePostData($perk_title);


        $equity = GetOneEquity($equity_id);

        $this->load->library('form_validation');
        $this->form_validation->set_rules('perk_amount', AMOUNT, 'required|is_natural_no_zero');
        $this->form_validation->set_rules('perk_title', TITLE, 'required|trim|at_least_one_letter');
        $this->form_validation->set_rules('perk_description', DESCRIPTION, 'at_least_one_letter');
        $perk_amount_err = '';
        if ($perk_amount != '' && is_numeric($perk_amount)) {
            if ($perk_amount < $equity['minimum_raise'] || $perk_amount > $equity['maximum_raise']) {

                $perk_amount_err = sprintf(PERK_AMOUNT_SHOULD_BETWEEN, set_currency($equity['minimum_raise'], $equity_id), set_currency($equity['maximum_raise'], $equity_id));
            }
        }
        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //   Check validations
        if ($this->form_validation->run($this) == FALSE || $perk_amount_err != '') {

            if (form_error('perk_amount') == '') {
                $data['perk_amount_error'] = $perk_amount_err;
            } else {
                $data['perk_amount_error'] = form_error('perk_amount');
            }
            $data['perk_title_error'] = form_error('perk_title');
             $data['perk_description_error'] = form_error('perk_description');

            $data["error"] = true;
            echo json_encode($data);
            die;

        }
        $data_array = array(
            'perk_title' => $perk_title,
            'perk_amount' => $perk_amount,
            'perk_description' => $perk_description,
            'equity_id' => $equity_id
        );

        if ($perk_id > 0) {
            $this->startequity_model->AddInsertUpdateTable('perk', 'perk_id', $perk_id, $data_array);
        } else {
            $this->startequity_model->AddInsertUpdateTable('perk', '', '', $data_array);
        }
         project_other_deletecache('perk', $equity_id);
        echo json_encode($data);


    }

    /*
	Function name :delete_perk()
	Parameter :none;
	Return : none
	Use : Delete perk for equity ;
	*/
    function delete_perk()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $perk_id = SecurePostData($this->input->post('perk_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($perk_id == null || $perk_id == '' || $perk_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_PERK_TO_DELETE;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $sql = "delete from perk where perk_id='" . $perk_id . "' ";
        $this->db->query($sql);
        project_other_deletecache('perk', $equity_id);
        echo json_encode($data);
    }

    /*
	Function name :list_perk()
	Parameter :none;
	Return : Result array
	Use : Show Perk list for equity ;
	*/
    function list_perk()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));

        
        $chech_id_array = array("equity_id" => $equity_id);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        $equity = $equity_data[0];


        $status = $equity['status'];
        $status_check = validatestatus_isedit($status);
        $data['status_check'] = $status_check;
    
        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $equity_perk_data = $this->startequity_model->equity_perk_data($equity_id);
        $data["equity_perk_data"] = $equity_perk_data;
        $this->load->view(THEME_LOCATION.'start_equity/list_perk_list', $data);
    }

    /*
	Function name :edit_perk()
	Parameter :none;
	Return : Result array
	Use : Edit perk for equity ;
	*/
    function edit_perk()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $perk_id = SecurePostData($this->input->post('perk_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($perk_id == null || $perk_id == '' || $perk_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_PERK_TO_EDIT;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $equity_perk_data = $this->startequity_model->equity_perk_data($equity_id, $perk_id);
        $data["perk"] = $equity_perk_data[0];
        $data["perk"]['perk_title']=SecureShowData($equity_perk_data[0]['perk_title']);
        echo json_encode($data);
        die;

    }


    /*
	Function name :create_step4()
	Parameter :id;
	Return : none
	Use : Creating a equity step4 ;
	*/
    function create_step4($id = '')
    {

        $data = array();
        $user_id = check_user_authentication(true);
        $data['id'] = $id;
        $equity_id = $id;

        if (!$id) {
            redirect('start_equity/create_prestep');
        }
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }

        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $meta = meta_setting();
        $image_settings = get_image_setting_data();
        $data['upload_limit'] = $image_settings['upload_limit'];
        $funding_source_data = $this->startequity_model->getTableData('funding_source', array('status' => 1), array('id' => 'asc'));
        $data['funding_source_data'] = $funding_source_data;

        $funding_type_data = $this->startequity_model->getTableData('funding_type', array('status' => 1), array('id' => 'asc'));
        $data['funding_type_data'] = $funding_type_data;

        $investor_type_data = $this->startequity_model->getTableData('investor_type', array('status' => 1), array('id' => 'asc'));
        $data['investor_type_data'] = $investor_type_data;

        $document_type_data = $this->startequity_model->equity_deal_document_type_data($equity_id, array('status' => 1));
        $data['document_type_data'] = $document_type_data;


        $chech_id_array = array("equity_id" => $id);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        $equity = $equity_data[0];


        $status = $equity['status'];
        $status_check = validatestatus_isedit($status);
        $data['status_check'] = $status_check;
        
        
        $is_allow_edit = true;
        $edit_status = array(0, 1, 2);
        $edit_page = '';
        
        if (!in_array($status, $edit_status)) {
            $is_allow_edit = false;
        }       
        if (!in_array($status, $edit_status)) {
            $edit_page = 'yes';
        }


        if ($is_allow_edit == true and $edit_page != 'yes') {
            
        } else {
            //redirect to dash
            redirect('equity/dashboard/' . $equity_id);
        }
        
        

        $data['executive_summary_status'] = $equity['executive_summary_status'];
        $data['executive_summary_file'] = $equity['executive_summary_file'];
        $data['contract_copy_file'] = $equity['contract_copy_file'];
        // /$data['term_sheet_date'] = $equity['term_sheet_date'];
        $data['term_sheet_file'] = $equity['term_sheet_file'];

        if (!is_null($equity['executive_summary_file']) and trim($equity['executive_summary_file']) != '') $data['executive_summary_file'] = anchor(base_url() . "upload/equity/investor/" . $equity['executive_summary_file'], $equity['executive_summary_file']);
        if (!is_null($equity['contract_copy_file']) and trim($equity['contract_copy_file']) != '') $data['contract_copy_file'] = anchor(base_url() . "upload/equity/investor/" . $equity['contract_copy_file'], $equity['contract_copy_file']);

        if (!is_null($equity['term_sheet_file']) and trim($equity['term_sheet_file']) != '') $data['term_sheet_file'] = anchor(base_url() . "upload/equity/investor/" . $equity['term_sheet_file'], $equity['term_sheet_file']);
        $data['term_sheet_status'] = $equity['term_sheet_status'];
        $data['equity_id'] = $equity['equity_id'];


        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/create_step4', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }
    /**   Start: CreateStep4 all other function**/
    /*
	Function name :delete_prev_funding()
	Parameter :none;
	Return : none
	Use : Delete Previous funding for equity ;
	Auther:Rakesh
	*/
    function delete_prev_funding()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $previous_funding_id = SecurePostData($this->input->post('previous_funding_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($previous_funding_id == null || $previous_funding_id == '' || $previous_funding_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_PREVIUOS_FUNDING_TO_DELETE;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $sql = "delete from previous_funding where previous_funding_id='" . $previous_funding_id . "' ";
        $this->db->query($sql);
        echo json_encode($data);
    }

    /*
	Function name :list_prev_funding()
	Parameter :none;
	Return : Result array
	Use : Show Previous Funding list for equity ;
	Auther:Rakesh
	*/
    function list_prev_funding()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $previous_funding_data = $this->startequity_model->equity_previous_funding_data($equity_id);
        $data["previous_funding_data"] = $previous_funding_data;
        $this->load->view(THEME_LOCATION.'start_equity/list_prev_funding', $data);
    }

    /*
	Function name :edit_prev_funding()
	Parameter :none;
	Return : Result array
	Use : Edit Previous funding for equity ;
	Auther:Rakesh
	*/
    function edit_prev_funding()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $prev_funding_id = SecurePostData($this->input->post('prev_funding_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($prev_funding_id == null || $prev_funding_id == '' || $prev_funding_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_PREVIUOS_FUNDING_TO_EDIT;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $equity_team_member_data = $this->startequity_model->equity_previous_funding_data($equity_id, $prev_funding_id);
        $data["previous_funding"] = $equity_team_member_data[0];
        echo json_encode($data);
        die;

    }

    /*
	Function name :prev_funding_save()
	Parameter :none;
	Return : Array for previous funding with equity
	Use : previous funding for equity
	Auther:Rakesh
	*/
    function prev_funding_save()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $previous_funding_id = SecurePostData($this->input->post('previous_funding_id'));
        $funding_source = SecurePostData($this->input->post('funding_source'));
        $funding_amount = SecurePostData($this->input->post('funding_amount'));
        $funding_type = SecurePostData($this->input->post('funding_type'));
        $funding_date = SecurePostData($this->input->post('funding_date'));

        $this->load->library('form_validation');

        if ($this->input->post('funding_amount') > 0) {
            $this->form_validation->set_rules('funding_amount', FUNDING_AMOUNT, 'required|trim|is_numeric');
        } else {
            $this->form_validation->set_rules('funding_amount', FUNDING_AMOUNT, 'required|trim|is_natural_no_zero');
        }
        $this->form_validation->set_rules('funding_source', FUNDING_SOURCE, 'required|trim|min_length[2]|max_length[40]');
        $this->form_validation->set_rules('funding_type', EQUITY_FUNDING_TYPE, 'required|trim|min_length[2]|max_length[40]');
        $this->form_validation->set_rules('funding_date', FUNDING_DATE, 'required|trim|min_length[2]|max_length[40]');

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //   Check validations
        if ($this->form_validation->run($this) == FALSE) {

            $data['funding_amount_error'] = form_error('funding_amount');
            $data['funding_source_error'] = form_error('funding_source');
            $data['funding_type_error'] = form_error('funding_type');
            $data['funding_date_error'] = form_error('funding_date');

            $data["error"] = true;
            echo json_encode($data);
            die;

        }

        $data_array = array('previous_funding_id' => $previous_funding_id, 'funding_source' => $funding_source, 'funding_amount' => $funding_amount, 'funding_type' =>
            $funding_type, 'funding_date' => $funding_date, 'equity_id' => $equity_id);

        if ($previous_funding_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('previous_funding', 'previous_funding_id', $previous_funding_id, $data_array);
        else $equity_id = $this->startequity_model->AddInsertUpdateTable('previous_funding', '', '', $data_array);
        echo json_encode($data);


    }

    /*
	Function name :investor_save()
	Parameter :none;
	Return : Array for investors with equity
	Use :company industries for equity
	Auther:Rakesh
	*/
    function investor_save()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('investor_equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $investor_id = SecurePostData($this->input->post('investor_id'));
        $investor_type = SecurePostData($this->input->post('investor_type'));
        $name = $investor_name = SecurePostData($this->input->post('investor_name'));
        if ($investor_name == '') $name = FIRST_AND_LAST_NAME;

        $email = SecurePostData($this->input->post('email'));
        $investor_description = SecurePostData($this->input->post('investor_description'));

        $this->load->library('form_validation');
        $this->form_validation->set_rules('investor_name', FIRST_AND_LAST_NAME, 'required|trim|min_length[3]|max_length[40]|min_word[2]');
        $this->form_validation->set_rules('investor_type', INVESTOR_TYPE, 'required|trim');
        $this->form_validation->set_rules('email', EMAIL_ADDRESS, 'required|trim|valid_email');
        $this->form_validation->set_rules('investor_description', INVESTOR_BIO, 'at_least_one_letter');

        $check_email = '';
        if ($_POST and SecurePostData($this->input->post('email')) != '') {

            if ($this->investor_email_check($this->input->post('email'), $investor_id, $equity_id) == 1) {
                $check_email = EXISTS_ACCOUNT_ASSOCIATE_WITHMAIL . '<br />';
            }
        }

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //   Check validations
        if ($this->form_validation->run($this) == FALSE || $check_email != '') {

            $data['investor_type_error'] = form_error('investor_type');
            $data['investor_name_error'] = form_error('investor_name');
            $data['investor_description_error'] = form_error('investor_description');
            $data['email_error'] = form_error('email');
            if ($check_email != '') {
                $data['email_error'] = $check_email;
            }
            $data["error"] = true;
            echo json_encode($data);
            die;


        }

        $imagename = '';
        if (isset($_FILES['investor_image']['name'])) {
            $_FILES['userfile']['name'] = $_FILES['investor_image']['name'];
            $_FILES['userfile']['type'] = $_FILES['investor_image']['type'];
            $_FILES['userfile']['tmp_name'] = $_FILES['investor_image']['tmp_name'];
            $image_info = getimagesize($_FILES['investor_image']['tmp_name']);
            $image_width = $image_info[0];
            $image_height = $image_info[1];
            $_FILES['userfile']['error'] = $_FILES['investor_image']['error'];
            $_FILES['userfile']['size'] = $_FILES['investor_image']['size'];
            $_FILES['userfile']['max_width'] = $image_width;
            $_FILES['userfile']['max_height'] = $image_height;
            // image validation
             $image_settings = get_image_setting_data();
            if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif") {
                $data["investor_image_error"] = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
                $data["error"] = true;
                echo json_encode($data);
                die;
            } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                $data["investor_image_error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);
                $data["error"] = true;
                echo json_encode($data);
                die;
            } else {


                $files = $_FILES;
                $base_path = $this->config->slash_item('base_path');
                $rand = rand(0, 100000);
                
                $path_parts = pathinfo($_FILES['investor_image']['name']);
                $date = new DateTime();
                
                $file_extention = $path_parts['extension'];
                $new_img = $rand .'-investor-'.$date->getTimestamp().'.'.$file_extention;
                move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/equity/investor/" . $new_img);
                $imagename = $new_img;

                $data["image"]["image_name"] = $imagename;
                $data["image"]["path"] = base_url() . "upload/equity/investor/" . $imagename;


            }
        }
        $data_array = array('investor_name' => $investor_name, 'investor_type' => $investor_type, 'investor_description' =>
            $investor_description, 'investor_email' => $email, 'equity_id' => $equity_id);
        if ($imagename != '') {
            $data_array = array('investor_name' => $investor_name, 'investor_type' => $investor_type, 'investor_description' =>
                $investor_description, 'investor_email' => $email, 'equity_id' => $equity_id, 'investor_image' => $imagename);
        }

        if ($investor_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('investors', 'investor_id', $investor_id, $data_array);
        else $equity_id = $this->startequity_model->AddInsertUpdateTable('investors', '', '', $data_array);
        echo json_encode($data);


    }

    /*
	Function name :delete_investor()
	Parameter :none;
	Return : none
	Use : Delete Team Member for equity ;
	Auther:Rakesh
	*/
    function delete_investor()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $investor_id = SecurePostData($this->input->post('investor_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($investor_id == null || $investor_id == '' || $investor_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_INVESTOR_TO_DELETE;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $sql = "delete from investors where investor_id='" . $investor_id . "' ";
        $this->db->query($sql);
        echo json_encode($data);
    }

    /*
	Function name :list_investor()
	Parameter :none;
	Return : Result array
	Use : Show Team Member list for equity ;
	Auther:Rakesh
	*/
    function list_investor()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $equity_investor_data = $this->startequity_model->equity_investor_data($equity_id);
        $data["equity_investor_data"] = $equity_investor_data;
        $this->load->view(THEME_LOCATION.'start_equity/list_investor', $data);
    }

    /*
	Function name :edit_investor()
	Parameter :none;
	Return : Result array
	Use : Show Investor list for equity ;
	Auther:Rakesh
	*/
    function edit_investor()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $investor_id = SecurePostData($this->input->post('investor_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($investor_id == null || $investor_id == '' || $investor_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_INVESTOR_TO_EDIT;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $equity_investor_data = $this->startequity_model->equity_investor_data($equity_id, $investor_id);
        $data["investor"] = $equity_investor_data[0];
        echo json_encode($data);
        die;

    }

    /*
	Function name :investor_email_check()
	Parameter :none
	Return : none
	Use : This is a callback function which is use to check this investor email exist or not.
	*/
    function investor_email_check($email, $investor_id, $equity_id)
    {
        $email1 = array(
            'investor_email' => $email,
            'equity_id' => $equity_id
        );
        if ($investor_id > 0) {
            $email1 = array(
                'investor_email' => $email, 'investor_id !=' => $investor_id, 'equity_id' => $equity_id
            );

        }
        $username = $this->startequity_model->investor_email_validate($email1);
        if ($username != 'FALSE') {
            return 1;
        } else {
            return 0;
        }
    }

    /*
	Function name :investor_email_check()
	Parameter :none
	Return : none
	Use : This is a callback function which is use to check this investor email exist or not.
	*/
    function document_change_status()
    {

        $equity_id = SecurePostData($this->input->post('equity_id'));
        $executive_summary_status = SecurePostData($this->input->post('executive_summary_status'));
        $term_sheet_status = SecurePostData($this->input->post('term_sheet_status'));

        $data_array =
            array('executive_summary_status' => $executive_summary_status,
                'term_sheet_status' => $term_sheet_status);

        if ($equity_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $data_array);

         project_deletecache($equity_id);

        echo json_encode($data_array);
        die;
    }

    /*
	Function name :investor_deal_document()
	Parameter :none
	Return : none
	Use : This is a callback function which is use to check this investor email exist or not.
	*/
    function investor_deal_document()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $check_equity_id = $equity_id;
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $document_case = SecurePostData($this->input->post('document_case'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //document_case=0 for executive summary file  ,document_case=1 for term sheet file
        $imagename = '';
        $data["document_case"] = $document_case;
        switch ($document_case) {

            case 0:
                $executive_summary_status = SecurePostData($this->input->post('executive_summary_status'));
                if (isset($_FILES['executive_summary_file']['name'])) {
                    $_FILES['userfile']['name'] = $_FILES['executive_summary_file']['name'];
                    $_FILES['userfile']['type'] = $_FILES['executive_summary_file']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['executive_summary_file']['tmp_name'];
                    
                    $_FILES['userfile']['error'] = $_FILES['executive_summary_file']['error'];
                    $_FILES['userfile']['size'] = $_FILES['executive_summary_file']['size'];
                    $image_settings = get_image_setting_data();
                    $finfo = new finfo(FILEINFO_MIME_TYPE);
                    $finfo->file($_FILES['userfile']['tmp_name']);
                    //var_dump($finfo->file($_FILES['userfile']['tmp_name']));die;
                    if (false === $file_extention = array_search($finfo->file($_FILES['userfile']['tmp_name']),$this->getSupportedFileTypes(),true)) {
                        $data["executive_summary_file_error"] = PLEASE_UPLOAD_DOC_PPT_ZIP_PDF;
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                        $data["executive_summary_file_error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else {


                        $files = $_FILES;
                        $base_path = $this->config->slash_item('base_path');
                        $rand = rand(0, 100000);
                       
                        $path_parts = pathinfo($_FILES['executive_summary_file']['name']);
                        $date = new DateTime();
                        
                        $new_img = $rand .'-executive-summary-'.$date->getTimestamp().'.'.$file_extention;

                        move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/equity/investor/" . $new_img);
                        $imagename = $new_img;

                        $data["image"]["image_name"] = $imagename;
                        $data["image"]["path"] = anchor(base_url() . "upload/equity/investor/" . $imagename, $imagename);


                    }
                }
                $data_array = array('executive_summary_status' => $executive_summary_status, 'executive_summary_file' => $imagename);

                if ($equity_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $data_array);
                project_deletecache($equity_id);


                break;
            case 1:
                $term_sheet_status = SecurePostData($this->input->post('term_sheet_status'));
                if (isset($_FILES['term_sheet_file']['name'])) {
                    $_FILES['userfile']['name'] = $_FILES['term_sheet_file']['name'];
                    $_FILES['userfile']['type'] = $_FILES['term_sheet_file']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['term_sheet_file']['tmp_name'];
                    
                    $_FILES['userfile']['error'] = $_FILES['term_sheet_file']['error'];
                    $_FILES['userfile']['size'] = $_FILES['term_sheet_file']['size'];
                    $image_settings = get_image_setting_data();
                    $finfo = new finfo(FILEINFO_MIME_TYPE);
                    $finfo->file($_FILES['userfile']['tmp_name']);
                    if (false === $file_extention = array_search($finfo->file($_FILES['userfile']['tmp_name']),$this->getSupportedFileTypes(),true)) {
                        $data["term_sheet_file_path_error"] = PLEASE_UPLOAD_DOC_PPT_ZIP_PDF;
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else if ($_FILES["userfile"]["size"] >$image_settings['upload_limit']*1000000) {
                        $data["term_sheet_file_path_error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else {


                        $files = $_FILES;
                        $base_path = $this->config->slash_item('base_path');
                        $rand = rand(0, 100000);
                       
                        $path_parts = pathinfo($_FILES['term_sheet_file']['name']);
                        $date = new DateTime();
                      
                        $new_img = $rand .'-term-sheet-'.$date->getTimestamp().'.'.$file_extention;
                        
                       
                        move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/equity/investor/" . $new_img);
                        $imagename = $new_img;

                        $data["image"]["image_name"] = $imagename;
                        $data["image"]["path"] = anchor(base_url() . "upload/equity/investor/" . $imagename, $imagename);


                    }
                }
                $data_array = array('term_sheet_status' => $term_sheet_status, 'term_sheet_file' => $imagename);

                if ($equity_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $data_array);
                project_deletecache($equity_id);


                break;
            case 2:
                $deal_document_type = SecurePostData($this->input->post('deal_document_type'));
                $deal_document_status = SecurePostData($this->input->post('deal_document_status'));
                $deal_document_type_other = SecurePostData($this->input->post('deal_document_type_other'));
                $deal_document_id = SecurePostData($this->input->post('deal_document_id'));
                if ($deal_document_id <= 0) {
                    if (trim($deal_document_type) == '') {
                        $data["deal_document_type_error"] = PLEASE_SELECT_A_DOCUMENT_TYPE;
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    }
                }
                $data["deal_document_type"]=$deal_document_type;
                if ($deal_document_type == 'addnew') {
                    $deal_document_type = SecurePostData($this->input->post('deal_document_type_other'));
                    if (trim($deal_document_type) == '') {
                        $data["deal_document_type_other_error"] = PLEASE_ENTER_A_DOCUMENT;
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    }
                }
                $deal_document_id = SecurePostData($this->input->post('deal_document_id'));
                $filename = '';
                if (isset($_FILES['deal_document_other']['name'])) {
                    $_FILES['userfile']['name'] = $_FILES['deal_document_other']['name'];
                    $_FILES['userfile']['type'] = $_FILES['deal_document_other']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['deal_document_other']['tmp_name'];
                   
                    $_FILES['userfile']['error'] = $_FILES['deal_document_other']['error'];
                    $_FILES['userfile']['size'] = $_FILES['deal_document_other']['size'];
                    $image_settings = get_image_setting_data();
                    //check file mime type. it's a best way to check file type.
                    $finfo = new finfo(FILEINFO_MIME_TYPE);
                    $finfo->file($_FILES['userfile']['tmp_name']);
                    if (false === $file_extention = array_search($finfo->file($_FILES['userfile']['tmp_name']),$this->getSupportedFileTypes(),true)) {
                        $data["deal_document_other_error"] = PLEASE_UPLOAD_DOC_PPT_ZIP_PDF;
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    }
                    else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                        $data["deal_document_other_error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else {
                        $files = $_FILES;
                        $base_path = $this->config->slash_item('base_path');
                        $rand = rand(0, 100000);
                       
                        //we don't need it. it's not accurate whenever someone uploads a file without extension.
                        //$path_parts = pathinfo($_FILES['deal_document_other']['name']);
                        $date = new DateTime();
                        $new_file = $rand .'-deal-document-'.$date->getTimestamp().'.'.$file_extention;
                       
                        move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/equity/investor/" . $new_file);
                        $filename = $new_file;

                        $data["image"]["image_name"] = $filename;
                        $data["image"]["path"] = anchor(base_url() . "upload/equity/investor/" . $filename, $filename);


                    }
                }
                if ($filename != '') {
                    if ($deal_document_type != '') $data_array = array('other' => $deal_document_type_other, 'status' => $deal_document_status, 'file_name' => $deal_document_type, 'file_path' => $filename, 'equity_id' => $equity_id);
                    else $data_array = array('other' => $deal_document_type_other, 'status' => $deal_document_status, 'file_path' => $filename, 'equity_id' => $equity_id);
                } else {
                    if ($deal_document_type != '') $data_array = array('other' => $deal_document_type_other, 'status' => $deal_document_status, 'file_name' => $deal_document_type, 'equity_id' => $equity_id);
                    else $data_array = array('other' => $deal_document_type_other, 'status' => $deal_document_status, 'equity_id' => $equity_id);

                }
                if ($deal_document_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('file_gallery', 'id', $deal_document_id, $data_array);
                else $equity_id = $this->startequity_model->AddInsertUpdateTable('file_gallery', '', '', $data_array);


                $document_type_data = $this->startequity_model->equity_deal_document_type_data($check_equity_id);
                //$str = '';
                $str = '<option value="" class="div-show">' . SELECT . '</option>';
                if ($document_type_data) {
                    foreach ($document_type_data as $document_type) {
                        $str .= '<option value=' . $document_type['document_type_name'] . '>' . $document_type['document_type_name'] . '</option>';
                    }
                }
                $str .= '<option value="addnew" class="div-show">' . ADD_CUSTOM_DOCUMENT . '</option>';
                $data["document_type_data"] = $str;


                break;
            case 3:

                if (isset($_FILES['contract_copy_file']['name'])) {
                    $_FILES['userfile']['name'] = $_FILES['contract_copy_file']['name'];
                    $_FILES['userfile']['type'] = $_FILES['contract_copy_file']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['contract_copy_file']['tmp_name'];
                   
                    $_FILES['userfile']['error'] = $_FILES['contract_copy_file']['error'];
                    $_FILES['userfile']['size'] = $_FILES['contract_copy_file']['size'];
                    $image_settings = get_image_setting_data();
                    $finfo = new finfo(FILEINFO_MIME_TYPE);
                    $finfo->file($_FILES['userfile']['tmp_name']);
                    if (false === $file_extention = array_search($finfo->file($_FILES['userfile']['tmp_name']),$this->getSupportedFileTypes(),true)) {
                        $data["contract_copy_file_error"] = PLEASE_UPLOAD_DOC_PPT_ZIP_PDF;
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                        $data["contract_copy_file_error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else {


                        $files = $_FILES;
                        $base_path = $this->config->slash_item('base_path');
                       
                        $rand = rand(0, 100000);
                        $date = new DateTime();
                        
                        $new_img = $rand .'-contract-copy-'.$date->getTimestamp().'.'.$file_extention;
                       
                        move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/equity/investor/" . $new_img);
                        $imagename = $new_img;

                        $data["image"]["image_name"] = $imagename;
                        $data["image"]["path"] = anchor(base_url() . "upload/equity/investor/" . $imagename, $imagename);


                    }
                }
                $data_array = array('contract_copy_file' => $imagename);

                if ($equity_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $data_array);
                project_deletecache($equity_id);


                break;
        }


        echo json_encode($data);
    }

    /*
	Function name :list_deal_document()
	Parameter :none;
	Return : Result array
	Use : Show Custom document list for equity ;
	Auther:Rakesh
	*/
    function list_deal_document()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $chech_id_array = array("equity_id" => $equity_id);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        $equity = $equity_data[0];
        $data['executive_summary_status'] = $equity['executive_summary_status'];
        $data['executive_summary_file'] = anchor(base_url() . "upload/equity/investor/" . $equity['executive_summary_file'], $equity['executive_summary_file']);
        //$data['executive_summary_date'] = $equity['executive_summary_date'];
        //$data['term_sheet_date'] = $equity['term_sheet_date'];
        $data['term_sheet_file'] = anchor(base_url() . "upload/equity/investor/" . $equity['term_sheet_file'], $equity['term_sheet_file']);
        $data['term_sheet_status'] = $equity['term_sheet_status'];
        $data['equity_id'] = $equity['equity_id'];


        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $equity_file_gallery_data = $this->startequity_model->equity_file_gallery_data($equity_id);
        $data["equity_file_gallery_data"] = $equity_file_gallery_data;
        $this->load->view(THEME_LOCATION.'start_equity/list_deal_document', $data);
    }

    /*
	Function name :delete_deal_document()
	Parameter :none;
	Return : none
	Use : Delete Deal Document for equity ;
	Auther:Rakesh
	*/
    function delete_deal_document()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $deal_document_id = SecurePostData($this->input->post('deal_document_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($deal_document_id == null || $deal_document_id == '' || $deal_document_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_DEAL_DOCUMENT_TO_DELETE;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        if ($deal_document_id == 'executive') {
            $data_array = array('executive_summary_status' => '', 'executive_summary_file' => '');
            if ($equity_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $data_array);
            project_deletecache($equity_id);

        }
        if ($deal_document_id == 'contract') {
            $data_array = array('contract_copy_file' => '');
            if ($equity_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $data_array);
            project_deletecache($equity_id);

        } else if ($deal_document_id == 'terms') {
            $data_array = array('term_sheet_status' => '', 'term_sheet_file' => '');

            if ($equity_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $data_array);
            project_deletecache($equity_id);

        } else {
            $sql = "delete from file_gallery where id='" . $deal_document_id . "' ";
            $this->db->query($sql);
        }
        $document_type_data = $this->startequity_model->equity_deal_document_type_data($equity_id);
        $str = '';

        if ($document_type_data) {

            $str = '<option value="" class="div-show">' . SELECT . '</option>';
            foreach ($document_type_data as $document_type) {
                $str .= '<option value=' . $document_type['document_type_name'] . '>' . $document_type['document_type_name'] . '</option>';
            }
            $str .= '<option value="addnew" class="div-show">' . ADD_CUSTOM_DOCUMENT . '</option>';

        }
        $data["document_type_data"] = $str;
        echo json_encode($data);
    }

    /*
	Function name :edit_deal_document()
	Parameter :none;
	Return : Result array
	Use : Show files for equity ;
	Auther:Rakesh
	*/
    function edit_deal_document()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $deal_document_id = SecurePostData($this->input->post('deal_document_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($deal_document_id == null || $deal_document_id == '' || $deal_document_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_DEAL_DOCUMENT_TO_EDIT;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $equity_file_gallery_data = $this->startequity_model->equity_file_gallery_data($equity_id, $deal_document_id);
        $data["file_gallery"] = $equity_file_gallery_data[0];
        echo json_encode($data);
        die;

    }

    /*
	Function name :video_save()
	Parameter :none;
	Return : Array for video with equity
	Use :video for equity
	Auther:Rakesh
	*/
    function video_save()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $data['media_video_title_error'] = '';
        $data['media_video_name_error'] = '';
        $data['media_video_desc_error'] = '';

        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $video_id = SecurePostData($this->input->post('video_id'));
        $media_video_title = SecurePostData($this->input->post('media_video_title'));
        $media_video_name = SecurePostData($this->input->post('media_video_name'));
        $media_video_desc = stripslashes($this->input->post('media_video_desc'));
        $media_video_status = SecurePostData($this->input->post('media_video_status'));

        $this->load->library('form_validation');
        $this->form_validation->set_rules('media_video_title', TITLE, 'required|trim|min_length[3]|max_length[70]|at_least_one_letter');
        $this->form_validation->set_rules('media_video_name', URL, 'required|trim');
        $this->form_validation->set_rules('media_video_desc', DESCRIPTION, 'at_least_one_letter');

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //   Check validations
        if ($this->form_validation->run($this) == FALSE) {

            $data['media_video_title_error'] = form_error('media_video_title');
            $data['media_video_name_error'] = form_error('media_video_name');
             $data['media_video_desc_error'] = form_error('media_video_desc');

            $data["error"] = true;
            echo json_encode($data);
            die;


        }

        $url = $media_video_name;
        $video_image = '';
        //
        if (substr_count($url, 'youtube') > 0) {
            $url = str_replace('youtu.be', 'www.youtube.com/v', $url);
            $url = str_replace(array(
                "v=",
                "v/",
                "vi/"
            ), "v=", $url);
            preg_match("#(?<=v=)[a-zA-Z0-9-]+(?=&)|(?<=v/)[^&\n]+(?=\?)|(?<=v=)[^&\n]+|(?<=youtu.be/)[^&\n]+#", $url, $matches);
            if (isset($matches[0])) {
                $item = $this->parse_youtube_url('http://www.youtube.com/embed/' . $matches[0], 'hqthumb');
                $video_image = $item;
            }
         } elseif (substr_count($url, 'youtube.com/embed/') > 0) {
               
                                $item = $this->parse_youtube_url($url, 'hqthumb');
                                $video_image = $item;
        } elseif (substr_count($url, 'youtube') > 0) {
            $url = str_replace(array(
                "v=",
                "v/",
                "vi/"
            ), "v=", $url);
            preg_match("#(?<=v=)[a-zA-Z0-9-]+(?=&)|(?<=v/)[^&\n]+(?=\?)|(?<=v=)[^&\n]+|(?<=youtu.be/)[^&\n]+#", $url, $matches);
            if (isset($matches[0])) {
                $item = $this->parse_youtube_url('http://www.youtube.com/embed/' . $matches[0], 'hqthumb');
                $video_image = $item;
            }
        } elseif (substr_count($url, 'vimeo') > 0) {
            $vid_code = explode("/", $url);
            $vid = $vid_code[count($vid_code) - 1];
            $item = $this->getVimeoInfo($vid, 'thumbnail_large');
            $video_image = $item;
        } else {
            $data['media_video_name_error'] = INVALID_VIDEO_URL;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        if($video_image==''){
              $data['media_video_name_error'] = INVALID_VIDEO_URL;
                 $data["error"] = true;
                  echo json_encode($data);
                 die;

            }
        $data["image"]["media_url"] = $video_image;

        $data_array = array('media_video_title' => $media_video_title, 'media_video_name' => $media_video_name, 'media_video_desc' =>
            $media_video_desc, 'status' => $media_video_status, 'equity_id' => $equity_id);
        if ($video_image != '') {
            $data_array = array('media_video_title' => $media_video_title, 'media_video_name' => $media_video_name, 'media_video_desc' =>
                $media_video_desc, 'status' => $media_video_status, 'equity_id' => $equity_id, 'image' => $video_image);


        }

        if ($video_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('video_gallery', 'id', $video_id, $data_array);
        else $equity_id = $this->startequity_model->AddInsertUpdateTable('video_gallery', '', '', $data_array);
        echo json_encode($data);


    }
   /*
    Function name :parse_youtube_url()
    Parameter :url ,url,width,height
    Return : none
    Use : Parse the youtube URL and return iframe or embded code    */
    // return image from youtube url
    function parse_youtube_url($url, $return = 'embed', $width = '', $height = '', $rel = 0)
    {
        $v = '';
        $urls = parse_url($url);
        if (isset($urls['host'])) {
            // url is http://youtu.be/xxxx
            if ($urls['host'] == 'youtu.be') {
                $id = ltrim($urls['path'], '/');
            } // url is http://www.youtube.com/embed/xxxx
            else if (strpos($urls['path'], 'embed') == 1) {
                $arr=explode('/', $urls['path']);
                $id = end($arr);
            } // url is xxxx only
            else if (strpos($url, '/') === false) {
                $id = $url;
            }
            // http://www.youtube.com/watch?feature=player_embedded&v=m-t4pcO99gI
            // url is http://www.youtube.com/watch?v=xxxx
            else {
                parse_str($urls['query']);
                $id = $v;
                if (!empty($feature)) {
                    $id = end(explode('v=', $urls['query']));
                }
            }
            // return embed iframe
            if ($return == 'embed') {
                return '<iframe width="' . ($width ? $width : 560) . '" height="' . ($height ? $height : 349) . '" src="http://www.youtube.com/embed/' . $id . '?rel=' . $rel . '" frameborder="0" allowfullscreen></iframe>';
            } // return normal thumb
            else if ($return == 'thumb') {
                return 'http://i1.ytimg.com/vi/' . $id . '/default.jpg';
            } // return hqthumb
            else if ($return == 'hqthumb') {
                return 'http://i1.ytimg.com/vi/' . $id . '/hqdefault.jpg';
            } // else return id
            else {
                return $id;
            }
        } ///===isset
        return false;
    }

    /*
	Function name :list_video()
	Parameter :none;
	Return : Result array
	Use : Show Video list for equity ;
	Auther:Rakesh
	*/
    function list_video()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $video_data = $this->startequity_model->equity_video_gallery_data($equity_id);
        $data["video_data"] = $video_data;
        $this->load->view(THEME_LOCATION.'start_equity/list_video', $data);
    }

    /*
	Function name :delete_video()
	Parameter :none;
	Return : none
	Use : Delete Video for equity ;
	Auther:Rakesh
	*/
    function delete_video()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $video_id = SecurePostData($this->input->post('video_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($video_id == null || $video_id == '' || $video_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_VIDEO_TO_DELETE;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $sql = "delete from video_gallery where id='" . $video_id . "' ";
        $this->db->query($sql);
        echo json_encode($data);
    }

    /*
	Function name :edit_video()
	Parameter :none;
	Return : Result array
	Use : Show video for equity ;
	Auther:Rakesh
	*/
    function edit_video()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $video_id = SecurePostData($this->input->post('video_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($video_id == null || $video_id == '' || $video_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_VIDEO_TO_EDIT;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $video_data = $this->startequity_model->equity_video_gallery_data($equity_id, $video_id);
        $data["video"] = $video_data[0];
        echo json_encode($data);
        die;

    }

    /*
	Function name :image_save()
	Parameter :none;
	Return : Array for Image  with equity
	Use :Image for equity
	Auther:Rakesh
	*/
    function image_save()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $data['image_name_error'] = '';
        $data['image_desc_error'] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $image_id = SecurePostData($this->input->post('image_id'));
        $image_name = SecurePostData($this->input->post('image_name'));
        $image_desc = stripslashes($this->input->post('image_desc'));
        $image_status = SecurePostData($this->input->post('image_status'));

        $this->load->library('form_validation');
        $this->form_validation->set_rules('image_name', TITLE, 'required|trim|at_least_one_letter');
        $this->form_validation->set_rules('image_desc', DESCRIPTION, 'at_least_one_letter');
        //$this->form_validation->set_rules('image', IMAGE, 'required|trim');


        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //   Check validations
        if ($this->form_validation->run($this) == FALSE) {
            $data['image_name_error'] = form_error('image_name');
            $data['image_desc_error'] = form_error('image_desc');
            //$data['image_error'] = form_error('image');
            if (isset($_FILES['image']['name'])) {
                $data['image_error'] = "";

            } else {
                $image_id_array = array("equity_gallery_id" => $image_id);
                $image_data = $this->startequity_model->getTableData('equity_gallery', $image_id_array);
                $images = $image_data[0];
                if ($images['image']) {
                    $data['image_error'] = "";
                } else {
                    $data['image_error'] = IMAGE_REQUIRED;
                }


            }
            $data["error"] = true;
            echo json_encode($data);
            die;


        }

        $imagename = '';
        if (isset($_FILES['image']['name'])) {


            $_FILES['userfile']['name'] = $_FILES['image']['name'];
            $_FILES['userfile']['type'] = $_FILES['image']['type'];
            $_FILES['userfile']['tmp_name'] = $_FILES['image']['tmp_name'];
            $image_info = getimagesize($_FILES['image']['tmp_name']);
            $image_width = $image_info[0];
            $image_height = $image_info[1];
            $_FILES['userfile']['error'] = $_FILES['image']['error'];
            $_FILES['userfile']['size'] = $_FILES['image']['size'];
            $_FILES['userfile']['max_width'] = $image_width;
            $_FILES['userfile']['max_height'] = $image_height;
            // image validation
            $image_settings = get_image_setting_data();
            if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif") {
                $data["image_error"] = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
                $data["error"] = true;
                echo json_encode($data);
                die;
            } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                $data["image_error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);;
                $data["error"] = true;
                echo json_encode($data);
                die;
            } else {


                $files = $_FILES;
                $base_path = $this->config->slash_item('base_path');
              
                $rand = rand(0, 100000);
                       
                $path_parts = pathinfo($_FILES['image']['name']);
                $date = new DateTime();
                
                $file_extention = $path_parts['extension'];
                $new_img = $rand .'-image-'.$date->getTimestamp().'.'.$file_extention;
               

                move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/gallery/" . $new_img);
                $imagename = $new_img;

                $data["image"]["image_name"] = $imagename;
                $data["image"]["path"] = anchor(base_url() . "upload/gallery/" . $imagename, $imagename);


            }
        } else {
            if(!$image_id) {
                $data["image_error"] = IMAGE_REQUIRED;
                $data["error"] = true;
                echo json_encode($data);
                die;
            }
        }
        $data_array = array('image_name' => $image_name, 'image_desc' => $image_desc, 'status' => $image_status, 'equity_id' => $equity_id);
        if ($imagename != '') {
            $data_array = array('image_name' => $image_name, 'image_desc' => $image_desc, 'status' => $image_status, 'equity_id' => $equity_id, 'image' => $imagename);


        }

        if ($image_id > 0) $equity_id = $this->startequity_model->AddInsertUpdateTable('equity_gallery', 'equity_gallery_id', $image_id, $data_array);
        else $equity_id = $this->startequity_model->AddInsertUpdateTable('equity_gallery', '', '', $data_array);
        echo json_encode($data);


    }

    /*
	Function name :list_image()
	Parameter :none;
	Return : Result array
	Use : Show Image list for equity ;
	Auther:Rakesh
	*/
    function list_image()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = INVALID_DATA;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $image_data = $this->startequity_model->equity_image_gallery_data($equity_id);
        $data["image_data"] = $image_data;
        $this->load->view(THEME_LOCATION.'start_equity/list_image', $data);
    }

    /*
	Function name :delete_image()
	Parameter :none;
	Return : none
	Use : Delete Image for equity ;
	Auther:Rakesh
	*/
    function delete_image()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $image_id = SecurePostData($this->input->post('image_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($image_id == null || $image_id == '' || $image_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_IMAGE_TO_DELETE;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $sql = "delete from equity_gallery where equity_gallery_id='" . $image_id . "' ";
        $this->db->query($sql);
        echo json_encode($data);
    }

    /*
	Function name :edit_image()
	Parameter :none;
	Return : Result array
	Use : Show Image for equity ;
	Auther:Rakesh
	*/
    function edit_image()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $image_id = SecurePostData($this->input->post('image_id'));

        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } else if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["url"] = "start_equity/create_prestep";
            $data["error"] = true;
            echo json_encode($data);
            die;
        }

        //check user select value from dropdown
        if ($equity_id == null || $equity_id == '' || $equity_id == '0') {
            $data["msg"] = 'Invalid data';
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        //check user select value from dropdown
        if ($image_id == null || $image_id == '' || $image_id == '0') {
            $data["msg"] = PLEASE_CLICK_ON_IMAGE_TO_EDIT;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }
        $image_data = $this->startequity_model->equity_image_gallery_data($equity_id, $image_id);
        $data["image"] = $image_data[0];
        echo json_encode($data);
        die;

    }
    /**      End: CreateStep4 all other function**/

    /*
	Function name :create_step5()
	Parameter :id;
	Return : none
	Use : Creating a equity step5 ;
	*/
    function create_step5($id = '')
    {

        $data = array();
        $user_id = check_user_authentication(true);
        $data['id'] = $id;
        $equity_id = $id;

        if (!$id) {
            redirect('start_equity/create_prestep');
        }
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }


        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $meta = meta_setting();

        $account_type_data = $this->startequity_model->getactiveTableData('account_type');
        $data['account_type_data'] = $account_type_data;

        $chech_id_array = array("equity_id" => $equity_id);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        $equity = $equity_data[0];

        $status = $equity['status'];
        $status_check = validatestatus_isedit($status);
        $data['status_check'] = $status_check;
        
         $page_term_array = array('slug' => 'bank-terms');
        $terms_data = $this->startequity_model->getTableData('pages', $page_term_array);
        $data['terms_data'] = $terms_data[0];
       

        
        $is_allow_edit = true;
        $edit_status = array(0, 1, 2);
        $edit_page = '';
        
        if (!in_array($status, $edit_status)) {
            $is_allow_edit = false;
        }       
        if (!in_array($status, $edit_status)) {
            $edit_page = 'yes';
        }


        if ($is_allow_edit == true and $edit_page != 'yes') {
            
        } else {
            //redirect to dash
            redirect('equity/dashboard/' . $equity_id);
        }

        $data['bank_name'] = $equity['bank_name'];
        $data['bank_account_type'] = $equity['bank_account_type'];
        $data['bank_account_number'] = $equity['bank_account_number'];
        $data['confirm_account_number'] = $equity['bank_account_number'];
        $data['routing_number'] = $equity['routing_number'];

        $this->load->library('form_validation');
        $this->form_validation->set_rules('bank_name', BANK_NAME, 'required|trim|at_least_one_letter');
        $this->form_validation->set_rules('bank_account_type', ACCOUNT_TYPE, 'required|trim');
        $this->form_validation->set_rules('bank_account_number', ACCOUNT_NUMBERC, 'required|is_natural');
        $this->form_validation->set_rules('confirm_account_number', CONFIRM_ACCOUNT_NUMBER, 'required|is_natural|matches[bank_account_number]');
        $this->form_validation->set_rules('routing_number', ROUTING_NO, 'required|is_natural|min_length[9]|max_length[9]');
        if ($_POST) {
            if ($this->form_validation->run() === FALSE) {

                $data['error'] = '';

                $data['bank_name'] = SecurePostData($this->input->post('bank_name'));
                $data['bank_account_type'] = SecurePostData($this->input->post('bank_account_type'));
                $data['bank_account_number'] = SecurePostData($this->input->post('bank_account_number'));
                $data['confirm_account_number'] = SecurePostData($this->input->post('confirm_account_number'));
                $data['routing_number'] = SecurePostData($this->input->post('routing_number'));
            } else {

                $get_funded_array = array(
                    'bank_name' => SecurePostData($this->input->post('bank_name')),
                    'bank_account_type' => SecurePostData($this->input->post('bank_account_type')),
                    'bank_account_number' => SecurePostData($this->input->post('bank_account_number')),

                    'routing_number' => SecurePostData($this->input->post('routing_number'))
                );


                $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $get_funded_array);
                project_deletecache($equity_id);

                $this->session->set_flashdata('common_success_msg', RECORD_UPDATED_SUCCESS);


                redirect('start_equity/create_step5/' . $equity_id);

            }

        }
        $data['check_live'] = $this->check_for_live($id);
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/create_step5', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :check_for_live()
	Parameter :id
	Return : true or false
	Use : Check equity data and return true or false according to data added;
	*/
    function check_for_live($id = null)
    {
        if ($id == null || $id == '' || $id == '0') {
            redirect('start_equity/create_step1');
        }
        $str = '';
        $data['error'] = "";
        $site_setting = site_setting();
        $equity_data = $this->equity_model->GetAllEquities($user_id = 0, $id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user','company_profile')); // store in cache

        $equity = $equity_data[0];
        // print_r($equity);
        // exit;
        $data['equity'] = $equity;

        $chech_id_array = array("company_id" => $equity['company_id']);
        $company_industry_data = $this->startequity_model->getTableData('equity_company_industry', $chech_id_array);
        $company_industry = $company_industry_data[0];

        if ($equity['company_name'] == '') {
            return 0;
        }


        if ($equity['headquater_city'] == '') {
            return 0;
        }
        if ($equity['year_founded'] == '') {
            return 0;
        }

        if ($equity['headquater_state'] == '') {
            return 0;
        }
        if ($equity['headquater_country'] == '') {
            return 0;
        }
        if (!isset($company_industry['company_id'])) {
            return 0;
        }
        if ($equity['assets_under_management'] == '') {
            return 0;
        }
        if ($equity['square_footage'] == '') {
            return 0;
        }
        if ($equity['company_overview'] == '') {
            return 0;
        }
        if ($equity['company_email'] == '') {
            return 0;
        }
        if ($equity['goal'] == '') {
            return 0;
        }
        if ($equity['minimum_raise'] == '') {
            return 0;
        }
        if ($equity['deal_type_name'] == '') {
            return 0;
        }
        if ($equity['elevator_pitch'] == '') {
            return 0;
        }
        if ($equity['cover_photo'] == '') {
            return 0;
        }
        if ($equity['executive_summary_file'] == '') {
            return 0;
        }
        if ($equity['term_sheet_file'] == '') {
            return 0;
        }
        if ($equity['bank_name'] == '') {
            return 0;
        }
        if ($equity['bank_account_type'] == '') {
            return 0;
        }
        if ($equity['bank_account_number'] == '') {
            return 0;
        }
        if ($equity['routing_number'] == '') {
            return 0;
        }
        // if ($equity['paypal_email'] == '') {
        //     return 0;
        // }
         if ($site_setting['sign_contract_upload_by'] == 0 && $site_setting['contract_copy_status'] == 0) {
            if (trim($equity['contract_copy_file']) == '') {
                return 0;
            }
        }


        return 1;
        // echo $str; die;
    }

    /*
	Function name :edit_steps()
	Parameter :id
	Return : message
	Use : Check project data and return message according to data added;
	*/
    function edit_steps($id = null)
    {
        if ($id == null || $id == '' || $id == '0') {
            redirect('start_equity/create_step1');
        }
        $str = '';
        $data['error'] = "";
       
        $equity_data = $this->equity_model->GetAllEquities($user_id = 0, $id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user')); // store in cache

        $equity = $equity_data[0];

        $data['equity'] = $equity;
        $site_setting = site_setting();

         $chech_id_array = array("company_id" => $equity['company_id']);
        $company_industry_data = $this->startequity_model->getTableData('equity_company_industry', $chech_id_array);
        $company_industry = $company_industry_data[0];

        if ($equity['company_name'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . COMPANY_NAME . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . COMPANY_NAME . ' : ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['year_founded'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . YEAR_FOUNDED . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . YEAR_FOUNDED . ' : ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['headquater_city'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . HEADQUATER_CITY . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . HEADQUATER_CITY . ' : ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }

        if ($equity['headquater_state'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . HEADQUATER_STATE . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . HEADQUATER_STATE . ' : ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['headquater_country'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . HEADQUATER_COUNTRY . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . HEADQUATER_COUNTRY . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['company_category'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . COMPANY_CATEGORY . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . COMPANY_CATEGORY . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if (!isset($company_industry['company_id'])) {
            $str .= '<div class="check-notcompleted check-item">' . COMPANY_INDUSTRY . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . COMPANY_INDUSTRY . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['assets_under_management'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . ASSETS_UNDER_MANAGEMENT . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . ASSETS_UNDER_MANAGEMENT . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['square_footage'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . SQUARE_FOOTAGE_DEVELOPED . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . SQUARE_FOOTAGE_DEVELOPED . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['company_logo'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . COMPANY_ASSETS . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . COMPANY_ASSETS . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_basic') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['company_overview'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . COMPANY_OVERVIEW . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_overview') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . COMPANY_OVERVIEW . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_overview') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['company_email'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . EMAIL_CONTACT . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_connect') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . EMAIL_CONTACT . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step1/' . $id . '#company_connect') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['goal'] == '' || $equity['goal'] == 0) {
            $str .= '<div class="check-notcompleted check-item">' . FUNDRAISING_GOAL . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#fundraising_detail') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . FUNDRAISING_GOAL . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#fundraising_detail') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['end_date'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . CLOSING_DATE_THIS_CAN_BE_EXTENDED . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#fundraising_detail') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . CLOSING_DATE_THIS_CAN_BE_EXTENDED . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#fundraising_detail') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['minimum_raise'] == '' || $equity['minimum_raise'] == 0) {
            $str .= '<div class="check-notcompleted check-item">' . MINIMUM_RAISE . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#fundraising_detail') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . MINIMUM_RAISE . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#fundraising_detail') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['funding_type'] == '') {

            $str .= '<div class="check-notcompleted check-item">' . FUNDING_TYPE . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#fundraising_detail') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . FUNDING_TYPE . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#fundraising_detail') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['deal_type_name'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . DEAL_TYPE . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#deal_type') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . DEAL_TYPE . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step2/' . $id . '#deal_type') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['elevator_pitch'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . ELEVATOR_PITCH . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step3/' . $id . '#elevator_pitch') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . ELEVATOR_PITCH . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step3/' . $id . '#elevator_pitch') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['cover_photo'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . COVER_PHOTO . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step3/' . $id . '#add_cover') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . COVER_PHOTO . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step3/' . $id . '#add_cover') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['executive_summary_file'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . EXECUTIVE_SUMMARY . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step4/' . $id . '#deal_documents') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . EXECUTIVE_SUMMARY . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step4/' . $id . '#deal_documents') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['term_sheet_file'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . TERM_SHEET . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step4/' . $id . '#deal_documents') . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . TERM_SHEET . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step4/' . $id . '#deal_documents') . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['bank_name'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . BANK_NAME . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step5/' . $id) . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . BANK_NAME . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step5/' . $id) . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['bank_account_type'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . ACCOUNT_TYPE . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step5/' . $id) . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . ACCOUNT_TYPE . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step5/' . $id) . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['bank_account_number'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . ACCOUNT_NUMBERC . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step5/' . $id) . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . ACCOUNT_NUMBERC . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step5/' . $id) . '" style="float:right;">Edit</a></div>';
        }
        if ($equity['routing_number'] == '') {
            $str .= '<div class="check-notcompleted check-item">' . ROUTING_NO . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step5/' . $id) . '" style="float:right;">Edit</a></div>';
        } else {
            $str .= '<div class="check-completed check-item">' . ROUTING_NO . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step5/' . $id) . '" style="float:right;">Edit</a></div>';
        }
        if ($site_setting['sign_contract_upload_by'] == 0 && $site_setting['contract_copy_status'] == 0) {

            if (trim($equity['contract_copy_file']) == '') {
                $str .= '<div class="check-notcompleted check-item">' . SIGN_CONTRACT . ' : ' . NOT_COMPLETED . ' <a href="' . site_url('start_equity/create_step4/' . $id) . '" style="float:right;">Edit</a></div>';
            } else {
                $str .= '<div class="check-completed check-item">' . SIGN_CONTRACT . ': ' . COMPLETED . ' <a href="' . site_url('start_equity/create_step4/' . $id) . '" style="float:right;">Edit</a></div>';
            }
        }
        echo $str;
        die;
    }

    /*
	Function name :launch_equity()
	Parameter :id 
	Return : none
	Use :Launch Equity
	*/
    function launch_equity($id = null)
    {
        $user_id = check_user_authentication(true);
        if ($id > 0) {
            if (!$this->startequity_model->is_equity_owner($id)) {
                redirect('home/notedit_project');
            }
        }
        $this->db->query("update equity set status=1 where equity_id='" . $id . "'");
        project_deletecache($id);
        $equity_data = $this->equity_model->GetAllEquities(0, $id); // store in cache
        $equity = $equity_data[0];

        //start count latest activities	
        project_activity('submit_project', $user_id, '', $id);

        if ($this->session->userdata('user_id') != $equity['user_id']) {
            redirect('home');
        }

        $company_industry_data = $this->equity_model->GetEquityCompanyIndustry($id, $joinarr = array('company_industry', 'equity'), $limit = 10, $order = array('equity_company_industry.company_industry_id' => 'desc'));

        $userdetail = UserData($user_id, array());
        $equity_url = $equity['equity_url'];
        $equity['user_name'] = $userdetail[0]['user_name'] . ' ' . $userdetail[0]['last_name'];
        $user_profile_link = '<a href="' . site_url('user/' . $userdetail[0]['profile_slug']) . '">' . $equity['user_name'] . '</a>';
        $equity['user_profile_link'] = $user_profile_link;
        $taxonomy_setting = taxonomy_setting();
        $project_url = $taxonomy_setting['project_url'];

       
        if($company_industry_data){

             foreach ($company_industry_data as $key=>$company_industry) {

                    if($key==0){
                         $company_industry_data= $company_industry['company_industry_name'];
                        
                    }else{

                        $company_industry_data .= ', ' . $company_industry['company_industry_name'];
                    }


            }
             
        }

        $equity['company_industry'] = $company_industry_data;
        $equity['email'] = $userdetail[0]['email'];
        $equity['equity_name'] = SecureShowData($equity['company_name']);
        $equity['equity_page_link'] = '<a href="' . site_url($project_url . '/' . $id) . '">' . site_url($project_url .'/' . $id) . '</a>';
        $equity['company_name_link'] = '<a href="' . site_url($project_url . '/' . $id) . '">' . SecureShowData($equity['company_name']) . '</a>';;
         $equity['user_id']=$userdetail[0]['user_id'];
        //Admin Alert
        $this->EquityMailAlerts('equity_submit_for_admin_approval', '', $equity, '', 'New Equity Post Admin Alert');
        //Equity Owner alert
        $this->EquityMailAlerts('equity_success_submit', '', $equity, '', 'New Equity Successful Alert');

        redirect('start_equity/thankyou/' . $user_id . '/' . $id);
    }

    /*
	Function name :thankyou()
	Parameter :none
	Return : none
	Use : When user confirm equity create then he/she can see thank you page
	*/

    function thankyou($user_id = '', $equity_id = 0)
    {
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;


        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity = $get_equity_user_detail[0];


        if ($user_id <= 0) $user_id = $equity['user_id'];
        $user_detail = $this->account_model->GetAllUsers($user_id);
        $user_detail = $user_detail[0];
        $data['email'] = $equity['email'];
        $data['user_email'] = $user_detail['email'];
        $company_name = $equity['company_name'];
        $equity_url = $equity['equity_url'];
        if ($company_name == '') $company_name = 'Untitled';
        $user_name = $equity['user_name'] . " " . $equity['last_name'];
        $invite_data_msg = sprintf(INVITE_MSGS, $user_name, $company_name, $site_setting['site_name']);
        $meta = meta_setting();

        $data['equity_url'] = $equity_url;
        $data['user_name'] = $user_name;
        $data['company_name'] = $company_name;
        $data['site_name'] = $site_setting['site_name'];
        $data['equity_id'] = $equity_id;


        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/submit_thankyou', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }


    /*
	Function name :GetOneCurrencySymbol()
	Parameter :none
	Return : none
	Use : get one currency symbol using ajax for onchange dropdown.
	*/
    function GetOneCurrencySymbol()
    {
        $curreny_code_id = $_POST['currency_code'];
        $this->db->where('currency_code_id', $curreny_code_id);
        $query = $this->db->get('currency_code');

        $curreny_id = $query->row_array();
        echo json_encode($curreny_id['currency_symbol']);
    }

    /*
	Function name :confirm_invite()
	Parameter :id , type
	Return : none
	Use : Confirm invitation of user when is send by project owner from step3
	*/
    function confirm_invite($code = 0)
    {
        $equity_cnt = $this->db->query("select cp.company_id,cp.company_url,i.email,i.id,i.user_id,i.code from invite_members as i inner join company_profile as cp on i.company_id=cp.company_id where i.code='" . $code . "'");

        if ($equity_cnt->num_rows() > 0) {
            $data = $equity_cnt->row();
            $this->load->helper('cookie');
            $email = $data->email;

            if ($data->company_url != '') {
                $redirct = 'start_equity/invite_thankyou/' . $data->company_url . '/' . $data->company_id;
            } else {
                $redirct = 'start_equity/invite_thankyou/0/' . $data->company_id;
            }
            // check user register or not
            $user_data = array(
                'email' => $email
            );
            $query = $this->db->get_where('user', $user_data);

            if ($query->num_rows() > 0) {
                $chk = $query->row_array();
                $invite_user_id = $chk['user_id'];

                $sql = "update invite_members set status= 1 ,invite_user_id=" . $invite_user_id . " ,code='' where code='" . $code . "'";
                $this->db->query($sql);
                $sql = "update equity_team_member set user_id=" . $invite_user_id . "  where invited_member_id='" . $data->id . "'";
                $this->db->query($sql);
                // logout
                // $this->session->sess_destroy();
                // $this->session->unset_userdata(array('user_id' => '', 'user_name' => '', 'last_name' => '', 'email' => ''));
                // login
                if ($chk['active'] == '1') {
                    // $data_team = array(
                    //     'user_id' => $chk['user_id'],
                    //     'user_name' => $chk['user_name'],
                    //     'last_name' => $chk['last_name'],
                    //     'email' => $chk['email'],
                    // );
                    // $data1 = array(
                    //     'user_id' => $chk['user_id'],
                    //     'login_date_time' => date('Y-m-d H:i:s'),
                    //     'login_ip' => $_SERVER['REMOTE_ADDR']
                    // );
                    // $this->db->insert('user_login', $data1);
                    // $this->session->set_userdata($data_team);
                    project_activity_feedback('team_member_added', $chk['user_id'], '', 0, array('company_id' => $data->company_id));

                }

            } else {
                // $this->session->sess_destroy();
                $this->load->library('encrypt');
                $add = array(
                    'name' => 'equity_member',
                    'value' => $this->encrypt->encode($data->code),
                    'expire' => time() + 3600,
                    'domain' => '',
                    'path' => '/',
                    'prefix' => '',
                );
                set_cookie($add);
            }
            redirect($redirct);
            // redirect($redirct);
        }
        redirect('home');
    }

    /*
    Function name :invite_thankyou()
    Parameter :none
    Return : none
    Use : When user confirm invitation then he/she can see thank you page
    */

    function invite_thankyou($company_url = '', $equity_id = 0)
    {
        $site_setting = site_setting();
        $taxonomy_setting = taxonomy_setting();
        // $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        // $equity = $get_equity_user_detail[0];
        $this->db->select("company_profile.company_name, user.user_id, user.user_name, user.last_name, user.email, user.user_website, user.profile_slug, user.user_occupation, company_profile.company_url");
        $this->db->from('company_profile');
        $this->db->join('user', 'user.user_id=company_profile.user_id','left');
        $this->db->where('company_profile.company_id', $equity_id);
        $equity = $this->db->get()->row_array();

        $user_id = $equity['user_id'];
        $user_detail = $this->account_model->GetAllUsers($user_id);
        $user_detail = $user_detail[0];
        $data['email'] = $equity['email'];
        $data['user_email'] = $user_detail['email'];
        $company_name = $equity['company_name'];
        $data['equity_url'] = '';
        // $equity_url = $equity['equity_url'];
        if ($company_name == '') $company_name = 'Untitled';
        $user_name = $equity['user_name'] . " " . $equity['last_name'];
        $invite_data_msg = sprintf(INVITE_MSGS, $user_name, $company_name, $site_setting['site_name']);
        $meta = meta_setting();
        $data['site_setting'] = $site_setting;
        // $data['equity_url'] = $equity_url;
        $data['user_name'] = $user_name;
        $data['company_name'] = SecureShowData($company_name);
        $data['site_name'] = $site_setting['site_name'];
        $data['equity_id'] = $equity_id;
        $data['project_url'] = $taxonomy_setting['project_url'];
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'start_equity/thankyou', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }
    function resend_invite()
    {   
            $invite_id=$this->input->post('team_member_id');
            $user_id = check_user_authentication(true);
            $site_setting=site_setting();
            $chech_id_array = array("id" => $invite_id);
            $invite_data = $this->startequity_model->getTableData('invite_members', $chech_id_array);
            $invite_data=$invite_data[0];
            if($invite_data['status'] == 1) {
                $data["msg"] = INVITATION_RESEND_FAILED;
                $data["error_mg"] = true;
                echo json_encode($data);
                die;
            }
            $company_id=$invite_data['company_id'];
            $chech_id_array = array("company_id" => $company_id);
            $company_data = $this->startequity_model->getTableData('company_profile', $chech_id_array);
            $company = $company_data[0];
          
            
            $company_url = $company['company_url'];
            $company_name = SecureShowData($company['company_name']);
            $taxonomy_setting = taxonomy_setting();
            $company_url = $taxonomy_setting['company_url'];
            $company_page_link = site_url($company_url . '/' . $company_url);
            $equity_title_anchor = '<a href="' . $company_page_link . '">' . SecureShowData($company_name) . '</a>';
            $user_data = UserData($company['user_id']);
            $company_owner_name = $user_data[0]['user_name'] . ' ' . $user_data[0]['last_name'];


            $company_owner_page_link = site_url('user/' . $user_data[0]['profile_slug']);
            $company_owner_title_anchor = '<a href="' . $company_owner_page_link . '">' . $company_owner_name . '</a>';

            $email_to = $email =$invite_data['email'];
            $code=$invite_data['code'];
            $visible_profile=$invite_data['visible_profile'];
            $visible_admin=$invite_data['admin'];
            $team_member_name= $invite_data['team_member_name'];
             $team_member_type= $invite_data['team_member_type'];
            $login_link = '<a href="' . site_url('start_equity/confirm_invite/' . $code) . '">' . site_url('start_equity/confirm_invite/' . $code) . '</a>';


            $site_name = $site_setting['site_name'];

            $project_name = $taxonomy_setting['project_name'];
            if (intval($visible_profile) == 1) $visible_profile = "Yes";
            else $visible_profile = "No";
            if (intval($visible_admin) == 1) $visible_admin = "Yes";
            else $visible_admin = "No";
            $language_id=GetUserLangCode();
            $email_template = $this->db->query("select * from `email_template` where task='Member Invitation' and language_id=".$language_id);
            $email_temp = $email_template->row();
            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_subject = $email_temp->subject;
            $email_subject = str_replace('{site_name}', $site_name, $email_subject);
            $email_subject = str_replace('{project_name}', $project_name, $email_subject);
            $email_message = $email_temp->message;

            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $team_member_name, $email_message);
            $email_message = str_replace('{access_status}', $visible_profile, $email_message);
            $email_message = str_replace('{visible_admin}', $visible_admin, $email_message);
            $email_message = str_replace('{equity_owner_name}', $company_owner_title_anchor, $email_message);
            $email_message = str_replace('{project_name}', $project_name, $email_message);
            $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
            $email_message = str_replace('{user_role}', $team_member_type, $email_message);
            $email_message = str_replace('{login_link}', $login_link, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);


             $str = $email_message;

            email_send($email_address_from, $email_address_reply, $email, $email_subject, $str);
            $data["msg"] = INVITATION_RESEND_SUCCESSFULLY;
            $data["error_mg"] = false;
            echo json_encode($data);
            die;

          
    }
    function equity_update_rights(){
       
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $invite_id = SecurePostData($this->input->post('invite_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $chech_id_array = array("invited_member_id" => $invite_id,'equity_id'=>$equity_id);
        $team_data = $this->startequity_model->getTableData('equity_team_member', $chech_id_array);
         $invite_id_array = array("id" => $invite_id);
         $invite_data = $this->startequity_model->getTableData('invite_members', $invite_id_array);
         $invite_data =$invite_data[0];
        if($team_data)
        {
            $team = $team_data[0];
            if($team['edit_right']!=$this->input->post('edit_right')){
               $data_array = array('invited_member_id' => $invite_id, 
                                    'user_id'=>$invite_data['invite_user_id'], 
                                    'company_id' => $invite_data['company_id'],
                                    'equity_id'=>$equity_id,
                                    'edit_right'=>$this->input->post('edit_right')
                                );
            $this->startequity_model->AddInsertUpdateTable('equity_team_member', 'id', $team['id'], $data_array); 
            }else{
                return false;
            }

        }else{
            $data_array = array('invited_member_id' => $invite_id, 'user_id'=>$invite_data['invite_user_id'], 'company_id' => $invite_data['company_id'],'equity_id'=>$equity_id, 'edit_right'=>$this->input->post('edit_right'));
            $this->startequity_model->AddInsertUpdateTable('equity_team_member', '', '', $data_array); 
        }
        $data["msg"] = RECORD_UPDATED_SUCCESS;
            $data["error"] = false;
            echo json_encode($data);
            die;
        


    }
      /*
    Function name :create_step1_cover_photo()
    Parameter :id 
    Return : Image name
    Use : Company Comapny cover photo upload using ajax;
    */
    function create_step1_cover_photo($id = null)
    {


        $site_setting = site_setting();
        $this->load->library('form_validation');
        $data = array();
        $data["msg"]["error"] = '';
        $data["msg"]["success"] = '';
        $data["redirect"]["url"] = '';
        $data["image"]["path"] = '';

        if ($this->session->userdata('user_id') == '') {
            $data["redirect"]["url"] = 'home/login';
        } else if ($id == null || $id == '' || $id == '0') {
            $data["redirect"]["url"] = "start_equity/create_prestep";
        } else {


            $_FILES['userfile']['name'] = $_FILES['file2']['name'];
            $_FILES['userfile']['type'] = $_FILES['file2']['type'];
            $_FILES['userfile']['tmp_name'] = $_FILES['file2']['tmp_name'];
            $image_info = getimagesize($_FILES['file2']['tmp_name']);
            $image_width = $image_info[0];
            $image_height = $image_info[1];
            $_FILES['userfile']['error'] = $_FILES['file2']['error'];
            $_FILES['userfile']['size'] = $_FILES['file2']['size'];
            $_FILES['userfile']['max_width'] = $image_width;
            $_FILES['userfile']['max_height'] = $image_height;
            // image validation
            $image_settings = get_image_setting_data();
            if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif") {
                $data["msg"]["error"] = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
            } else if ($_FILES["userfile"]["size"] >  $image_settings['upload_limit']*1000000) {
                $data["msg"]["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);
             } else if ($_FILES['userfile']['max_width'] <= 599) {
                        $data["msg"]["error"] = IMAGE_MUST_BE_GREATER_THAN;
             } else if ($_FILES['userfile']['max_height'] <= 299) {
                        $data["msg"]["error"] = IMAGE_MUST_BE_GREATER_THAN;
            } else {

                $files = $_FILES;
                $base_path = $this->config->slash_item('base_path');
                $rand = rand(0, 100000);
              
                  
                $path_parts = pathinfo($_FILES['file2']['name']);
                $date = new DateTime();
                
                $file_extention = $path_parts['extension'];
                $new_img = $rand .'-company-cover-photo-'.$date->getTimestamp().'.'.$file_extention;
                move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/company/cover_photo/" . $new_img);
                $imagename = $new_img;
                $data_gallery = array(

                    'company_cover_photo' => $imagename
                );
                // save data
              
                $chech_id_array = array("equity_id" => $id);
                $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
                $equity = $equity_data[0];

                if($equity['company_id'] == '' || $equity['company_id'] == 0)
                {
                    $this->startequity_model->AddInsertUpdateTable('company_profile', '','', $data_gallery);
                    $company_id = $this->db->insert_id();
                    $data_equity = array('company_id' => $company_id);
                     $new_logo = $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id',$id, $data_equity);
                      project_deletecache($id);
                }
                else
                {
                     $new_logo = $this->startequity_model->AddInsertUpdateTable('company_profile', 'company_id', $equity['company_id'], $data_gallery);
                }

                if ($new_logo) {
                    $data["image"]["path"] = base_url() . "upload/company/cover_photo/" . $imagename;
                    $data["msg"]["success"] = 'success';
                } else {
                    $data["msg"]["error"] = THERE_IS_SOME_PROBLEM_SITE_TRY_AFTER_SOMETIME;
                }
            }
            echo json_encode($data);


        }

    }
    function delete_comapny()
    {
      
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $company_id = SecurePostData($this->input->post('company_id'));
        $chech_id_array = array("company_id" => $company_id, 'status !='=> 0);
        $equity_data = $this->startequity_model->getTableData('equity', $chech_id_array);
        if($equity_data){
            $data["msg"] = CAN_NOT_DELETE_THIS_COMPANY_HAVE_LIVE_OR_SUCESS_EQUITIES;
            $data["error"] = true;
            echo json_encode($data);
            die;
        }else {
          $this->db->where('company_id' , $company_id);
          $this->db->delete('company_profile');


          $this->db->where('company_id' , $company_id);
          $this->db->update('equity',array('company_id'=>''));

           $data["msg"] = COMPANY_DELETE_SUCESSFULLY;
        $data["error"] = '';
         $data["company_id"] = $company_id;
         echo json_encode($data);
         die;
        }
        

       
        
    }
}
?>
