<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Repayment extends ROCKERS_Controller
{
    function __construct()
    {
        parent::__construct();
        
           $this->load->model('home_model');
        $this->load->model('repayment_model');
        $this->load->model('equity_model');
        $this->load->model('startequity_model');
         $this->load->model('investment_step_model');
        $this->load->helper('payment');
        

    }

    /*
    Function name :list_repayment()
    Parameter :$equity_url_title(equity url title),$msg (message string or equity id)
    Return : none
    Use : to show the equity detail
        this is used to show the equity information or details on equity detail page
    */

    function list_repayment($equity_id = '')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $user_id = check_user_authentication(false);
        $data['equity_id'] = $equity_id;
        $data['site_setting'] = site_setting();
        $get_equity_user_detail = $this->equity_model->GetAllEquities($user_id = 0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user',

        ), $limit = 10, $order = array(
            'equity_id' => 'desc'
        )); // store in cache

        $data['equity_detail'] = $get_equity_user_detail[0];

         $data['rePayments'] = $this->repayment_model->getAllRepayments($equity_id);
        
         $total_paid=0;
         //paid payment
         $rePaymentsPaid = $this->repayment_model->getDuePaidRePayemnt($equity_id,"'SUCCESS'");        
         
         $total_paid=0;
         if( $rePaymentsPaid){
            $total_paid= $rePaymentsPaid['total'];
         }
         $data['total_paid'] =$total_paid;

         //due payment
         $rePaymentsDue = $this->repayment_model->getDuePaidRePayemnt($equity_id,"'PROCESS','PENDING'");        
         $total_due=0;
         if( $rePaymentsDue){
            $total_due= $rePaymentsDue['total'];;
         }
         $data['total_due'] =$total_due;
       
         $return_investment_interest = $data['equity_detail']['return_investment_interest'];
         $return_payment_frequency = $data['equity_detail']['return_payment_frequency'];
        $return_term_length = $data['equity_detail']['return_term_length'];
        $irr_percentage = $data['equity_detail']['irr_percentage'];
        $amount_get= $data['equity_detail']['amount_get'];
        if($return_term_length>0){

        $data['next_payment'] = (($return_investment_interest*$amount_get/100)/$return_term_length);  
        }else{
            $data['next_payment'] =0;
        }
        $data['next_due_date'] = $this->repayment_model->calculateNextRepaymentDate($equity_id);
        
        
      
         $this->load->view(THEME_LOCATION . 'equity/repayment-tab', $data);

      
    
        //$this->output->enable_profiler(TRUE);
    }

     function add_repayment($equity_id='')
    {
         $user_id=check_user_authentication(true);
         $data1['equity_id'] = SecurePostData($this->input->post('equity_id'));
        
        $this->form_validation->set_rules('amount', AMOUNT, 'required');
        $this->form_validation->set_rules('period_start_date', PERIOD_START_DATE, 'required');
        $this->form_validation->set_rules('period_end_date', PERIOD_END_DATE, 'required');
        $this->form_validation->set_rules('payment_desc', PAYMENT_DESC, 'required');
        $this->form_validation->set_rules('payment_type', PAYMENT_TYPE, 'required');

       
        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';

        if ($this->form_validation->run() == FALSE ) {
            if (validation_errors()) {
                $data["msg"]['error'] = validation_errors();
            } else {
                $data["msg"]['error'] = "";
            }
           
        } else {
            $datetime = date('Y-m-d H:i:s');
            $period_start_date=date('Y-m-d H:i:s',strtotime($this->input->post('period_start_date')));
            $period_end_date=date('Y-m-d H:i:s',strtotime($this->input->post('period_end_date')));

            $repayment_array = array( 
                'equity_id' => $equity_id,
                'amount'=>SecurePostData($this->input->post('amount')),
                'period_start_date'=>SecurePostData($period_start_date),
                'period_end_date'=>SecurePostData($period_end_date),
                'payment_desc'=>SecurePostData($this->input->post('payment_desc')),
                'payment_type'=>SecurePostData($this->input->post('payment_type')),
                'created_at'=>$datetime,
                                       
        );

           $success= $this->startequity_model->AddInsertUpdateTable('repayments',"","", $repayment_array);
            $data["msg"]['success'] = true;
             $data["msg"]['id'] = $success;
            
        }
        echo json_encode($data);

    }
    function payment($rePaymentId='')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $user_id = check_user_authentication(false);
        
       $results = $this->repayment_model->RepaymentHistory($rePaymentId, 0, 0, '', $join = array(
            'equity',
        ), $limit, $order = array(
            'id' => 'desc'
        ), '', '');

     
        foreach($results as $res)
        $data['transactions'] =$res;       
        $this->load->view(THEME_LOCATION . 'equity/payment-option-tab', $data);
    }


    /*
    Function name :UserAcknowledge()
    Parameter :$type
    Return : json data
    Use : upload zip,pdf document
    */

    function UserAcknowledge($type = 0)
    {

        $user_id = check_user_authentication(false);
        $this->load->library('form_validation');

        $data = array();
        $data["error"] = '';
        $data["success"] = '';
        $check = '';

        $site_setting = site_setting();

        if ($_POST) 
        {

                    $equity_id = SecurePostData($this->input->post('equity_id'));
                    $_FILES['userfile']['name'] = $_FILES['file1']['name'];
                    $_FILES['userfile']['type'] = $_FILES['file1']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['file1']['tmp_name'];
                    $_FILES['userfile']['error'] = $_FILES['file1']['error'];
                    $_FILES['userfile']['size'] = $_FILES['file1']['size'];
                     $image_settings = get_image_setting_data();
                    //file validation
                    if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif " and $_FILES["userfile"]["type"] != "application/pdf" and $_FILES["userfile"]["type"] != "application/zip") {
                        //if ($_FILES["userfile"]["type"] != "application/zip" and $_FILES["userfile"]["type"] != "application/pdf" ) {

                        $data["error"] = PLEASE_UPLOAD_DOC_IMAGE_ZIP_PDF;
                        //PLEASE_UPLOAD_ZIP_OR_PDF_FILE
                    } else if ($_FILES["userfile"]["size"] >  $image_settings['upload_limit']*1000000) {

                        $data["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);

                    } else {

                        $filename = $_FILES['file1']['name'];
                        $base_path = $this->config->slash_item('base_path');

                        //move file into folder

                        $rand = rand(0, 100000);
                       
                        $path_parts = pathinfo($_FILES['file1']['name']);
                        $date = new DateTime();
                      
                        $file_extention = $path_parts['extension'];
                        $new_file = $rand .'-investor-ack-'.$date->getTimestamp().'.'.$file_extention;

                        move_uploaded_file($_FILES["userfile"]["tmp_name"], $base_path . "upload/acknowledge/" . $new_file);
                        if ($filename) {

                            $data["success"] = 'File Uploaded Successfully.';
                            $data["file_name"] = $new_file;

                        } else {

                            $data["error"] = THERE_IS_SOME_PROBLEM_SITE_TRY_AFTER_SOMETIME;
                        }
                    }
        }

           echo json_encode($data);
     }              

 /*
    Function name :paypal_pay()
    Parameter :gateway_id
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
    // //---------paypal wallet----------//////
    /**
     * @param $gateway_id
     */
    function offline_pay()
    {
       // echo $transaction_id;die;
        $user_id=$this->session->userdata('user_id');
        $data = array();
        $data["error"] = '';
        $data["success"] = '';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $reciept = SecurePostData($this->input->post('payment_reciept'));
          $notes = SecurePostData($this->input->post('notes'));
         $transaction_id = SecurePostData($this->input->post('repayment_id'));
        $gateway_id = SecurePostData($this->input->post('gateway_id'));
        if( $reciept=="" or $notes=="")
        {
            $data['error'] = 'Please upload payment reciept. or Add notes.';
            echo json_encode($data);die;
        }
        if( $notes=="")
        {
            //$data['error'] = 'Notes is Required.';
            //echo json_encode($data);die;
        }
        $results = $this->repayment_model->RepaymentHistory($transaction_id, 0, 0, '', $join = array(
            'equity',
        ), 1, $order = array(
            'id' => 'desc'
        ), '', '');
     
        foreach($results as $res)
        $paymentData=$res;

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];
        
        $total_amount = $paymentData['amount'];
        $txnid = 'RE' . randomNumber(12);
         try
        {
            $data = array(
                    'in_process_id' => $in_process_id,
                    'payment_method' => 'Offline',
                    'user_id' => $user_id,
                    'txnid' => $txnid,
                     'reciept' => $reciept,
                      'notes' => $notes,
                    'equity_id' => $equity_id,
                    'transaction_status' =>'PROCESS'
                );

                $temp=$this->status_approveByPayment($data);
                 $data["success"] =DONATION_DONE_SUCCESSFULLY_HOME ;
       } catch (Exception $e)
         {
            
             $error = $e->getMessage() . "Please try again.\n\n\nThank You.";
             $data['error'] = $error;
                        //$this->load->view('default/paypal_error', $data);
                        //die();
        }        
                
         echo json_encode($data);
    }    
      /*
    Function name :paypal_pay()
    Parameter :gateway_id
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
    // //---------paypal wallet----------//////
    /**
     * @param $gateway_id
     */
    function paypal_pay($transaction_id,$gateway_id=2)
    {
       // echo $transaction_id;die;
        $user_id=$this->session->userdata('user_id');
        if($transaction_id=="")redirect('/');

        $results = $this->repayment_model->RepaymentHistory($transaction_id, 0, 0, '', $join = array(
            'equity',
        ), 1, $order = array(
            'id' => 'desc'
        ), '', '');
     
        foreach($results as $res)
        $paymentData=$res;

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];
        
        $total_amount = $paymentData['amount'];

        $where_user = array('user_id' => $user_id);
        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);

        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity_data = $get_equity_user_detail[0];

        $dataGatewayDetails=paymentGatewayDetails();
        $site_setting = site_setting();


        $amt = $total_amount;
        $num = 'WL' . randomNumber(12);
        $this->load->library('paypal_lib');
        $pays = $dataGatewayDetails[$gateway_id];

        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }

        $Paypal_Email = $gateway_array['paypal_email'];
        $Paypal_Status = $gateway_array['site_status'];
        $gateway_fees = $gateway_array['transaction_fees'];
        $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        if ($Paypal_Status == 'sandbox') {
            $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        }
        if ($Paypal_Status == 'live') {
            $Paypal_Url = 'https://www.paypal.com/cgi-bin/webscri';
        }
       
        if ($equity_data['equity_currency_code'] != '') {
            $currency_code = $equity_data['equity_currency_code'];
        } elseif ($site_setting['currency_code'] != '') {
            $currency_code = $site_setting['currency_code'];
        } else {
            $currency_code = 'USD';
        }
        $this->paypal_lib->add_field('currency_code', $currency_code);
        // $this->paypal_lib->add_field('feesPayer', 'SENDER');

        $this->paypal_lib->add_field('business', $Paypal_Email);
        $this->paypal_lib->add_field('return', site_url('repayment/paypal_paySuccess/'));
        $this->paypal_lib->add_field('cancel_return', site_url('repayment/paypal_payCancel/'));
        $this->paypal_lib->add_field('notify_url', site_url('repayment/paypal_payIpn/')); // <-- IPN url
        $this->paypal_lib->add_field('custom', str_replace(',', '', $amt) . '#' . $gateway_id . '#' .  $user_id . '#' . $equity_id . '#' . str_replace(',', '', $amt) . '#' . $in_process_id ); // <-- Verify return
        $this->paypal_lib->paypal_url = $Paypal_Url;
        $this->paypal_lib->add_field('item_name', 'Repayment on  ' . $site_setting['site_name'] . ' by ' . $user_data['user_name'] . ' ' . $user_data['last_name']);
        $this->paypal_lib->add_field('item_number', $num);
        $this->paypal_lib->add_field('amount', str_replace(',', '', $amt));
        $this->paypal_lib->button('Make Donation');
        $data['paypal_form'] = $this->paypal_lib->paypal_auto_form();
    }
 /* Function name :paypal_payCancel()
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
  
    function paypal_payCancel()
    {
          redirect('/');
    }
     /* Function name :paypal_payIpn()
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
  
    function paypal_payIpn()
    {
          $vals = array();
        $strtemp = '';

        foreach ($_POST as $key => $value) {
            $vals[$key] = $value;
            $strtemp .= $key . "=" . $value . ",";
        }
        log_message('error', "IPN DATA:" . $strtemp);
    }
    /* Function name :paypal_paySuccess()
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
    
    function paypal_paySuccess()
    {
        $vals = array();
        $strtemp = '';
        $gateway_id=2;
        $this->load->library('paypal_lib');
        $dataGatewayDetails=paymentGatewayDetails();
        $pays = $dataGatewayDetails[$gateway_id];

        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }

        $Paypal_Email = $gateway_array['paypal_email'];
        $Paypal_Status = $gateway_array['site_status'];
        $gateway_fees = $gateway_array['transaction_fees'];
        $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        if ($Paypal_Status == 'sandbox') {
            $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        }
        if ($Paypal_Status == 'live') {
            $Paypal_Url = 'https://www.paypal.com/cgi-bin/webscri';
        }
        $this->paypal_lib->paypal_url = $Paypal_Url;
        $validate_ipn=$this->paypal_lib->validate_ipn();
       // print_r( $validate_ipn);die;


        foreach ($_POST as $key => $value) {
            $vals[$key] = $value;
            $strtemp .= $key . "=" . $value . ",";
        }
        
        log_message('error', "Success DATA:" . $strtemp);
        if (isset($_POST['custom'])) {
            $status = $_POST['payment_status'];
            $custom = explode('#', $_POST['custom']);
            $gateway_id = $custom[1];
            $custom_amt = $custom[0];
            $pay_gross = $custom[0];
            $payee_email = $_POST['payer_email'];
            $payer_status = $_POST['payer_status'];
            $txnid = $_POST['txn_id'];
            $date = date('Y-m-d H:i:s');
            $ip = $_SERVER['REMOTE_ADDR'];
            $user_id = $custom[2];
            $project_id = $custom[3];
            $in_process_id = $custom[5];
            $donar_amount = $custom[0];

            $chk_transaction_id = $this->check_unique_transaction($txnid);
            if ((strtolower($status) == 'completed' or strtolower($status) == 'pending') && $pay_gross >= $custom_amt && $chk_transaction_id == 0)
             {
              
                $data = array(
                    'in_process_id' => $in_process_id,
                    'payment_method' => 'Paypal',
                    'user_id' => $user_id,
                    'txnid' => $txnid,
                    'equity_id' => $project_id,
                    'transaction_status' =>'SUCCESS'
                );

                $temp=$this->status_approveByPayment($data);
            } 

            redirect('equity/dashboard/'. $project_id."#repayment-tab");
        }

        //redirect('home/index/' . $msg);
         redirect('/');
    }

    /*
    Function name :check_unique_transaction()
    Parameter : $txn_id
    Return : none
    Use :check uniue transactionID
    */

    function wepay_pay($transaction_id,$gateway_id=4)
    {
       // echo $transaction_id;die;
        $user_id=$this->session->userdata('user_id');
        if($transaction_id=="")redirect('/');

        $results = $this->repayment_model->RepaymentHistory($transaction_id, 0, 0, '', $join = array(
            'equity',
        ), 1, $order = array(
            'id' => 'desc'
        ), '', '');
     
        foreach($results as $res)
        $paymentData=$res;

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];$id = $paymentData['id'];

        $total_amount = $paymentData['amount'];

        $where_user = array('user_id' => $user_id);
        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);

        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity_data = $get_equity_user_detail[0];

        $dataGatewayDetails=paymentGatewayDetails();
        $site_setting = site_setting();


        $amt = $total_amount;
        $num = 'WL' . randomNumber(12);
       
        $pays = $dataGatewayDetails[$gateway_id];

        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }
        if ($equity_data['equity_currency_code'] != '') {
            $currency_code = $equity_data['equity_currency_code'];
        } elseif ($site_setting['currency_code'] != '') {
            $currency_code = $site_setting['currency_code'];
        } else {
            $currency_code = 'USD';
        }
          $data['error'] = '';
        try
        {
            $wepay_client_id = $gateway_array['wepay_client_id'];
            $wepay_client_secret = $gateway_array['wepay_client_secret'];
            $wepay_clinet_access_token = $gateway_array['wepay_clinet_access_token'];
             $wepay_account_id = $gateway_array['wepay_account_id'];
              $wepay_status = $gateway_array['wepay_status'];
              $wepay_fees_payer = $gateway_array['wepay_fees_payer'];
               if(intval($wepay_fees_payer)==0)
                {
                    $fees_payer='payee';
                }else
                {
                    $fees_payer='payer';
                }

            $this->load->library('wepay',$wepay_clinet_access_token);
            if($wepay_status=="test")
            { 

                $wepay_url="https://stage.wepayapi.com/v2/";
                Wepay::useStaging($wepay_client_id,$wepay_client_secret);
                 
            }
            else
            {   
                $wepay_url="https://wepayapi.com/v2/";
                Wepay::useProduction($wepay_client_id,$wepay_client_secret);
            }
                 $wepay = new WePay($wepay_clinet_access_token);
                $last_transaction_id=$transaction_id;
                $donar_amount=$total_amount;
                $ip = $_SERVER['REMOTE_ADDR'];
                $short_description="";
                $long_description="";
                $date_time = date("Y-m-d H:i:s");
                $redirect_uri = site_url('repayment/wepay_paySuccess/'.$last_transaction_id);
                $ipn_uri = site_url('repayment/wepay_payIpn/'.$last_transaction_id);
                $user_name=$user_data['user_name'] . ' ' . $user_data['last_name'];
                if($currency_code=="CAD")
                {
                    $country="CA";
                }else 
                {
                     $country="US";
                }
                $address=array("country"=>$country);
                $prefill_info=array("email"=>$user_data['email'] ,"name"=>$user_name,"address"=>$address);
                $theme_id=time();
                $name="API Theme for API App: My Sample Application";
                $primary_color="FFFFFF";
                $secondary_color="333333";
                $background_color="F1F1F1";
                $button_color="7cb333";$admin_amount=0;
                $wepay_data=array('account_id' => $wepay_account_id, // ID of the account that you want the money to go to
                                    'amount' => $donar_amount, // dollar amount you want to charge the user
                                    'short_description' => $short_description, // a short description of what the payment is for
                                     'long_description' => $long_description, // a short description of what the payment is for
                                    'type' => "donation",
                                    'fee'   => array (
                                          'app_fee'=> $admin_amount,
                                          'fee_payer' => $fees_payer
                                     ),
                                     'hosted_checkout'   => array ('redirect_uri' => $redirect_uri
                                     ,'mode'=>'iframe',"theme_object" => array (
                                          'name'=> $name,
                                          'primary_color' => $primary_color,
                                          'secondary_color' => $secondary_color,
                                          'background_color' => $background_color,
                                          'button_color' => $button_color
                                     ),'prefill_info'=>$prefill_info),
                                    'currency'          => $currency_code,
                                    'callback_uri'=>$ipn_uri
                                    );
                                    //print_r($wepay_data);die;
                                    
                                   
                                    $checkout = $wepay->request('/checkout/create', array(
                                    'account_id' => $wepay_account_id, // ID of the account that you want the money to go to
                                    'amount' => $donar_amount, // dollar amount you want to charge the user
                                    'short_description' => $short_description, // a short description of what the payment is for
                                    'type' => "donation",
                                    'fee'   => array (
                                          'app_fee'=> $admin_amount,
                                          'fee_payer' => $fees_payer
                                     ),
                                     'hosted_checkout'   => array ('redirect_uri' => $redirect_uri
                                     ,'mode'=>'iframe',"theme_object" => array (
                                          'name'=> $name,
                                          'primary_color' => $primary_color,
                                          'secondary_color' => $secondary_color,
                                          'background_color' => $background_color,
                                          'button_color' => $button_color
                                     ),'prefill_info'=>$prefill_info),
                                    'currency'          =>$currency_code,
                                    'callback_uri'=>$ipn_uri
                                    )); 

                $page=$checkout->hosted_checkout->checkout_uri;
                $data['page'] = $page;

        }
        catch (WePayException $e)
         {
             log_message('error','Wepay Error Wepay_payment 330:'.$e->getMessage());
             $error = $e->getMessage() . "Please try again.\n\n\nThank You.";
             $data['error'] = $error;
                        //$this->load->view('default/paypal_error', $data);
                        //die();
        }
           
         $data['site_setting'] = site_setting();
          $meta = meta_setting();
      

         $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
          $this->load->helper('url');
        $this->load->library('user_agent');
        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'payment/wepay', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();

       
    }
    /*
    Function name :wepay_paySuccess()
    Parameter : $txn_id
    Return : none
    Use :check uniue transactionID
    */

    function wepay_paySuccess($transaction_id)
    {
        $checkout_id =0;
        if(isset($_GET['checkout_id']))$checkout_id = $_GET['checkout_id'];
        log_message('error', "1 checkout_id:" . $checkout_id.",time".date("Y-m-d H:m:s"));
         
        $user_id=$this->session->userdata('user_id');
        if($transaction_id=="")redirect('/');

        $results = $this->repayment_model->RepaymentHistory($transaction_id, 0, 0, '', $join = array(
            'equity',
        ), 1, $order = array(
            'id' => 'desc'
        ), '', '');
     
        foreach($results as $res)
        $paymentData=$res;

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];
        $gateway_id = 4; $id = $paymentData['id'];

     
        $total_amount =$paymentData['amount'];

        $where_user = array('user_id' => $user_id);
        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);

        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity_data = $get_equity_user_detail[0];

        $dataGatewayDetails=paymentGatewayDetails();
        $site_setting = site_setting();


        $amt = $total_amount;
        $num = 'WL' . randomNumber(12);
       
        $pays = $dataGatewayDetails[$gateway_id];

        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }
        if ($equity_data['equity_currency_code'] != '') {
            $currency_code = $equity_data['equity_currency_code'];
        } elseif ($site_setting['currency_code'] != '') {
            $currency_code = $site_setting['currency_code'];
        } else {
            $currency_code = 'USD';
        }
          $data['error'] = '';
        try
        {

             //log_message('error', "transaction query:" . "select * from temp_preapprove where temp_pre_id='".$transaction_id."'".",time".date("Y-m-d H:m:s"));
            //redirect('home/index/done');
            $txnid=$checkout_id;
            $get_temp_transaction=$this->db->query("select * from repayments where transaction_key='".$checkout_id."'");
            $chk_transaction=$get_temp_transaction->num_rows();
            //echo $checkout_id; 
            if($chk_transaction<=0)
            {
                    $wepay_client_id = $gateway_array['wepay_client_id'];
                    $wepay_client_secret = $gateway_array['wepay_client_secret'];
                    $wepay_clinet_access_token = $gateway_array['wepay_clinet_access_token'];
                     $wepay_account_id = $gateway_array['wepay_account_id'];
                      $wepay_status = $gateway_array['wepay_status'];
                      $wepay_fees_payer = $gateway_array['wepay_fees_payer'];
                       if(intval($wepay_fees_payer)==0)
                        {
                            $fees_payer='payee';
                        }else
                        {
                            $fees_payer='payer';
                        }

                    $this->load->library('wepay',$wepay_clinet_access_token);
                    if($wepay_status=="test")
                    { 

                        $wepay_url="https://stage.wepayapi.com/v2/";
                        Wepay::useStaging($wepay_client_id,$wepay_client_secret);
                         
                    }
                    else
                    {   
                        $wepay_url="https://wepayapi.com/v2/";
                        Wepay::useProduction($wepay_client_id,$wepay_client_secret);
                    }
                    $wepay = new WePay($wepay_clinet_access_token);
                    $checkout = $wepay->request('checkout',array('checkout_id'=>$checkout_id));

                    $checkout_state = $checkout->state;
                     $trans_status=true;
                    if($checkout_state=='cancelled' or $checkout_state=='expired' or $checkout_state=='failed')
                    {
                        $trans_status=false;
                    }
                     if ($trans_status==true)
                     {
                      
                        $data = array(
                            'in_process_id' => $in_process_id,
                            'payment_method' => 'Wepay',
                            'user_id' => $user_id,
                             'txnid' => $txnid,
                            'equity_id' => $equity_id,
                             'transaction_status' =>'SUCCESS'
                        );

                        $temp=$this->status_approveByPayment($data);
                    } 

                    redirect('equity/dashboard/'. $equity_id."#repayment-tab");
                }    

        }
        catch (WePayException $e)
         {
             log_message('error','Wepay Error Wepay_payment 330:'.$e->getMessage());
             $error = $e->getMessage() . "Please try again.\n\n\nThank You.";
             $data['error'] = $error;
                        //$this->load->view('default/paypal_error', $data);
                        //die();
        }  
        
          $data['site_setting'] = site_setting();
          $meta = meta_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'payment/wepay', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();       
    }
     /* Function name :paypal_payIpn()
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
  
    function wepay_payIpn()
    {
          $vals = array();
        $strtemp = '';

        foreach ($_POST as $key => $value) {
            $vals[$key] = $value;
            $strtemp .= $key . "=" . $value . ",";
        }
        log_message('error', "Wepay IPN DATA:" . $strtemp);
    }

     /*
    Function name :wepay_paySuccess()
    Parameter : $txn_id
    Return : none
    Use :check uniue transactionID
    */

    function stripe_pay($transaction_id,$gateway_id=3)
    {
      // echo $transaction_id;die;
         
        $user_id=$this->session->userdata('user_id');
        if($transaction_id=="")redirect('/');

        $results = $this->repayment_model->RepaymentHistory($transaction_id, 0, 0, '', $join = array(
            'equity',
        ), 1, $order = array(
            'id' => 'desc'
        ), '', '');
     
        foreach($results as $res)
        $paymentData=$res;

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];$id = $paymentData['id'];

        $total_amount = $paymentData['amount'];

        $where_user = array('user_id' => $user_id);
        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);

        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity_data = $get_equity_user_detail[0];

        $dataGatewayDetails=paymentGatewayDetails();
        $site_setting = site_setting();

        $token  = $_POST['stripeToken'];
        $email=$_POST['stripeEmail'];
        $amount=$total_amount;
        $currency= $equity_data['equity_currency_code'];

        

        if(in_array($currency,array('JPY','NZD','BIF','DJF','KRW','PYG','VND','XAF','XPF','CLP','GNF','KMF','MGA','RWF','VUV','XOF'))){
            $amount = $amount;
           
        } else{
            $amount = $amount*100;
         
        }
        $this->load->library('stripe');                            
        $dat=$this->stripe->charge($token,$email,$amount,$currency);
      //  print_r( $dat);die;
        if($dat['status']=="fail")
        {
            
                $data['site_setting'] = site_setting();
                $meta = meta_setting();
                $data['error']=$dat['message'];
                $this->template->write('meta_title', $meta['title'], TRUE);
                $this->template->write('meta_description', $meta['meta_description'], TRUE);
                $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
              //  $this->template->front_write_view('header', 'common/header', $data, TRUE);
                $this->template->front_write_view('main_content', 'paypal_error', $data, TRUE);
               // $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
                $this->template->render();  
           
        }else
        {
                       $txnid=$dat['message'];
                        $data = array(
                            'in_process_id' => $in_process_id,
                            'payment_method' => 'Stripe',
                            'user_id' => $user_id,
                            'txnid' => $txnid,
                            'equity_id' => $equity_id,
                            'transaction_status' =>'SUCCESS'
                        );

                        $temp=$this->status_approveByPayment($data);
                   

                   redirect('equity/dashboard/'. $equity_id."#repayment-tab");
        }
    }        
/*
    Function name :check_unique_transaction()
    Parameter : $txn_id
    Return : none
    Use :check uniue transactionID
    */

    function check_unique_transaction($txn_id)
    {
            $query = $this->db->query("select * from repayments where transaction_key='" . $txn_id . "'");
            if ($query->num_rows() > 0) {
                return 1;
            }
            return 0;
    }

    /*
    Function name :status_approveByPayment()
    Parameter : $in_process_id
    Return : none
    Use :update status
    */

    function status_approveByPayment($data = array())
    {


            $in_process_id = $data['in_process_id'];
            $user_id = $data['user_id'];
            $transaction_key = $data['txnid'];
            $equity_id = $data['equity_id'];
            $payment_method = $data['payment_method'];
            $transaction_status = $data['transaction_status'];
            if(isset($data['reciept'])) $reciept = $data['reciept'];
            else  $reciept='';
              if(isset($data['notes'])) $notes = $data['notes'];
               else  $notes='';
            $update_id = 7;

            $data_update = array(
                'transaction_key' => $transaction_key,
                'reciept' => $reciept,
                'notes' => $notes,
                 'payment_method' => $payment_method,
                  'transaction_status' => $transaction_status
            );
            admin_activity('approve_acknowledge_contract', $user_id, 0, $equity_id);

            $this->investment_step_model->AddUpdateData('repayments', $data_update, $in_process_id, 'id');
             $this->repaymentEmail($in_process_id);
            return 0;
    }
     /*
    Function name :status_approveByPayment()
    Parameter : $in_process_id
    Return : none
    Use :update status
    */

    function repaymentEmail($transaction_id=0)
    {

        $results = $this->repayment_model->RepaymentHistory($transaction_id, 0, 0, '', $join = array(
            'equity','user'
        ), 1, $order = array(
            'id' => 'desc'
        ), '', '');
     
        foreach($results as $res)
        $paymentData=$res;

        $in_process_id = $paymentData['id']; $user_id = $paymentData['owner_id'];
        $equity_id = $paymentData['equity_id'];$id = $paymentData['id'];$equity_url = $paymentData['equity_url'];
        $total_amount = $paymentData['amount'];
         $transaction_status = $paymentData['transaction_status'];
         $user_details = UserData( $user_id);
        $user_name = $user_details[0]['user_name'].' '.$user_details[0]['last_name'];
        $user_email = $user_details[0]['email'];
         $send_email=false;
         if($transaction_status=='SUCCESS' )
         {
            $send_email=true;
            $template='Repayment DONE SUCCESSFULLY';
            $click_here = '<a href="' . site_url('admin/equity/equity_detail/' . $equity_url) . '">click here</a>';
         }
         if($transaction_status=='PROCESS')
         {
            $send_email=true;
            $template='Offline Repayment DONE SUCCESSFULLY';
             $click_here = '<a href="' . site_url('admin/equity/equity_detail/' . $equity_url) . '">click here</a>';
         }

         if($send_email==true)
         {
            //send email

                    $language_id = GetUserLangCode($user_id);
                    $email_template = $this->db->query("select * from `email_template` where task='".$template."' and language_id=".$language_id);

                    $email_temp = $email_template->row();

                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_subject = $email_temp->subject;
                    $email_message = $email_temp->message;
                    $email_to = $email_address_from;                   
                    $site_setting = site_setting();
                    $site_name = $site_setting['site_name'];
                    $taxonomy_setting = taxonomy_setting();
                    $project_name = $taxonomy_setting['project_name'];
                    $funds = $taxonomy_setting['funds'];

                    $email_subject = str_replace('{site_name}', $site_name, $email_subject);
                    $email_message = str_replace('{investor_name}', $user_name, $email_message);
                    $email_message = str_replace('{funds}', $funds, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);
                    $email_message = str_replace('{click_here}', $click_here, $email_message);

                    $str = $email_message;
                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

         }

    }

}
