<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Investment extends ROCKERS_Controller
{
    /**
     * Constructor method
     */
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('investment_step_model');
        $this->load->model('message_model');
        $this->load->model('equity_model');
         $this->load->model('startequity_model');
          $this->load->model('repayment_model');
         $this->load->model('account_model');
        $this->load->helper('payment');
    }

    function hello_sign_status($equity_id = '', $investor_process_id = '', $hello_sign_id = '') {
        $data['encode_equity_id'] = $equity_id;
        $data['encode_investor_process_id'] = $investor_process_id;
        $user_id = check_user_authentication(false);
        if (!is_numeric($equity_id)) {
            $data['equity_id'] = $equity_id=decrypt($equity_id) ;
        } 
        if (!is_numeric($investor_process_id)) {
            $data['equity_process_id'] = $data['investor_process_id'] = $investor_process_id=decrypt($investor_process_id) ;
        }
        $redirect_url = '';
        $response = false;
        if($user_id && $equity_id && $investor_process_id && $hello_sign_id) {
            $session_key = md5($user_id.$equity_id.$investor_process_id);
            $this->db->where('id', $hello_sign_id);
            $hello_sign = $this->db->get('hello_sign')->row();
            if($hello_sign && $hello_sign->is_complete) {
                $response = true;
                if($this->session->userdata($session_key)) {
                    $this->session->unset_userdata($session_key);
                }
            } else {
                if($this->session->userdata($session_key)) {
                    $time_out = $this->session->userdata($session_key);
                    $current_time = strtotime(date("Y-m-d G:i:s"));
                    if ($time_out < $current_time) {
                        $response = false;
                        $this->session->set_flashdata('hello_sign_error', 'We are facing the technology issue. Please sign contract again.');
                        $redirect_url = base_url('investment/investment_step_contract/'. $data['encode_equity_id'] .'/'. $data['encode_investor_process_id']);
                        $this->session->unset_userdata($session_key);
                    }
                } else {
                    $time_out = strtotime(date("Y-m-d G:i:s", strtotime("+5 minutes")));
                    $this->session->set_userdata($session_key, $time_out);
                }
            }
        }
        $this->output->set_content_type('application/json')->set_output(json_encode(array('response' => $response, 'redirect_url' => $redirect_url)));
    }


    /*
    Function name :investment_step()
    Parameter :$equity_id
    Return : none
    Use : load the page and fetch the data related project_id and user_id
    */

    function hello_sign_callback() {
        // die;
         log_message('error', "ResponseFrom hello_sign_callback:" . json_encode($_REQUEST));

        $response = json_encode($_REQUEST);
        $a = json_decode($response);
        $json = json_decode($a->json);
        $is_complete = $json->signature_request->is_complete;
        $site_setting = site_setting();

        $data['bank_detail'] = $site_setting['bank_detail'];

        if($is_complete) {
            if(isset($json->signature_request->signatures[0]->signature_id) && $json->signature_request->signatures[0]->signature_id) {
                $signature_id = $json->signature_request->signatures[0]->signature_id;
                $status = $json->event->event_type;
                $hello_sign = $this->db->get_where('hello_sign', array('signature_id' => trim($signature_id)))->row();
                if($hello_sign && $hello_sign->is_complete != 1) {
                    $is_complete = ($is_complete) ? 1 : 0;
                    $this->db->where('id', $hello_sign->id);
                    $this->db->update('hello_sign', array('response' => json_encode($a), 'status' => $status, 'is_complete' => $is_complete, 'update_at' => date('Y-m-d H:i:s')));
                    $date = date('YmdGis');
                    $date = (string)$date;
                    $file_name = randomNumber(5).$date.'.pdf';
                    $site_setting = site_setting();
                    $bank_detail = $site_setting['bank_detail'];
                    $equity_investment_process_data['document_name'] = $file_name;
                    $equity_investment_process_data['invest_status_id'] = 4;
                    $equity_investment_process_data['bank_detail'] = $bank_detail;
                    $this->db->where('id', $hello_sign->investor_process_id);
                    $this->db->update('equity_investment_process', $equity_investment_process_data);
                    $equity_id = $hello_sign->equity_id;
                    // $equity = $this->db->get_where('equity', array('equity_id' => $equity_id))->row();
                    $where_equity = array('equity_id' => $equity_id);
                    $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
                    $equity_data = $get_equity_user_detail[0];
                    $user_id = $equity_data['user_id'];
                    admin_activity('approve_contract', $user_id, 0, $equity_id);
                    $history_process = array(
                        'investment_process_id' => $hello_sign->investor_process_id,
                        'invest_status_id' => 4,
                        'document_name' => $file_name,
                        'document_verified' =>1,
                        'update_date' => date('Y-m-d')
                    );
                    $this->investment_step_model->AddUpdateData('equity_investment_process_history', $history_process);
                    $signature_request_id = $json->signature_request->signature_request_id;
                    $apikey = $site_setting['hello_sign_apikey'];
                    require_once APPPATH.'libraries/hello_sign/autoload.php';
                    $client = new HelloSign\Client($apikey);
                    $client->getFiles($signature_request_id, base_path().'upload/doc/'.$file_name, HelloSign\SignatureRequest::FILE_TYPE_PDF);

                    $where_user = array(
                        'user_id' => $user_id
                    );

                    $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
                    $language_id = GetUserLangCode($user_id);
                    $email_template = $this->db->query("select * from `email_template` where task='Investmemt Document Approved' and language_id=".$language_id);

                    $email_temp = $email_template->row();

                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_subject = $email_temp->subject;
                    $email_message = $email_temp->message;

                    $username = $user_data['user_name'];
                    $email = $user_data['email'];
                    $email_to = $email;
                    $equity_name = SecureShowData($equity_data['company_name']);
                    $site_setting = site_setting();
                    $site_name = $site_setting['site_name'];
                    $taxonomy_setting = taxonomy_setting();
                    $project_name = $taxonomy_setting['project_name'];
                    $funds = $taxonomy_setting['funds'];

                    $email_subject = str_replace('{site_name}', $site_name, $email_subject);

                    $project_link = '<a href="' . site_url('investment/investor/' . $equity_id.'/'.$hello_sign->investor_process_id) . '">click here</a>';
                    $message_to_owner_link = '<a href="' . site_url('inbox/sendmessage/' . $equity_id) . '">' . site_url('inbox/sendmessage/' . $equity_id) . '</a>';

                    $email_message = str_replace('{user_name}', $username, $email_message);
                    $email_message = str_replace('{funds}', $funds, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);
                    $email_message = str_replace('{click_here}', $project_link, $email_message);
                    $email_message = str_replace('{message_to_admin}', $message_to_owner_link, $email_message);

                    $str = $email_message;

                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                }
            }
        }
        $this->output->set_status_header(200)->set_content_type('application/json', 'utf-8')->set_output(json_encode(array('Hello API Event Received')));
    }

    function hello_sign_callback_test() {
        require_once APPPATH.'libraries/hello_sign/autoload.php';
        $date = date('YmdGis');
        $date = (string)$date;
        $file_name = randomNumber(5).$date.'.pdf';
        $site_setting = site_setting();
        $apikey = $site_setting['hello_sign_apikey'];
        $client = new HelloSign\Client($apikey);
        $client->getFiles('891c58249d291d04773f72d8ad4f7a5ec6db55db', base_path().'upload/do_c/'.$file_name, HelloSign\SignatureRequest::FILE_TYPE_PDF);
        die;
        $response = json_encode($_REQUEST);
        $a = json_decode($response);
        $json = json_decode($a->json);
        $is_complete = $json->signature_request->is_complete;
        $status = $json->event->event_type;
        $signature_id = $json->signature_request->signature_request_id;
        // $hello_sign = $this->db->get_where('hello_sign', array('signature_id' => trim($signature_id)))->row();
        // if($hello_sign && $hello_sign->is_complete != 1) {
            $is_complete = ($is_complete) ? 1 : 0;
            // $this->db->where('id', $hello_sign->id);
            $this->db->insert('hello_sign', array('signature_id' => trim($signature_id), 'response' => json_encode($a), 'status' => $status, 'is_complete' => $is_complete, 'create_at' => date('Y-m-d H:i:s')));
        // }
    }

    function sign_contract($equity_id = '', $investor_process_id=0) {
        $user_id = check_user_authentication(true);
        $data['site_setting'] = $site_setting = site_setting();
        $data['encode_equity_id'] = $equity_id;
        $data['encode_investor_process_id'] = $investor_process_id;
        if ($site_setting['contract_copy_status'] == 0 && $site_setting['document_type'] == "hellosign" && $site_setting['hello_sign_apikey'] && $site_setting['hello_sign_client_id']) 
        {

        }else{
            redirect('investment/investment_step_2/'. $data['encode_equity_id'].'/'.$data['encode_investor_process_id']);
        }
        if(!is_numeric($equity_id)) {
            $data['equity_id'] = $equity_id=decrypt($equity_id) ;
        } 
        if(!is_numeric($investor_process_id)) {
            $data['equity_process_id'] = $data['investor_process_id'] = $investor_process_id=decrypt($investor_process_id) ;
        }
        $investment_process_id = $investor_process_id;
        if ($this->session->userdata('user_id') == '') {
            redirect('home/login');
        }

        if($investor_process_id == 0) {
            $this->db->select('*');
            $this->db->from('equity_investment_process');
            $this->db->where('user_id', $user_id);
            $this->db->where('equity_id', $equity_id);
            $this->db->where('status', '0');
            $this->db->where('invest_status_id <', 7);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                $investment_process_result=$query->row();
                $investment_process_id=$investment_process_result->id;
                redirect(base_url().'investment/investment_step_contract/' . $data['encode_equity_id'].'/'.$data['encode_investor_process_id']);
            }
        }
        $result=array();
        if($investment_process_id>0){
            $equity_where = array(
                'user_id' => $user_id,
                'equity_id' => $equity_id,
                'id' => $investment_process_id
            );
            $result = $this->investment_step_model->get_equity_process('equity_investment_process', $equity_where);
        }
        if($result && $result['document_name']) {
            redirect(base_url().'investment/investment_step_contract/'.$data['encode_equity_id'].'/'.$data['encode_investor_process_id']);
        }
        $session_key = md5($user_id.$equity_id.$investor_process_id);

        
        if ($site_setting['contract_copy_status'] == 0 && $site_setting['document_type'] == "hellosign" && $site_setting['hello_sign_apikey'] && $site_setting['hello_sign_client_id']) {
            if($this->session->userdata($session_key)) {
                $this->db->where(array('equity_id' => $equity_id, 'investor_process_id' => $investment_process_id, 'user_id' => $user_id));
                $this->db->order_by('id', 'desc');
                $hello_sign = $this->db->get('hello_sign')->row();
                $data['hello_sign_id'] = $hello_sign_id = $hello_sign->id;
            } else {

                $user = UserData($user_id);
                $user = $user[0];
                // echo "<pre>";
                // print_r($user);die;
                $equity = $this->db->get_where('equity', array('equity_id' => $equity_id))->row();
                if($equity->contract_copy_file_hello_sign) {
                    $contract_copy_file_hello_sign = $equity->contract_copy_file_hello_sign;
                } else {
                    $contract_copy_file_hello_sign = $site_setting['hello_sign_default_template'];
                    $this->db->where('equity_id', $equity_id);
                    $this->db->update('equity', array('contract_copy_file_hello_sign' => $site_setting['hello_sign_default_template']));
                    $equity = $this->db->get_where('equity', array('equity_id' => $equity_id))->row_array();
                    project_deletecache($equity_id, $equity['equity_url']);
                    user_deletecache('equities', $equity['user_id']);
                }
                try {

                    require_once APPPATH.'libraries/hello_sign/autoload.php';

                    $apikey = $site_setting['hello_sign_apikey'];
                    $data['client_id'] = $site_setting['hello_sign_client_id'];
                    $client = new HelloSign\Client($apikey);

                    $request = new HelloSign\TemplateSignatureRequest;
                    if($site_setting['hello_sign_test_mode'] == 1)
                        $request->enableTestMode();
                    $request->setTemplateId($contract_copy_file_hello_sign);
                    $request->setSigner('client', $user['email'], ucfirst($user['user_name']).' '.$user['last_name']);

                    $embedded_request = new HelloSign\EmbeddedSignatureRequest($request, $data['client_id']);
                    $response = $client->createEmbeddedSignatureRequest($embedded_request);
                    $signatures   = $response->getSignatures();
                    $signature_id = $signatures[0]->getId();
                    $getembeddedsignurl = $client->getEmbeddedSignUrl($signature_id);
                } catch (Exception $ex) {
                    redirect(base_url('investment/investment_step_2/'.$encode_equity_id.'/'.$encode_investor_process_id));
                }
                    $data['sign_url'] = $getembeddedsignurl->getSignUrl();
                $hell_sign_data = array('equity_id' => $equity_id, 'signature_id' => trim($signature_id), 'user_id' => $user_id, 'create_at' => date('Y-m-d H:i:s'));
                if($investor_process_id)
                    $hell_sign_data['investor_process_id'] = $investment_process_id;
                $this->db->insert('hello_sign', $hell_sign_data);
                $data['hello_sign_id'] = $hello_sign_id = $this->db->insert_id();
            }
        } else {
            redirect(base_url('/'));
        }
        

                        
        $new_file = '';
        if (!empty($result)) {
            if($this->session->userdata($session_key)) {
            } else {
                $inv_process = array(
                    'equity_id' => $equity_id,
                    'user_id' => $user_id,
                    'invest_status_id' => 5,
                    'document_name' => $new_file,
                     'document_verified' =>1,
                    'created_date' => date('Y-m-d H:i:s')
                );

                $investment_process_id = $this->investment_step_model->AddUpdateData('equity_investment_process', $inv_process, $investment_process_id, 'id');
            }
        } else {
            $transaction_id = $this->payment_process($equity_id, $user_id);
            $inv_process = array(
                'equity_id' => $equity_id,
                'user_id' => $user_id,
                'invest_status_id' => 5,
                'transaction_id' => $transaction_id,
                'document_name' => $new_file,
                 'document_verified' =>1,
                'created_date' =>  date('Y-m-d H:i:s')
            );

            $investment_process_id = $this->investment_step_model->AddUpdateData('equity_investment_process', $inv_process);

            admin_activity('upload_contract', $user_id, 0, $equity_id);
            
                ///=once process id generate remove the session data
            unset($_SESSION["donatedata"]);
            $this->db->where('id', $hello_sign_id);
            $this->db->update('hello_sign', array('investor_process_id' => $investment_process_id));
        }

        $data['equity_process_id'] = $investment_process_id;

        if ($investment_process_id > 0) {


            if($this->session->userdata($session_key)) {
            } else {
                $history_process = array(
                    'investment_process_id' => $investment_process_id,
                    'invest_status_id' => 1,
                    'document_name' => $new_file,
                    'update_date' => date('Y-m-d'),
                     'document_verified' =>1,

                );

                $this->investment_step_model->AddUpdateData('equity_investment_process_history', $history_process);
            }

        }
        
        $data['user_id'] = $user_id;

        $data['success_msg'] = $this->session->flashdata('success_msg');
        $data['external_doc'] = true;
        $meta = meta_setting();

        $data['equity_id'] = $equity_id;
        $equity = GetOneEquity($equity_id);
        $data['site_name'] = $data['site_setting']['site_name'];
        if($this->session->userdata($session_key)) {
        } else {
            $data['show_hello_Sign'] = true;
        }
        $data['session_key'] = $session_key;
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'investment_step/investment_step_contract', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    function investor($equity_id = '',$investor_process_id=0)
    {

        
        if ($this->session->userdata('user_id') == '') {
            redirect('home/login');
        }
         if (!is_numeric($equity_id)) 
         {
            $equity_id=decrypt($equity_id) ;
         } 
         if (!is_numeric($investor_process_id)) 
         {
            $investor_process_id=decrypt($investor_process_id) ;
         } 

        if((int) $equity_id<=0)redirect('home');

        $investment_process_result=array();        
        if((int) $investor_process_id>0)
        {               
                $this->checkInvestmentSteps($equity_id,$investor_process_id,'1');
                exit;
        }

        $user_id = check_user_authentication(false);
        
        $investment_process_result=array();
        
        if((int) $investor_process_id>0){
               
                $this->db->select('*');
                $this->db->from('equity_investment_process');
                $this->db->where('user_id', $user_id);
                $this->db->where('equity_id', $equity_id);
                $this->db->where('id', $investor_process_id);
               
                $query = $this->db->get();

                if ($query->num_rows() > 0) {

                    $investment_process_result=$query->row();
                }
        }
        

        $data = array();
        $data['site_setting'] = $site_setting = site_setting();
        // if ($site_setting['contract_copy_status'] == 0 && $site_setting['document_type'] == "hellosign" && $site_setting['hello_sign_apikey'] && $site_setting['hello_sign_client_id']) {
        //     $user = UserData($user_id);
        //     $user = $user[0];
        //     // echo "<pre>";
        //     // print_r($user);die;
        //     require_once APPPATH.'libraries/hello_sign/autoload.php';

        //     $apikey = $site_setting['hello_sign_apikey'];
        //     $data['client_id'] = $site_setting['hello_sign_client_id'];
        //     $client = new HelloSign\Client($apikey);

        //     $request = new HelloSign\TemplateSignatureRequest;
        //     if($site_setting['hello_sign_test_mode'] == 1)
        //         $request->enableTestMode();
        //     $request->setTemplateId('f079c8b9d7d1c100ddec400f1f57e62133d63252');
        //     $request->setSigner('client', $user['email'], ucfirst($user['user_name']).' '.$user['last_name']);

        //     $embedded_request = new HelloSign\EmbeddedSignatureRequest($request, $data['client_id']);
        //     $response = $client->createEmbeddedSignatureRequest($embedded_request);
        //     $signatures   = $response->getSignatures();
        //     $signature_id = $signatures[0]->getId();
        //     $getembeddedsignurl = $client->getEmbeddedSignUrl($signature_id);
        //     $data['sign_url'] = $getembeddedsignurl->getSignUrl();
        //     $this->db->insert('hello_sign', array('equity_id' => $equity_id, 'investor_process_id' => $investor_process_id, 'signature_id' => trim($signature_id), 'user_id' => $user_id, 'create_at' => date('Y-m-d H:i:s')));
        // }
        $data['equity_id'] = $equity_id;
        $data['check_entry'] = '';
        $equity = GetOneEquity($equity_id);
        
        $taxonomy_setting = taxonomy_setting();
        $project_url = $taxonomy_setting['project_url'];

        
        if(empty($investment_process_result)){
            
            $investor_manage = investor_status($user_id, $equity_id);
        
       
            if ($investor_manage['interest_status'] != 4) {

                if(!isset($_SESSION["donatedata"]))
                {
                    redirect('startinvest/index/' . $equity_id);
                }
                else
                {
                    redirect($project_url . '/' . $equity['equity_url']);
                }

            }
        }
        
        
        
        $data['success_msg']='';

        
        $result=array();
        $transaction=array();
        $temp_preapprove_res=array();
        
        
         if((int) $investor_process_id>0){
            
             
             $where = array(
                'user_id' => $user_id,
                'equity_id' => $equity_id,
                //'status' => 0,
                'id'=>$investor_process_id

            );
             
              $result = $this->investment_step_model->get_equity_process('equity_investment_process', $where);
              
               if(!empty($result)){
              
                    $session_key = md5($user_id.$equity_id.$investor_process_id);

                    if($this->session->userdata($session_key)) {
                        if($result['document_name']) {
                            $this->session->unset_userdata($session_key);
                        } else {
                            redirect(base_url().'investment/sign_contract/' . $equity_id.'/'.$investor_process_id);
                        }
                    }
                   
                    $temp_preapprove_where = array(
                        'user_id' => $user_id,
                        'equity_id' => $equity_id,
                        'preapprovalKey'=>$result['transaction_id']
                    ); 
                     
                    // print_r($transaction_where);
                     $temp_preapprove_res = $this->investment_step_model->get_equity_process('temp_preapprove', $temp_preapprove_where);
                   
                   
                   $transaction_where = array(
                        'user_id' => $user_id,
                        'equity_id' => $equity_id,
                        'preapproval_key'=>$result['transaction_id']
                    ); 
                     
                    // print_r($transaction_where);
                     $transaction = $this->investment_step_model->get_equity_process('transaction', $transaction_where);
                } 
                
              
         }

       
       
        /*echo "<pre>";
         print_r($result);
         
         
         print_r($investment_process_result);
         
         print_r($temp_preapprove_res);
         print_r($transaction);*/
        
        
       

       
        if(!empty($transaction)) {
            $data['investor_amount'] = $transaction['amount'];
        } elseif(!empty($temp_preapprove_res)){ 
            $data['investor_amount'] = $temp_preapprove_res['amount'];
        } else {
            if(isset($_SESSION["donatedata"]['amount'])){
                $data['investor_amount'] = $_SESSION["donatedata"]['amount'];
            } else{
                 $data['investor_amount'] = 0;
            }
        }
        
       /* echo $data['investor_amount'];
        die;*/
        
        if($data['investor_amount']<=0){
            redirect('/');
        }
        
        
        if (!empty($result)) {

            $data['acknowledge_note'] = $result['acknowledge_note'];
            $data['equity_process_id'] = $result['id'];
            $data['invest_status_id'] = $result['invest_status_id'];
            $data['shipment'] = $result['shipment'];
            $data['bank_detail'] = $result['bank_detail'];
            $data['document_name'] = $result['document_name'];
            $data['acknowledge_doc'] = $result['acknowledge_doc'];
            $data['status'] = $result['status'];
            $data['contract_sign_file'] = $result['document_name'];
            
           
            
            $data['status_id'] = $result['invest_status_id'];
            $data['gateway_id'] = $result['gateway_id'];
            $data['transaction_id'] = $result['transaction_id'];

        } else {

            $data['acknowledge_note'] = '';
            $data['equity_process_id'] = '';
            $data['shipment'] = '';
            $data['bank_detail'] = '';
            $data['document_name'] = '';
            $data['acknowledge_doc'] = '';
            $data['status'] = '';
            $data['contract_sign_file'] = '';
            
            
            $data['status_id'] ='';
            $data['gateway_id'] ='1';
             $data['transaction_id'] ='';
        }
        
        $data['check_entry'] = $result;
       
        $data['user_id'] = $user_id;

        $data['success_msg'] = $this->session->flashdata('success_msg');


        $meta = meta_setting();
        $data['site_name'] = $data['site_setting']['site_name'];

        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'investment_step/investment_step', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();

    }

    /*
    Function name :dwn_document()
    Parameter :none
    Return : none
    Use : download pdf document
    */

    function dwn_document($equity_id = '', $in_process_id = '')
    {

        if ($this->session->userdata('user_id') == '') {
            redirect('home/login');
        }

        if ($equity_id != 0) {

            $user_id = check_user_authentication(false);
            
             $where_equity = array(
                'equity_id' => $equity_id
            );
            $equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);
            $file_name = $equity_data['contract_copy_file'];
            $this->load->helper('download');
            $data = file_get_contents(base_url() . "upload/equity/investor/" . $file_name); // Read the file's contents

            force_download($file_name, $data);

        }

  

    }

    /*
    Function name :UserImageAjax()
    Parameter :$type
    Return : json data
    Use : upload zip,pdf document
    */

    function UserPdfAjax($type = 0)
    {


        $user_id = check_user_authentication(false);
        $this->load->library('form_validation');

        $data = array();
        $data["error"] = '';
        $data["success"] = '';
        $check = '';
        $investment_process_id = '';
        $site_setting = site_setting();

        if ($_POST) {

            $equity_id = SecurePostData($this->input->post('equity_id_ack'));
            $investment_process_id = SecurePostData($this->input->post('equity_process_id'));


            if(!is_numeric($equity_id)) {
                 $equity_id=decrypt($equity_id) ;
            } 
            if(!is_numeric($investment_process_id)) {
                $investment_process_id=decrypt($investment_process_id) ;
            }

            switch ($type) {
                case 0:

                    $_FILES['userfile']['name'] = $_FILES['file1']['name'];
                    $_FILES['userfile']['type'] = $_FILES['file1']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['file1']['tmp_name'];
                    $_FILES['userfile']['error'] = $_FILES['file1']['error'];
                    $_FILES['userfile']['size'] = $_FILES['file1']['size'];
                    $image_settings = get_image_setting_data();
                    $type_file = explode('/', $_FILES['userfile']['type']);
                    $upload_file_type = $type_file[1];
                    $upload_file_type = str_replace('"', '', $upload_file_type);
                    $file_type_array = array('zip', 'pdf', 'octet-stream');
                    if (!in_array($upload_file_type, $file_type_array)) {

                        $data["error"] = PLEASE_UPLOAD_ZIP_OR_PDF_FILE;

                    } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {

                        $data["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);

                    } else {

                        $filename = $_FILES['file1']['name'];
                        $base_path = $this->config->slash_item('base_path');

                        //move file into folder
                        $rand = rand(0, 100000);
                       
                        $path_parts = pathinfo($_FILES['file1']['name']);
                        $date = new DateTime();
                      
                        $file_extention = $path_parts['extension'];
                        $new_file = $rand .'-investor-'.$date->getTimestamp().'.'.$file_extention;

                        move_uploaded_file($_FILES["userfile"]["tmp_name"], $base_path . "upload/doc/" . $new_file);

                        
                        //$check = $this->investment_step_model->check_equity_investment_process($equity_id, $user_id, '0');
                        //$investment_process_id = $check['id'];
                        
                        $result=array();
                        if($investment_process_id>0){
                            $equity_where = array(
                                'user_id' => $user_id,
                                'equity_id' => $equity_id,
                                'id' => $investment_process_id
                            );

                            $result = $this->investment_step_model->get_equity_process('equity_investment_process', $equity_where);
                        
                        }

                       
                      
                        if (!empty($result)) {

                            $inv_process = array(
                                'equity_id' => $equity_id,
                                'user_id' => $user_id,
                                'invest_status_id' => 5,
                                'document_name' => $new_file,
                                'created_date' => date('Y-m-d H:i:s')
                            );

                            $investment_process_id = $this->investment_step_model->AddUpdateData('equity_investment_process', $inv_process, $investment_process_id, 'id');

                        } else {
                            // $transaction_id = $this->payment_process($equity_id, $user_id);
                            $inv_process = array(
                                'equity_id' => $equity_id,
                                'user_id' => $user_id,
                                'invest_status_id' => 3,
                                'transaction_id' => $transaction_id,
                                'document_name' => $new_file,
                                'created_date' =>  date('Y-m-d H:i:s')
                            );

                            $investment_process_id = $this->investment_step_model->AddUpdateData('equity_investment_process', $inv_process);

                            admin_activity('upload_contract', $user_id, 0, $equity_id);
                            
                                ///=once process id generate remove the session data
                                unset($_SESSION["donatedata"]);
                        }

                        if ($investment_process_id > 0) {


                            $history_process = array(
                                'investment_process_id' => $investment_process_id,
                                'invest_status_id' => 3,
                                'document_name' => $new_file,
                                'update_date' => date('Y-m-d')

                            );

                            $this->investment_step_model->AddUpdateData('equity_investment_process_history', $history_process);

                        }

                        //email send to admin

                        $where_user = array(
                            'user_id' => $user_id
                        );

                        $where_equity = array(
                            'equity_id' => $equity_id
                        );

                        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
                        //$equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);
                         $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);

                        $equity_data = $get_equity_user_detail[0];

                        $site_name = $site_setting['site_name'];
                        $taxonomy_setting = taxonomy_setting();
                        $project_name = $taxonomy_setting['project_name'];
                        $funds = $taxonomy_setting['funds'];
                         $language_id=$site_setting['site_language'];
                        $email_template = $this->db->query("select * from `email_template` where task='Investmemt Document Uploaded' and language_id=".$language_id);
                        $email_temp = $email_template->row();
                        $email_address_from = $email_temp->from_address;
                        $email_address_reply = $email_temp->reply_address;
                        $email_subject = $email_temp->subject;
                        $email_message = $email_temp->message;

                        $username = $user_data['user_name'] . ' ' . $user_data['last_name'];
                        $profile_slug = $user_data['profile_slug'];
                        $email = $email_address_from;
                        $email_to = $email;


                        $email_address_from = $user_data['email'];

                        $company_name = SecureShowData($equity_data['company_name']);


                        $email_subject = str_replace('{investor_name}', $username, $email_subject);


                        $admin_link = '<a href="' . site_url('investment/adminstep/' . $investment_process_id) . '">click here</a>';


                        $message_to_owner_link = '<a href="' . site_url('inbox/sendmessage/' . $equity_id) . '">' . site_url('inbox/sendmessage/' . $equity_id) . '</a>';
                        $investor_name = '<a href="' . site_url('user/' . $profile_slug) . '">' . $username . '</a>';
                        $email_message = str_replace('{break}', '<br/>', $email_message);
                        $email_message = str_replace('{investor_name}', $investor_name, $email_message);
                        $email_message = str_replace('{project_name}', $project_name, $email_message);
                        $email_message = str_replace('{company_name}', SecureShowData($company_name), $email_message);
                        $email_message = str_replace('{click_here}', $admin_link, $email_message);
                        $email_message = str_replace('{message_to_owner}', $message_to_owner_link, $email_message);
                        $email_message = str_replace('{funds}', $funds, $email_message);
                        $email_message = str_replace('{site_name}', $site_name, $email_message);

                        $str = $email_message;

                        email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);


                        //$login_id = $this->session->userdata('admin_id');
                        $where_email = array(
                            'email' => $email_to

                        );

                        $user_email = $this->investment_step_model->get_equity_process('user', $where_email);
                        $user_id_rec = $user_email['user_id'];

                        $data_insert = array(
                            'sender_id' => $user_id,
                            'receiver_id' => $user_id_rec,
                            'is_read' => 0,
                            'message_subject' => $email_subject,
                            'message_content' => $str,
                            'date_added' => date('Y-m-d H:i:s'),
                            'type' => $user_id,
                            'equity_id' => $equity_id
                        );


                        //$message_insert = $this->message_model->insert_project_profile_message($data_insert);
                        $message_setting = message_setting();
                        $user_id = $user_id_rec;
                        $user_detail = UserData($user_id_rec, array());
                        $login_user_detail = UserData($user_id, array());
                        $message_setting->message_enable;

                        //$message_user_profile_link = site_url('member/' . $user_id);

                        $user_name = $user_detail[0]['user_name'];
                        $message_user_name = $login_user_detail[0]['user_name'];
                        $content = $str;


                        if ($new_file) {

                            $data["success"] = FILE_UPLOAD_SUCCESS . $site_setting['site_name'] . ' team will get back to you shortly';
                            $data["file_name"] = $new_file;

                        } else {

                            $data["error"] = THERE_IS_SOME_PROBLEM_SITE_TRY_AFTER_SOMETIME;
                        }

                    }//end

                    //}

                    $data['process_id'] = $investment_process_id;
                    $data["successbox"] = 1;
                    break;


            }
        }

        echo json_encode($data);
    }

    /*
    Function name :add_acknowledge()
    Parameter :none
    Return : json data
    Use : update the data
    */

    function add_acknowledge()
    {

        if ($this->session->userdata('user_id') == '') {
            redirect('home/login');
        }

        $user_id = check_user_authentication(false);

        $this->form_validation->set_rules('gateway_id', PAYWITH_REQUIRED, 'required');

        $data['error'] = '';
        $data['success'] = '';

        if ($this->form_validation->run() == FALSE) {

            if (validation_errors()) {

                $data['error'] = validation_errors();

            } else {

                $data['error'] = '';
            }

        } else {

            if ($_POST) {

                $equity_id = SecurePostData($this->input->post('equity_id1'));
                $equity_process_id=  SecurePostData($this->input->post('equity_process_id'));
                
                $result=array();
                
                if($equity_process_id>0){
                    $where = array(
                        'user_id' => $user_id,
                        'equity_id' => $equity_id,
                        'id' => $equity_process_id
                    );
               
                    $result = $this->investment_step_model->get_equity_process('equity_investment_process', $where);
                   
                }
                
                
                //===
                
                $invest_status_id=5;
                if($this->input->post('gateway_id')==1)  $invest_status_id=6;

                if(!empty($result))
                {
                //print_r($update_data);die;

                    $update_data = array(
                    'gateway_id' => SecurePostData($this->input->post('gateway_id')),    
                    'acknowledge_note' => SecurePostData($this->input->post('acknowledge_note')),
                    'invest_status_id' => $invest_status_id
                    );

                    $where = array(
                        'equity_id' => $equity_id,
                        'user_id' => $user_id,
                        'id'=>$equity_process_id
                    );


                    $this->investment_step_model->acknowdledge_update($where, 'equity_investment_process', $update_data);
                    
                    $data['equity_process_id']=$equity_process_id;
                    $data['success'] = RECORD_HAS_BEEN_UPDATED_SUCCESSFULLY;
                }
                else
                {

                     $transaction_id = $this->payment_process($equity_id, $user_id);
                     $insert_data = array(
                        'acknowledge_note' => SecurePostData($this->input->post('acknowledge_note')),
                        'invest_status_id' =>$invest_status_id,
                        'transaction_id' => $transaction_id,
                        'equity_id' => $equity_id,
                        'user_id' => $user_id,
                        'created_date' => date('Y-m-d H:i:s')
                    );

                    $equity_process_id=$this->investment_step_model->acknowdledge_insert('equity_investment_process', $insert_data);
                    
                    $data['equity_process_id']=$equity_process_id;
                    $data['success'] = RECORD_HAS_BEEN_UPDATED_SUCCESSFULLY;
                    
                    ///=once process id generate remove the session data
                            unset($_SESSION["donatedata"]);
                    
                }
                
                ///==

            }

        }
        echo json_encode($data);

    }

    /*
    Function name :UserImageAjax()
    Parameter :$type
    Return : json data
    Use : upload zip,pdf document
    */

    function UserAcknowledge($type = 0)
    {

        $user_id = check_user_authentication(false);
        $this->load->library('form_validation');

        $data = array();
        $data["error"] = '';
        $data["success"] = '';
        $check = '';

        $site_setting = site_setting();

        if ($_POST) {

            $equity_id = SecurePostData($this->input->post('equity_id_ack'));

            $investment_process_id = SecurePostData($this->input->post('equity_process_id'));
            
             $data['equity_process_id']=$investment_process_id;

            switch ($type) {
                case 0:

                    $_FILES['userfile']['name'] = $_FILES['file1']['name'];
                    $_FILES['userfile']['type'] = $_FILES['file1']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['file1']['tmp_name'];
                    $_FILES['userfile']['error'] = $_FILES['file1']['error'];
                    $_FILES['userfile']['size'] = $_FILES['file1']['size'];
                     $image_settings = get_image_setting_data();
                    //file validation
                    if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif " and $_FILES["userfile"]["type"] != "application/pdf" and $_FILES["userfile"]["type"] != "application/zip") {
                        //if ($_FILES["userfile"]["type"] != "application/zip" and $_FILES["userfile"]["type"] != "application/pdf" ) {

                        $data["error"] = PLEASE_UPLOAD_DOC_IMAGE_ZIP_PDF;
                        //PLEASE_UPLOAD_ZIP_OR_PDF_FILE
                    } else if ($_FILES["userfile"]["size"] >  $image_settings['upload_limit']*1000000) {

                        $data["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);

                    } else {

                        $filename = $_FILES['file1']['name'];
                        $base_path = $this->config->slash_item('base_path');

                        //move file into folder

                        $rand = rand(0, 100000);
                       
                        $path_parts = pathinfo($_FILES['file1']['name']);
                        $date = new DateTime();
                      
                        $file_extention = $path_parts['extension'];
                        $new_file = $rand .'-investor-ack-'.$date->getTimestamp().'.'.$file_extention;

                        move_uploaded_file($_FILES["userfile"]["tmp_name"], $base_path . "upload/acknowledge/" . $new_file);

                        if ($investment_process_id) {

                            //update data into 	equity_investment_process table

                            $inv_process = array(
                                'invest_status_id' => 6,
                                'acknowledge_doc' => $new_file,
                                'created_date' =>  date('Y-m-d H:i:s')
                            );

                            $investment_process_id = $this->investment_step_model->AddUpdateData('equity_investment_process', $inv_process, $investment_process_id, 'id');
                            admin_activity('acknowledge_contract', $user_id, 0, $equity_id);
                        }
                        else
                        {
                             $transaction_id = $this->payment_process($equity_id, $user_id);
                             $inv_process = array(
                                'invest_status_id' => 6,
                                'acknowledge_doc' => $new_file,
                                'created_date' =>  date('Y-m-d H:i:s'),
                                'transaction_id' => $transaction_id,
                                'user_id'=>$user_id,
                                'equity_id'=>$equity_id
                            );

                            $investment_process_id = $this->investment_step_model->AddUpdateData('equity_investment_process', $inv_process, '', '');
                            admin_activity('acknowledge_contract', $user_id, 0, $equity_id);
                            
                            
                            ///=once process id generate remove the session data
                            unset($_SESSION["donatedata"]);
                            
                        }

                        if ($investment_process_id > 0) {

                            $history_process = array(
                                'investment_process_id' => $investment_process_id,
                                'invest_status_id' => 6,
                                'acknowledge_doc' => $new_file,
                                'update_date' => date('Y-m-d')

                            );

                            $this->investment_step_model->AddUpdateData('equity_investment_process_history', $history_process);

                        }


                        $where_user = array(
                            'user_id' => $user_id
                        );

                        $where_equity = array(
                            'equity_id' => $equity_id
                        );

                        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
                        //$equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);
                         $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);

                        $equity_data = $get_equity_user_detail[0];

                           $language_id=$site_setting['site_language'];
                        $email_template = $this->db->query("select * from `email_template` where task='Payment Reciept Uploaded' and language_id=".$language_id);
                        $email_temp = $email_template->row();
                        $email_address_from = $email_temp->from_address;
                        $email_address_reply = $email_temp->reply_address;
                        $email_subject = $email_temp->subject;
                        $email_message = $email_temp->message;

                        $username = $user_data['user_name'];
                        $email = $email_address_from;
                        $email_to = $email;
                        $email_address_from = $user_data['email'];

                        $company_name = SecureShowData($equity_data['company_name']);
                        $equity_url = $equity_data['equity_url'];

                        $site_name = $site_setting['site_name'];
                        $taxonomy_setting = taxonomy_setting();
                        $project_name = $taxonomy_setting['project_name'];
                        $project_url = $taxonomy_setting['project_url'];
                        $funds = $taxonomy_setting['funds'];
                        $profile_slug = $user_data['profile_slug'];
                        $email_subject = str_replace('{investor_name}', $username, $email_subject);
                        $email_subject = str_replace('{funds}', $funds, $email_subject);

                        //$admin_link = '<a href="' . site_url('admin/equity/equity_detail/'.$equity_url.'#investors') . '">click here</a>';
                        $admin_link = '<a href="' . site_url('investment/adminstep/' . $investment_process_id) . '">click here</a>';
                        $investor_link = '<a href="' . site_url('user/' . $profile_slug) . '">' . $username . '</a>';
                        $company_name = '<a href="' . site_url($project_url . '/' . $equity_url) . '">' . $company_name . '</a>';
                        $message_to_owner = '<a href="' . site_url('admin/message/view_message/' . $equity_id . '/' . $user_id) . '">' . site_url('admin/message/view_message/' . $equity_id . '/' . $user_id) . '</a>';
                        $email_message = str_replace('{break}', '<br/>', $email_message);
                        $email_message = str_replace('{investor_name}', $investor_link, $email_message);
                        $email_message = str_replace('{company_name}', SecureShowData($company_name), $email_message);
                        $email_message = str_replace('{project_name}', $project_name, $email_message);
                        $email_message = str_replace('{click_here}', $admin_link, $email_message);
                        $email_message = str_replace('{site_name}', $site_name, $email_message);
                        $email_message = str_replace('{message_to_owner}', $message_to_owner, $email_message);

                        $str = $email_message;
                        email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

                        //send message
                        $where_email = array(
                            'email' => $email_to

                        );

                        $user_email = $this->investment_step_model->get_equity_process('user', $where_email);
                        $user_id_rec = $user_email['user_id'];

                        $data_insert = array(
                            'sender_id' => $user_id,
                            'receiver_id' => $user_id_rec,
                            'is_read' => 0,
                            'message_subject' => $email_subject,
                            'message_content' => $str,
                            'date_added' => date('Y-m-d H:i:s'),
                            'type' => $user_id,
                            'equity_id' => $equity_id
                        );


                        //$message_insert = $this->message_model->insert_project_profile_message($data_insert);
                        $message_setting = message_setting();
                        $user_id = $user_id_rec;
                        $user_detail = UserData($user_id_rec, array());
                        $login_user_detail = UserData($user_id, array());
                        $message_setting->message_enable;

                        //$message_user_profile_link = site_url('member/' . $user_id);

                        $user_name = $user_detail[0]['user_name'];
                        $message_user_name = $login_user_detail[0]['user_name'];
                        $content = $str;

                        if ($filename) {

                            $data["success"] = YOUR_PAYMENT_ACKNOWLEDGEMENT_INFORMATION_HAS_BEEN_SUBMITTED_SUCCESSFULLY . $site_setting['site_name'] . TEAM_WILL_REVIEW_AND_CONFIRM_YOUR_PAYMENT_SHORTLY;
                            $data["file_name"] = $new_file;

                        } else {

                            $data["error"] = THERE_IS_SOME_PROBLEM_SITE_TRY_AFTER_SOMETIME;
                        }
                    }

                    $data["successbox"] = 1;
                    $data['investment_process_id']=$investment_process_id;
                    break;


            }
        }

        echo json_encode($data);
    }

    /*
    Function name :adminstep()
    Parameter :$equity_id
    Return : none
    Use : load the page and fetch the data related project_id and user_id
    */

    function adminstep($in_process_id = '')
    {
        $site_setting = site_setting();
        $admin_id = check_admin_authentication();
        $user_id = check_user_authentication(false);
        $data['in_process_id'] = $in_process_id;

        $where = array(
            'id' => $in_process_id
        );

        $result = $this->investment_step_model->get_equity_process('equity_investment_process', $where);


        $data['document_name'] = $result['document_name'];
        $data['acknowledge_doc'] = $result['acknowledge_doc'];

        $data['shipment'] = $result['shipment'];
        $data['user_id'] = $result['user_id'];
        $data['equity_id'] = $result['equity_id'];
        $data['invest_status_id'] = $result['invest_status_id'];
        $data['status'] = $result['status'];
        $data['bank_detail'] = $site_setting['bank_detail'];
        $data['acknowledge_note'] = $result['acknowledge_note'];
        $data['gateway_id'] = $result['gateway_id'];

        $user_id = $result['user_id'];
        $userdata = UserData($user_id);
        $data['investor_name'] = $userdata[0]['user_name'] . ' ' . $userdata[0]['last_name'];
        $transaction_where = array(
            'user_id' => $user_id,
            'equity_id' => $data['equity_id'],
            'preapproval_key'=>$result['transaction_id']
        );
        $transaction = $this->investment_step_model->get_equity_process('transaction', $transaction_where);
        if($transaction)
            $data['investor_amount'] = $transaction['amount'];
        else {
            $temp_preapprove_where = array(
                'user_id' => $user_id,
                'equity_id' => $data['equity_id'],
                'preapprovalKey'=>$result['transaction_id']
            ); 

            // print_r($transaction_where);
            $temp_preapprove_res = $this->investment_step_model->get_equity_process('temp_preapprove', $temp_preapprove_where);
            $data['investor_amount'] = $temp_preapprove_res['amount'];
        }
        $user_where = array(
            'user_id' => $user_id
        );
        $user_result = $this->investment_step_model->get_equity_process('user', $user_where);
        $data['user_result'] = $user_result;


        $equity_id = $result['equity_id'];

        $where_equity = array(
            'equity_id' => $equity_id
        );


        $project_data = GetOneEquity($equity_id);
        $data['project_title'] = SecureShowData($project_data['company_name']);

        $data['admin_success_msg'] = $this->session->flashdata('admin_success_msg');
        $data['ship_success_msg'] = $this->session->flashdata('ship_success_msg');

        $meta = meta_setting();
        $data['site_setting'] = site_setting();

        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'investment_step/investment_step_admin', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();

    }

    /*
    Function name :download_doc()
    Parameter : $doc_name
    Return : none
    Use :download file
    */

    function download_doc($doc_name = '')
    {

        check_admin_authentication();

        $this->load->helper('download');
        $data = file_get_contents(base_url() . "upload/doc/" . $doc_name); // Read the file's contents
        $name = $doc_name;
        force_download($name, $data);

    }

    /*
    Function name :download_doc()
    Parameter : $doc_name
    Return : none
    Use :download file
    */

    function download_acknowledge($acknowledge_doc = '')
    {

        check_admin_authentication();

        $this->load->helper('download');
        $data = file_get_contents(base_url() . "upload/acknowledge/" . $acknowledge_doc); // Read the file's contents
        $name = $acknowledge_doc;
        force_download($name, $data);

    }

    /*
    Function name :approve_bankdetail()
    Parameter : $in_process_id
    Return : none
    Use :approve status
    */

    function approve_bankdetail($in_process_id = '')
    {

        $admin_id = check_admin_authentication();

        if ($_POST) {

            $bank_detail = SecurePostData($this->input->post('bank_detail'));
            $user_id = SecurePostData($this->input->post('user_id'));
            $equity_id = SecurePostData($this->input->post('equity_id'));
            $update_id = 4;

            if ($bank_detail) {

                $data_update = array(
                    'invest_status_id' => $update_id,
                    'bank_detail' => $bank_detail
                );

                $this->investment_step_model->AddUpdateData('equity_investment_process', $data_update, $in_process_id, 'id');

                admin_activity('approve_contract', $user_id, 0, $equity_id);
            }


            $where_equity = array(
                'equity_id' => $equity_id
            );

            //$equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);

             $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);

            $equity_data = $get_equity_user_detail[0];


            $where_user = array(
                'user_id' => $user_id
            );

            $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
             $language_id=GetUserLangCode( $user_id);
            $email_template = $this->db->query("select * from `email_template` where task='Investmemt Document Approved' and language_id=".$language_id);

            $email_temp = $email_template->row();

            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_subject = $email_temp->subject;
            $email_message = $email_temp->message;


            $username = $user_data['user_name'];
            $email = $user_data['email'];
            $email_to = $email;
            $equity_name = SecureShowData($equity_data['company_name']);
            $site_setting = site_setting();
            $site_name = $site_setting['site_name'];
            $taxonomy_setting = taxonomy_setting();
            $project_name = $taxonomy_setting['project_name'];
            $funds = $taxonomy_setting['funds'];

            $email_subject = str_replace('{site_name}', $site_name, $email_subject);


            $project_link = '<a href="' . site_url('investment/investor/' . $equity_id.'/'.$in_process_id) . '">click here</a>';
            $message_to_owner_link = '<a href="' . site_url('inbox/sendmessage/' . $equity_id) . '">' . site_url('inbox/sendmessage/' . $equity_id) . '</a>';

            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{funds}', $funds, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $email_message = str_replace('{click_here}', $project_link, $email_message);
            $email_message = str_replace('{message_to_admin}', $message_to_owner_link, $email_message);

            $str = $email_message;


            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

            //send message
            //$login_id = $this->session->userdata('admin_id');

            $data_insert = array(
                'sender_id' => $admin_id,
                'receiver_id' => $user_id,
                'is_read' => 0,
                'message_subject' => $email_subject,
                'message_content' => $str,
                'date_added' => date('Y-m-d H:i:s'),
                'type' => $admin_id,
                'equity_id' => $equity_id
            );

            //$message_insert = $this->message_model->insert_project_profile_message($data_insert);
            $message_setting = message_setting();
            $user_id = $user_id;
            $user_detail = UserData($user_id, array());
            $login_user_detail = UserData($admin_id, array());
            $message_setting->message_enable;

            //$message_user_profile_link = site_url('member/' . $user_id);

            $user_name = $user_detail[0]['user_name'];
            $message_user_name = $login_user_detail[0]['user_name'];
            $content = $str;


        }
        $this->session->set_flashdata('admin_success_msg', STEP_2_HAS_BEEN_CONFIRMED_AND_COMPLETED_PROCEED_TO_THE_STEP_3_PAYMENT);
        redirect('investment/adminstep/' . $in_process_id);

    }

    /*
    Function name :reject_comment()
    Parameter : $in_process_id
    Return : none
    Use :reject status
    */

    function reject_comment($in_process_id = '')
    {

        $admin_id = check_admin_authentication();

        if ($_POST) {

            $reject_comment = SecurePostData($this->input->post('reject_comment'));
            $user_id = SecurePostData($this->input->post('user_id'));
            $equity_id = SecurePostData($this->input->post('equity_id'));
            $update_id = 9;

            if ($reject_comment) {

                $data_update = array(
                    'invest_status_id' => $update_id,
                );

                $this->investment_step_model->AddUpdateData('equity_investment_process', $data_update, $in_process_id, 'id');
                admin_activity('declined_contract', $user_id, 0, $equity_id);
            }


            $where_equity = array(
                'equity_id' => $equity_id
            );


           // $equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);
            $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);

            $equity_data = $get_equity_user_detail[0];


            $where_user = array(
                'user_id' => $user_id
            );

            $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
             $language_id=GetUserLangCode( $user_id);
            $email_template = $this->db->query("select * from `email_template` where task='Document Rejected' and language_id=".$language_id);

            $email_temp = $email_template->row();

            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $site_setting = site_setting();
            $site_name = $site_setting['site_name'];
            $taxonomy_setting = taxonomy_setting();
            $project_name = $taxonomy_setting['project_name'];
            $funds = $taxonomy_setting['funds'];

            $email_subject = $email_temp->subject;


            $email_message = $email_temp->message;

            $username = $user_data['user_name'];
            $email = $user_data['email'];
            $email_to = $email;
            $equity_name = SecureShowData($equity_data['company_name']);


            $email_subject = str_replace('{site_name}', $site_name, $email_subject);

            $project_link = '<a href="' . site_url('investment/investor/' . $equity_id.'/'.$in_process_id) . '">click here</a>';
            $message_to_owner_link = '<a href="' . site_url('inbox/sendmessage/' . $equity_id) . '">' . site_url('inbox/sendmessage/' . $equity_id) . '</a>';
            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{funds}', $funds, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $email_message = str_replace('{click_here}', $project_link, $email_message);
            $email_message = str_replace('{message_to_admin}', $message_to_owner_link, $email_message);
            $email_message = str_replace('{reason}', $reject_comment, $email_message);


            $str = $email_message;

            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

            //send message
            //$login_id = $this->session->userdata('admin_id');

            $data_insert = array(
                'sender_id' => $admin_id,
                'receiver_id' => $user_id,
                'is_read' => 0,
                'message_subject' => $email_subject,
                'message_content' => $str,
                'date_added' => date('Y-m-d H:i:s'),
                'type' => $admin_id,
                'equity_id' => $equity_id
            );

            //$message_insert = $this->message_model->insert_project_profile_message($data_insert);
            $message_setting = message_setting();
            $user_id = $user_id;
            $user_detail = UserData($user_id, array());
            $login_user_detail = UserData($admin_id, array());
            $message_setting->message_enable;

            //$message_user_profile_link = site_url('member/' . $user_id);

            $user_name = $user_detail[0]['user_name'];
            $message_user_name = $login_user_detail[0]['user_name'];
            $content = $str;


        }
        $this->session->set_flashdata('admin_success_msg', STATUS_HAS_BEEN_REJECTED_SUCCESSFULLY);
        redirect('investment/adminstep/' . $in_process_id);


    }

    /*
    Function name :add_shipment()
    Parameter : none
    Return : json data
    Use :update status and shipment detail
    */

    function add_shipment()
    {


        $admin_id = check_admin_authentication();
        $this->form_validation->set_rules('shipment', "Shipment", 'required');

        $data['error'] = '';
        $data['success'] = '';

        if ($this->form_validation->run() == FALSE) {

            if (validation_errors()) {

                $data['error'] = validation_errors();

            } else {

                $data['error'] = '';
            }

        } else {

            if ($_POST) {

                $shipment = SecurePostData($this->input->post('shipment'));
                $user_id = SecurePostData($this->input->post('user_id'));
                $equity_id = SecurePostData($this->input->post('equity_id'));
                $in_process_id = SecurePostData($this->input->post('in_process_id'));

                $update_id = 8;

                if ($shipment) {

                    $data_update = array(
                        'invest_status_id' => $update_id,
                        'shipment' => $shipment
                    );

                    $this->investment_step_model->AddUpdateData('equity_investment_process', $data_update, $in_process_id, 'id');
                    $data['success'] = 'Your share/document transmission information submitted and sent';
                }


                $where_equity = array(
                    'equity_id' => $equity_id
                );


                //$equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);

                $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);

                $equity_data = $get_equity_user_detail[0];



                $where_user = array(
                    'user_id' => $user_id
                );

                $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
                 $language_id=GetUserLangCode( $user_id);
                $email_template = $this->db->query("select * from `email_template` where task='Payment Reciept Approved' and language_id=".$language_id);

                $email_temp = $email_template->row();

                $email_address_from = $email_temp->from_address;
                $email_address_reply = $email_temp->reply_address;
                $email_subject = $email_temp->subject;
                $email_message = $email_temp->message;


                $username = $user_data['user_name'];
                $email = $user_data['email'];
                $email_to = $email;
                $equity_name = SecureShowData($equity_data['company_name']);


                $site_setting = site_setting();
                $site_name = $site_setting['site_name'];
                $taxonomy_setting = taxonomy_setting();
                $project_name = $taxonomy_setting['project_name'];
                $funds = $taxonomy_setting['funds'];

                $email_subject = str_replace('{site_name}', $site_name, $email_subject);
                $email_subject = str_replace('{funds}', $funds, $email_subject);


                $project_link = '<a href="' . site_url('investment/investor/' . $equity_id.'/'.$in_process_id) . '">click here</a>';

                $message_to_owner_link = '<a href="' . site_url('inbox/sendmessage/' . $equity_id) . '">' . site_url('inbox/sendmessage/' . $equity_id) . '</a>';

                $email_message = str_replace('{break}', '<br/>', $email_message);
                $email_message = str_replace('{user_name}', $username, $email_message);
                $email_message = str_replace('{click_here}', $project_link, $email_message);
                $email_message = str_replace('{site_name}', $site_name, $email_message);
                $email_message = str_replace('{message_to_admin}', $message_to_owner_link, $email_message);

                $str = $email_message;

                email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

                //send message
                //$login_id = $this->session->userdata('admin_id');

                $data_insert = array(
                    'sender_id' => $admin_id,
                    'receiver_id' => $user_id,
                    'is_read' => 0,
                    'message_subject' => $email_subject,
                    'message_content' => $str,
                    'date_added' => date('Y-m-d H:i:s'),
                    'type' => $admin_id,
                    'equity_id' => $equity_id
                );

                //$message_insert = $this->message_model->insert_project_profile_message($data_insert);
                $message_setting = message_setting();
                $user_id = $user_id;
                $user_detail = UserData($user_id, array());
                $login_user_detail = UserData($admin_id, array());
                $message_setting->message_enable;

                $message_user_profile_link = '';

                $user_name = $user_detail[0]['user_name'];
                $message_user_name = $login_user_detail[0]['user_name'];
                $content = $str;


            }

        }
        echo json_encode($data);

    }

    /*
    Function name :status_approve()
    Parameter : $in_process_id
    Return : none
    Use :update status
    */

    function status_approve($in_process_id = '')
    {

        $admin_id = check_admin_authentication();

        if ($_POST) {

            $in_process_id = SecurePostData($this->input->post('in_process_id'));
            $user_id = SecurePostData($this->input->post('user_id'));
            $equity_id = SecurePostData($this->input->post('equity_id'));
            $update_id = 7;

            $data_update = array(
                'invest_status_id' => $update_id

            );
            admin_activity('approve_acknowledge_contract', $user_id, 0, $equity_id);

            $this->investment_step_model->AddUpdateData('equity_investment_process', $data_update, $in_process_id, 'id');
            $data['success'] = "Step 4. has been confirmed and completed. Proceed to the Step 5. Shares/Documents";

            $where_equity = array(
                'equity_id' => $equity_id
            );


            //$equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);

            $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);

            $equity_data = $get_equity_user_detail[0];



            $where_user = array(
                'user_id' => $user_id
            );

            $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
             $language_id=GetUserLangCode( $user_id);
            $email_template = $this->db->query("select * from `email_template` where task='Payment Reciept Approved' and language_id=".$language_id);

            $email_temp = $email_template->row();

            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_subject = $email_temp->subject;
            $email_message = $email_temp->message;


            $username = $user_data['user_name'];
            $email = $user_data['email'];
            $email_to = $email;
            $equity_name = SecureShowData($equity_data['company_name']);

            $site_setting = site_setting();
            $site_name = $site_setting['site_name'];
            $taxonomy_setting = taxonomy_setting();
            $project_name = $taxonomy_setting['project_name'];
            $funds = $taxonomy_setting['funds'];

            $email_subject = str_replace('{site_name}', $site_name, $email_subject);
            $email_subject = str_replace('{funds}', $funds, $email_subject);


            $project_link = '<a href="' . site_url('investment/investor/' . $equity_id.'/'.$in_process_id) . '">click here</a>';

            $message_to_owner_link = '<a href="' . site_url('inbox/sendmessage/' . $equity_id) . '">' . site_url('inbox/sendmessage/' . $equity_id) . '</a>';

            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{click_here}', $project_link, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $email_message = str_replace('{message_to_admin}', $message_to_owner_link, $email_message);

            $str = $email_message;

            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

            //send message
            //$login_id = $this->session->userdata('admin_id');

            $data_insert = array(
                'sender_id' => $admin_id,
                'receiver_id' => $user_id,
                'is_read' => 0,
                'message_subject' => $email_subject,
                'message_content' => $str,
                'date_added' => date('Y-m-d H:i:s'),
                'type' => $admin_id,
                'equity_id' => $equity_id
            );

            //$message_insert = $this->message_model->insert_project_profile_message($data_insert);
            $message_setting = message_setting();
            $user_id = $user_id;
            $user_detail = UserData($user_id, array());
            $login_user_detail = UserData($admin_id, array());
            $message_setting->message_enable;

            $message_user_profile_link = '';

            $user_name = $user_detail[0]['user_name'];
            $message_user_name = $login_user_detail[0]['user_name'];
            $content = $str;


            //insert into transaction table
            $where_equity = array(
                'id' => $in_process_id
            );

            $investor_data = $this->investment_step_model->get_equity_process('equity_investment_process', $where_equity);

            $preapprovalKey = $investor_data['transaction_id'];
            $get_other_detail_trans = $this->db->query("select * from temp_preapprove where preapprovalKey='" . $preapprovalKey . "'");
            $detail_trans = $get_other_detail_trans->row();

            $equity_id = $detail_trans->equity_id;
            $donor_id = $detail_trans->user_id;
            $user_all_data = UserData($donor_id);
            $detail_trans->donor_email = $user_all_data[0]['email'];
            $donor_id = $user_id;
            $equity_id = $equity_id;
            $perk_id = $detail_trans->perk_id;


            $donar_comment = SecurePostData($detail_trans->comment);
            $total_amount = $detail_trans->total_amount;
            $project_owner_amount = $detail_trans->total_amount;
            $anonymous = $detail_trans->temp_anonymous;


            $get_other_detail_trans = $this->db->query("select * from transaction where preapproval_key='" . $preapprovalKey . "'");
            $nums_rows = $get_other_detail_trans->num_rows();
            if ($nums_rows <= 0) {
                $insert = $this->db->query("insert into transaction (`user_id`,`equity_id`,`perk_id`,`amount`,`host_ip`,`comment`,`transaction_date_time`,`preapproval_key`,`preapproval_status`,`preapproval_total_amount`)values('" . $donor_id . "','" . $equity_id . "','" . $perk_id . "','" . $project_owner_amount . "','" . $_SERVER['REMOTE_ADDR'] . "','" . $donar_comment . "','" . date("Y-m-d H:i:s") . "','" . $preapprovalKey . "','SUCCESS','" . $total_amount . "')");

                // activity added
                $amount_array = array('amount' => set_currency($total_amount, $equity_id));
                project_activity('funded', $donor_id, $equity_data['user_id'], $equity_id, $amount_array);

                $this->update_project_perk($equity_id, $perk_id, $project_owner_amount);

                $get_project_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
                $prj = $get_project_user_detail[0];
                $user_all_data = UserData($donor_id);
                $user_detail = $user_all_data[0];
                $this->adminalerts($prj, $detail_trans, $user_detail);


                //$insert = $this->db->query("delete from temp_preapprove where preapprovalKey='" . $preapprovalKey . "'" );
            }
        }
        echo json_encode($data);
    }

    /*
    Function name :reject_comment_ship()
    Parameter : $in_process_id
    Return : none
    Use :update status
    */

    function reject_comment_ship($in_process_id = '')
    {


        $admin_id = check_admin_authentication();

        if ($_POST) {

            $reject_comment = SecurePostData($this->input->post('reject_comment'));
            $user_id = SecurePostData($this->input->post('user_id'));
            $equity_id = SecurePostData($this->input->post('equity_id'));
            //$in_process_id = SecurePostData($this->input->post('in_process_id'));
            $update_id = 10;

            if ($reject_comment) {

                $data_update = array(
                    'invest_status_id' => $update_id,
                );

                $this->investment_step_model->AddUpdateData('equity_investment_process', $data_update, $in_process_id, 'id');
                admin_activity('declined_acknowledge_contract', $user_id, 0, $equity_id);
            }


            $where_equity = array(
                'equity_id' => $equity_id
            );


            //$equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);
            $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);

            $equity_data = $get_equity_user_detail[0];



            $where_user = array(
                'user_id' => $user_id
            );

            $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
             $language_id=GetUserLangCode( $user_id);
            $email_template = $this->db->query("select * from `email_template` where task='Document Rejected' and language_id=".$language_id);

            $email_temp = $email_template->row();

            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $site_setting = site_setting();
            $site_name = $site_setting['site_name'];
            $taxonomy_setting = taxonomy_setting();
            $project_name = $taxonomy_setting['project_name'];
            $funds = $taxonomy_setting['funds'];

            $email_subject = $email_temp->subject;


            $email_message = $email_temp->message;

            $username = $user_data['user_name'];
            $email = $user_data['email'];
            $email_to = $email;
            $equity_name = SecureShowData($equity_data['company_name']);


            $email_subject = str_replace('{site_name}', $site_name, $email_subject);
            $message_to_owner_link = '<a href="' . site_url('inbox/sendmessage/' . $equity_id) . '">' . site_url('inbox/sendmessage/' . $equity_id) . '</a>';
            $project_link = '<a href="' . site_url('investment/investor/' . $equity_id.'/'.$in_process_id) . '">click here</a>';

            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{funds}', $funds, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $email_message = str_replace('{click_here}', $project_link, $email_message);
            $email_message = str_replace('{message_to_admin}', $message_to_owner_link, $email_message);
            $email_message = str_replace('{reason}', $reject_comment, $email_message);


            $str = $email_message;

            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

            //send message
            //$login_id = $this->session->userdata('admin_id');

            $data_insert = array(
                'sender_id' => $admin_id,
                'receiver_id' => $user_id,
                'is_read' => 0,
                'message_subject' => $email_subject,
                'message_content' => $str,
                'date_added' => date('Y-m-d H:i:s'),
                'type' => $admin_id,
                'equity_id' => $equity_id
            );

            //$message_insert = $this->message_model->insert_project_profile_message($data_insert);
            $message_setting = message_setting();
            $user_id = $user_id;
            $user_detail = UserData($user_id, array());
            $login_user_detail = UserData($admin_id, array());
            $message_setting->message_enable;

            //$message_user_profile_link = site_url('member/' . $user_id);

            $user_name = $user_detail[0]['user_name'];
            $message_user_name = $login_user_detail[0]['user_name'];
            $content = $str;


        }
        $this->session->set_flashdata('ship_success_msg', STATUS_HAS_BEEN_REJECTED_SUCCESSFULLY);
        redirect('investment/adminstep/' . $in_process_id);


    }

    /*
    Function name :confirm_status()
    Parameter : $equity_id
    Return : none
    Use :update status
    */

    function confirm_status($equity_id = '')
    {


        $user_id = check_user_authentication(false);

        $data_update = array(
            'status' => 1,
            'invest_status_id' => 10
        );

        $where = array(
            'user_id' => $user_id,
            'equity_id' => $equity_id

        );

        $this->investment_step_model->acknowdledge_update($where, 'equity_investment_process', $data_update);
        admin_activity('confirmed_submmited_tracking', $user_id, 0, $equity_id);

        $sql = "update interest_request set payment_status=1 where user_id='" . $user_id . "' and  equity_id='" . $equity_id . "'  and payment_status=0 ";
        $query = $this->db->query($sql);

        $this->session->set_flashdata('success_msg', "Share/Document delivery has been confirmed and marked as delivered successfully.");
        $this->session->set_flashdata('success_investment', YOUR_INVESTMENT_DONE_SUCCESSFULLY);
        $equity = GetOneEquity($equity_id);
        $equity_url = $equity['equity_url'];
        $taxonomy_setting = taxonomy_setting();
        $project_url = $taxonomy_setting['project_url'];
        redirect($project_url . '/' . $equity_url);


    }

    /*
    Function name :payment_process()
    Parameter : $equity_id $user_id
    Return : none
    Use :initiate payment process
    */

    function payment_process($equity_id = '', $user_id = '')
    {


        if (!is_array($_SESSION["donatedata"])) {
            redirect('investment/investment_step_1/' . $equity_id);
        }

        $post_perk_id = $_SESSION["donatedata"]['perks'];
        $post_amount = $_SESSION["donatedata"]['amount'];
        $perk_id = $_SESSION["donatedata"]['perk_id'];
        $post_docomment = $_SESSION["donatedata"]['docomment'];
        $post_anonymous = $_SESSION["donatedata"]['anonymous'];
        $num = 'INV' . randomNumber(12);
        $temp_insert = $this->db->query("insert into temp_preapprove (`preapprovalKey`,`user_id`,`equity_id`,`perk_id`,`comment`,`host_ip`,`transaction_date_time`,`temp_anonymous`,`amount`,`total_amount`)values('" . $num . "','" . $user_id . "','" . $equity_id . "','" . $post_perk_id . "','" . SecurePostData($post_docomment) . "','" . $_SERVER['REMOTE_ADDR'] . "','" . date("Y-m-d H:i:s") . "','" . $post_anonymous . "','" . $post_amount . "','" . $post_amount . "')");
        return $num;

    }

    function payment_process_update($equity_id = '', $user_id = '',$preapprovalKey='')
    {


        if (!is_array($_SESSION["donatedata"])) {
            redirect('investment/investment_step_1/' . $equity_id);
        }

        $post_perk_id = $_SESSION["donatedata"]['perks'];
        $post_amount = $_SESSION["donatedata"]['amount'];
        $perk_id = $_SESSION["donatedata"]['perk_id'];
        $post_docomment = $_SESSION["donatedata"]['docomment'];
        $post_anonymous = $_SESSION["donatedata"]['anonymous'];
       
        $update_data= array('perk_id' => $post_perk_id,
                            'comment' => SecurePostData($post_docomment),
                            'temp_anonymous' => $post_anonymous,
                            'amount' => $post_amount,
                             'total_amount' => $post_amount, );
        $this->db->where('preapprovalKey',$preapprovalKey)->update('temp_preapprove',$update_data);

        return $preapprovalKey;

    }
     /*
    Function name :adminstep()
    Parameter :$equity_id
    Return : none
    Use : load the page and fetch the data related project_id and user_id
    */
    function checkInvestmentSteps($equity_id = '',$investor_process_id=0,$step='1')
    {
        $site_setting = site_setting();
        $user_id = check_user_authentication(true);
         if (!is_numeric($equity_id)) 
         {
            $equity_id=decrypt($equity_id) ;
         } 
         if (!is_numeric($investor_process_id)) 
         {
            $investor_process_id=decrypt($investor_process_id) ;
         } 

        if((int) $equity_id<=0)redirect('home');

        $investment_process_result=array();        
        if((int) $investor_process_id>0 and (!$_POST))
        {               
                $this->db->select('*');
                $this->db->from('equity_investment_process');
                $this->db->where('user_id', $user_id);
                $this->db->where('equity_id', $equity_id);
                $this->db->where('id', $investor_process_id);               
                $query = $this->db->get();
                if ($query->num_rows() > 0) {
                    $investment_process_result=$query->row_array();
                    //redirect to particular steps
                     $page='';   
                     $invest_status_id = $investment_process_result['invest_status_id'];
                     $statusArr= array(1);
                     if(in_array($invest_status_id, $statusArr) and $step!="1")
                     {
                        $page='investment/investment_step_1/'.encrypt($equity_id).'/'.encrypt($investor_process_id);
                     }
                      $statusArr= array(2,3);
                     if(in_array($invest_status_id, $statusArr) and $step!="2")
                     {
                        $page='investment/investment_step_2/'.encrypt($equity_id).'/'.encrypt($investor_process_id);
                     }
                     $statusArr= array(4,5,6);
                     if(in_array($invest_status_id, $statusArr) and $step!="3")
                     {
                        $page='investment/investment_step_3/'.encrypt($equity_id).'/'.encrypt($investor_process_id);
                     }
                     $statusArr= array(7);
                     if(in_array($invest_status_id, $statusArr) and $step!="4")
                     {
                        $page='investment/investment_step_4/'.encrypt($equity_id).'/'.encrypt($investor_process_id);
                     }
                     // var_dump($invest_status_id);
                    if($page!=""){ 
                        redirect($page);
                     }else{
                              $page='investment/investment_step_1/'.encrypt($equity_id).'/'.encrypt($investor_process_id);
                               redirect($page);
                     }
                }
        }
    }
    /*
    Function name :adminstep()
    Parameter :$equity_id
    Return : none
    Use : load the page and fetch the data related project_id and user_id
    */

    function investment_step_1($equity_id = '',$investor_process_id=0)
    {

        $site_setting = site_setting();
        $user_id = check_user_authentication(true);
         if (!is_numeric($equity_id)) 
         {
            $equity_id=decrypt($equity_id) ;
         } 
         if (!is_numeric($investor_process_id)) 
         {
            $investor_process_id=decrypt($investor_process_id) ;
         } 

        if((int) $equity_id<=0)redirect('home');

        $investment_process_result=array();        
        if((int) $investor_process_id>0)
        {               
                // $this->checkInvestmentSteps($equity_id,$investor_process_id,'1');
        }
        

        $data = array();
        $data['error'] = "";
        $data['site_setting'] = $site_setting = site_setting();
        $meta = meta_setting();
        $data['equity_id'] = $equity_id;
        $data['enc_equity_id'] = $enc_equity_id=encrypt($equity_id);
        $data['enc_investor_process_id'] = $enc_investor_process_id=encrypt($investor_process_id);
        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user','investment_tax_relief'), $limit = 10, $order = array('equity_id' => 'desc'),0,'no',1); // store in cache
        $data["equity"] = $equity=$get_equity_user_detail[0];
        $data['perk'] ='';
        $data['preapprovalKey']='';
       // Fetch Data Perks
        if($site_setting["perk_enable"] ==1)
        {
            if (!$this->simple_cache->is_cached('equity_detail_perks' . $equity_id)) {
                $data['perk'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                    'perk'
                ), $limit = 1000, $group = array(), $order = array(
                    'perk.perk_amount' => 'asc'
                ), '');
                $this->simple_cache->cache_item('equity_detail_perks' . $equity_id, $data['perk']);
            } else {
                $data['perk'] = $this->simple_cache->get_item('equity_detail_perks' . $equity_id);
            }
        }    

        //start :validation
        $dataarray['amount'] = SecurePostData($this->input->post('amount'));
        $min_amount_error = '';
        $min_amount = '';
        $max_amount_error = '';
        $max_amount = '';
        if ($dataarray['amount'] > 0) {

            if ($this->input->post('amount') < $equity['minimum_raise']) {
                $min_amount_error = 'min';
                $donation_amount = set_currency($equity['minimum_raise']);
                $min_amount = sprintf(DONATION_MIN_AMOUNT, $donation_amount);
            }
            if ($this->input->post('amount') > $equity['goal']) {
                $max_amount_error = 'max';
                $maximum_donation_amount = set_currency($equity['goal']);
                $max_amount = sprintf(DONATION_MAX_AMOUNT, $maximum_donation_amount);
            }
        }
     
        $this->form_validation->set_rules('amount', DONATION_AMOUNT, 'required|is_numeric');
        
        if ($this->form_validation->run() == FALSE || $min_amount_error == "min" || $max_amount_error == 'max') {
            if (validation_errors()) {
                $data['error'] = validation_errors();
            } elseif ($min_amount_error == "min") {
                $data['error'] = $min_amount;
            } elseif ($max_amount_error == "max") {
                $data['error'] = $max_amount;
            } else {
                $data['error'] = "";
            }
            $dataarray['perks'] = SecurePostData($this->input->post('perks'));
            $dataarray['equity_id'] = $equity_id;
            $dataarray['perk_id'] = SecurePostData($this->input->post('perk_id'));
            $_SESSION["donatedata"] = $dataarray;
            $data['perk_id'] = SecurePostData($this->input->post('perk_id'));
            $data['amount'] = SecurePostData($this->input->post('amount'));   

        } else {
            if ($_POST) {

                $dataarray['perks'] = SecurePostData($this->input->post('perks'));
                $dataarray['equity_id'] = $equity_id;
                $dataarray['perk_id'] = SecurePostData($this->input->post('perk_id'));
                $_SESSION["donatedata"] = $dataarray;
                $data['perk_id'] = SecurePostData($this->input->post('perk_id'));
                $data['amount'] = SecurePostData($this->input->post('amount'));  
                $data['preapprovalKey'] = $preapprovalKey = SecurePostData($this->input->post('preapprovalKey'));  

                    $first_name=$this->session->userdata('user_name');
                    $last_name=$this->session->userdata('last_name');
                    $email=$this->session->userdata('email');
                    newsletterApiSubscribe('donation',$email,$first_name,$last_name);

                if(!$preapprovalKey){
                         $transaction_id = $this->payment_process($equity_id, $user_id);
                        $inv_process = array('equity_id' => $equity_id,
                            'user_id' => $user_id,
                            'invest_status_id' => 1,
                            'transaction_id' => $transaction_id,
                            'created_date' =>  date('Y-m-d H:i:s')
                             );
                        $investment_process_id = $this->investment_step_model->AddUpdateData('equity_investment_process', $inv_process); 
                       
                }else{
                     $this->payment_process_update($equity_id, $user_id,$preapprovalKey);
                     $transaction_id=  $preapprovalKey;
                     $investment_process_id = $investor_process_id ;

                }
                  
                     

                    $enc_investor_process_id=encrypt($investment_process_id);
                    if ($site_setting['contract_copy_status'] == 0 && $site_setting['document_type'] == "hellosign" && $site_setting['hello_sign_apikey'] && $site_setting['hello_sign_client_id']) { 
                        redirect("investment/investment_step_contract/" . $enc_equity_id."/".$enc_investor_process_id);
                        
                    } else{

                        redirect("investment/investment_step_2/" . $enc_equity_id."/".$enc_investor_process_id);
                    }
            }
        }
         $investment_process_result=array();

        if((int) $investor_process_id>0){
          
             $investment_process_result =$this->investment_process_data($user_id,$equity_id,$investor_process_id);
            $data['preapprovalKey']=$investment_process_result->transaction_id;
             $transaction_where = array(
                        'user_id' => $user_id,
                        'equity_id' => $equity_id,
                        'preapproval_key'=>$investment_process_result->transaction_id
                    ); 
                     
                    // print_r($transaction_where);
            $transaction = $this->investment_step_model->get_equity_process('transaction', $transaction_where);
        if(!$transaction ){

            $temp_where = array(
                        'user_id' => $user_id,
                        'equity_id' => $equity_id,
                        'preapprovalKey'=>$investment_process_result->transaction_id
                    ); 
                     
       
                $temp_preapprove = $this->investment_step_model->get_equity_process('temp_preapprove', $temp_where);
                      $data['perk_id'] =$temp_preapprove['perk_id'];
                    $data['temp_anonymous'] =$temp_preapprove['temp_anonymous'];
                    $data['comment'] =$temp_preapprove['comment'];
                    $data['total_amount'] =$temp_preapprove['total_amount'];
                    $data['total_amount'] =$temp_preapprove['total_amount'];
                    $data['amount'] =$temp_preapprove['amount'];
                }else{
                    $data['perk_id'] =$transaction['perk_id'];
                    $data['temp_anonymous'] =$transaction['temp_anonymous'];
                    $data['comment'] =$transaction['comment'];
                    $data['total_amount'] =$transaction['total_amount'];
                    $data['total_amount'] =$transaction['total_amount'];
                    $data['amount'] =$transaction['amount'];
                }
        }
      // var_dump($data);
        //end :validation
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'investment_step/investment_step_1', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();

    }

    function investment_step_contract($equity_id = '',$investor_process_id=0)
    {



        $user_id = check_user_authentication(true);
        $data['encode_equity_id'] = $equity_id;
        $data['encode_investor_process_id'] = $investor_process_id;
        if(!is_numeric($equity_id)) {
            $data['equity_id'] = $equity_id=decrypt($equity_id) ;
        } 
        if(!is_numeric($investor_process_id)) {
            $data['equity_process_id'] = $data['investor_process_id'] = $investor_process_id=decrypt($investor_process_id) ;
        }

        $site_setting = site_setting();

        if ($site_setting['contract_copy_status'] == 0 && $site_setting['document_type'] == "hellosign" && $site_setting['hello_sign_apikey'] && $site_setting['hello_sign_client_id']) 
        {

        }else{
            redirect('investment/investment_step_2/'. $data['encode_equity_id'].'/'.$data['encode_investor_process_id']);
        }


         if (!is_numeric($equity_id)) 
         {
            $data['equity_id'] = $equity_id=decrypt($equity_id) ;
         } 
         if (!is_numeric($investor_process_id)) 
         {
            $data['equity_process_id'] = $data['investor_process_id'] = $investor_process_id=decrypt($investor_process_id) ;
         }
         $data['document_name'] = '';
        if((int) $equity_id<=0)redirect('home');

        $investment_process_result=array();        
        if((int) $investor_process_id>0)
        {               
            // $this->checkInvestmentSteps($equity_id,$investor_process_id,'1');
        }
        $user_id = check_user_authentication(false);
        $investment_process_result=array();

        if((int) $investor_process_id>0){
          
             $investment_process_result =$this->investment_process_data($user_id,$equity_id,$investor_process_id);
            $investor_manage = investor_status($user_id, $equity_id);
            if ($investor_manage['interest_status'] != 4) {
                if(!isset($_SESSION["donatedata"]))
                {
                    redirect('startinvest/index/' . $equity_id);
                }
                else
                {
                    redirect($project_url . '/' . $equity['equity_url']);
                }
            }
            $where = array(
                'user_id' => $user_id,
                'equity_id' => $equity_id,
                'id'=>$investor_process_id
            );
            $result = $this->investment_step_model->get_equity_process('equity_investment_process', $where);
            if(!empty($result)) {
                $session_key = md5($user_id.$equity_id.$investor_process_id);
                if($this->session->userdata($session_key)) {
                    if($result['document_name']) {
                        $this->session->unset_userdata($session_key);
                    } else {
                        redirect(base_url().'investment/sign_contract/' . $data['encode_equity_id'].'/'.$data['encode_investor_process_id']);
                    }
                }
                $data['document_name'] = $result['document_name'];
            }
        }
        $data['session_key'] = md5($user_id.$equity_id.$investor_process_id);
        $data['site_setting'] = $site_setting = site_setting();
        $data['equity_id'] = $equity_id;
        $meta = meta_setting();

        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'investment_step/investment_step_contract', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    function investment_step_2($equity_id = '',$investor_process_id='')
    {


        $site_setting = site_setting();
        // $admin_id = check_admin_authentication();
        $user_id = check_user_authentication(false);
      

        if(!is_numeric($equity_id)) {
            $data['equity_id'] = $equity_id=decrypt($equity_id) ;
        } 
        if(!is_numeric($investor_process_id)) {
            $data['equity_process_id'] = $data['investor_process_id'] = $investor_process_id=decrypt($investor_process_id) ;
        }

         if((int) $investor_process_id>0){
            
             
             $where = array(
                'user_id' => $user_id,
                'equity_id' => $equity_id,
                //'status' => 0,
                'id'=>$investor_process_id

            );
             
              $result = $this->investment_step_model->get_equity_process('equity_investment_process', $where);
              
               if(!empty($result)){
              
                   $data['session_key']=$session_key = md5($user_id.$equity_id.$investor_process_id);

                    if($this->session->userdata($session_key)) {
                        if($result['document_name']) {
                            $this->session->unset_userdata($session_key);
                        } else {
                            redirect(base_url().'investment/sign_contract/' . $equity_id.'/'.$investor_process_id);
                        }
                    }
                   
                    $temp_preapprove_where = array(
                        'user_id' => $user_id,
                        'equity_id' => $equity_id,
                        'preapprovalKey'=>$result['transaction_id']
                    ); 
                     
                    // print_r($transaction_where);
                     $temp_preapprove_res = $this->investment_step_model->get_equity_process('temp_preapprove', $temp_preapprove_where);
                   
                   
                   $transaction_where = array(
                        'user_id' => $user_id,
                        'equity_id' => $equity_id,
                        'preapproval_key'=>$result['transaction_id']
                    ); 
                     
                    // print_r($transaction_where);
                     $transaction = $this->investment_step_model->get_equity_process('transaction', $transaction_where);
                } 
                
              }
              
            if (!empty($result)) {

                $data['acknowledge_note'] = $result['acknowledge_note'];
                $data['equity_process_id'] = $result['id'];
                $data['invest_status_id'] = $result['invest_status_id'];
                $data['shipment'] = $result['shipment'];
                $data['bank_detail'] = $result['bank_detail'];
                $data['document_name'] = $result['document_name'];
                $data['acknowledge_doc'] = $result['acknowledge_doc'];
                $data['status'] = $result['status'];
                $data['contract_sign_file'] = $result['document_name'];
                
               
                
                $data['status_id'] = $result['invest_status_id'];
                $data['gateway_id'] = $result['gateway_id'];
                $data['transaction_id'] = $result['transaction_id'];
                $data['session_key']=$session_key = md5($user_id.$equity_id.$investor_process_id);

            } else {

                $data['acknowledge_note'] = '';
                $data['equity_process_id'] = '';
                $data['shipment'] = '';
                $data['bank_detail'] = '';
                $data['document_name'] = '';
                $data['acknowledge_doc'] = '';
                $data['status'] = '';
                $data['contract_sign_file'] = '';
                $data['status_id'] ='';
                $data['gateway_id'] ='1';
                 $data['transaction_id'] ='';
                   $data['session_key']=$session_key = md5($user_id.$equity_id.$investor_process_id);

                   
            }

            $data["error"] = "";
            $this->load->library('form_validation');


             $this->form_validation->set_rules('document_name', SIGN_CONTRACT, 'required');
            if ($this->form_validation->run() == FALSE) {

            if (validation_errors()) {

                $data["error"] = validation_errors();

            } else {

                $data["error"] = "";

            }
        }else{
            redirect('investment/investment_step_3/'.encrypt($equity_id).'/'.encrypt($investor_process_id));
        }

        $meta = meta_setting();
        $data['site_setting'] = site_setting();

        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'investment_step/investment_step_2', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();

    }

    function investment_step_3($equity_id = '',$investor_process_id=0)
    {
        $site_setting = site_setting();
        $user_id = check_user_authentication(true);
         if (!is_numeric($equity_id)) 
         {
            $equity_id=decrypt($equity_id) ;
         } 
         if (!is_numeric($investor_process_id)) 
         {
            $investor_process_id=decrypt($investor_process_id) ;
         } 

        if((int) $equity_id<=0)redirect('home');

        $investment_process_result=array();        
        if((int) $investor_process_id>0)
        {               
                // $this->checkInvestmentSteps($equity_id,$investor_process_id,'3');
        }
        

        $data = array();
        $data['error'] = "";
        $data['site_setting'] = $site_setting = site_setting();
        $meta = meta_setting();
        $data['equity_id'] = $equity_id;
        $data['enc_equity_id'] = $enc_equity_id=encrypt($equity_id);
        $data['enc_investor_process_id'] = $enc_investor_process_id=encrypt($investor_process_id);
        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user','investment_tax_relief'), $limit = 10, $order = array('equity_id' => 'desc'),0,'no',1); // store in cache
        $data["equity"] = $equity=$get_equity_user_detail[0];

       $where = array('user_id' => $user_id,'equity_id' => $equity_id,'id'=>$investor_process_id);
       $result = $this->investment_step_model->get_equity_process('equity_investment_process', $where);
        $data['status_id'] = $result['invest_status_id'];
        $data['gateway_id'] = $result['gateway_id'];
        $data['transaction_id'] = $result['transaction_id'];

        $transaction_where = array('user_id' => $user_id,'equity_id' => $equity_id,'preapproval_key'=>$result['transaction_id']); 
        $transaction = $this->investment_step_model->get_equity_process('transaction', $transaction_where);

        
        $temp_preapprove_where = array(
            'user_id' => $user_id,
            'equity_id' => $equity_id,
            'preapprovalKey'=>$result['transaction_id']
        ); 
         
        // print_r($transaction_where);
         $temp_preapprove_res = $this->investment_step_model->get_equity_process('temp_preapprove', $temp_preapprove_where);
                   
        if(!empty($transaction)) {
            $data['investor_amount'] = $transaction['amount'];
        } elseif(!empty($temp_preapprove_res)){ 
            $data['investor_amount'] = $temp_preapprove_res['amount'];
        } else {
            if(isset($_SESSION["donatedata"]['amount'])){
                $data['investor_amount'] = $_SESSION["donatedata"]['amount'];
            } else{
                 $data['investor_amount'] = 0;
            }
        }
        $meta = meta_setting(); 
        if($_POST)
        {
            $new_file='';
            $data["notes"] =$notes= SecurePostData($this->input->post('notes'));
            if ($_FILES['file1']['name'] != "") 
            {
                    $_FILES['userfile']['name'] = $_FILES['file1']['name'];
                    $_FILES['userfile']['type'] = $_FILES['file1']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['file1']['tmp_name'];
                    $_FILES['userfile']['error'] = $_FILES['file1']['error'];
                    $_FILES['userfile']['size'] = $_FILES['file1']['size'];
                     $image_settings = get_image_setting_data();
                    //file validation
                    if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif " and $_FILES["userfile"]["type"] != "application/pdf" and $_FILES["userfile"]["type"] != "application/zip") {
                       $data["error"] = PLEASE_UPLOAD_DOC_IMAGE_ZIP_PDF;
                        //PLEASE_UPLOAD_ZIP_OR_PDF_FILE
                    } else if ($_FILES["userfile"]["size"] >  $image_settings['upload_limit']*1000000) 
                    {
                        $data["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);
                    } else 
                    {
                        $filename = $_FILES['file1']['name'];
                        $base_path = $this->config->slash_item('base_path');
                        $rand = rand(0, 100000);                       
                        $path_parts = pathinfo($_FILES['file1']['name']);
                        $date = new DateTime();                      
                        $file_extention = $path_parts['extension'];
                        $new_file = $rand .'-investor-ack-'.$date->getTimestamp().'.'.$file_extention;
                        move_uploaded_file($_FILES["userfile"]["tmp_name"], $base_path . "upload/acknowledge/" . $new_file);

                    }
            }
           
            if($data["error"]=="")
            {
                        $inv_process = array(
                                'invest_status_id' => 7,
                                'acknowledge_doc' => $new_file,
                                'acknowledge_note' =>$notes,
                                'created_date' =>  date('Y-m-d H:i:s')
                            );

                        $investment_process_id = $this->investment_step_model->AddUpdateData('equity_investment_process', $inv_process, $investor_process_id, 'id');
                        admin_activity('acknowledge_contract', $user_id, 0, $equity_id);
                        $history_process = array(
                                'investment_process_id' => $investor_process_id,
                                'invest_status_id' => 7,
                                'acknowledge_doc' => $new_file,
                                'update_date' => date('Y-m-d')
                            );
                        $this->investment_step_model->AddUpdateData('equity_investment_process_history', $history_process);
                         //$enc_investor_process_id=encrypt($investment_process_id);
                        //pending payment entry
                        $preapprovalKey = $result['transaction_id'];

                        $get_other_detail_trans = $this->db->query("select * from temp_preapprove where preapprovalKey='" . $preapprovalKey . "'");
                        $detail_trans = $get_other_detail_trans->row();

                        $equity_id = $detail_trans->equity_id;
                        $donor_id = $detail_trans->user_id;
                        $user_all_data = UserData($donor_id);
                        $detail_trans->donor_email = $user_all_data[0]['email'];
                        $donor_id = $user_id;
                        $equity_id = $equity_id;
                        $perk_id = $detail_trans->perk_id;

                        $gateway_id=1;
                        $donar_comment = SecurePostData($detail_trans->comment);
                        $total_amount = $detail_trans->total_amount;
                        $project_owner_amount = $detail_trans->total_amount;
                        $anonymous = $detail_trans->temp_anonymous;
                        $get_other_detail_trans = $this->db->query("select * from transaction where preapproval_key='" . $preapprovalKey . "'");
                        $nums_rows = $get_other_detail_trans->num_rows();
                        if ($nums_rows <= 0) {
                            $insert = $this->db->query("insert into transaction (`txnid`,`user_id`,`equity_id`,`perk_id`,`amount`,`host_ip`,`comment`,`transaction_date_time`,`preapproval_key`,`preapproval_status`,`preapproval_total_amount`,`gateway_id`)values('" . $preapprovalKey . "','" . $donor_id . "','" . $equity_id . "','" . $perk_id . "','" . $project_owner_amount . "','" . $_SERVER['REMOTE_ADDR'] . "','" . $donar_comment . "','" . date("Y-m-d H:i:s") . "','" . $preapprovalKey . "','PENDING','" . $total_amount . "','" .  $gateway_id . "')");

                            // activity added
                            $amount_array = array('amount' => set_currency($total_amount, $equity_id));
                           
                            project_activity('funded', $donor_id, $equity['user_id'], $equity_id, $amount_array);

                            $this->update_project_perk($equity_id, $perk_id, $project_owner_amount);

                            $get_project_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
                            $prj = $get_project_user_detail[0];
                            $user_all_data = UserData($donor_id);
                            $user_detail = $user_all_data[0];
                            $this->adminalerts($prj, $detail_trans, $user_detail);


                            //$insert = $this->db->query("delete from temp_preapprove where preapprovalKey='" . $preapprovalKey . "'" );
                        }
                         redirect("investment/investment_step_4/" . $enc_equity_id."/".$enc_investor_process_id);
            }
        }

        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'investment_step/investment_step_3', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();

    }

    function investment_step_4($equity_id = '',$investor_process_id=0)
    {
        $site_setting = site_setting();
        $user_id = check_user_authentication(true);
         if (!is_numeric($equity_id)) 
         {
            $equity_id=decrypt($equity_id) ;
         } 
         if (!is_numeric($investor_process_id)) 
         {
            $investor_process_id=decrypt($investor_process_id) ;
         } 

        if((int) $equity_id<=0)redirect('home');

        $investment_process_result=array();        
        if((int) $investor_process_id>0)
        {               
                // $this->checkInvestmentSteps($equity_id,$investor_process_id,'4');
        }
        

        $data = array();
        $data['error'] = "";
        $data['site_setting'] = $site_setting = site_setting();
        $meta = meta_setting();
        $data['equity_id'] = $equity_id;
        $data['enc_equity_id'] = $enc_equity_id=encrypt($equity_id);
        $data['enc_investor_process_id'] = $enc_investor_process_id=encrypt($investor_process_id);
        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user','investment_tax_relief'), $limit = 10, $order = array('equity_id' => 'desc'),0,'no',1); // store in cache
        $data["equity"] = $equity=$get_equity_user_detail[0];

       $where = array('user_id' => $user_id,'equity_id' => $equity_id,'id'=>$investor_process_id);
       $result = $this->investment_step_model->get_equity_process('equity_investment_process', $where);
        $data['status_id'] = $result['invest_status_id'];
        $data['gateway_id'] = $result['gateway_id'];
        $data['transaction_id'] = $result['transaction_id'];
        $transaction_where = array('user_id' => $user_id,'equity_id' => $equity_id,'preapproval_key'=>$result['transaction_id']); 
        $transaction = $this->investment_step_model->get_equity_process('transaction', $transaction_where);
        // var_dump($transaction); die;
        if(!empty($transaction)) {
            $transaction_id = $transaction['transaction_id'];$offset=0;$limit=10;
            $results = $this->repayment_model->investmentProfile($transaction_id, $user_id, 0, $join = array('equity','user'), $limit, $order = array('transaction_id' => 'desc'),$offset,"");
            $data['transactions'] = $results[0];
        }else{
              $temp_preapprove_where = array(
                        'user_id' => $user_id,
                        'equity_id' => $equity_id,
                        'preapprovalKey'=>$result['transaction_id']
                    ); 
                     
                    // print_r($transaction_where);
                $temp_preapprove_res = $this->investment_step_model->get_equity_process('temp_preapprove', $temp_preapprove_where);
                $user_data= UserData($user_id);
                $transaction_merge['email']=$user_data[0]['email'];
                $transaction_merge['user_name'] =$user_data[0]['user_name'];

                $transaction_merge['last_name'] =$user_data[0]['last_name'];
                $transaction_merge['txnid'] ='-';
                $transaction_merge['gateway_id'] ='';
                $transaction_merge['name'] ='';
                $transaction_merge['preapproval_status'] =PENDING;
             $data['transactions'] =   array_merge($temp_preapprove_res,$transaction_merge);
                
        }
         
         $meta = meta_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'investment_step/investment_step_4', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();

    }
    private function investment_process_data($user_id,$equity_id,$investor_process_id)
    {
             $this->db->select('*');
            $this->db->from('equity_investment_process');
            $this->db->where('user_id', $user_id);
            $this->db->where('equity_id', $equity_id);
            $this->db->where('id', $investor_process_id);
           
            $query = $this->db->get();

        

            return $investment_process_result=$query->row();
          
    }
    function resign_document($equity_id='',$investment_process_id='')
    {
        if (!is_numeric($equity_id)) 
         {
            $equity_id=decrypt($equity_id) ;
         } 
         if (!is_numeric($investment_process_id)) 
         {
            $investment_process_id=decrypt($investment_process_id) ;
         } 
        if($investment_process_id>0){
            $this->db->where('id', $investment_process_id);
            $this->db->update('equity_investment_process',array('document_name' =>''  ));
        }
        redirect('investment/sign_contract/'.encrypt($equity_id).'/'.encrypt($investment_process_id));
    }
}

?>
