<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Home extends ROCKERS_Controller
{
    /**
     * Constructor method
     */
    function __construct()
    {
        parent::__construct();
        $this->load->model('account_model');
        $this->load->model('activity_model');

        $this->load->model('follower_model');
        $this->load->model('following_model');
        $this->load->model('home_model');
        $this->load->model('inbox_model');
        $this->load->model('message_model');
        $this->load->model('equity_model');
        $this->load->model('startequity_model');
        $this->load->model('transaction_model');
        $this->load->model('equity_model');
        $this->load->helper('cookie');
        $this->load->library('securimage');
        $this->load->library('email');
        $this->load->library('password');
        $this->load->library('encrypt');
        $this->load->library('pagination');

    }

    /*
	Function name :index()
	Parameter :$msg (message string)
	Return : none
	Use : user can see feature equities,latest equities and other detail
	Description : site home page its default function which called http://hostname/home
	SEO friendly URL which is declare in config route.php file  http://hostname/
	*/
    function index($msg = '')
    {

        //image_clener_db();
        $user_id = check_user_authentication(false);
        $data = array();
        $offset = 0;
        $limit = 6;
        if (is_numeric($msg)) {
            $id = $msg;
            $msg = '';
        }
        $meta = meta_setting();
       
        $data['limit'] = $limit;
        $data['offset'] = $offset;
        $data['msg'] = $msg;


        $latest_equities = $this->equity_model->GetAllEquities(0, 0, 0, '2', array(
            'user'
        ), $limit, array(
            'equity_id' => 'desc'
        ), $offset,'no',1);
        $data['latest_equities'] = $latest_equities;



        $get_all_slider_data = $this->equity_model->GetAllSliderData(array('view_order' => 'asc'));
        $data['get_all_slider_data'] = $get_all_slider_data;


        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->load->helper('url');
        $this->load->library('user_agent');
        if ($this->agent->browser() == 'Internet Explorer' and $this->agent->version() <= 6) {
            $this->template->front_write_view('main_content', 'home/unsupported', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'home/index', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
        //$this->output->enable_profiler(TRUE);
    }

    /*
	Function name :my_equity()
	Parameter :$msg (message string)
	Return : none
	Use : user can see feature equities,latest equities and other detail
	Description : site home page its default function which called http://hostname/home
	SEO friendly URL which is declare in config route.php file  http://hostname/
	*/
    function my_equity($msg = '')
    {
        redirect('home/main_dashboard');
        $user_id = check_user_authentication(true);
        $data = array();
        $offset = 0;
        $limit = 3;
        if (is_numeric($msg)) {
            $id = $msg;
            $msg = '';
        }
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $data['msg'] = $msg;
        // all latest equity

        $latest_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, '', array(
            'user'
        ), 1000, array(
            'equity_id' => 'desc'
        ));
        $data['latest_equities'] = $latest_equities;

        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/my_equity', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :export_user_equity_data()
	Parameter :1
	Return : none
	Use : This function is used for generating csv file about user's equities(Note:But it is not used in actual script).
	*/
    function export_user_equity_data($time = '')
    {
        $user_id = check_user_authentication(true);
        $this->load->dbutil();
        $query = $this->db->query("SELECT equity.company_name, equity.date_added, equity.end_date, equity.amount, IFNULL( equity.amount_get, 0 ) AS amount_get, 

        CASE equity.active

        WHEN  '0'

        THEN  'draft'

        WHEN  '1'

        THEN  'pending'

        WHEN  '2'

        THEN  'active'

        WHEN  '3'

        THEN  'successful'

        WHEN  '4'

        THEN  'unsuccessful'

        WHEN  '5'

        THEN  'failure'

        WHEN  '6'

        THEN  'decline_admin'

        END AS active_stat

        FROM equity

        WHERE user_id =" . $user_id . "

        AND equity.active

        IN ( 1, 2, 3, 4, 5 ) ");
        $delimiter = ",";
        $newline = "\r\n";
        $csv = $this->dbutil->csv_from_result($query, $delimiter, $newline);
        $file_name = "active_user_" . date('d-m-Y') . ".csv";
        $this->force_download($file_name, $csv);
        $this->db->cache_delete_all();
    }

    /*
	Function name :main_dashboard()
	Parameter :1
	Return : none
	Use : This function is used for displaying user dashboard after login.
	Description : This function is called http://hostname/home/main_dashboard.
	*/
    function main_dashboard($status = '', $msg = '')
    {

        $user_id = check_user_authentication(true);
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $data['msg'] = $msg;
        $limit=8;
        // user equities


        if ($status == 'draft') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, '0', array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, '0', array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));


        } else if ($status == 'pending') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 1, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 1, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));

        } else if ($status == 'active') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 2, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 2, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));

        } else if ($status == 'successful') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 3, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 3, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));

        } else if ($status == 'console') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 4, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 4, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));

        } else if ($status == 'failure') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 5, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 5, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));

        } else if ($status == 'decline') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 6, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 6, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));

        }else if ($status == 'inactive-visible') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 7, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 7, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));


        }else if ($status == 'inactive-hidden') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 8, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 8, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));

        } else if ($status == 'all') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));

        } else {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ));
        }

        $config['base_url'] = site_url('home/get_ajax_projects');
        $config['total_rows'] = $user_equities_count;
        $config['per_page'] = $limit;
        $this->pagination->initialize($config);
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();
        $this->pagination->initialize_js_function($jsFunction);
        $data['base_url'] = $config['base_url'];
        $data['pagination_link'] = $this->pagination->create_js_links();


        $equity_count = $this->equity_model->GetAllEquitiesCount($user_id);
        $data['equity_count'] = $equity_count;
        $data['user_equities'] = $user_equities;
        $data['search_status'] = $status;

        // count total posted equity which are running
        $total_running_equities = $this->equity_model->Equity_Counter('equity', 0, 0, $user_id, '2', array(
            'user'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        // count total posted equity which are completed
        $total_completed_equities = $this->equity_model->Equity_Counter('equity', 0, 0, $user_id, '3', array(
            'user'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        $total_equity = $total_running_equities + $total_completed_equities;
        $data['total_running_equities'] = $total_running_equities;
        $data['total_completed_equities'] = $total_completed_equities;
        $data['total_equity'] = $total_equity;
        // count total donation done by you on active equity
        $total_running_donations = $this->equity_model->Equity_Counter('transaction', $user_id, 0, 0, '2', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));

        if ($total_running_donations['total'] != '' || $total_running_donations['total'] != NULL) {
            $total_running_donations = $total_running_donations['total'];
        } else {
            $total_running_donations = 0;
        }
        // count total donation done by you on running equity
        $total_completed_donations = $this->equity_model->Equity_Counter('transaction', $user_id, 0, 0, '3,4', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        if ($total_completed_donations['total'] != '' || $total_completed_donations['total'] != NULL) {
            $total_completed_donations = $total_completed_donations['total'];
        } else {
            $total_completed_donations = 0;
        }

        // count total donation done by you on running equity and completed equity
        $total_donation_done = $total_running_donations + $total_completed_donations;
        $data['total_running_donations'] = $total_running_donations;
        $data['total_completed_donations'] = $total_completed_donations;
        $data['total_donation_done'] = $total_donation_done;
        // count total donation receive by you on active equity
        $total_running_donations_rec = $this->equity_model->Equity_Counter('transaction', 0, 0, $user_id, '2', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        if ($total_running_donations_rec['total'] != '' || $total_running_donations_rec['total'] != NULL) {
            $total_running_donations_rec = $total_running_donations_rec['total'];
        } else {
            $total_running_donations_rec = 0;
        }
        // count total donation receive by you on running equity
        $total_completed_donations_rec = $this->equity_model->Equity_Counter('transaction', 0, 0, $user_id, '3,4', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        if ($total_completed_donations_rec['total'] != '' || $total_completed_donations_rec['total'] != NULL) {
            $total_completed_donations_rec = $total_completed_donations_rec['total'];
        } else {
            $total_completed_donations_rec = 0;
        }

        $total_donation_rec = $total_running_donations_rec + $total_completed_donations_rec;
        $data['total_running_donations_rec'] = $total_running_donations_rec;
        $data['total_completed_donations_rec'] = $total_completed_donations_rec;
        $data['total_donation_rec'] = $total_donation_rec;
        $total_equity_follower['equity_follower'] = $this->follower_model->CountAllFollowerofEquity('', $user_id, array(
            'equity'
        ), 50, array(
            'equity_follow_id' => 'desc'
        ));
        $total_equity_following['equity_following'] = $this->following_model->GetAllCountFollowing('equity_following', $user_id, array(
            'equity'
        ), 50, array(
            'equity_follow_id' => 'desc'
        ));
        if ($total_equity_follower['equity_follower'] != '' || $total_equity_follower['equity_follower'] != NULL) {
            $tot_equity_follower = $total_equity_follower['equity_follower'];
        } else {
            $tot_equity_follower = 0;
        }
        if ($total_equity_following['equity_following'] != '' || $total_equity_following['equity_following'] != NULL) {
            $tot_equity_following = $total_equity_following['equity_following'];
        } else {
            $tot_equity_following = 0;
        }
        $total_following_follower = $tot_equity_follower + $tot_equity_following;
        $data['equity_follower'] = $tot_equity_follower;
        $data['equity_following'] = $tot_equity_following;
        $data['total_equity_follower_following'] = $total_following_follower;
        $data['total_week_equities'] = $this->equity_model->Equity_Counter('equity_week', 0, 0, $user_id, '2,3,4', array(
            'user'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        $data['equity_week_follower'] = $this->follower_model->CountAllFollowerofEquity('equity_week', $user_id, array(
            'equity'
        ), 50, array(
            'equity_follow_id' => 'desc'
        ));
        $transaction_weekly = $this->equity_model->Equity_Counter('transaction_weekly', 0, 0, $user_id, '2,3,4', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        if ($transaction_weekly['total'] != '' || $transaction_weekly['total'] != NULL) {
            $data['transaction_weekly'] = $transaction_weekly['total'];
            $data['transaction_weekly_amount'] = $transaction_weekly['equity_amount'];
        } else {
            $data['transaction_weekly'] = 0;
            $data['transaction_weekly_amount'] = $transaction_weekly['equity_amount'];
        }
        if ($data['transaction_weekly_amount'] != 0) {

            $date = date('Y-m-d');
            $first_day = get_first_day_of_week($date);
            $last_day = get_last_day_of_week($date);
            $data['week_percentage_total'] = number_format(($data['transaction_weekly'] / $data['transaction_weekly_amount']) * 100, 2);
        } else {
            $data['week_percentage_total'] = 0;
        }
        $data['total_week_comment'] = $this->equity_model->Equity_Counter('comment_weekly', 0, 0, $user_id, '2,3', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        $data['show_donation_list_completed'] = $this->equity_model->Equity_Counter('transaction_currency', $user_id, 0, 0, '3,4', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));

        $data['show_donation_list_running'] = $this->equity_model->Equity_Counter('transaction_currency', $user_id, 0, 0, '2', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));

        $data['show_donation_list_rec_completed'] = $this->equity_model->Equity_Counter('transaction_currency', 0, 0, $user_id, '3,4', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));

        $data['show_donation_list_rec_running'] = $this->equity_model->Equity_Counter('transaction_currency', 0, 0, $user_id, '2', array(
            'equity'
        ), 50, array(
            'equity_id' => 'desc'
        ));
        
        
        
       
       $data['show_running_investment_process'] = $this->equity_model->Equity_Counter('runninginvestmentprocess', $user_id, 0, 0, 0, array(), 0, array());
        
        
        
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/main_dashboard', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    function get_ajax_projects($offset=0,$status=''){

        $user_id = check_user_authentication();
        if(!$user_id){
            $return_url = base64_encode('home/dashboard');
            echo "<script>window.location.href='".site_url('home/login/'.$return_url)."'</script>";
        }
        
        $data['site_setting'] = site_setting();
        $limit=8;
        
         if ($status == 'draft') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, '0', array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, '0', array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);


        } else if ($status == 'pending') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 1, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 1, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);

        } else if ($status == 'active') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 2, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 2, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);

        } else if ($status == 'successful') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 3, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 3, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);

        } else if ($status == 'console') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 4, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 4, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);

        } else if ($status == 'failure') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 5, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 5, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);

        } else if ($status == 'decline') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 6, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 6, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);

        }else if ($status == 'inactive-visible') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 7, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 7, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);


        }else if ($status == 'inactive-hidden') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 8, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 8, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);

        } else if ($status == 'all') {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);

        } else {
            $user_equities_count = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ),0,'yes');

             $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), $limit, array(
                'equity_id' => 'desc'
            ),$offset);
        }

        $equity_count = $this->equity_model->GetAllEquitiesCount($user_id);
        $data['equity_count'] = $equity_count;
        $data['user_equities'] = $user_equities;


        $config['base_url'] = site_url('home/get_ajax_projects');
        $config['total_rows'] = $user_equities_count;
        $config['per_page'] = $limit;
        $config["cur_page"] = $offset;
        $this->pagination->initialize($config);
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();
        $this->pagination->initialize_js_function($jsFunction);
        $data['base_url'] = $config['base_url'];
        $data['pagination_link'] = $this->pagination->create_js_links();
        $this->load->view(THEME_LOCATION.'home/ajax_projects', $data);
    }

    /*
	Function name :dashboard_search()
	Parameter :none
	Return : none
	Use : This function is use for equity status.
		
	*/

    function dashboard_search($str)
    {
        $user_id = check_user_authentication(true);
        if ($str == 'all') {
            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, 0, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ));
        } else {
            $user_equities = $this->equity_model->GetAllEquities($user_id, 0, 0, $str, array(
                'user'
            ), null, array(
                'equity_id' => 'desc'
            ));
        }


        $data['user_equities'] = $user_equities;
        $this->load->view(THEME_LOCATION.'home/ajax_search_equity_status', $data);
    }


    function error()
    {

        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/fatal', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :error_page()
	Parameter :none
	Return : none
	Use : This function is use for displaying 404 page.
		This error_page function is called http://hostname/home/error_page.

	*/
    function error_page()
    {
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/404_page', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :login()
	Parameter :none
	Return : none
	Use : This function is use for login user.
	Description : This login function which called http://hostname/home/login.
	Done By : Dharmesh
	*/
    function login($return_url = '')
    {
        if (check_user_authentication() == true) {
            redirect('home');
        }
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = site_setting();
        $data['error_login'] = "";
        // this varible come from start equity invite member
        $invite_data = '';
        $this->load->library('fb_connect');
        if ($return_url == "invite") {
            $referral_cookie = get_cookie('fundraising_member', TRUE);
            if (isset($referral_cookie)) {
                $invite_data = $referral_cookie;
            } else {
                if (isset($_COOKIE['fundraising_member'])) {
                    $invite_data = $_COOKIE['fundraising_member'];
                } elseif (isset($HTTP_COOKIE_VARS['fundraising_member'])) {
                    $invite_data = $HTTP_COOKIE_VARS['fundraising_member'];
                }
            }

            if ($invite_data != "") {
                $invite_data_msg = '';
                $arr = explode("/", $invite_data);
                if (count($arr) > 1) {
                    $equity_id = $arr[3];
                    $user_id = $arr[4];
                    $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
                    $equity = $get_equity_user_detail[0];
                    if ($user_id <= 0) $user_id = $prj['user_id'];
                    $user_detail = $this->account_model->GetAllUsers($user_id);
                    $user_detail = $user_detail[0];
                    $company_name = $equity['company_name'];
                    if ($company_name == '') $company_name = 'Untitled';
                    $user_name = $user_detail['user_name'] . " " . $user_detail['last_name'];
                    $user_email = $arr[1];
                    $redirct = 'equity/invite_thankyou/' . $arr[2] . '/' . $arr[3];
                    $return_url = base64_encode($redirct);
                    $invite_data_msg = sprintf(INVITE_MSGS, $user_name, $company_name, $site_setting['site_name']);
                }
            } else {
                $return_url = '';
            }
        }
        $data['femail'] = '';
        $temp = $this->input->cookie('tubestart');
        $data['email'] = '';
        $data['password'] = '';
        $data['remember'] = '';
        $data['error_forget'] = '';
        $data['page'] = $return_url;
        if (!empty($temp)) {
            $arr = explode("^", $temp);
            if (isset($arr[0])) $data['email'] = $this->encrypt->decode($arr[0]);
            if (isset($arr[1])) $data['password'] = $arr[1];
            $data['remember'] = '1';
        }
        $this->load->library('form_validation');
        $this->form_validation->set_rules('email', EMAIL_ADDRESS, 'required|valid_email|trim');
        $this->form_validation->set_rules('password', PASSWORD, 'required|trim|min_length[8]|max_length[20]');
        $chk_user = 'false';
        //   Check spamer

        $spamer = $this->home_model->spam_protection();
        if ($spamer) {
            $chk_user = 'true';
        }
           $captcha_result = '';

        require(base_path() . '/application/libraries/ReCaptcha/src/autoload.php');


        $secret = $site_setting['captcha_private_key'];


        if ($_POST) {
            if ($site_setting['signup_captcha'] == 1) {
                $recaptcha = new \ReCaptcha\ReCaptcha($secret);
                $session_ip_address = $this->session->userdata('ip_address');
                $resp = $recaptcha->verify($_POST['g-recaptcha-response'], $session_ip_address);

                if ($resp->isSuccess()) {
                    $captcha_result = '';
                } else {
                    $captcha_result = '<p>' . IMAGE_VERIFICATION_WRONG . '</p>';
                }
            }
        }



        if ($this->form_validation->run() == FALSE || $chk_user == 'true' || $captcha_result != "") {
            $data['error_login'] = "";
            if (validation_errors() || $captcha_result != "") {
                $data['error_login'] = validation_errors(). $captcha_result;
            } else {
                $data['error_login'] = '';
            }
            if ($chk_user == 'true') {
                $spam_message = "<p>" . IPBAND_CANNOTREG_NOW_SIGNIN . "</p>";
                $data['error_login'] = $spam_message;
            }
            if ($_POST) {
                $data['email'] = SecurePostData($this->input->post('email'));
                $data['page'] = SecurePostData($this->input->post('page'));
                $data['password'] = '';
                $data['remember'] = SecurePostData($this->input->post('remember'));
            }
        } else {
            $login_data = array(
                'email' => SecurePostData($this->input->post('email')),
                'password' => SecurePostData(md5($this->input->post('password'))),
            );


            $chk = $this->home_model->user_validate($login_data, 'login');

            if ($chk != 'FALSE') {
                if ($chk['active'] == '1') {
                    $data = array(
                        'user_id' => $chk['user_id'],
                        'user_name' => $chk['user_name'],
                        'last_name' => $chk['last_name'],
                        'email' => $chk['email'],
                    );
                    $this->session->set_userdata($data);
                    if ($this->input->post('remember') == 1) {
                        // delete cokiies and reset it
                        $cookie = array(
                            'name' => 'tubestart',
                            'value' =>  $this->encrypt->encode($this->input->post('email')),
                            'expire' => -time() + (3600 * 24),
                            'domain' => '',
                            'path' => '/',
                            'prefix' => ''
                        );
                        $this->input->set_cookie($cookie);
                       
                    } else {
                        delete_cookie('tubestart');
                    }
                    if ($invite_data != "") {
                        $arr = explode("/", $invite_data);
                        $sql = "update invite_members set status=1 ,code='' where code='" . $arr[0] . "'";
                        $this->db->query($sql);
                        delete_cookie('fundraising_member');
                    }
                    $data['page'] = SecurePostData($this->input->post('page'));
                    if ($data['page'] != '') {
                        $return_page = base64_decode($data['page']);
                        redirect($return_page);
                    } else {
                        redirect('home/index/login');
                    }

                } elseif ($chk['active'] == '2') {
                    $data['error_login'] = "<p> " . YOUR_EMAIL_ADDRESS_IS_SUSPENDED . "</p>";
                } elseif ($chk['active'] == '0') {
                    $data['error_login'] = "<p>" . YOUR_ACCOUNT_INACTIVE_ADMIN . "</p>";
                } else {
                    $data['error_login'] = "<p>" . INACTIVE_ACCOUNT_AFTER_SIGNUP . "<br/>" . RESEND_VERIFICATION_LINK . " " . anchor('home/resend', CLICK_HERE, 'style="color:#870835"') . "</p>";
                }
            } else {
                $data['error_login'] = "<p> " . EMAIL_ADDRESS_OR_PASSWORD_ARE_INVALID . "</p>";
            }
        }
        if ($invite_data != "") {
            $data['error_login'] = $invite_data_msg;
        }

        if ($return_url == "inactive") {
            $data['error_login'] = "<p>" . YOUR_ACCOUNT_INACTIVE_ADMIN . "</p>";
        } else if ($return_url == "suspend") {
            $data['error_login'] = "<p> " . YOUR_EMAIL_ADDRESS_IS_SUSPENDED . "</p>";
        }

        $data['page'] = $return_url;


        $this->template->write('meta_title', LOGIN . ' -' . $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/login', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :forget_password()
	Parameter :none
	Return : none
	Use : This function is use to send forget password to user's account.
	Description : forget_password function which called http://hostname/home/forget_password.
	*/
    function forget_password()
    {

        $user_id = check_user_authentication(false);
         $this->load->library('fb_connect');
        if($user_id) redirect('home');
        
        $data['email'] = '';
        $data['femail'] = '';
        $data['page'] = '';
        $data['password'] = '';
        $data['remember'] = '';
        $data['error_forget'] = '';
        $data['error_login'] = '';
        $this->load->library('form_validation');
            $captcha_result = '';

        require(base_path() . '/application/libraries/ReCaptcha/src/autoload.php');
        $data['site_setting'] = $site_setting= site_setting();

        $secret = $site_setting['captcha_private_key'];


        if ($_POST) {
            if ($site_setting['signup_captcha'] == 1) {
                $recaptcha = new \ReCaptcha\ReCaptcha($secret);
                $session_ip_address = $this->session->userdata('ip_address');
                $resp = $recaptcha->verify($_POST['g-recaptcha-response'], $session_ip_address);

                if ($resp->isSuccess()) {
                    $captcha_result = '';
                } else {
                    $captcha_result = '<p>' . IMAGE_VERIFICATION_WRONG . '</p>';
                }
            }
        }
        $this->form_validation->set_rules('femail', EMAIL_ADDRESS, 'required|valid_email|trim');
        $chk_user = 'false';
        //   Check spamer


        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            $chk_user = 'true';
        }
        if ($this->form_validation->run() == FALSE || $chk_user == 'true'|| $captcha_result != "") {
            $data['error_forget'] = "";
            if (validation_errors() || $captcha_result != "") {
                $data['error_forget'] = validation_errors(). $captcha_result;
            } else {
                $data['error_forget'] = '';
            }
            if ($chk_user == 'true') {
                $data['error_forget'] = "<p>" . IPBAND_CANNOTREG_NOW . "</p>";
            }
            $data['femail'] = SecurePostData($this->input->post('femail'));
        } else {
            $em = array(
                'email' => SecurePostData($this->input->post('femail'))
            );


            $check_email = $this->home_model->user_validate($em);
            if ($check_email != '') {
                if ($check_email['active'] == 1) {
                    $forgot_unique_code = randomNumber(20);
                    $fdata = array(
                        'forgot_unique_code' => $forgot_unique_code,
                        'request_date' => date('Y-m-d H:i:s'),
                    );


                    $set = $this->account_model->UpdateAccount('user_id', $check_email['user_id'], 'user', $fdata);
                    $cache_file_name = 'user_detail' . $check_email['user_id'];
                    setting_deletecache($cache_file_name);
                    $cache_file_name = 'user_detail_notification' . $check_email['user_id'];
                    setting_deletecache($cache_file_name);
                    if ($set != '') {
                        $result = UserData($check_email['user_id']);
                         $language_id=GetUserLangCode( $check_email['user_id']);
                        $email_template = $this->db->query("select * from `email_template` where task='Forgot Password Request' and language_id=".$language_id);
                        $email_temp = $email_template->row();
                        $email_address_from = $email_temp->from_address;
                        $email_address_reply = $email_temp->reply_address;
                        $email_subject = $email_temp->subject;
                        $email_message = $email_temp->message;
                        $username = $result[0]['user_name'];
                        $email = $result[0]['email'];
                        $email_to = $email;
                        // $login_link=site_url('home/reset_password/'.$result[0]['forgot_unique_code']);
                        $login_link = '<a href="' . site_url('home/reset_password/' . $result[0]['forgot_unique_code']) . '">' . site_url('home/reset_password/' . $result[0]['forgot_unique_code']) . '</a>';
                        $email_message = str_replace('{break}', '<br/>', $email_message);
                        $email_message = str_replace('{user_name}', $username, $email_message);
                        $email_message = str_replace('{login_link}', $login_link, $email_message);
                        $str = $email_message;
                        email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                    } else {
                        $data["error_forget"] = "<p>" . RESET_PASSWORD_FAILED . "</p>";
                    }
                    $data['error_forget'] = "success";
                } elseif ($check_email['active'] == 2) {
                    $data['error_forget'] = "<p>" . YOUR_EMAIL_ADDRESS_IS_SUSPENDED . "</p>";
                } elseif (is_null($check_email['active']) || $check_email['active'] == 0) {
                    $data['error_forget'] = "<p>" . INACTIVE_ACCOUNT_AFTER_SIGNUP . "<br/>" . RESEND_VERIFICATION_LINK . " " . anchor('home/resend', CLICK_HERE, 'style="color:#870835"') . "</p>";
                }
            } else {
                $data["error_forget"] = "<p>" . EMAIL_ADDRESS_NOT_FOUND . "</p>";
            }
        }
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $this->template->write('meta_title', LOGIN . ' -' . $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/login', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :reset_password()
	Parameter :forgot_unique_code
	Return : none
	Use : This function is use for reset the user password.
	*/
    function reset_password($forgot_unique_code = null)
    {
        $chk_forget_code = $this->home_model->checkForgetUniqueCode(SecurePostData($forgot_unique_code));
        if ($chk_forget_code == 'expire') {
            redirect('home/index/expire');
        }
        if ($chk_forget_code == 'not_sent') {
            redirect('home/index/not_sent');
        }
        $user_id = $chk_forget_code;
        $this->load->library('form_validation');
        $this->form_validation->set_rules('password', PASSWORD, 'required|valid_password|trim');
        $this->form_validation->set_rules('cpassword', RETYPE_PASSWORD, 'required|min_length[8]|max_length[20]|matches[password]|trim');
        $chk_user = 'false';
        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            $chk_user = 'true';
        }
        if ($this->form_validation->run() == FALSE || $chk_user == 'true') {
            $data['error'] = "";
            if (validation_errors()) {
                $data['error'] = validation_errors();
            } else {
                $data['error'] = '';
            }
            if ($chk_user == 'true') {
                $spam_message = "<p>" . IPBAND_CANNOTREG_NOW . "</p>";
                $data['error'] = $spam_message;
            }
            if ($this->input->post('user_id')) {
                $data['user_id'] = SecurePostData($this->input->post('user_id'));
                $data['forgot_unique_code'] = SecurePostData($this->input->post('forget_unique_code'));
            } else {
                $data['user_id'] = $user_id;
                $data['forgot_unique_code'] = $forgot_unique_code;
            }
            $data['password'] = '';
            $data['cpassword'] = '';
        } else {
            $spass = array(
                'password' => SecurePostData(md5($this->input->post('password')))
            );
            $set = $this->home_model->setNewPassword($user_id, $spass);
            if ($set != '') {
                redirect('home/index/reset_success');
            } else {
                redirect('home/index/reset_fail');
            }
        }
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $this->template->write('meta_title', RESET_PASSWORD . ' -' . $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/reset_password', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :findreferid($findreferid='')
	Parameter :findreferid
	Return : none
	Use : This function is use to .
	*/
    function findreferid($findreferid = '')
    {
        $reference_user_id = 0;
        if ($findreferid != '') {
            $invite_code = $findreferid;
        } else {
            // $referral_cookie=get_cookie('invite_code',TRUE);
            $referral_cookie = get_cookie('invite_code', TRUE);
            if (isset($referral_cookie)) {
                $invite_code = $referral_cookie;
            } else {
                if (isset($_COOKIE['invite_code'])) {
                    $invite_code = $_COOKIE['invite_code'];
                } elseif (isset($HTTP_COOKIE_VARS['invite_code'])) {
                    $invite_code = $HTTP_COOKIE_VARS['invite_code'];
                } else {
                    $invite_code = '';
                }
            }
        }
        if ($invite_code != '') {
            $check_reference_user = $this->db->get_where('user', array(
                'unique_code' => $invite_code
            ));
            if ($check_reference_user->num_rows() > 0) {
                $get_reference_user = $check_reference_user->row();
                $reference_user_id = $get_reference_user->user_id;
                $reference_user_id;
            } else {
                $reference_user_id = 0;
            }
        }

    }

    /*
	Function name :signup($invite_code='')
	Parameter :code
	Return : none
	Use : This function is use for register user.
	     site register page its Signup function which called http://hostname/home/signup.
	*/
    function signup($invite_code = '',$invite_email='')
    {
        if($this->session->userdata('user_id')>0){
            redirect('home');
        }
        $this->load->library('fb_connect');
        
        
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $this->load->library('form_validation');
        $this->form_validation->set_rules('user_name', NAME, 'required|trim|min_length[3]|max_length[40]|alpha_space');
        $this->form_validation->set_rules('email', EMAIL_ADDRESS, 'required|trim|valid_email');
         $this->form_validation->set_rules('phone', PHONE, 'required|trim|numeric|max_length[15]');
        $this->form_validation->set_rules('remail', RETYPE_EMAIL, 'required|trim|valid_email|matches[email]');
        $this->form_validation->set_rules('password', PASSWORD, 'required|trim|valid_password');
        $this->form_validation->set_rules('cpassword', RETYPE_PASSWORD, 'required|trim|min_length[8]|max_length[20]|matches[password]');
        if ($invite_code != '') {
            $data['user_invite_code'] = $invite_code;
        } else {
            $data['user_invite_code'] = '';
        }
        
         if ($invite_email != '') {
            $data['email'] = base64_decode($invite_email);
        } else {
            $data['email'] = "";
        }
        
        $data['user_name'] = "";
        $data['email'] = "";
        $data['agree'] = "";
         $data['phone'] = "";
        $chk_user = 'false';
        //   Check spamer
        setting_deletecache('spam_protectd');
        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            $chk_user = 'true';
        }
        $check_user = '';
        if ($_POST) {
            if ($this->username_check(SecurePostData($this->input->post('email'))) == 1) {
                $check_user = EXISTS_ACCOUNT_ASSOCIATE_WITHMAIL . '<br />';
            }
        }
        $captcha_result = '';
        
        require(base_path().'/application/libraries/ReCaptcha/src/autoload.php'); 

        $siteKey = $site_setting['captcha_public_key'];
        $secret = $site_setting['captcha_private_key'];

        
        if ($_POST)
        {
            if ($site_setting['signup_captcha'] == 1) { 
                $recaptcha = new \ReCaptcha\ReCaptcha($secret);
                $session_ip_address = $this->session->userdata('ip_address');
                $resp = $recaptcha->verify($_POST['g-recaptcha-response'], $session_ip_address);
                
                if ($resp->isSuccess())
                {
                    $captcha_result = '';
                }
                else
                {
                    $captcha_result = '<p>' . IMAGE_VERIFICATION_WRONG . '</p>';
                }
            }
        }
        //   Check validations
        if ($this->form_validation->run($this) == FALSE || $chk_user == 'true' || $check_user != '' || $captcha_result != "") {
            $data['error'] = "";
            if (validation_errors() || $check_user != '' || $captcha_result != "") {
                $data['error'] = validation_errors() . $check_user . $captcha_result;
            } else {
                $data['error'] = '';
            }
            if ($chk_user == 'true') {
                $spam_message = "<p>" . IPBAND_CANNOTREG_NOW . "</p>";
                $data['error'] = $spam_message;
            }
            if ($_POST) {
                $data['user_name'] = SecurePostData($this->input->post('user_name'));
                $data['agree'] = SecurePostData($this->input->post('agree'));
                $data['email'] = SecurePostData($this->input->post('email'));
                 $data['phone'] = SecurePostData($this->input->post('phone'));
                $data['user_invite_code'] = SecurePostData($this->input->post('user_invite_code'));
            }
        } else {
            //   Check spam register
            $chk_spam_register = $this->home_model->check_spam_register();
            if ($chk_spam_register == 1) {
                $data['user_name'] = SecurePostData($this->input->post('user_name'));
                $data['email'] = SecurePostData($this->input->post('email'));
                 $data['phone'] = SecurePostData($this->input->post('phone'));
                $data["error"] = "<p> " . IPBAND_CANNOTREG_NOW . "</p>";
            } else {
                $invite_code_id = SecurePostData($this->input->post('user_invite_code'));
                $find_refeer_id = $this->findreferid($invite_code_id);
                $name = explode(' ', SecurePostData($this->input->post('user_name')));

                //first name and last name from full name
                $f_name = isset($name[0]) ? $name[0] : '';
                $l_name = isset($name[1]) ? $name[1] : '';
                  $language_id=GetUserLangCode();
                //echo $hash = $this->password->create_hash(SecurePostData($this->input->post('password')));
                $user_data = array(
                    'user_name' => SecurePostData($f_name),
                    'last_name' => SecurePostData($l_name),
                    'email' => SecurePostData($this->input->post('email')),
                    'password' => SecurePostData(md5($this->input->post('password'))),
                    //'password' => SecurePostData($this->password->create_hash($this->input->post('password'))),
                    'signup_ip' => SecurePostData($_SERVER['REMOTE_ADDR']),
                    'date_added' => SecurePostData(date('Y-m-d H:i:s')),
                    'confirm_key' => randomNumber(20),
                    'unique_code' => unique_user_code(getrandomCode(12)),
                    'reference_user_id' => $find_refeer_id,
                     'phone' => SecurePostData($this->input->post('phone')),
                     'user_language_id'=>$language_id
                );

                $sign = $this->home_model->register($user_data);

                 $first_name=$user_data['user_name'];
                    $last_name=$user_data['last_name'];
                    $email=$user_data['email'];
                    newsletterApiSubscribe('sign_up',$email,$first_name,$last_name);
                //////////end of activities////////////////////////////////
                if ($sign) {
                    // ///////////============new user email===========
                    $site_setting = site_setting();
                    $site_name = $site_setting['site_name'];
                    $taxonomy_setting = taxonomy_setting();
                    $project_name = $taxonomy_setting['project_name'];
                    $project_owner_name = $taxonomy_setting['project_owner'];
                    $funds_name = $taxonomy_setting['funds'];
                    $funds_gerund = $taxonomy_setting['funds_gerund'];
                    $funds_plural = $taxonomy_setting['funds_plural'];
                    $result = UserData($sign);
                     $language_id=GetUserLangCode($sign);
                    $email_template = $this->db->query("select * from `email_template` where task='New User Join' and language_id=".$language_id);
                    $email_temp = $email_template->row();
                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_subject = $email_temp->subject;
                    $email_subject = str_replace('{site_name}', $site_name, $email_subject);
                    $email_message = $email_temp->message;
                    $username = SecureShowData($this->input->post('user_name'));
                    $password = SecureShowData($this->input->post('password'));
                    $email = SecureShowData($this->input->post('email'));
                    $email_to = SecureShowData($this->input->post('email'));
                    $login_link = '<a href="' . site_url('home/confirm_account/' . $result[0]['user_id'] . '/' . $result[0]['confirm_key']) . '">' . site_url('home/confirm_account/' . $result[0]['user_id'] . '/' . $result[0]['confirm_key']) . '</a>';
                    $create_step_link = '<a href="' . site_url('start_equity/create_prestep') . '">' . site_url('start_equity/create_prestep') . '</a>';
                    $user_accrediation_link = '<a href="' . site_url('accreditation/personal') . '">' . site_url('accreditation/personal') . '</a>';
                    $email_message = str_replace('{break}', '<br/>', $email_message);
                    $email_message = str_replace('{user_name}', $username, $email_message);
                    $email_message = str_replace('{project_name}', $project_name, $email_message);
                    $email_message = str_replace('{project_owner_name}', $project_owner_name, $email_message);
                    $email_message = str_replace('{funds_name}', $funds_name, $email_message);
                    $email_message = str_replace('{funds_plural}', $funds_plural, $email_message);
                    $email_message = str_replace('{funds_gerund}', $funds_gerund, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);
                    $email_message = str_replace('{verify_link}', $login_link, $email_message);
                    $email_message = str_replace('{create_step_link}', $create_step_link, $email_message);
                    $email_message = str_replace('{user_accrediation_link}', $user_accrediation_link, $email_message);
                    $str = $email_message;

                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                    $invite_code = get_cookie('equity_member', TRUE);
                    if ($invite_code != '') {
                        $invite_code = $this->encrypt->decode($invite_code);
                        $member = $this->db->get_where('invite_members', array('code' => $invite_code))->row_object();
                        if($member->email == $email) {
                            $sql = "update invite_members set status= 1 ,invite_user_id=" . $sign . " ,code='' where code='" . $invite_code . "'";
                            $this->db->query($sql);
                            $sql = "update equity_team_member set user_id=" . $sign . "  where invited_member_id='" . $member->id . "'";
                            $this->db->query($sql);
                            delete_cookie("equity_member");
                        }
                    }
                    redirect('home/index/signup');
                } else {
                    redirect('home/index');
                }
            }
        }
        $data['show_email'] = false;
        if($invite_code == 'team_member' && $invite_code = get_cookie('equity_member', TRUE)) {
            $invite_code = $this->encrypt->decode($invite_code);
            $data['member'] = $this->db->get_where('invite_members', array('code' => $invite_code))->row_object();
            if($data['member']) {
                $data['show_email'] = true;
            }
        }
        
        $this->template->write('meta_title', SIGN_UP . ' -' . $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/signup', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :username_check()
	Parameter :none
	Return : none
	Use : This is a callback function which is use to check this user exist or not.
	*/
    function username_check($email)
    {
        $email1 = array(
            'email' => $email
        );
        $username = $this->home_model->user_validate($email1);
        if ($username != 'FALSE') {
            // $this->form_validation->set_message('username_check', EXISTS_ACCOUNT_ASSOCIATE_WITHMAIL);
            return 1;
        } else {
            return 0;
        }
    }

    /*
	Function name :logout()
	Parameter :none
	Return : none
	Use : This is used to logout here it destroy the session and cookie.
	*/
    function logout($type = '')
    {
        $this->load->helper('cookie');

        //$this->session->sess_destroy();
        $this->session->unset_userdata('user_id');
         $this->session->unset_userdata('twitter');
         $_SESSION=array();

        $data['logged_out'] = TRUE;
        if ($type == '') {
            redirect("home/index");
        } else if ($type == '0') {
            redirect("home/index/0");
        } else if ($type == '2') {
            redirect("home/index/2");
        }
    }

    /*
	Function name :confirm_account()
	Parameter :id is userid and key is confirm key
	Return : none
	Use : This is used to match the confirm key and active the user.
	*/
    function confirm_account($id = null, $key = '', $admin = '')
    {
        $ud = array(
            'user_id' => SecurePostData($id)
        );
        $cuser = $this->home_model->user_validate($ud);
        //print_r($cuser);
        if ($cuser) {

            if (intval($cuser['active']) == 1 && $admin != '') {
                $msg = 'update';
                redirect('admin/user/list_user/' . $msg);
            }

            if (intval($cuser['active']) == 1) {
                $msg = 'cant_click';
                redirect('home/index/' . $msg);
            }

            $msg = '';
            if ($cuser['confirm_key'] == $key) {
                $ud = array(
                    'active' => 1,
                    'confirm_key' => '1',
                );


                $cuser = $this->account_model->UpdateAccount('user_id', $id, 'user', $ud);
                user_activity('signup', $id, 0, 0);

                $result = UserData($id);

                $check_team_member_array = array("email" => $result[0]['email']);
                $team_member_signup = $this->startequity_model->getTableData('invite_members', $check_team_member_array);
                $team_member_data = $team_member_signup[0];
                if (is_array($team_member_data)) {
                    if ($result[0]['email'] == $team_member_data['email']) {
                        project_activity_feedback('team_member_added', $id, '', '', array('company_id' => $team_member_data['company_id']));
                    }
                }
                $site_setting = site_setting();
                $site_name = $site_setting['site_name'];
                 $language_id=GetUserLangCode( $id);
                $email_template = $this->db->query("select * from `email_template` where task='Welcome Email' and language_id=".$language_id);
                $email_temp = $email_template->row();
                $email_address_from = $email_temp->from_address;
                $email_address_reply = $email_temp->reply_address;
                $email_subject = $email_temp->subject;
                $email_message = $email_temp->message;
                $username = $result[0]['user_name'];
                $email = $result[0]['email'];
                $email_to = $email;
                $email_message = str_replace('{user_name}', $username, $email_message);
                $email_message = str_replace('{email}', $email, $email_message);
                $email_message = str_replace('{site_name}', $site_name, $email_message);
                $str = $email_message;

                email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                // ///////////============welcome email===========

                $msg = 'success';
            } elseif ($cuser['confirm_key'] == '1' and $cuser['active'] == '1') {
                $msg = 'active';
            } else {
                $msg = 'error';
            }
        } else {
            $msg = 'error';
        }

        if ($admin != '') {
            $msg = 'update';
            redirect('admin/user/list_user/' . $msg);
        }
        redirect('home/index/' . $msg);
    }

    /*
	Function name :resend()
	Parameter :none
	Return : none
	Use : This is used when the user login in without user activate then it send a link you confirm account first.
	*/
    function resend()
    {
        $this->load->library('fb_connect');
        
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $data['email'] = '';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('email', EMAIL_ADDRESS, 'required|valid_email|trim');
        $chk_user = 'false';
        //   Check spamer
        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            $chk_user = 'true';
        }
        //   Check validations
        if ($this->form_validation->run() == FALSE || $chk_user == 'true') {
            $data['error'] = "";
            if (validation_errors()) {
                $data['error'] = validation_errors();
            } else {
                $data['error'] = '';
            }
            if ($chk_user == 'true') {
                $spam_message = "<p>" . IPBAND_CANNOTREG_NOW . "</p>";
            }
        } else {
            $em = array(
                'email' => SecurePostData($this->input->post('email'))
            );
            $check_email = $this->home_model->user_validate($em);
            // print_r($check_email);
            if ($check_email) {
                if ($check_email['active'] == 0) {
                    $confirm_key = randomNumber(20);
                    $fdata = array(
                        'confirm_key' => $confirm_key
                    );
                    $set = $this->account_model->UpdateAccount('user_id', $check_email['user_id'], 'user', $fdata);

                    // ///////////============new user email===========
                    if ($set != '') {

                        $result = UserData($check_email['user_id']);
                         $language_id=GetUserLangCode( $check_email['user_id']);
                        $email_template = $this->db->query("select * from `email_template` where task='Email Verification' and language_id=".$language_id);
                        $email_temp = $email_template->row();
                        $site_name = $site_setting['site_name'];
                        $email_address_from = $email_temp->from_address;
                        $email_address_reply = $email_temp->reply_address;
                        $email_subject = $email_temp->subject;
                        $email_message = $email_temp->message;
                        $username = SecureShowData($result[0]['user_name']);
                        $password = SecureShowData($result[0]['password']);
                        $email = SecureShowData($result[0]['email']);
                        $email_to = SecureShowData($result[0]['email']);
                        $taxonomy_setting = taxonomy_setting();
                        $project = $taxonomy_setting['project_name'];
                        $projects = $taxonomy_setting['project_name_plural'];

                        $funds = $taxonomy_setting['funds'];
                        $project_explor_link = '<a href="' . site_url('category/search') . '">' . $projects . '</a>';
                        $create_step_link = '<a href="' . site_url('start_equity/create_prestep') . '">' . CREATE . '</a>';

                        $login_link = '<a href="' . site_url('home/confirm_account/' . $result[0]['user_id'] . '/' . $result[0]['confirm_key']) . '">Click Here</a>';
                        $email_message = str_replace('{break}', '<br/>', $email_message);
                        $email_message = str_replace('{user_name}', $username, $email_message);
                        $email_message = str_replace('{password}', $password, $email_message);
                        $email_message = str_replace('{site_name}', $site_name, $email_message);

                        $email_message = str_replace('{email}', $email, $email_message);
                        $email_message = str_replace('{project_name}', $project, $email_message);
                        $email_message = str_replace('{donation_name}', $funds, $email_message);
                        $email_message = str_replace('{login_link}', $login_link, $email_message);
                        $email_message = str_replace('{create_step_link}', $create_step_link, $email_message);
                        $email_message = str_replace('{project_name_explor}', $project_explor_link, $email_message);
                        $email_subject = str_replace('{site_name}', $site_name, $email_subject);
                        $str = $email_message;
                        email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                        redirect('home/index/resend_success');
                    } else {
                        $data["error"] = "<p>" . RESEND_VERIFICATION_FAILED . "</p>";
                    }
                    // ///////////============new user email===========
                } elseif ($check_email['active'] == 2) {
                    $data['error'] = "<p> " . YOUR_EMAIL_ADDRESS_IS_SUSPENDED . "</p>";
                } else {
                    $data['error'] = "<p>" . YOUR_ACCOUNT_ALREADY_ACTIVE . "</p>";
                }
            } else {
                $data["error"] = "<p> " . EMAIL_ADDRESS_NOT_FOUND . "</p>";
            }
        }
        $this->template->write('meta_title', RESEND_VARIFICATION_LINK . ' -' . $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/resend', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :facebook()
	Parameter : unique_code
	Return : register or update user with facebook data
	Use : register or update user with facebook data
	*/
    function facebook($unique_code = '')
    {

        if ($unique_code == 'facebook_admin') {
            redirect('admin/social_setting/add_facebook_setting/true');
        }
        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            redirect('home/signup');
        }
        $this->load->library('fb_connect');
        if (!$this->fb_connect->fbSession) {
            // 2. If No, bounce back to login
            redirect('home/login');
        }
        $fb_uid = $this->fb_connect->fbSession;
        $fb_usr = $this->fb_connect->user;
        $fb_fbaccesstoken = $this->fb_connect->fbaccesstoken;

        //Validate user if user status is Active / Inactive / Suspend
        $this->_facebook_validate($fb_uid, $fb_usr["email"]);
        //----------------

        if ($fb_uid != '') {
            $this->session->set_userdata(array(
                "facebook_id" => $fb_uid,
                "fb_access_token" => $fb_fbaccesstoken
            ));
        }

        if (isset($fb_usr["email"])) $email = $fb_usr["email"];
        else $email = '';
        if (isset($fb_usr["first_name"])) $fname = $fb_usr["first_name"];
        else $fname = '';
        if (isset($fb_usr["last_name"])) $lname = $fb_usr["last_name"];
        else $lname = '';
        $pwd = ''; //left blank so user can modify this later
        $redir = 'home';
        if ($unique_code == 'backinvite') {
            $redir = 'invites/facebook';
        }
        if ($unique_code == "social") {
            $redir = "social_networking/index/";
        }
        $usr = $this->home_model->check_social_user(array(
            "fb_uid" => $fb_uid,
            "email" => $email
        ));
        if ($usr) {
            if ($this->session->userdata('user_id') > 0) {

                $data = array(
                    'fb_uid' => "" . $fb_uid,
                    'fb_access_token' => "" . $fb_fbaccesstoken,
                );
                if ($unique_code == "social") {
                    $data['facebook_wall_post'] = 1;
                }
                $wheredata = array(
                    'user_id' => $this->session->userdata('user_id')
                );
                $bQry = $this->home_model->update_social_user($wheredata, $data);
                redirect($redir);
            } else {
                $data_update = array(
                    'fb_uid' => "" . $fb_uid,
                    'fb_access_token' => "" . $fb_fbaccesstoken,
                    'email' => "" . $email,
                );
                if ($unique_code == "social") {
                    $data_update['facebook_wall_post'] = 1;
                }
                $bQry = $this->home_model->update_social_user(array(
                    "fb_uid" => $fb_uid,
                    "email" => $email
                ), $data_update);
                redirect($redir);
            }
        } else {

            try {

                $CI = &get_instance();
                $fb_img = '';
                $base_path = $CI->config->slash_item('base_path');
                $image_settings = get_image_setting_data();
                if (isset($fb_usr["picture"])) {
                    $inPath = $fb_usr["picture"];
                    $outPath = $base_path . 'upload/orig/' . $fb_uid . '.jpg';
                    $in = fopen($inPath, "rb");
                    $out = fopen($outPath, "wb");
                    while ($chunk = fread($in, 8192)) {
                        fwrite($out, $chunk, 8192);
                    }
                    fclose($in);
                    fclose($out);
                    $fb_img = $fb_uid . '.jpg';
                    $files["userfile"]["name"] = $fb_img;
                    $files["userfile"]["tmp_name"] = '';
                    UserImageUpload($files, true);
                }
                $db_values = array(
                    'fb_uid' => "" . $fb_uid,
                    'fb_access_token' => "" . $fb_fbaccesstoken,
                    'user_name' => strtolower(str_replace(" ", "", $fname)),
                    'last_name' => strtolower(str_replace(" ", "", $lname)),
                    'password' => $pwd,
                    'email' => $email,
                    'image' => $fb_img,
                    'active' => 1,
                    'unique_code' => $unique_code,
                    'date_added' => date('Y-m-d H:i:s'),
                );

            } catch (Exception $ex) {

                throw new Exception('Error occurred in PayReceipt method');
                $error = WRONG_FACEDBOOK_SETTINGS;
                $data['error'] = $error;
                $this->load->view(THEME_LOCATION.'paypal_error', $data);
            }
            $this->social_signup($db_values, 'fb_uid');
        }

    }

    /*
	Function name :_facebook_validate()
	Parameter : uid , email
	Return : redirect or return 1
	Use : check social signup user exists or not
	*/
    function _facebook_validate($uid = 0, $email = '')

    {

        //this query basically sees if the users facebook user id is associated with a user.

        $chk = $this->db->query("SELECT * FROM `user` WHERE email='" . $email . "'");

        if ($chk->num_rows() > 0) {
            $chk = $chk->result();
            //echo '<pre>'; print_r($chk); die;
            $bQry = $chk[0]->active;
            //echo $bQry; die;
            $meta = meta_setting();
            if ($bQry == '2') {
                redirect('home/login/suspend');
            } elseif ($bQry == 0) { // if the user's credentials validated...		
                redirect('home/login/inactive');
            } elseif ($bQry) { // if the user's credentials validated...	
                return 1;
            } else {
                return 1;
            }
        } else {
            return 1;
        }

    }

    /*
	Function name :twitter_auth()
	Parameter : unique_code
	Return : register or update user with twitter data
	Use : register or update user with twitter data
	*/
    function twitter_authss($unique_code = '')
    {
        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            redirect('home/signup');
        }
        $CII = &get_instance();
        $base_path = $CII->config->slash_item('base_path');

        $includes_url = $base_path . 'twitteroauth/twitteroauth.php';
        $this->load->file($includes_url);
        $twitter_setting = twitter_setting();
        define('CONSUMER_KEY', $twitter_setting['consumer_key']);
        define('CONSUMER_SECRET', $twitter_setting['consumer_secret']);
        define('OAUTH_CALLBACK', site_url('home/auth/' . $unique_code));
        /* Build TwitterOAuth object with client credentials. */

        $connection = new TwitterOAuth(CONSUMER_KEY, CONSUMER_SECRET);
        /* Get temporary credentials. */
        $request_token = $connection->getRequestToken(OAUTH_CALLBACK);
        /* Save temporary credentials to session. */
        $_SESSION['oauth_token'] = $token = $request_token['oauth_token'];
        $_SESSION['oauth_token_secret'] = $request_token['oauth_token_secret'];
        /* If last connection failed don't display authorization link. */
        switch ($connection->http_code) {
            case 200:
                /* Build authorize URL and redirect user to Twitter. */
                $url = $connection->getAuthorizeURL($token);
                header('Location: ' . $url);
                break;

            default:
                /* Show notification if something went wrong. */
                echo TWITTER_CONNECTION_ERROR;
        }
    }

    /*
	Function name :twitter_auth()
	Parameter : unique_code
	Return : register or update user with twitter data
	Use : register or update user with twitter data
	*/
    function twitter_auth($unique_code = '')
    {
        // error_reporting(E_ALL ^ E_NOTICE);
        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            redirect('home/signup');
        }
        $CII = &get_instance();
        $base_path = $CII->config->slash_item('base_path');
        // include_once $base_path.'../lib/GoCardless.php';
        $includes_url = $base_path . 'twitteroauth/twitteroauth.php';
        $this->load->file($includes_url);
        $twitter_setting = twitter_setting();
        define('CONSUMER_KEY', $twitter_setting['consumer_key']);
        define('CONSUMER_SECRET', $twitter_setting['consumer_secret']);
        define('OAUTH_CALLBACK', site_url('home/auth/' . $unique_code));
        /* Build TwitterOAuth object with client credentials. */

        $connection = new TwitterOAuth(CONSUMER_KEY, CONSUMER_SECRET);
        /* Get temporary credentials. */
        $request_token = $connection->getRequestToken(OAUTH_CALLBACK);


        /* Save temporary credentials to session. */
        $_SESSION['oauth_token'] = $token = $request_token['oauth_token'];
        $_SESSION['oauth_token_secret'] = $request_token['oauth_token_secret'];
        /* If last connection failed don't display authorization link. */
        switch ($connection->http_code) {
            case 200:
                /* Build authorize URL and redirect user to Twitter. */
                $url = $connection->getAuthorizeURL($token);
                header('Location: ' . $url);
                break;

            default:
                /* Show notification if something went wrong. */
                echo TWITTER_CONNECTION_ERROR;
        }
    }

    /*
	Function name :auth()
	Parameter : unique_code
	*/
    function auth($unique_code = '')
    {
        if (isset($_GET['denied'])) {
            redirect('home');
        }
        try {
            $redir = 'home';
            if ($unique_code == "social") $redir = "social_networking/index/";
            $CII = &get_instance();
            $base_path = $CII->config->slash_item('base_path');
            // include_once $base_path.'../lib/GoCardless.php';
            $includes_url = $base_path . 'twitteroauth/twitteroauth.php';
            $this->load->file($includes_url);
            $twitter_setting = twitter_setting();
            define('CONSUMER_KEY', $twitter_setting['consumer_key']);
            define('CONSUMER_SECRET', $twitter_setting['consumer_secret']);
            define('OAUTH_CALLBACK', site_url('home/auth/' . $unique_code));
            /* Create TwitteroAuth object with app key/secret and token key/secret from default phase */
            $connection = new TwitterOAuth(CONSUMER_KEY, CONSUMER_SECRET, $_SESSION['oauth_token'], $_SESSION['oauth_token_secret']);
            /* Request access tokens from twitter */
            $access_token = $connection->getAccessToken($_GET['oauth_verifier']);
            /* Save the access tokens. Normally these would be saved in a database for future use. */
            $_SESSION['access_token'] = $access_token;
            /* Remove no longer needed request tokens */
            unset($_SESSION['oauth_token']);
            unset($_SESSION['oauth_token_secret']);
            $access_token = $_SESSION['access_token'];
            /* Create a TwitterOauth object with consumer/user tokens. */
            $connection = new TwitterOAuth(CONSUMER_KEY, CONSUMER_SECRET, $access_token['oauth_token'], $access_token['oauth_token_secret']);
            if (isset($access_token['oauth_token'])) {
                $oauth_token = $access_token['oauth_token'];
            }
            if (isset($access_token['oauth_token_secret'])) {
                $oauth_token_secret = $access_token['oauth_token_secret'];
            }
            /* If method is set change API call made. Test is called by default. */
            $content = $connection->get('account/verify_credentials');
            $user = $content;

            if ($unique_code == 'twitter_admin') {
                redirect('admin/social_setting/add_twitter_setting/true');
            } else {
                if (isset($content->errors)) {
                    $obj = $content->errors[0];
                    if ($obj->message) {
                        $error = $obj->message;
                        $data['error'] = $error;
                        $this->load->view(THEME_LOCATION.'paypal_error', $data);
                    }
                } elseif (isset($user->screen_name)) {
                    $screen_name = $user->screen_name;
                    $twiter_img_url = $user->profile_image_url_https;
                    if (isset($user->name)) {
                        $first_name = $user->name;
                        if (substr_count($first_name, ' ') >= 1) {
                            $ex = explode(' ', $first_name);
                            $first_name = $ex[0];
                            if (!isset($ex[1])) {
                                $last_name = '';
                            } else {
                                $last_name = $ex[1];
                            }
                        } else {
                            $last_name = '';
                        }
                    }
                    $name = $user->name;
                    $twitter_id = $user->id;

                    $usr = $this->home_model->check_social_user(array(
                        "tw_id" => $twitter_id
                    ));
                    $return_email = $this->home_model->get_user_info($twitter_id);

                    if ($return_email != '0' && $return_email != '') {
                        $this->_facebook_validate($twitter_id, $return_email);
                    }
//echo $usr; die;

                    if ($usr) {
                        $data = array(
                            'tw_id' => $twitter_id,
                            'tw_screen_name' => $screen_name,
                            'tw_oauth_token' => $oauth_token,
                            'tw_oauth_token_secret' => $oauth_token_secret
                        );
                        $this->session->set_userdata('twitter', $data);
                        $this->db->delete('user', array('user_id' => $this->session->userdata('user_id')));

                        if ($unique_code == "social") {
                            $data['autopost_site'] = 1;
                        }

                        if ($this->session->userdata('user_id') > 0) {
                            $wheredata = array(
                                "tw_id" => $twitter_id,
                                "email" => $return_email
                            );
                            $bQry = $this->home_model->update_social_user($wheredata, $data);
                            // ====put condition for invite code related if user is alreadt logged in
                        } else {
                            $bQry = $this->home_model->update_social_user(array(
                                "tw_id" => $twitter_id,
                                "email" => $return_email,
                            ), $data);
                        }

                        redirect($redir);
                    } else {
                        if ($this->session->userdata('user_id') > 0) {
                            $data = array(
                                'tw_id' => $twitter_id,
                                'tw_screen_name' => $screen_name,
                                'tw_oauth_token' => $oauth_token,
                                'tw_oauth_token_secret' => $oauth_token_secret
                            );
                            $this->session->set_userdata('twitter', $data);
                            $this->db->delete('user', array('user_id' => $this->session->userdata('user_id')));

                            if ($unique_code == "social") {
                                $data['autopost_site'] = 1;
                            }
                            $wheredata = array(
                                'user_id' => $this->session->userdata('user_id')
                            );
                            $bQry = $this->home_model->update_social_user($wheredata, $data);
                            // ====put condition for invite code related if user is alreadt logged in
                            redirect($redir);
                        } else {
                            $twiter_img = '';
                            if (isset($twiter_img_url)) {
                                $CI = &get_instance();
                                $base_path = $CI->config->slash_item('base_path');
                                $image_settings = get_image_setting_data();
                                $inPath = $twiter_img_url;
                                $outPath = $base_path . 'upload/orig/' . $screen_name . '.jpg';
                                $in = fopen($inPath, "rb");
                                $out = fopen($outPath, "wb");
                                while ($chunk = fread($in, 8192)) {
                                    fwrite($out, $chunk, 8192);
                                }
                                fclose($in);
                                fclose($out);
                                $twiter_img = $screen_name . '.jpg';
                                $files["userfile"]["name"] = $twiter_img;
                                $files["userfile"]["tmp_name"] = '';
                                UserImageUpload($files, true);
                            }
                            $db_values = array(
                                'user_name' => strtolower(str_replace(" ", "", $first_name)),
                                'last_name' => $last_name,
                                'email' => '',
                                'tw_id' => $twitter_id,
                                'image' => $twiter_img,
                                'tw_screen_name' => $screen_name,
                                'tw_oauth_token' => $oauth_token,
                                'tw_oauth_token_secret' => $oauth_token_secret,
                                'active' => 1,
                                'unique_code' => $unique_code,
                                'date_added' => date('Y-m-d H:i:s'),
                            );

                            $data = array(
                                'tw_id' => $twitter_id,
                                'tw_screen_name' => $screen_name,
                                'tw_oauth_token' => $oauth_token,
                                'tw_oauth_token_secret' => $oauth_token_secret
                            );
                            $this->session->set_userdata('twitter', $data);

                            $this->social_signup($db_values, 'tw_id');
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            throw new Exception('Error occurred in PayReceipt method');
            $error = WRONG_TWITTER_SETTINGS;
            $data['error'] = $error;
            $this->load->view(THEME_LOCATION.'paypal_error', $data);
        }
    }

    /*
	Function name :social_signup()
	Parameter : data and social_site_name it comes from social site id
	Return : register or update user with social networking
	Use : register or update user with social networking data
	*/
    function social_signup($data = array(), $social_site_name)
    {
        $data['signup_ip'] = SecurePostData($_SERVER['REMOTE_ADDR']);
        $data['date_added'] = SecurePostData(date('Y-m-d H:i:s'));
         $data['user_language_id'] = GetUserLangCode();
        $data['unique_code'] = unique_user_code(getrandomCode(12));
        $find_refeer_id = $this->findreferid();
        $data['reference_user_id'] = $find_refeer_id;
        if ($data['email'] != "") {
            $email = $data['email'];
            $query = $this->db->query("select user_id from user where email='$email'");
            if ($query->num_rows() > 0) {
                $res = $query->row_array();

                //print_r($res);die;
                $sign = $res['user_id'];
                $this->db->where('user_id', $sign);
                $this->db->update('user', $data);
            } else {
                $sign = $this->home_model->register($data);

            }
        } else {
            $sign = $this->home_model->register($data);

        }

        if ($sign) {
            $user_detail = $this->account_model->GetAllUsers($sign);
            $user_detail = $user_detail[0];
            if ($social_site_name == 'fb_uid') {
                $login_data = array(
                    'fb_uid' => SecurePostData($user_detail['fb_uid'])
                );
            }
            if ($social_site_name == 'tw_id') {
                $login_data = array(
                    'tw_id' => SecurePostData($user_detail['tw_id'])
                );
            }
            if ($social_site_name == 'linkdin_id') {
                $login_data = array(
                    'linkdin_id' => SecurePostData($user_detail['linkdin_id'])
                );
            }
            $chk = $this->home_model->user_validate($login_data, 'login');
            $set_session_data = array(
                'user_id' => $user_detail['user_id'],
                'user_name' => $user_detail['user_name'],
                'email' => $user_detail['email'],
            );
            $this->session->set_userdata($set_session_data);
             $language_id=GetUserLangCode( $user_detail['user_id']);
            $email_template = $this->db->query("select * from `email_template` where task='Welcome Email' and language_id=".$language_id);
            $email_temp = $email_template->row();
            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_subject = $email_temp->subject;
            $email_message = $email_temp->message;
            $username = $user_detail['user_name'];
            $email = $user_detail['email'];
            $password = $user_detail['password'];
            $email_to = $user_detail['email'];
            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{email}', $email, $email_message);
            $str = $email_message;
            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
            // ///////////============welcome email===========
            // ///////////============new user email===========

            $email_template = $this->db->query("select * from `email_template` where task='Social User Join' and language_id=".$language_id);
            $email_temp = $email_template->row();
            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_subject = $email_temp->subject;
            $email_message = $email_temp->message;
            $login_link = '<a href="' . site_url('home/login') . '">' . site_url('home/login') . '</a>';
            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{email}', $email, $email_message);
            $email_message = str_replace('{login_link}', $login_link, $email_message);
            $str = $email_message;
            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
            // ///////////============new user email===========
            redirect('home/step1');
        } else {
            redirect('home/index');
        }
    }

    /*
	Function name :linkdin_getAuthorizationCode()
	Parameter : none
	Use: generate authorize URL for linkdin.
	*/
    function linkdin_getAuthorizationCode()
    {
        $params = array(
            'response_type' => 'code',
            'client_id' => API_KEY,
            'scope' => SCOPE,
            'state' => uniqid('', true), // unique long string
            'redirect_uri' => REDIRECT_URI,
        );
        // Authentication request
        $url = 'https://www.linkedin.com/uas/oauth2/authorization?' . http_build_query($params);
        // Needed to identify request when it returns to us
        $_SESSION['state'] = $params['state'];
        // Redirect user to authenticate
        header("Location: $url");
        exit;
    }

    /*
	Function name :linkdin_getAccessToken()
	Parameter : none
	Use: generate Access Token.
	*/
    function linkdin_getAccessToken()
    {
        $params = array(
            'grant_type' => 'authorization_code',
            'client_id' => API_KEY,
            'client_secret' => API_SECRET,
            'code' => $_GET['code'],
            'redirect_uri' => REDIRECT_URI,
        );
        // Access Token request
        $url = 'https://www.linkedin.com/uas/oauth2/accessToken?' . http_build_query($params);
        // Tell streams to make a POST request
        $context = stream_context_create(array(
            'http' => array(
                'method' => 'POST',
            )
        ));
        // Retrieve access token information
        $response = file_get_contents($url, false, $context);
        // Native PHP object, please
        $token = json_decode($response);
        // Store access token and expiration time
        $_SESSION['access_token'] = $token->access_token; // guard this!
        $_SESSION['expires_in'] = $token->expires_in; // relative time (in seconds)
        $_SESSION['expires_at'] = time() + $_SESSION['expires_in']; // absolute time
        return true;
    }

    /*
	Function name :linkdin_fetch()
	Parameter : none
	Use: Fetch data from linkdin according to accesstoken
	*/
    function linkdin_fetch($method, $resource, $body = '')
    {
        $params = array(
            'oauth2_access_token' => $_SESSION['access_token'],
            'format' => 'json',
        );
        // Need to use HTTPS
        $url = 'https://api.linkedin.com' . $resource . '?' . http_build_query($params);
        // Tell streams to make a (GET, POST, PUT, or DELETE) request
        $context = stream_context_create(array(
            'http' => array(
                'method' => $method,
            )
        ));
        // Hocus Pocus
        $response = file_get_contents($url, false, $context);
        // Native PHP object, please
        return json_decode($response);
    }

    /*
	Function name :linkdin_auth()
	Parameter : none
	Use: Authorize user for linkdin data.
	*/
    function linkdin_auth($unique_code = '')
    {
        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            redirect('home/signup');
        }
        $linkdin_setting = linkdin_setting();
        // $l_query = $this->db->getwhere('linkdin_setting');
        // $l_setting = $l_query->row_array();
        $linkedin_access = $linkdin_setting['linkedin_access'];
        $linkedin_secret = $linkdin_setting['linkedin_secret'];
        if (!defined("API_KEY")) define('API_KEY', $linkedin_access);
        if (!defined("API_SECRET")) define('API_SECRET', $linkedin_secret);
        if (!defined("REDIRECT_URI")) define('REDIRECT_URI', site_url('home/linkdin_callback'));
        if (!defined("SCOPE")) define('SCOPE', 'r_basicprofile r_emailaddress');
        session_name('linkedin');
        // session_start();
        // OAuth 2 Control Flow
        if (isset($_GET['error'])) {
            // LinkedIn returned an error
            print $_GET['error'] . ': ' . $_GET['error_description'];
            exit;
        } elseif (isset($_GET['code'])) {
            // User authorized your application
            if ($_SESSION['state'] == $_GET['state']) {
                // Get token so you can make API calls
                $this->linkdin_getAccessToken();
            } else {
                // CSRF attack? Or did you mix up your states?
                exit;
            }
        } else {
            if ((empty($_SESSION['expires_at'])) || (time() > $_SESSION['expires_at'])) {
                // Token has expired, clear the state
                $_SESSION = array();
            }
            if (empty($_SESSION['access_token'])) {

                // Start authorization process
                $this->linkdin_getAuthorizationCode();
            }
        }
        redirect('home/linkdin_callback');
    }

    /*
	Function name :linkdin_callback()
	Parameter : none
	Use: user redirect back to site after completion of linkdin authorization processs.
	*/
    function linkdin_callback($unique_code = '')
    {


        $linkdin_setting = linkdin_setting();

        $linkedin_access = $linkdin_setting['linkedin_access'];

        $linkedin_secret = $linkdin_setting['linkedin_secret'];

        if (isset($_GET['error']) == 'access_denied') {
            redirect('home');
        }
        try {

            if (!defined("API_KEY")) define('API_KEY', $linkedin_access);

            if (!defined("API_SECRET")) define('API_SECRET', $linkedin_secret);

            if (!defined("REDIRECT_URI")) define('REDIRECT_URI', site_url('home/linkdin_callback'));

            if (!defined("SCOPE")) define('SCOPE', 'r_fullprofile r_emailaddress rw_nus');


            session_name('linkedin');

            ///session_start();

            // OAuth 2 Control Flow

            if (isset($_GET['error'])) {

                // LinkedIn returned an error

                print $_GET['error'] . ': ' . $_GET['error_description'];

                exit;

            } elseif (isset($_GET['code'])) {

                // User authorized your application

                if ($_SESSION['state'] == $_GET['state']) {

                    // Get token so you can make API calls

                    $this->linkdin_getAccessToken();

                } else {

                    // CSRF attack? Or did you mix up your states?

                    exit;

                }

            } else {

                if ((empty($_SESSION['expires_at'])) || (time() > $_SESSION['expires_at'])) {

                    // Token has expired, clear the state

                    $_SESSION = array();

                }

                if (empty($_SESSION['access_token'])) {

                    // Start authorization process

                    $this->linkdin_getAuthorizationCode();

                }

            }

            $user = $this->linkdin_fetch('GET', '/v1/people/~:(id,firstName,lastName,email-address,picture-url)');


            if ($user->id == '') {

                //2. If No, bounce back to login   			

                redirect('home/login');


            } else {


                $this->_facebook_validate($user->id, $user->emailAddress);
                $linkdin_id = $user->id;

                $firstname = $user->firstName;
                $emailAddress = $user->emailAddress;
                $pictureUrl = $user->pictureUrl;

                $lastName = $user->lastName;
                $tw_img = '';

                if ($pictureUrl != '') {

                    $inPath = $pictureUrl;
                    $base_path = $this->config->slash_item('base_path');
                    $outPath = $base_path . 'upload/orig/' . $linkdin_id . '.jpg';

                    $in = fopen($inPath, "rb");

                    $out = fopen($outPath, "wb");

                    while ($chunk = fread($in, 8192)) {

                        fwrite($out, $chunk, 8192);

                    }

                    fclose($in);

                    fclose($out);

                    $tw_img = $linkdin_id . '.jpg';

                    $files["userfile"]["name"] = $tw_img;

                    $files["userfile"]["tmp_name"] = '';

                    UserImageUpload($files, true);

                }

                $usr = $this->home_model->check_social_user(array("linkdin_id" => $linkdin_id));

                if ($usr) {

                    if ($this->session->userdata('user_id') > 0) {

                        $data = array(

                            'linkdin_id' => $linkdin_id

                        );

                        $wheredata = array(

                            'user_id' => $this->session->userdata('user_id')

                        );

                        $bQry = $this->home_model->update_social_user($wheredata, $data);

                        //====put condition for invite code related if user is alreadt logged in					

                    } else {

                        $bQry = $this->home_model->update_social_user(array("linkdin_id" => $linkdin_id), array("linkdin_id" => $linkdin_id));

                    }

                    if ($bQry == '2') {

                        redirect('home/index');


                    } else { // if the user's credentials validated...


                        redirect('home/account');


                    }

                } else {


                    if ($this->session->userdata('user_id') > 0) {

                        $data = array(

                            'linkdin_id' => $linkdin_id

                        );

                        $wheredata = array(

                            'user_id' => $this->session->userdata('user_id')

                        );

                        $bQry = $this->home_model->update_social_user($wheredata, $data);

                        //====put condition for invite code related if user is alreadt logged in					

                    } else {


                        $db_values = array(

                            'user_name' => strtolower(str_replace(" ", "", $firstname)),

                            'last_name' => $lastName,
                            'email' => $emailAddress,
                            'image' => $tw_img,

                            'linkdin_id' => $linkdin_id,

                            'active' => 1,

                            'unique_code' => $unique_code,
                            'date_added' => date('Y-m-d H:i:s'),

                        );


                        $this->social_signup($db_values, 'linkdin_id');


                    }

                }

            }

        } catch (Exception $ex) {

            //throw new Exception('Error occurred in PayReceipt method');

            $error = WRONG_LINKEDIN_SETTINGS;

            $data['error'] = $error;

            $this->load->view(THEME_LOCATION.'paypal_error', $data);

        }


    }

    /*
	Function name :email_check()
	Parameter :none
	Return : none
	Use : This is a callback function which is use to check this email exist or not except login user email.
	*/
    function email_check()
    {
        $data_check = SecurePostData($this->input->post('email'));
        $username = $this->home_model->email_validate($data_check, $this->session->userdata('user_id'));
        if ($username) {
            //$this->form_validation->set_message('email_check', EXISTS_ACCOUNT_ASSOCIATE_WITHMAIL);
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /*
	Function name :step1()
	Parameter : none
	Return : none
	Use : register or update user detail social networking
	*/
    function step1()
    {
        if ($this->session->userdata('user_id') == '') {
            redirect("home/login");
        }
        $meta = meta_setting();

        $data["error"] = '';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('user_name', USERNAME, 'required|trim|min_length[3]|max_length[40]');
        $this->form_validation->set_rules('last_name', LAST_NAME, 'required|trim|min_length[3]|max_length[40]');
        $this->form_validation->set_rules('password', PASSWORD, 'required|trim|valid_password');
        $this->form_validation->set_rules('zip_code', ZIPCODE, 'required|alpha_numeric|trim|min_length[5]|max_length[7]');
        $this->form_validation->set_rules('email', EMAIL, 'required|valid_email|trim');
        $check_user = '';

        if ($this->form_validation->run() == FALSE) {

            if ($check_user != '') {
                $data["error"] = validation_errors();
            } else {
                $data["error"] = validation_errors();
            }
            $data["user_name"] = SecurePostData($this->input->post('user_name'));
            $data["last_name"] = SecurePostData($this->input->post('last_name'));
            $data["email"] = SecurePostData($this->input->post('email'));
            $data["image"] = SecurePostData($this->input->post('file_name'));
            $data["password"] = SecurePostData($this->input->post('password'));
            $data["address"] = SecurePostData($this->input->post('address'));
            $data["zip_code"] = SecurePostData($this->input->post('zip_code'));
        } else {
            $update_data = array();
            $update_data["user_name"] = SecurePostData($this->input->post('user_name'));
            $update_data["last_name"] = SecurePostData($this->input->post('last_name'));
            $update_data["email"] = SecurePostData($this->input->post('email'));

            $update_data["password"] = md5(SecurePostData($this->input->post('password')));
            $update_data["address"] = SecurePostData($this->input->post('address'));
            $update_data["zip_code"] = SecurePostData($this->input->post('zip_code'));
            $update_data["confirm_key"] = SecurePostData(randomNumber(20));
            $update_data["profile_slug"] = makeSlugs($update_data["user_name"] . $update_data["last_name"] . SecurePostData($this->session->userdata('user_id')));
            $update = $this->account_model->UpdateAccount('user_id', SecurePostData($this->session->userdata('user_id')), 'user', $update_data);
            $cache_file_name = 'user_detail' . $this->session->userdata('user_id');
            setting_deletecache($cache_file_name);
            $data = array(
                'email' => $update_data["email"]
            );
            $this->session->set_userdata($data);
            if ($update) {
                // ///////////============new user email===========
                $result = UserData($this->session->userdata('user_id'));
                 $language_id=GetUserLangCode($this->session->userdata('user_id'));
                $email_template = $this->db->query("select * from `email_template` where task='Update Profile' and language_id=".$language_id);
                $email_temp = $email_template->row();
                if ($email_temp) {
                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_subject = $email_temp->subject;
                    $email_message = $email_temp->message;
                    $username = SecureShowData($this->input->post('user_name'));
                    $last_name = SecureShowData($this->input->post('last_name'));
                    $email = SecureShowData($this->input->post('email'));
                    $password = SecureShowData($this->input->post('password'));
                    if ($this->input->post('address') != '') {
                        $address = SecureShowData($this->input->post('address'));
                    } else {
                        $address = "N/A";;
                    }
                    $zip_code = SecureShowData($this->input->post('zip_code'));
                    $email_to = SecureShowData($this->input->post('email'));
                    $email_message = str_replace('{break}', '<br/>', $email_message);
                    $email_message = str_replace('{user_name}', $username, $email_message);
                    $email_message = str_replace('{last_name}', $last_name, $email_message);
                    $email_message = str_replace('{email}', $email, $email_message);
                    $email_message = str_replace('{password}', $password, $email_message);
                    $email_message = str_replace('{address}', $address, $email_message);
                    $email_message = str_replace('{zip_code}', $zip_code, $email_message);
                    $str = $email_message;
                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                }
            }
             $first_name= $update_data["user_name"] ;
                $last_name= $update_data["last_name"] ;
                $email= $update_data["email"] ;
                newsletterApiSubscribe('sign_up',$email,$first_name,$last_name);
            redirect('home/step2');
        }
        $data['site_setting'] = site_setting();
        $user_data = UserData($this->session->userdata('user_id'));
        $data["user_name"] = ucfirst($user_data[0]['user_name']);
        $data["last_name"] = ucfirst($user_data[0]['last_name']);
        $data["email"] = $user_data[0]['email'];
        $data["tw_screen_name"] = $user_data[0]['tw_screen_name'];
        $data["tw_id"] = $user_data[0]['tw_id'];
        $data["fb_uid"] = $user_data[0]['fb_uid'];
        $data["image"] = $user_data[0]['image'];
        $data["password"] = $user_data[0]['password'];
        $data["address"] = $user_data[0]['address'];
        $data["zip_code"] = $user_data[0]['zip_code'];
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/step1', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :UserImageAjax()
	Parameter :id , type
	Return : none
	Use : Upload image using ajax for user;
	*/
    function UserImageAjax($id = null, $type = 0)
    {
        $site_setting = site_setting();
        $this->load->library('form_validation');
        $data = array();
        $data["msg"]["error"] = '';
        $data["msg"]["success"] = '';
        $data["redirect"]["url"] = '';
        $data["image"]["path"] = '';
        $data["msg"]["image_media"] = '';
        $data["msg"]["video_media"] = '';

        if ($this->session->userdata('user_id') == '') {
            $data["redirect"]["url"] = 'home/login';
        } else if ($id == null || $id == '' || $id == '0') {
            $data["redirect"]["url"] = "home/step1";
        } else {

            switch ($type) {
                case 0:
                    $_FILES['userfile']['name'] = $_FILES['file1']['name'];
                    $_FILES['userfile']['type'] = $_FILES['file1']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['file1']['tmp_name'];
                    $_FILES['userfile']['error'] = $_FILES['file1']['error'];
                    $_FILES['userfile']['size'] = $_FILES['file1']['size'];
                    // image validation
                    $image_settings = get_image_setting_data();
                    if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif") {
                        $data["msg"]["error"] = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
                    } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                        $data["msg"]["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);;
                    } else {
                        $imagename = UserImageUpload($_FILES);
                        $data_gallery = array(
                            'image' => $imagename
                        );
                        // save data
                        $new_img = $this->account_model->UpdateAccount('user_id', $id, 'user', $data_gallery);
                        if ($new_img) {
                            $data["image"]["path"] = base_url() . "upload/user/user_small_image/" . $imagename;
                            $data["msg"]["success"] = '<span>' . IMAGE_UPLOADED_SUCCESSFULLY . '</span>';
                        } else {
                            $data["msg"]["error"] = THERE_IS_SOME_PROBLEM;
                        }
                    }
                    $cache_file_name = 'user_detail' . $this->session->userdata('user_id');
                    setting_deletecache($cache_file_name);
                    $cache_file_name = 'user_detail_notification' . $this->session->userdata('user_id');
                    setting_deletecache($cache_file_name);
                    $data["msg"]["successbox"] = 1;
                    break;
            }
        }
        echo json_encode($data);
    }

    /*
	Function name :step2()
	Parameter : none
	Return : none
	Use : fill profile or update user detail social networking
	*/
    function step2()
    {
       $meta = meta_setting();
        $user_data = UserData($this->session->userdata('user_id'));
        $data["user_about"] = ucfirst($user_data[0]['user_about']);
        $data["user_interest"] = ucfirst($user_data[0]['user_interest']);
        $data["user_skill"] = $user_data[0]['user_skill'];
        $data["user_occupation"] = $user_data[0]['user_occupation'];
        $data['site_setting'] = site_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/step2', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :step2data()
	Parameter : none
	Return : none
	Use : saved the data in user table	*/
    function step2data()
    {
        $data["user_about"] = SecurePostData($this->input->post('user_about'));
        $data["user_interest"] = SecurePostData($this->input->post('user_interest'));
        $data["user_skill"] = SecurePostData($this->input->post('user_skill'));
        $data["user_occupation"] = SecurePostData($this->input->post('user_occupation'));
        $this->account_model->UpdateAccount('user_id', SecurePostData($this->session->userdata('user_id')), 'user', $data);
        $cache_file_name = 'user_detail' . $this->session->userdata('user_id');
        setting_deletecache($cache_file_name);
        redirect('home/step3');
    }

    /*
	Function name :step3()
	Parameter : none
	Return : none
	Use : fill profile or update user detail social networking	*/
    function step3()
    {   
         if ($this->session->userdata('user_id') == '') {
            redirect("home/login");
        }
        $meta = meta_setting();
        $user_data = UserData($this->session->userdata('user_id'));
        $data["facebook_url"] = ucfirst($user_data[0]['facebook_url']);
        $data["twitter_url"] = ucfirst($user_data[0]['twitter_url']);
        $data["googleplus_url"] = $user_data[0]['googleplus_url'];
        $data["youtube_url"] = $user_data[0]['youtube_url'];
        $data["user_website"] = $user_data[0]['user_website'];
        $data["linkedln_url"] = $user_data[0]['linkedln_url'];
        $data["bandcamp_url"] = $user_data[0]['bandcamp_url'];
        $data["myspace_url"] = $user_data[0]['myspace_url'];
        $data["error"] = '';
        $data['site_setting'] = site_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/step3', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
	Function name :step3data()
	Parameter : none
	Return : none
	Use : saved the data in user table	*/
    function step3data()
    {
        $meta = meta_setting();
        $user_data = UserData($this->session->userdata('user_id'));
        $this->load->library('form_validation');

        $this->form_validation->set_rules('user_website', WEBSITE_URL, 'valid_url|trim');
        $this->form_validation->set_rules('bandcamp_url', BANDCAMP_URL, 'valid_url|trim');
 $check_facebook_url = '';
        if ($this->input->post('facebook_url') != '') {
          
             if (!substr_count($this->input->post('facebook_url'), 'facebook.com')) {
                $check_facebook_url = ENTER_VALID_FACEBOOK_URL . '<br/>';
            }
        }
        $check_twitter_url = '';
        if ($this->input->post('twitter_url') != '') {
           
             if (!substr_count($this->input->post('twitter_url'), 'twitter.com')) {
                $check_twitter_url = ENTER_VALID_TWITTER_URL . '<br/>';
            }
        }
        $check_linkedln_url = '';
        if ($this->input->post('linkedln_url') != '') {
           
             if (!substr_count($this->input->post('linkedln_url'), 'linkedin.com')) {
                $check_linkedln_url = ENTER_VALID_LINKEDIN_URL . '<br/>';
            }
        }
         $check_youtube_url = '';
        if ($this->input->post('youtube_url') != '') {
           
             if (!substr_count($this->input->post('youtube_url'), 'youtube.com')) {
                $check_youtube_url = ENTER_VALID_YOUTUBE_URL . '<br/>';
            }
        }
    
         $check_basecamp_url = '';
         if ($this->input->post('bandcamp_url') != '') {
            if (!substr_count($this->input->post('bandcamp_url'), 'bandcamp.com')) {
                $check_basecamp_url = ENTER_VALID_BASECAMP_URL. '<br />';
            }
        }

        $check_myspace_url = '';
         if ($this->input->post('myspace_url') != '') {
            if (!substr_count($this->input->post('myspace_url'), 'myspace.com')) {
                $check_myspace_url = ENTER_VALID_MYSPACE_URL. '<br />';
            }
        }

         $check_googleplus_url = '';
         if ($this->input->post('googleplus_url') != '') {
            if (!substr_count($this->input->post('googleplus_url'), 'plus.google.com')) {
                $check_googleplus_url = ENTER_VALID_GOOGLEPLUS_URL. '<br />';
            }
        }
        if ($this->form_validation->run() == FALSE || $check_facebook_url != '' || $check_twitter_url != '' || $check_linkedln_url != '' || $check_youtube_url != '' || $check_basecamp_url != '' || $check_myspace_url != '' || $check_googleplus_url != '') {
            $data["error"] = validation_errors() . $check_facebook_url . $check_twitter_url . $check_linkedln_url . $check_youtube_url . $check_basecamp_url. $check_myspace_url. $check_googleplus_url;
            $data["facebook_url"] = SecurePostData($this->input->post('facebook_url'));
            $data["twitter_url"] = SecurePostData($this->input->post('twitter_url'));
            $data["googleplus_url"] = SecurePostData($this->input->post('googleplus_url'));
            $data["youtube_url"] = SecurePostData($this->input->post('youtube_url'));
            $data["user_website"] = SecurePostData($this->input->post('user_website'));
            $data["linkedln_url"] = SecurePostData($this->input->post('linkedln_url'));
            $data["bandcamp_url"] = SecurePostData($this->input->post('bandcamp_url'));
            $data["myspace_url"] = SecurePostData($this->input->post('myspace_url'));
            $data['site_setting'] = site_setting();
            $this->template->write('meta_title', $meta['title'], TRUE);
            $this->template->write('meta_description', $meta['meta_description'], TRUE);
            $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
            $this->template->front_write_view('header', 'common/header', $data, TRUE);
            $this->template->front_write_view('main_content', 'home/step3', $data, TRUE);
            $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
            $this->template->render();
        } else {
            $data["facebook_url"] = SecurePostData($this->input->post('facebook_url'));
            $data["twitter_url"] = SecurePostData($this->input->post('twitter_url'));
            $data["googleplus_url"] = SecurePostData($this->input->post('googleplus_url'));
            $data["youtube_url"] = SecurePostData($this->input->post('youtube_url'));
            $data["user_website"] = SecurePostData($this->input->post('user_website'));
            $data["linkedln_url"] = SecurePostData($this->input->post('linkedln_url'));
            $data["bandcamp_url"] = SecurePostData($this->input->post('bandcamp_url'));
            $data["myspace_url"] = SecurePostData($this->input->post('myspace_url'));
            $this->account_model->UpdateAccount('user_id', SecurePostData($this->session->userdata('user_id')), 'user', $data);
            $cache_file_name = 'user_detail' . $this->session->userdata('user_id');
            setting_deletecache($cache_file_name);
            $referece_user_id = $user_data[0]['reference_user_id'];

            redirect('home');
        }
    }

    /*
	Function name :invited()
	Parameter : code , invite_email
	Return : none
	Use : saved the data in user table	*/
    function invited($code, $invite_email = '')
    {
        if ($this->session->userdata('user_id') != '') {
            redirect('home/main_dashboard');
        }
        $email = '';
        if ($invite_email != 'facebook') {
            
          
            $check_request_exists = $this->home_model->get_code(array(
                'invite_code' => $code,
                'invite_email' => base64_decode($invite_email)
            ));
            if ($check_request_exists) {
                $user_id = $check_request_exists['invite_by'];
            }
            $email = $invite_email;
        } elseif ($invite_email == 'facebook') {
        }

        $domain_name = '';
        $get_domain_name = get_domain_name(base_url());
        if ($get_domain_name) {
            $domain_name = $get_domain_name;
        }

        $this->load->helper('cookie');
        $cookie = array(
            'name' => 'invite_code',
            'value' => $code,
            'expire' => time(),
            'domain' => $domain_name,
            'secure' => false
        );
        set_cookie($cookie);

        $this->session->set_userdata(array(
            'invite_code' => $code
        ));
        $db_values = array(
            'fb_uid' => '',
            'user_name' => '',
            'last_name' => '',
            'email' => $email,
            'tw_id' => '',
            'fb_img' => '',
            'fb_access_token' => '',
            'tw_screen_name' => '',
            'oauth_token' => '',
            'oauth_token_secret' => '',
            'invite_code' => $code,
        );
        // data ready, try to create the new user
        redirect('home/signup/' . $code.'/'.$invite_email);
    }

    /*
	Function name :adminlog()
	Parameter :admin_email
	Return : none
	Use : Admin user can take login to front site
	
	*/
    function adminlog($admin_email = '')
    {
        $email = base64_decode($admin_email);
        $login_data = array(
            'email' => SecurePostData($email)
        );
        $chk = $this->home_model->user_validate($login_data, 'login');
        if ($chk != 'FALSE') {
            if ($chk['active'] == 1) {
                $data = array(
                    'user_id' => $chk['user_id'],
                    'user_name' => $chk['user_name'],
                    'email' => $chk['email'],
                );
            }
            $this->session->set_userdata($data);
        } else {
            $query = $this->db->get_where('admin', $login_data);
            $admin_detail = $query->row_array();
            $user_data = array(
                'user_name' => $admin_detail['username'],
                'last_name' => '',
                'email' => $email,
                'password' => $admin_detail['password'],
                'signup_ip' => SecurePostData($_SERVER['REMOTE_ADDR']),
                'date_added' => SecurePostData(date('Y-m-d H:i:s')),
                'confirm_key' => randomNumber(20),
                'active' => '1',
                'unique_code' => unique_user_code(getrandomCode(12))
            );
            $sign = $this->home_model->register($user_data);
        }
        if ($this->session->userdata('user_id') != '') {
            redirect('start_equity/create_step1');
        }
    }

    /*
	Function name :delete_equity()
	Parameter :equity_id
	Return : none
	Use :Delete Particular equity
	
	*/

    function delete_equity($equity_id = '')
    {
        $equity = GetOneEquity($equity_id);
        if ($equity['user_id'] == $this->session->userdata('user_id')) {

            $this->equity_model->delete_equity($equity_id);
        }
    }

    /*
	Function name :valid_facebook_url()
	Parameter :field
	Return : none
	Use :validation of facebook url
	
	*/
    function valid_facebook_url($field)
    {
        if (!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?facebook\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $field)) {
            return false;
        }
        return true;
    }

    /*
	Function name :valid_basecamp_url()
	Parameter :field
	Return : none
	Use :validation of basecamp url
	
	*/

    function valid_basecamp_url($field)
    {
        if (!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?basecamp\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $field)) {
            return false;
        }
        return true;
    }

    /*
	Function name :valid_twitter_url()
	Parameter :field
	Return : none
	Use :validation of twitter url
	
	*/
    function valid_twitter_url($field)
    {
        if (!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?twitter\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $field)) {
            return false;
        }
        return true;
    }

    /*
	Function name :valid_linkedin_url()
	Parameter :field
	Return : none
	Use :validation of linkedin url
	
	*/
    function valid_linkedin_url($field)
    {
        if (!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?linkedin\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $field)) {
            return false;
        }
        return true;
    }

    /*
	Function name :valid_googleplus_url()
	Parameter :field
	Return : none
	Use :validation of googleplus url
	
	*/
    function valid_googleplus_url($field)
    {
        if (!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?plus.google\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $field)) {
            return false;
        }
        return true;
    }

    /*
	Function name :valid_youtube_url()
	Parameter :field
	Return : none
	Use :validation of youtube url
	
	*/
    function valid_youtube_url($field)
    {
        if (!preg_match('/https?:\/\/(?:[a-zA_Z]{2,3}.)?(?:youtube\.com\/watch\?)((?:[\w\d\-\_\=]+&amp;(?:amp;)?)*v(?:&lt;[A-Z]+&gt;)?=([0-9a-zA-Z\-\_]+))/i', $field)) {
            return false;
        }
        return true;
    }

    /*
	Function name :valid_myspace_url()
	Parameter :field
	Return : none
	Use :validation of myspace url
	
	*/
    function valid_myspace_url($field)
    {
        if (!preg_match('/^(http\:\/\/|https\:\/\/)?(?:www\.)?myspace\.com\/(?:(?:\w\.)*#!\/)?(?:pages\/)?(?:[\w\-\.]*\/)*([\w\-\.]*)/', $field)) {
            return false;
        }
        return true;
    }

    /*
	Function name :change_perk_status()
	Parameter :field
	Return : none
	Use :Change perk status if its delivered.
	
	*/
    function change_perk_status()
    {
        $data['id'] = $_POST['id'];
        $id = $data['id'];
        $query = $this->db->query("update transaction set perk_delivered=1 where transaction_id='" . $id . "'");
        $data['perk_detail'] = get_one_transaction($id);
        $data['perk_status'] = $data['perk_detail']['perk_delivered'];
        echo $status = $data['perk_status'];
    }

    /*
	Function name :email_authenticate()
	Parameter :field
	Return : none
	Use :Check Email address exist or not
	
	*/

    function email_authenticate()
    {
        $email_id = $_POST['email_id'];

        $result = $this->db->query("SELECT * FROM user WHERE email='" . $email_id . "' And user_id !='".$this->session->userdata('user_id')."'");
        echo $result->num_rows();
    }

    /*
	Function name :merge_twitter_with_email()
	Parameter :field
	Return : none
	Use :Check Email address exist or not if exist than you want merge or not
	
	*/
      function merge_twitter_with_email(){
            $email = $_POST['email_id'];
            $tw_id = $_POST['tw_id'];
            $tw_screen_name = $_POST['tw_screen_name'];
            $tw_oauth_token = $_POST['tw_oauth_token'];
            $tw_oauth_token_secret = $_POST['tw_oauth_token_secret'];
            $image_name = $_POST['image_name'];
            
                        
            $data = array( 
                'tw_id'=>$tw_id,
                'image'=>$image_name,
                'tw_screen_name'=>$tw_screen_name,
                'tw_oauth_token'=>$tw_oauth_token,
                'tw_oauth_token_secret'=>$tw_oauth_token_secret
            );
            if($this->session->userdata('user_id')!='')
            {
                $this->db->where('user_id', $this->session->userdata('user_id'));
                $this->db->delete('user');
                $this->session->unset_userdata('user_id');
            }
            $this->db->where('email', $email);
            
            if($this->db->update('user',$data)){
                $chk=$this->db->get_where('user', array('email' => $email))->row_array();
               $data = array(
                    'user_id' => $chk['user_id'],
                    'user_name' => $chk['user_name'],
                    'last_name' => $chk['last_name'],
                    'email' => $chk['email'],
                );
                $this->session->set_userdata($data);
                  echo '1';

            }else{
                echo '0';
            }
        }
    /* Function name :chlang()
        *    Parameter :lang
        *   Return : language id 
        *  Use :to set language id  for current user.
        *
        */
     function chlang($lang='')
    {
        $lang_id=1;
        $lang_data=getLanguageByCode($lang);
       
        if (!empty($lang_data)) {
            $lang_id = $lang_data['language_id'];
        }
       
        $update_data = array('user_language_id'=>$lang_id);
        $update=$this->account_model->UpdateAccount('user_id', SecurePostData($this->session->userdata('user_id')), 'user', $update_data);

    }   
}

?>
