<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Equity extends ROCKERS_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('equity_model');

        $this->load->model('startequity_model');

        $this->load->model('follower_model');
        $this->load->model('following_model');
        $this->load->model('account_model');
        $this->load->model('inbox_model');
        $this->load->model('activity_model');
        $this->load->helper('cookie');
        $this->load->library('securimage');
        $this->load->helper('download');

        $this->load->model('repayment_model');

    }

    /*
    Function name :equity_detail()
    Parameter :$equity_url_title(equity url title),$msg (message string or equity id)
    Return : none
    Use : to show the equity detail
        this is used to show the equity information or details on equity detail page
    */

    function equity_detail($equity_url = '', $msg = '')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $user_id = check_user_authentication(false);

        $data['session_user_id'] = $user_id;
        if (is_numeric($msg)) {
            $id = $msg;
            $msg = '';
        }
        // for tab control
        $data['tabs'] = '';
        if ($msg == 'gallery') {
            $data['tabs'] = 'gallery';
            $msg = '';
        }
        if ($msg == 'proj_follow') {
            $data['tabs'] = 'proj_follow';
            $msg = '';
        }
        if ($msg == 'funders') {
            $data['tabs'] = 'funders';
            $msg = '';
        }
        if ($msg == 'comments') {
            $data['tabs'] = 'comments';
            $msg = '';
        }
        if ($msg == 'update') {
            $data['tabs'] = 'update';
            $msg = '';
        }
        if ($msg == 'description') {
            $data['tabs'] = 'description';
            $msg = '';
        }
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $data['taxonomy_setting'] = taxonomy_setting();
        $data['msg'] = $msg;
        // not cached, do our things that need caching
        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_url, $is_featured = 0, $is_status = '', $joinarr = array(
            'user','investment_tax_relief'

        ), $limit = 10, $order = array(
            'equity_id' => 'desc'
        ),0,'no',1); // store in cache


        $user_data = UserData($user_id, array());
        $user_occupation = $user_data[0]['user_occupation'];
        $user_image = $user_data[0]['image'];
        $address = $user_data[0]['address'];
        $data['login_user_occupation'] = $user_occupation;
        $data['login_user_image'] = $user_image;
        $data['login_user_address'] = $address;
        
        if ($user_occupation != '' && $user_image != '' && $address != '') {
            $request_access_allow = 'yes';
        }else if ($user_id == $get_equity_user_detail[0]['user_id']) {
            $request_access_allow = 'yes';
        }else{
            $request_access_allow = 'no';
        }
        $data['request_access_allow'] = $request_access_allow;

        $data['equity_detail'] = $get_equity_user_detail;
        
        $data['share_project_detail'] = $get_equity_user_detail;
        
        $status = $get_equity_user_detail[0]['status'];
        $user_id = $get_equity_user_detail[0]['user_id'];
        $equity_id = $get_equity_user_detail[0]['equity_id'];
        $company_name = SecureShowData($get_equity_user_detail[0]['company_name']);
        $company_id = SecureShowData($get_equity_user_detail[0]['company_id']);
        $company_overview = $get_equity_user_detail[0]['company_overview'];
        $investment_tax_relief_type = $get_equity_user_detail[0]['tax_relief_type'];

        

        $data['company_industry_data'] = $this->equity_model->GetEquityCompanyIndustry($equity_id, $joinarr = array('company_industry', 'equity'), $limit = 10, $order = array('equity_company_industry.company_industry_id' => 'desc'));
       
        $cookieData = get_cookie("the_cookie");
        $admin_id = $this->session->userdata('admin_id');

        if (!isset($equity_id) || $equity_id <= 0) {
            redirect('equity/invalid_page');
        }
        $data['comment_url'] = site_url('equity/comment_list/' . $equity_id . '/');
        $data['updates_url'] = site_url('equity/updates_list/' . $equity_id . '/');
        $data['funders_url'] = site_url('equity/funders_list/' . $equity_id . '/');
        // display draft equity
        $view_draft_equity = '';
        $view_hidden_equity = '';
        // display all tabs in detail page
        $is_allow_tab = 'no';
        if ($this->startequity_model->is_equity_owner($equity_id, false) || $admin_id > 0) { 
            $is_allow_tab = 'yes'; 
            $view_draft_equity = 'yes';
            $view_hidden_equity = 'yes';
        } else {
            if (!$this->startequity_model->is_equity_owner($equity_id, true)) {

                $is_status = $status;
                $status_check = array(0, 1);
                if (!in_array($is_status, $status_check)) {
                    $view_draft_equity = 'yes';
                }


                $status_check = array(8);
                if (!in_array($is_status, $status_check)) {
                    $view_hidden_equity = 'yes';
                }

            }
        }

        $data['view_all_tabs'] = $is_allow_tab;
        //$delete_cache = delete_all_cache();

        $equity_id = $get_equity_user_detail[0]['equity_id'];

        // update conuter
        $sql = "update equity set view_counter=view_counter+1 where equity_url='" . $equity_url . "' or equity_id ='" . $equity_url . "'";
        $this->db->query($sql);

        project_deletecache($equity_id);

        $login_user_data = UserData($this->session->userdata('user_id'), array());
        $data['result'] = $user_data;
        $data['login_user_data'] = $login_user_data;

        if (!$this->simple_cache->is_cached('equity_detail_all_update_count' . $equity_url)) {
            // not cached, do our things that need caching
            $get_equity_update_count = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'updates'
            ), 100, $group = array(), $order = array(
                'updates.date_added' => 'desc'
            ), ''); // store in cache

            $this->simple_cache->cache_item('equity_detail_all_update_count' . $equity_url, $get_equity_update_count);
        } else {
            $get_equity_update_count = $this->simple_cache->get_item('equity_detail_all_update_count' . $equity_url);
        }
        $data['update_on_my_equity_total'] = $get_equity_update_count;
        $data['update_on_my_equity_count'] = count($data['update_on_my_equity_total']);
        if (!$this->simple_cache->is_cached('equity_detail_all_update' . $equity_url)) {
            // not cached, do our things that need caching
            $get_equity_update = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'updates'
            ), $limit = 5, $group = array(), $order = array(
                'updates.date_added' => 'desc'
            ), ''); // store in cache

            $this->simple_cache->cache_item('equity_detail_all_update' . $equity_url, $get_equity_update);
        } else {
            $get_equity_update = $this->simple_cache->get_item('equity_detail_all_update' . $equity_url);
        }
        //echo '<pre>'; print_r($get_equity_update); die;
        $data['update_on_my_equity'] = $get_equity_update;
        if (!$this->simple_cache->is_cached('equity_detail_all_funder_total' . $equity_url)) {
            $data['funder_total'] = $this->account_model->GetDonation('funder', 0, $equity_id, '', $join = array(
                'user'
            ), 0, $order = array(
                'transaction_id' => 'desc'
            ),0,0,0,1);
            $this->simple_cache->cache_item('equity_detail_all_funder_total' . $equity_url, $data['funder_total']);
        } else {
            $data['funder_total'] = $this->simple_cache->get_item('equity_detail_all_funder_total' . $equity_url);
        }
        $data['funder_count'] = count($data['funder_total']);

        if (!$this->simple_cache->is_cached('equity_detail_all_funder' . $equity_url)) {
            $data['funder'] = $this->account_model->GetDonation('funder', 0, $equity_id, '', $join = array(
                'user'
            ), $limit = 5, $order = array(
                'transaction_id' => 'desc'
            ),0,0,0,1);
            $this->simple_cache->cache_item('equity_detail_all_funder' . $equity_url, $data['funder']);

        } else {
            $data['funder'] = $this->account_model->GetDonation('funder', 0, $equity_id, '', $join = array(
                'user'
            ), $limit = 5, $order = array(
                'transaction_id' => 'desc'
            ),0,0,0,1);
            //$data['funder'] = $this->simple_cache->get_item('equity_detail_all_funder' . $equity_url);
        }
        
        if (!$this->simple_cache->is_cached('equity_detail_total_comment' . $equity_url)) {
            $data['comment_total'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'comment',
                'user'
            ), 100, $group = array(
                'comment_id' => 'comment.comment_id'
            ), $order = array(
                'equity.equity_id' => 'desc',
                'comment.comment_id' => 'desc'
            ), 1);
            $this->simple_cache->cache_item('equity_detail_total_comment' . $equity_url, $data['comment_total']);
        } else {
            $data['comment_total'] = $this->simple_cache->get_item('equity_detail_total_comment' . $equity_url);
        }
        $data['comment_count'] = count($data['comment_total']);
        if (!$this->simple_cache->is_cached('equity_detail_comments' . $equity_url)) {
            $data['comment'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'comment',
                'user'
            ), $limit = 5, $group = array(
                'comment_id' => 'comment.comment_id'
            ), $order = array(
                'equity.equity_id' => 'desc',
                'comment.comment_id' => 'desc'
            ), 1);
            $this->simple_cache->cache_item('equity_detail_comments' . $equity_url, $data['comment']);
        } else {
            $data['comment'] = $this->simple_cache->get_item('equity_detail_comments' . $equity_url);
        }
        if (!$this->simple_cache->is_cached('equity_detail_all_gallery' . $equity_url)) {
            // not cached, do our things that need caching
            $get_equity_gallery = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'equity_gallery'
            ), $limit = 1000, $group = array(), $order = array(
                'equity.equity_id' => 'desc'
            ), '', '', '', '', $user_id); // store in cache

            $this->simple_cache->cache_item('equity_detail_all_gallery' . $equity_url, $get_equity_gallery);
        } else {
            $get_equity_gallery = $this->simple_cache->get_item('equity_detail_all_gallery' . $equity_url);
        }
        $data['gallery'] = $get_equity_gallery;
        if (!$this->simple_cache->is_cached('equity_detail_all_video' . $equity_url)) {
            // not cached, do our things that need caching
            $get_equity_video = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'video_gallery'
            ), $limit = 1000, $group = array(), $order = array(
                'video_gallery.id' => 'asc'
            ), '', '', '', '', $user_id); // store in cache

            $this->simple_cache->cache_item('equity_detail_all_video' . $equity_url, $get_equity_video);
        } else {
            $get_equity_video = $this->simple_cache->get_item('equity_detail_all_video' . $equity_url);
        }
        $data['equity_video'] = $get_equity_video;
        if (!$this->simple_cache->is_cached('equity_detail_all_file' . $equity_url)) {
            // not cached, do our things that need caching
            $get_equity_file = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'file_gallery'
            ), $limit = 1000, $group = array(), $order = array(
                'file_gallery.id' => 'asc'
            ), '', '', '', '', $user_id); // store in cache

            $this->simple_cache->cache_item('equity_detail_all_file' . $equity_url, $get_equity_file);
        } else {
            $get_equity_file = $this->simple_cache->get_item('equity_detail_all_file' . $equity_url);
        }

        $data['file_gallery'] = $get_equity_file;
        if (!$this->simple_cache->is_cached('equity_detail_followers' . $get_equity_user_detail[0]['equity_id'])) {
            $data['follower'] = $this->follower_model->GetAllFollower($type = 'equity_follow', $equity_id, 0, $join = array(
                'user'
            ), $limit = 1000, $order = array(
                'equity_follow_id' => 'desc'
            ));
            $this->simple_cache->cache_item('equity_detail_followers' . $get_equity_user_detail[0]['equity_id'], $data['follower']);
        } else {
            $data['follower'] = $this->simple_cache->get_item('equity_detail_followers' . $get_equity_user_detail[0]['equity_id']);
        }
        // fetch data team member
        $data['equity_company_team_member_data'] = $this->startequity_model->equity_team_member_data($equity_id, '', 1);
        $data['company_team_member_data'] = $this->startequity_model->company_team_member_data($company_id, '', 1,$equity_id);
         $data['equity_team_members'] = $this->startequity_model->equity_team_members($equity_id, '', 1);
         // var_dump($data['equity_team_members']);die;

        // Fetch Data Perks
        if (!$this->simple_cache->is_cached('equity_detail_perks' . $equity_url)) {
            $data['perk'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'perk'
            ), $limit = 1000, $group = array(), $order = array(
                'perk.perk_amount' => 'asc'
            ), '');
            $this->simple_cache->cache_item('equity_detail_perks' . $equity_url, $data['perk']);
        } else {
            $data['perk'] = $this->simple_cache->get_item('equity_detail_perks' . $equity_url);
        }


        //fetch data previous funding
        if (!$this->simple_cache->is_cached('equity_detail_previous_funding' . $equity_url)) {
            $data['previous_funding'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'previous_funding'
            ), $limit = 1000, $group = array(), $order = array(
                'previous_funding.previous_funding_id' => 'desc'
            ), '');
            $this->simple_cache->cache_item('equity_detail_previous_funding' . $equity_url, $data['previous_funding']);
        } else {
            $data['previous_funding'] = $this->simple_cache->get_item('equity_detail_previous_funding' . $equity_url);
        }

        //fetch data investors
        if (!$this->simple_cache->is_cached('equity_detail_investors' . $equity_url)) {
            $data['investors'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
                'investors'
            ), $limit = 1000, $group = array(), $order = array(
                'investors.investor_id' => 'desc'
            ), '');
            $this->simple_cache->cache_item('equity_detail_investors' . $equity_url, $data['investors']);
        } else {
            $data['investors'] = $this->simple_cache->get_item('equity_detail_investors' . $equity_url);
        }
        // $pages_title='';
        $meta_keyword = '';
        $meta_description = '';
        if ($company_name != '') {
            $pages_title = $company_name . ' | ' . $meta['title'];
        } else {
            $pages_title = $meta['title'];
        }
        if ($company_name != '') $meta_keyword = $company_name;
        if ($company_overview != '') {
            $meta_description = $company_overview;
        } else {
            $meta_description = $meta['meta_description'];
        }
        $this->template->write('meta_title', $pages_title, TRUE);
        $this->template->write('meta_description', $meta_description, TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'] . "," . $meta_keyword, TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        if ($view_draft_equity != 'yes') {
            $this->template->front_write_view('main_content', 'equity/404_page', $data, TRUE);
        } else if ($view_hidden_equity != 'yes') {
            $this->template->front_write_view('main_content', 'equity/hidden_page', $data, TRUE);
        } else {
            $this->template->front_write_view('main_content', 'equity/equity_detail', $data, TRUE);
        }
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
        //$this->output->enable_profiler(TRUE);
    }

    /*
    Function name :Addrequestaccess()
    Parameter : no
    Return : success data
    Use : add request to owner for user can see the document , updates ,comments ,funders
    */
    function Addrequestaccess()
    {
        $data = array();
        $request_type = SecurePostData($this->input->post('access_request_type'));
        $equity_id = SecurePostData($this->input->post('equity_id'));

        $check_id_array = array("equity_id" => $equity_id, "user_id" => $this->session->userdata('user_id'));
        $access_data = $this->startequity_model->getTableData('access_request', $check_id_array);
        $request_access_data = $access_data[0];
        $site_setting = site_setting();
        $site_name = $site_setting['site_name'];
        $access_request_manage = $site_setting['access_request_manage'];
        $equity = GetOneEquity($equity_id);

        $created_date = date('Y-m-d H:i:s');
        if ($request_access_data['equity_id'] > 0) {
            $created_date = $request_access_data['created_date'];
        }
        $add_request_data = array(
            'user_id' => $this->session->userdata('user_id'),
            'equity_id' => $equity_id,
            $request_type => 1,
            'request_name' => $request_type,
            'created_date' => $created_date,
            'updated_date' => date('Y-m-d H:i:s'),

        );

        //print_r($add_request_data);die;
        if ($request_access_data['access_request_id'] > 0) {

            $this->startequity_model->AddInsertUpdateTable('access_request', 'access_request_id', $request_access_data['access_request_id'], $add_request_data);
        } else {

            $this->startequity_model->AddInsertUpdateTable('access_request', '', '', $add_request_data);
            $access_request_id =$this->db->insert_id();
            project_activity_feedback('access_request', $this->session->userdata('user_id'), '', $equity_id);
        }

        $userdata = UserData($this->session->userdata('user_id'));
        $owner_data = UserData($equity['user_id']);
        $owner_name = $owner_data[0]['user_name'];
        $owner_email = $owner_data[0]['email'];
        $user_profile_slug = $userdata[0]['profile_slug'];
        $section_name = $request_type;
        $username = $userdata[0]['user_name'] . ' ' . $userdata[0]['last_name'];
        $company_name = $equity['company_name'];
        $equity_url = $equity['equity_url'];
        $email = $userdata[0]['email'];
        $taxonomy_setting = taxonomy_setting();
        $project_url = $taxonomy_setting['project_url'];
        $equity_page_link = site_url($project_url . '/' . $equity_url);
        $equity_title_anchor = '<a href="' . $equity_page_link . '">' . SecureShowData($company_name) . '</a>';

        $requester_page_link = site_url('user/' . $user_profile_slug);
        $requester_title_anchor = '<a href="' . $requester_page_link . '">' . $username . '</a>';


        $request_page_link = site_url('equity/dashboard/' . $equity_id . '#access-tab');


        //============== Send access request to owner================================
        $language_id=GetUserLangCode( $owner_data[0]['user_id']);
        $template="Request access received";
         //send email to admin
        if($access_request_manage==1)
        {
             $template="Request access received For Admin";
             $request_page_link = site_url('admin/equity/equity_detail/' . $equity_url . '#request');
        }
        $email_template = $this->db->query("select * from `email_template` where task='".$template."' and language_id=".$language_id);
        $email_temp = $email_template->row();
        $email_message = $email_temp->message;
        $email_subject = $email_temp->subject;
        $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
        $email_address_from = $email_temp->from_address;
        $email_address_reply = $email_temp->reply_address;
        $email_to = $owner_email;
        //send email to admin
        if($access_request_manage==1)
        {
            $email_to =  $email_address_from;
        }
        $email_message = str_replace('{break}', '<br/>', $email_message);
        $email_message = str_replace('{user_name}', $owner_name, $email_message);
        $email_message = str_replace('{requestor_name}', $requester_title_anchor, $email_message);
        $email_message = str_replace('{company_name}', SecureShowData($company_name), $email_message);
        $email_message = str_replace('{company_name_link}', $equity_title_anchor, $email_message);
        $email_message = str_replace('{request_page_link}', $request_page_link, $email_message);
        $email_message = str_replace('{section-name}', $section_name, $email_message);
        $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
        $email_message = str_replace('{site_name}', $site_name, $email_message);
        $str = $email_message;


        email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

        //============== Send access request to requested user================================
         $language_id=GetUserLangCode( $userdata[0]['user_id']);
        $email_template = $this->db->query("select * from `email_template` where task='Request access sent' and language_id=".$language_id);
        $email_temp = $email_template->row();
        $email_message = $email_temp->message;
        $email_subject = $email_temp->subject;
        $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
        $email_address_from = $email_temp->from_address;
        $email_address_reply = $email_temp->reply_address;
        $email_to = $email;
        $email_message = str_replace('{break}', '<br/>', $email_message);
        $email_message = str_replace('{user_name}', $username, $email_message);
        $email_message = str_replace('{company_name}', SecureShowData($company_name), $email_message);

        $email_message = str_replace('{section-name}', $section_name, $email_message);
        $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
        $email_message = str_replace('{site_name}', $site_name, $email_message);
        $str = $email_message;
        email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

        $data['success'] = 'success';
        echo json_encode($data);
    }

    /*
    Function name :Updaterequestaccess()
    Parameter : no
    Return : success data
    Use : approve or reject access request
    */
    function Updaterequestaccess()
    {


        //$data=array();
        $site_setting = site_setting();
        $site_name = $site_setting['site_name'];
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $user_id = check_user_authentication(true);
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        
        $updates = EditorSecurePostData($this->input->post('updates'));

        $comments = SecurePostData($this->input->post('comments'));
        $funders = SecurePostData($this->input->post('funders'));
        $docs_media = SecurePostData($this->input->post('docs_media'));
        $access_request_id = SecurePostData($this->input->post('access_request_id'));
        $access_user_id = SecurePostData($this->input->post('access_user_id'));
        $deny_reason = strip_tags($this->input->post('deny_reason'));
        $reason_save = SecurePostData($this->input->post('reason_save'));
        $request_type = SecurePostData($this->input->post('request_type'));


        $add_request_data = array(
            'user_id' => $access_user_id,
            'equity_id' => $equity_id,
            'updates' => $updates,
            'comments' => $comments,
            'funders' => $funders,
            'docs_media' => $docs_media,
            'updated_date' => date('Y-m-d H:i:s'),

        );
        if ($reason_save == 1) {
            $add__equity_request_data = array(
                'deny_reason_access' => $deny_reason,
                'reason_save_aceess' => $reason_save
            );
            $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $add__equity_request_data);
        }


        $this->startequity_model->AddInsertUpdateTable('access_request', 'access_request_id', $access_request_id, $add_request_data);

        $check_id_array = array("access_request_id" => $access_request_id);
        $access_data = $this->startequity_model->getTableData('access_request', $check_id_array);
        $request_access_data = $access_data[0];

        $equity = GetOneEquity($request_access_data['equity_id']);
        $userdata = UserData($request_access_data['user_id']);

        $data['get_access_request_count'] = $this->equity_model->GetAccessRequest($equity['user_id'], $request_access_data['equity_id'], '1', $joinarr = array('access_request', 'accreditation'), $limit = 10, $order = array('access_request_id' => 'desc'), '', 'yes');

        //============== Approve access request by owner================================
        $access_reason = $deny_reason;
        $company_name = $equity['company_name'];
        $username = $userdata[0]['user_name'];

        $email = $userdata[0]['email'];
        $equity_url = $equity['equity_url'];
        $section_name = $request_access_data['request_name'];
        $taxonomy_setting = taxonomy_setting();
        $project_url = $taxonomy_setting['project_url'];
        $equity_page_link = site_url($project_url . '/' . $equity_url);
        $equity_title_anchor = '<a href="' . $equity_page_link . '">' . SecureShowData($company_name) . '</a>';
         $language_id=GetUserLangCode( $userdata[0]['user_id']);
        if ($request_type == 'approve') {
            $email_template = $this->db->query("select * from `email_template` where task='Request access approved' and language_id=".$language_id);
            $email_temp = $email_template->row();
            $email_message = $email_temp->message;
            $email_subject = $email_temp->subject;
            $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_to = $email;
            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
            $email_message = str_replace('{section-name}', $section_name, $email_message);
            $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $str = $email_message;
            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
        } //============== Reject access request by owner================================
        else {
            $email_template = $this->db->query("select * from `email_template` where task='Request access denied' and language_id=".$language_id);
            $email_temp = $email_template->row();
            $email_message = $email_temp->message;
            $email_subject = $email_temp->subject;
            $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_to = $email;
            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
            $email_message = str_replace('{reason}', $access_reason, $email_message);
            $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $str = $email_message;
            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
        }
        // end
        $permission = '';

        $str = '';
        if ($request_access_data['updates'] == 2) {
            if ($str == '') $str .= UPDATES;
            else $str .= "," . UPDATES;
        }

        if ($request_access_data['comments'] == 2) {
            if ($str == '') $str .= COMMENTS;
            else $str .= "," . COMMENTS;
        }
        if ($request_access_data['funders'] == 2) {
            if ($str == '') $str .= FUNDERS;
            else $str .= "," . FUNDERS;
        }
        if ($request_access_data['docs_media'] == 2) {
            if ($str == '') $str .= DOCS_MEDIA;
            else $str .= "," . DOCS_MEDIA;
        }

        $data['permission'] = $str;
        $data['success'] = 'success';
        echo json_encode($data);
    }

    /*
    Function name :comment_list()
    Parameter :$equity_id(equity id),$offset (number)
    Return : none
    Use : to show the comments on equity detail page using ajax
        this is used to show the all or more comments on equity detail page
    */
    function comment_list($equity_id = '', $offset = 0)
    {
        $data['equity_user_id'] = $this->session->userdata('user_id');

        $data['offset'] = $offset;
        $data['comment_row'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'comment',
            'user'
        ), 0, $group = array(
            'comment_id' => 'comment.comment_id'
        ), $order = array(
            'equity.equity_id' => 'desc',
            'comment.comment_id' => 'desc'
        ), 1);
        $count_comments = count($data['comment_row']);

        $data['total_row_display'] = $count_comments - $offset;
        $data['comment'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'comment',
            'user'
        ), $limit = 5, $group = array(
            'comment_id' => 'comment.comment_id'
        ), $order = array(
            'equity.equity_id' => 'desc',
            'comment.comment_id' => 'desc'
        ), 1, $offset);

        $this->load->view(THEME_LOCATION.'equity/comment_list', $data);
    }

    /*
    Function name :updates_list()
    Parameter :$equity_id(equity id),$offset (number)
    Return : none
    Use : to show the updates on equity detail page using ajax
         this is used to show the all or more updates on equity detail page
    */
    function updates_list($equity_id = '', $offset = 0)
    {
        $equity_data = GetOneEquity($equity_id);
        $data['user_id'] = $equity_data['user_id'];
        $user_data = UserData($equity_data['user_id']);

        $data['user_name'] = $user_data[0]['user_name'];
        $data['last_name'] = $user_data[0]['last_name'];
        $data['profile_slug'] = $user_data[0]['profile_slug'];

        $data['equity_user_id'] = $this->session->userdata('user_id');
        $data['offset'] = $offset;
        $data['update_on_my_equity_row'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'updates'
        ), $limit = 100, $group = array(), $order = array(
            'updates.date_added' => 'desc'
        ), '', '', $count = 'yes');
        $count_updates = $data['update_on_my_equity_row'];

        $data['total_row_display'] = $count_updates - $offset;
        $data['update_on_my_equity'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'updates'
        ), $limit = 5, $group = array(), $order = array(
            'updates.date_added' => 'desc'
        ), '', $offset);
        $this->load->view(THEME_LOCATION.'equity/updates_list', $data);
    }

    /*
    Function name :funders_list()
    Parameter :$equity_id(equity id),$offset (number)
    Return : none
    Use : to show the funders on equity detail page using ajax
        this is used to show the all or more funders on equity detail page
    */
    function funders_list($equity_id = '', $offset = 0)
    {
        $data['equity_user_id'] = $this->session->userdata('user_id');
        $data['equity_id'] = $equity_id;
        $data['offset'] = $offset;
        $data['funder_row'] = $this->account_model->GetDonation('funder', 0, $equity_id, '', $join = array(
            'user'
        ), 0, $order = array(
            'transaction_id' => 'desc'
        ),0,0,0,1);
        $count_funders = count($data['funder_row']);
        $data['total_row_display'] = $count_funders - $offset;
        $data['funder'] = $this->account_model->GetDonation('funder', 0, $equity_id, '', $join = array(
            'user'
        ), 5, $order = array(
            'transaction_id' => 'desc'
        ), $offset,0,0,1);
        $this->load->view(THEME_LOCATION.'equity/funders_list', $data);
    }

    /*
    Function name :dashboard()
    Parameter :$equity_id(equity id)
    Return : none
    Use : To see equity's all the information like perks, updates, comments, donation etc under one view for equity owner
    */
    function dashboard($equity_id = '')
    {
        $user_id = check_user_authentication(true);
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }

        $data['equity_id'] = $equity_id;
        $login_user_data = UserData($this->session->userdata('user_id'), array());
        $data['login_user_data'] = $login_user_data;
        $data['site_setting'] = site_setting();
        $meta = meta_setting();
        $get_equity_user_detail = $this->equity_model->GetAllEquities($user_id = 0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user',

        ), $limit = 10, $order = array(
            'equity_id' => 'desc'
        )); // store in cache

        $data['equity_detail'] = $get_equity_user_detail[0];

        $data['member_teams'] = $this->startequity_model->team_member($equity_id);


        $data['company_industry_data'] = $this->equity_model->GetEquityCompanyIndustry($equity_id, $joinarr = array('company_industry', 'equity'), $limit = 1000, $order = array('equity_company_industry.company_industry_id' => 'desc'));

        $data['is_equity_owner'] = $this->startequity_model->is_equity_owner($equity_id, false);

        $data['get_access_request'] = $this->equity_model->GetAccessRequest($user_id, $equity_id, '', $joinarr = array('access_request', 'accreditation', 'equity'), $limit = 1000, $order = array('updates' => 'desc', 'comments' => 'desc', 'funders' => 'desc', 'docs_media' => 'desc'));
      
       
        $data['get_access_request_count'] = $this->equity_model->GetAccessRequest($user_id, $equity_id, '1', $joinarr = array('access_request', 'accreditation','equity'), $limit = 1000, $order = array('access_request_id' => 'desc'), '', 'yes');

        $data['get_interest_request'] = $this->equity_model->GetAccessRequest($user_id, $equity_id, '', $joinarr = array('interest_request', 'accreditation', 'equity'), $limit = 1000, $order = array('interest_request_id' => 'desc'));

        $data['get_interest_request_count'] = $this->equity_model->GetAccessRequest($user_id, $equity_id, '', $joinarr = array('interest_request', 'accreditation','equity'), $limit = 1000, $order = array('interest_request_id' => 'desc'), '', 'yes', '1');

        $data['total_request_counter'] = $data['get_access_request_count'] + $data['get_interest_request_count'];

        $data['equity_updates'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'updates'
        ), $limit = 0, $group = array(), $order = array(
            'updates.date_added' => 'desc'
        ), '');

        $data['equity_comments'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'comment',
            'user'
        ), $limit = 0, $group = array(
            'comment_id' => 'comment.comment_id'
        ), $order = array(
            'equity.equity_id' => 'desc',
            'comment.comment_id' => 'desc'
        ), '');

        $data['funder'] = $this->account_model->GetDonation('funder', 0, $equity_id, '', $join = array(
            'user',
            'perk'
        ), $limit = 50, $order = array(
            'transaction_id' => 'desc'
        ));


        $data['follower'] = $this->follower_model->GetAllFollower($type = 'equity_follow', $equity_id, 0, $join = array(
            'user'
        ), $limit = 1000, $order = array(
            'equity_follow_id' => 'desc'
        ));
     
      

         // var_dump($data['rePayemnts']);die;

        $this->template->write('meta_title', 'Dashboard-' . $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'equity/equity_dashboard', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
    Function name :AddInterestRequest()
    Parameter :no
    Return : success message
    Use : interested user can request to owner for invest
    */
    function AddInterestRequest()
    {
        $data = array();
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $site_setting = site_setting();
        $site_name = $site_setting['site_name'];
         $access_request_manage = $site_setting['access_request_manage'];
        $taxonomy_setting = taxonomy_setting();
        $project_name = $taxonomy_setting['project_name'];
        $funds = $taxonomy_setting['funds'];

        $check_id_array = array("equity_id" => $equity_id, "user_id" => $this->session->userdata('user_id'));
        $interest_data = $this->startequity_model->getTableData('interest_request', $check_id_array);
        $interest_request_data = $interest_data[0];

        $equity = GetOneEquity($equity_id);

        $created_date = date('Y-m-d H:i:s');
        if ($interest_request_data['equity_id'] > 0) {
            $created_date = $interest_request_data['created_date'];
        }

        $add_request_data = array(
            'user_id' => $this->session->userdata('user_id'),
            'equity_id' => $equity_id,
            'status' => 1,
            'payment_status' => 0,
            'created_date' => $created_date,
            'updated_date' => date('Y-m-d H:i:s'),

        );
        if ($interest_request_data['interest_request_id'] > 0) {
            $this->startequity_model->AddInsertUpdateTable('interest_request', 'equity_id', $equity_id, $add_request_data);
        } else {
            $this->startequity_model->AddInsertUpdateTable('interest_request', '', '', $add_request_data);
            $interest_request_id =$this->db->insert_id();
            project_activity_feedback('intrest_request', $this->session->userdata('user_id'), '', $equity_id);
        }


        $equity_data = $this->equity_model->GetAllEquities($user_id = 0, $equity_id, $is_featured = 0, $is_status = '', $joinarr = array(
            'user',

        ), $limit = 10, $order = array(
            'equity_id' => 'desc'
        ));
        $equity = $equity_data[0];

        $user_data = UserData($this->session->userdata('user_id'));


        $company_name = $equity['company_name'];
        $equity_url = $equity['equity_url'];
        $email = $user_data[0]['email'];
        $taxonomy_setting = taxonomy_setting();
        $project_url = $taxonomy_setting['project_url'];
        $equity_page_link = site_url($project_url . '/' . $equity_url);
        $equity_title_anchor = '<a href="' . $equity_page_link . '">' . SecureShowData($company_name) . '</a>';


        $owner_data = UserData($equity['user_id']);
        $owner_name = $owner_data[0]['user_name'];
        $owner_email = $owner_data[0]['email'];
        $user_profile_slug = $user_data[0]['profile_slug'];
        $username = $user_data[0]['user_name'] . ' ' . $user_data[0]['last_name'];
        $requester_page_link = site_url('user/' . $user_profile_slug);
        $requester_title_anchor = '<a href="' . $requester_page_link . '">' . $username . '</a>';


        $request_page_link = site_url('equity/dashboard/' . $equity_id . '#access-tab');
        $equity_title_anchor_owner = '<a href="' . $request_page_link . '">' . SecureShowData($company_name) . '</a>';
        //============== Send access request to owner================================
         $language_id=GetUserLangCode( $owner_data[0]['user_id']);
         $template="Interest request received";
         //send email to admin
        if($access_request_manage==1)
        {
             $template="Interest request received For Admin";
             $request_page_link = site_url('admin/equity/equity_detail/' . $equity_url . '#request');
        }
        $email_template = $this->db->query("select * from `email_template` where task='Interest request received' and language_id=".$language_id);
        $email_temp = $email_template->row();
        $email_message = $email_temp->message;
        $email_subject = $email_temp->subject;
        $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);

        $email_address_from = $email_temp->from_address;
        $email_address_reply = $email_temp->reply_address;
        $email_to = $owner_email;
        //send email to admin
        if($access_request_manage==1)
        {
             $email_to=$email_address_from;
        }
        $email_message = str_replace('{break}', '<br/>', $email_message);
        $email_message = str_replace('{user_name}', $owner_name, $email_message);
        $email_message = str_replace('{project_name}', $project_name, $email_message);
        $email_message = str_replace('{investor_name}', $requester_title_anchor, $email_message);
        $email_message = str_replace('{company_name}', SecureShowData($company_name), $email_message);
        $email_message = str_replace('{company_name_link}', $equity_title_anchor_owner, $email_message);
        $email_message = str_replace('{intrest_link}', $request_page_link, $email_message);
        $email_message = str_replace('{site_name}', $site_name, $email_message);

        $str = $email_message;
        email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);


        //============== Send access request to investor user================================
        $language_id=GetUserLangCode( $user_data[0]['user_id']);
        $email_template = $this->db->query("select * from `email_template` where task='Interest request sent' and language_id=".$language_id);
        $email_temp = $email_template->row();
        $email_message = $email_temp->message;
        $email_subject = $email_temp->subject;
        $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
        $email_subject = str_replace('{funds}', $funds, $email_subject);
        $email_address_from = $email_temp->from_address;
        $email_address_reply = $email_temp->reply_address;
        $email_to = $email;
        $email_message = str_replace('{break}', '<br/>', $email_message);
        $email_message = str_replace('{user_name}', $username, $email_message);
        $email_message = str_replace('{company_name}', SecureShowData($company_name), $email_message);
        $email_message = str_replace('{project_name}', $project_name, $email_message);
        $email_message = str_replace('{company_name_link}', $equity_title_anchor, $email_message);

        $email_message = str_replace('{site_name}', $site_name, $email_message);
        $str = $email_message;
        email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);


        $data['success'] = 'success';
        echo json_encode($data);


    }


    /*
    Function name :updateintrestrequest()
    Parameter :no
    Return : success message
    Use : interest request approve or reject
    */
    function updateintrestrequest()
    {


        $data = array();

        $equity_id = SecurePostData($this->input->post('equity_id'));
        $user_id = check_user_authentication(true);
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/notedit_equity');
            }
        }
        $interest_request_id = SecurePostData($this->input->post('interest_request_id'));
        $status = SecurePostData($this->input->post('status'));
        $interest_user_id = SecurePostData($this->input->post('interest_user_id'));
        $reason_save_interest = SecurePostData($this->input->post('reason_save_interest'));
        $deny_reason_interest = stripcslashes($this->input->post('deny_reason_interest'));
        $site_setting = site_setting();
        $site_name = $site_setting['site_name'];
        $taxonomy_setting = taxonomy_setting();
        $project_name = $taxonomy_setting['project_name'];
        $funds = $taxonomy_setting['funds'];
        $request_type = SecurePostData($this->input->post('request_type'));
        $add_request_data = array(
            'user_id' => $interest_user_id,
            'equity_id' => $equity_id,
            'status' => $status,
            'updated_date' => date('Y-m-d H:i:s'),


        );

        if ($reason_save_interest == 1) {
            $add_equity_request_data = array(
                'deny_reason_interest' => $deny_reason_interest,
                'reason_save_interest' => $reason_save_interest
            );
            $this->startequity_model->AddInsertUpdateTable('equity', 'equity_id', $equity_id, $add_equity_request_data);
        }

        $this->startequity_model->AddInsertUpdateTable('interest_request', 'interest_request_id', $interest_request_id, $add_request_data);

        $check_id_array = array("interest_request_id" => $interest_request_id);
        $interest_data = $this->startequity_model->getTableData('interest_request', $check_id_array);
        $interest_request_data = $interest_data[0];

        $equity = GetOneEquity($interest_request_data['equity_id']);
        $userdata = UserData($interest_request_data['user_id']);


        //============== Approve access request by owner================================
        $company_name = $equity['company_name'];
        $username = $userdata[0]['user_name'];
        $email = $userdata[0]['email'];
        $interest_reason = $deny_reason_interest;
        $equity_url = $equity['equity_url'];

        $project_url = $taxonomy_setting['project_url'];

        $equity_page_link = site_url($project_url . '/' . $equity_url);
        $equity_title_anchor = '<a href="' . $equity_page_link . '">' . SecureShowData($company_name) . '</a>';
         $language_id=GetUserLangCode( $userdata[0]['user_id']);
        if ($request_type == 'approve') {
            $email_template = $this->db->query("select * from `email_template` where task='Interest access approved' and language_id=".$language_id);
            $email_temp = $email_template->row();
            $email_message = $email_temp->message;
            $email_subject = $email_temp->subject;
            $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
            $email_subject = str_replace('{funds}', $funds, $email_subject);
            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_to = $email;
            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
            $email_message = str_replace('{project_name}', $project_name, $email_message);
            $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $str = $email_message;
            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
        } //============== Reject access request by owner================================
        else {
            $email_template = $this->db->query("select * from `email_template` where task='Interest access denied' and language_id=".$language_id);
            $email_temp = $email_template->row();
            $email_message = $email_temp->message;
            $email_subject = $email_temp->subject;
            $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
            $email_subject = str_replace('{funds}', $funds, $email_subject);
            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_to = $email;
            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
            $email_message = str_replace('{project_name}', $project_name, $email_message);
            $email_message = str_replace('{reason}', $interest_reason, $email_message);
            $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $str = $email_message;
            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
        }

        $data['success'] = 'success';
        echo json_encode($data);
    }

    /*
    Function name :number_check()
    Parameter :none
    Return : none
    Use : Check value is number or not
    */
    public function number_check($num)
    {
        if ($num > 0 && is_numeric($num)) {
            return TRUE;
        } else {
            $this->form_validation->set_message('number_check', 'The %s field contain only numeric number ');
            return FALSE;
        }
    }

    // ===========================widget code====================
    /*
    * Used for generating widget of equity commoncard
    */
    function widgets_code($w, $c, $n)
    {

        $data['w'] = $w;
        $data['c'] = $c;
        $data['n'] = $n;
        $data['offset'] = 0;
        $data['limit'] = 8;
        $this->load->view(THEME_LOCATION.'widgets_code', $data);
    }

    function widgets_page($w, $c, $n)
    {
        $data['color'] = $c;
        $data['width'] = $w;
        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $n);
        $data['equity'] = $get_equity_user_detail[0];
        $data['equity_gallery'] = $this->equity_model->get_all_equity_gallery($n);
        $data['site_setting'] = site_setting();
        $data['offset'] = 0;
        $data['limit'] = 8;
        $this->template->add_css($data['color'] . '/fund-' . $data['color'] . '.css');
        $this->template->front_write_view('main_content', 'widgets_page', $data, TRUE);
        $this->template->render();
    }

    function widgets($id = 0)
    {
        if ($id != '') {
            $equity_detail = $this->db->query("select * from equity where equity_id='" . $id . "'");
            $equity = $equity_detail->row();
            $this->session->set_userdata('equity_id', $this->security->xss_clean($id));
            $this->session->set_userdata('equity_title', $this->security->xss_clean($equity->equity_title));
            $this->session->set_userdata('equity_url', $this->security->xss_clean($equity->equity_url));
        }
        $data['pid'] = $id;
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $data['offset'] = 0;
        $data['limit'] = 8;
        $data['header_menu'] = dynamic_menu(0);
        $data['footer_menu'] = dynamic_menu_footer(0);
        $data['right_menu'] = dynamic_menu_right(0);
        $this->home_model->select_text();
        $this->template->write('meta_title', 'Widgets-' . $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'header_login', $data, TRUE);
        $this->template->front_write_view('main_content', 'widgets', $data, TRUE);
        $this->template->front_write_view('footer', 'footer', $data, TRUE);
        $this->template->render();
    }
    // =================End widgets code================
    // ===========================comment action====================
    /*
    Function name :commentaction()
    Parameter :none
    Return : none
    Use :  Comments reply,approve,decline,spam,delete
    */
    function commentaction()
    {

        $equity_id = SecurePostData($this->input->post('equity_id'));
        $user_id = check_user_authentication(true);
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/my_equity');
            }
        }
        $data1['equity_id'] = SecurePostData($this->input->post('equity_id'));
        $data1['user_id'] = $this->session->userdata('user_id');
        $data1['comments'] = strip_tags($this->input->post('comment_reply'));
        $data1['comment_type'] = SecurePostData($this->input->post('comment_type'));
        $data1['parent_id'] = SecurePostData($this->input->post('comment_id'));
        $comment_user_id = SecurePostData($this->input->post('comment_user_id'));
        $data1['status'] = 1;
        $data1['date_added'] = date("Y-m-d H:i:s");
        $data1['comment_ip'] = $_SERVER['REMOTE_ADDR'];


        $equity_id = $data1['equity_id'];
        $comment_id = SecurePostData($this->input->post('comment_id'));
        $type = SecurePostData($this->input->post('type'));
        $type1 = SecurePostData($this->input->post('type1'));
        $comment = $data1['comments'];
        $comment_user_ip = SecurePostData($this->input->post('comment_ip'));
        $equity_data = GetOneEquity($equity_id);
        $equity_url = $equity_data['equity_url'];
        $this->form_validation->set_rules('comment', COMMENT, 'required');
        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';
        $site_setting = site_setting();
         $captcha_result = '';
       

        if ($this->form_validation->run() == FALSE || $captcha_result) {
            if (validation_errors() || $captcha_result) {
                $data["msg"]['error'] = validation_errors().$captcha_result;
            } else {
                $data["msg"]['error'] = "";
            }
        } else {
            if ($type == 'approved') {
                $data1['comment_approve'] = $this->equity_model->commentaction($comment_id, $type, $equity_id, 1, '', '', '', '');


                $data["msg"]["success"] = '<span>' . RECORD_APPROVED_SUCCESSFULLY . '</span>';
            }
            if ($type == 'decline') {
                $data1['comment_decline'] = $this->equity_model->commentaction($comment_id, $type, $equity_id, 2, '', '', '', '');
                $data["msg"]["success"] = '<span>' . RECORD_DECLINED_SUCCESSFULLY . '</span>';
            }
            if ($type == 'reply') {
                if ($type1 == 'edit') {
                    $data1['comment_edit'] = $this->equity_model->commentaction($comment_id, $type, $equity_id, 1, '', '', $type1, $comment);
                    $data["msg"]["success"] = '<span>' . RECORD_UPDATED_SUCCESSFULLY . '</span>';
                } else {
                    $data1['comment_reply'] = $this->equity_model->commentaction($comment_id, $type, $equity_id, 1, $data1, '', '', '');
                    $data["msg"]["success"] = '<span>' . RECORD_REPLIED_SUCCESSFULLY . '</span>';


                    $site_setting = site_setting();
                    $site_name = $site_setting['site_name'];
                    $taxonomy_setting = taxonomy_setting();
                    $taxo_comments = $taxonomy_setting['comments'];
                    $project_url = $taxonomy_setting['project_url'];
                    $comments_plural = $taxonomy_setting['comments_plural'];
                    $project_name = $taxonomy_setting['project_name'];

                    $user_not_own = $this->account_model->get_email_notification($comment_user_id);
                    $company_name = $equity_data['company_name'];
                    $equity_page_link = site_url($project_url . '/' . $equity_url);
                    $equity_title_anchor = '<a href="' . $equity_page_link . '">' . SecureShowData($company_name) . '</a>';

                    $comment_user_data = UserData($comment_user_id);
                    $comment_user_name = $comment_user_data[0]['user_name'];
                    $comment_last_name = $comment_user_data[0]['last_name'];
                    $comment_email = $comment_user_data[0]['email'];

                    $reply_user_data = UserData($user_id);

                    $profile_slug = $reply_user_data[0]['profile_slug'];

                    $comment_profile_link = site_url('user/' . $profile_slug);

                    $reply_user_name = $reply_user_data[0]['user_name'] . ' ' . $reply_user_data[0]['last_name'];
                    $comment_name_anchor = '<a href="' . $comment_profile_link . '">' . $reply_user_name . '</a>';

                    ///////// add latest activities
                    project_activity('commented', $data1['user_id'], $comment_user_id, $equity_id);
                    ///////// end

                    if ($user_not_own != '0') {
                        if ($user_not_own->comment_reply_alert == '1') {
                             $language_id=GetUserLangCode( $comment_user_id);
                            $email_template = $this->db->query("select * from `email_template` where task='You have reply on your comment on' and language_id=".$language_id);
                            $email_temp = $email_template->row();
                            $email_message = $email_temp->message;
                            $email_subject = $email_temp->subject;
                            $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
                            $email_subject = str_replace('{comment}', $taxo_comments, $email_subject);
                            $email_address_from = $email_temp->from_address;
                            $email_address_reply = $email_temp->reply_address;
                            $email_to = $comment_email;

                            $email_message = str_replace('{break}', '<br/>', $email_message);
                            $email_message = str_replace('{user_name}', $comment_user_name, $email_message);
                            $email_message = str_replace('{last_name}', $comment_last_name, $email_message);
                            $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
                            $email_message = str_replace('{comment_user_name}', $comment_name_anchor, $email_message);
                            $email_message = str_replace('{comments}', $comment, $email_message);
                            $email_message = str_replace('{comment}', $taxo_comments, $email_message);
                            $email_message = str_replace('{project_name}', $project_name, $email_message);
                            $email_message = str_replace('{comment_full_name}', $reply_user_name, $email_message);
                            $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
                            $email_message = str_replace('{site_name}', $site_name, $email_message);

                            $str = $email_message;

                            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                        }
                    }

                }
            }
            if ($type == 'spam') {
                $data1['comment_spam'] = $this->equity_model->commentaction($comment_id, $type, $equity_id, 3, '', $comment_user_ip, '', '');
                $data["msg"]["success"] = '<span>' . RECORD_SPAM_SUCCESSFULLY . '</span>';
            }
            if ($type == 'delete') {
                $data1['comment_delete'] = $this->equity_model->commentaction($comment_id, $type, 0, 0, '', '', '', '');
                $data["msg"]["success"] = '<span>' . RECORD_DELETED_SUCCESSFULLY . '</span>';
            }
        }
        /* commment is approved , delete or declined so delete cache*/

        project_other_deletecache('comment', $equity_id, $equity_url);
        user_deletecache('comments', $comment_user_id);
        echo json_encode($data);
    }

    /*
    Function name :ajax_updatecomments()
    Parameter :none
    Return : none
    Use : Update comments data .
    */
    function ajax_updatecomments()
    {
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $user_id = check_user_authentication(true);
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/my_equity');
            }
        }
        $data['is_equity_owner'] = $this->startequity_model->is_equity_owner($equity_id, false);
        $data['site_setting'] = site_setting();
        $data["msg"]['type'] = 'comment_validation';
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $data['equity_comments'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'comment',
            'user'
        ), $limit = 0, $group = array(
            'comment_id' => 'comment.comment_id'
        ), $order = array(
                'equity.equity_id' => 'desc',
                'comment.comment_id' => 'desc'
            ), '');
        $this->load->view(THEME_LOCATION.'equity/ajax_updatedashboardcomments', $data);
    }
    // =================End comment for equity dashboard===============
    // ========================================== ajax update save======================

    /*
    Function name :ajax_update_save()
    Parameter :none
    Return : none
    Use : Add update of equity data.
    */
    function ajax_update_save()
    {
        //print_r($_POST);die;
        $equity_id = SecurePostData($this->input->post('equity_id'));


        $user_id = check_user_authentication(true);
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/my_equity');
            }
        }
        $update_id = SecurePostData($this->input->post('update_id'));
        $action = SecurePostData($this->input->post('type'));

        $data1['equity_id'] = SecurePostData($this->input->post('equity_id'));
        $data1['updates'] = EditorSecurePostData($this->input->post('updates'));
        $data1['status'] = '0';
        $data1['date_added'] = date("Y-m-d H:i:s");
        $update_value_check = '';

        if (strip_tags($this->input->post('updates')) == '') {
            $update_value_check = UPDATES_IS_REQURED;
        }

        //$this->form_validation->set_rules('updates', UPDATES, 'required');
        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';

        if ($update_value_check != '') {
            if ($update_value_check != '') {
                $data["msg"]['error'] = $update_value_check;
            } else {
                $data["msg"]['error'] = "";
            }
        } else {
            if ($update_id != '') {
                if ($action != '') {
                    $this->equity_model->DeleteUpdateById('update_id', $update_id, 'updates', '', array(
                        'update'
                    ));
                    $data["msg"]["success"] = '<span>' . RECORD_DELETED_SUCCESSFULLY . '</span>';
                } else {
                    $this->equity_model->UpdatePerkUpdates('update_id', $update_id, 'updates', $data1, array(
                        'update'
                    ));
                    $data["msg"]["success"] = '<span>' . RECORD_UPDATED_SUCCESSFULLY . '</span>';
                }
            } else {
                $this->equity_model->AddUpdateComment('updates', $data1, array(
                    'update'
                ));

                // activity notification
                project_activity('update', $this->session->userdata('user_id'), $user_id, $equity_id);

                $data["msg"]["success"] = '<span>' . RECORD_ADDED_SUCCESSFULLY . '</span>';
            }
            $equity = GetOneEquity($equity_id);

            $company_name = $equity['company_name'];

            $equity_url = $equity['equity_url'];
            $taxonomy_setting = taxonomy_setting();
            $project_url = $taxonomy_setting['project_url'];
            $equity_page_link = site_url($project_url . '/' . $equity_url);
            $equity_title_anchor = '<a href="' . $equity_page_link . '">' . SecureShowData($company_name) . '</a>';


            $all_back_user_update = UserData($equity['user_id']);

            $profile_slug = $all_back_user_update[0]['profile_slug'];

            $update_profile_link = site_url('user/' . $profile_slug);
            $username = $all_back_user_update[0]['user_name'];
            $lastname = $all_back_user_update[0]['last_name'];
            $email = $all_back_user_update[0]['email'];

            $update_user_name = $username . ' ' . $lastname;
            $update_name_anchor = '<a href="' . $update_profile_link . '">' . $update_user_name . '</a>';

            $site_setting = site_setting();
            $site_name = $site_setting['site_name'];
            $taxonomy_setting = taxonomy_setting();
            $project_name = $taxonomy_setting['project_name'];
            $updates_plural = $taxonomy_setting['updates_plural'];
            $funds_past = $taxonomy_setting['funds_past'];
            $followers_past = $taxonomy_setting['followers_past'];

            // ///////////////============== Project you created notification================================

            $user_not_own = $this->account_model->get_email_notification($equity['user_id']);

            if ($user_not_own != '0') {
                if ($user_not_own->creator_newup_alert == 1) {


                    $updates = EditorSecurePostData($this->input->post('updates'));
                     $language_id=GetUserLangCode( $equity['user_id']);
                    $email_template = $this->db->query("select * from `email_template` where task='New updates on campaign you created' and language_id=".$language_id);
                    $email_temp = $email_template->row();
                    $email_message = $email_temp->message;
                    $email_subject = $email_temp->subject;
                    $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
                    $email_subject = str_replace('{updates_plural}', $updates_plural, $email_subject);
                    $email_subject = str_replace('{project_name}', $project_name, $email_subject);

                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_to = $email;
                    $email_message = str_replace('{break}', '<br/>', $email_message);
                    $email_message = str_replace('{user_name}', $username, $email_message);
                    $email_message = str_replace('{project_name}', $project_name, $email_message);
                    $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
                    $email_message = str_replace('{update_user_name}', $update_name_anchor, $email_message);
                    $email_message = str_replace('{updates_plural}', $updates_plural, $email_message);
                    $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);

                    $str = $email_message;

                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

                    # code...
                }
            }


            // ///////////////============== Project you back notification================================

            $equity_back_update = $this->db->query("SELECT un.update_alert,un.user_id,u.email,u.user_name,u.last_name FROM `user_notification` un
				inner join user u on u.user_id=un.user_id
				inner join transaction tr on tr.user_id=u.user_id
				where  un.update_alert=1 and tr.equity_id=" . $equity_id . "
				group by u.user_id");


            $all_back_user = $equity_back_update->result_array();


            if (is_array($all_back_user)) {
                foreach ($all_back_user as $back_user) {

                    $donated_user_name = $back_user['user_name'];
                    $donated_last_name = $back_user['last_name'];
                    $donated_email = $back_user['email'];
                    $updates = EditorSecurePostData($this->input->post('updates'));
                     $language_id=GetUserLangCode( $back_user['user_id']);
                    $email_template = $this->db->query("select * from `email_template` where task='update on your backed equity' and language_id=".$language_id);
                    $email_temp = $email_template->row();
                    $email_message = $email_temp->message;
                    $email_subject = $email_temp->subject;

                    $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
                    $email_subject = str_replace('{updates_plural}', $updates_plural, $email_subject);
                    $email_subject = str_replace('{project_name}', $project_name, $email_subject);
                    $email_subject = str_replace('{funds_past}', $funds_past, $email_subject);

                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_to = $donated_email;
                    $email_message = str_replace('{break}', '<br/>', $email_message);
                    $email_message = str_replace('{user_name}', $donated_user_name, $email_message);
                    $email_message = str_replace('{project_name}', $project_name, $email_message);
                    $email_message = str_replace('{funds_past}', $funds_past, $email_message);
                    $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
                    $email_message = str_replace('{update_user_name}', $update_name_anchor, $email_message);
                    $email_message = str_replace('{updates_plural}', $updates_plural, $email_message);
                    $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);
                    $str = $email_message;

                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

                    # code...
                }
            }

            // ///////////////============== Project you follow notification================================


            $equity_you_follow = $this->db->query("SELECT un.new_updates_alert,un.user_id,u.email,u.user_name,u.last_name FROM `user_notification` un
						inner join user u on u.user_id=un.user_id
						inner join equity_follower ef on ef.equity_follow_user_id=u.user_id
						where  un.new_updates_alert=1 and ef.equity_id=" . $equity_id . "
						group by u.user_id");

            $all_equity_follow_user = $equity_you_follow->result_array();

            if (is_array($all_equity_follow_user)) {
                foreach ($all_equity_follow_user as $follower_user) {

                    $follower_user_name = $follower_user['user_name'];
                    $follower_last_name = $follower_user['last_name'];
                    $follower_email = $follower_user['email'];
                     $language_id=GetUserLangCode( $follower_user['user_id']);
                    $email_template = $this->db->query("select * from `email_template` where task='New updates on campaign you followed' and language_id=".$language_id);
                    $email_temp = $email_template->row();
                    $email_message = $email_temp->message;
                    $email_subject = $email_temp->subject;
                    $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
                    $email_subject = str_replace('{updates_plural}', $updates_plural, $email_subject);
                    $email_subject = str_replace('{project_name}', $project_name, $email_subject);
                    $email_subject = str_replace('{followers_past}', $followers_past, $email_subject);
                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_to = $follower_email;
                    $email_message = str_replace('{break}', '<br/>', $email_message);
                    $email_message = str_replace('{user_name}', $follower_user_name, $email_message);
                    $email_message = str_replace('{project_name}', $project_name, $email_message);
                    $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
                    $email_message = str_replace('{followers_past}', $followers_past, $email_message);
                    $email_message = str_replace('{update_user_name}', $update_name_anchor, $email_message);
                    $email_message = str_replace('{updates_plural}', $updates_plural, $email_message);
                    $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);
                    $str = $email_message;

                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

                    # code...
                }
            }


        }
        project_other_deletecache('update', $equity_id);
        echo json_encode($data);
    }
    /*
    Function name :ajax_updateupdates()
    Parameter :none
    Return : none
    Use : Update update of equity data.
    */
    // ==========================update updates================
    function ajax_updateupdates()
    {
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $user_id = check_user_authentication(true);
        if ($equity_id > 0) {
            if (!$this->startequity_model->is_equity_owner($equity_id, false)) {
                redirect('home/my_equity');
            }
        }
        $data['is_equity_owner'] = $this->startequity_model->is_equity_owner($equity_id, false);
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $data['site_setting'] = site_setting();
        $data['equity_updates'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'updates'
        ), $limit = 0, $group = array(), $order = array(
            'updates.date_added' => 'desc'
        ), '');
        $equity = GetOneEquity($equity_id);
        $equity_url = '';
        if (isset($equity['equity_url'])) $equity_url = $equity['equity_url'];
        project_other_deletecache('update', $equity_id, $equity_url);

        $this->load->view(THEME_LOCATION.'equity/ajax_updateupdates', $data);
    }
    // ============= equity detail add comments=========
    /*
    Function name :add_comment()
    Parameter :none
    Return : none
    Use : Add comments data.
    */
    function add_comment()
    {

        $user_id=check_user_authentication(true);

        if(!$user_id){
            echo "<script>window.location.reload(true);</script>";
            die;
        }

        $data1['equity_id'] = SecurePostData($this->input->post('equity_id'));
        $data1['user_id'] = SecurePostData($this->input->post('comment_user_id'));
        $data1['comments'] = strip_tags($this->input->post('comment'));
        $data1['comment_type'] = SecurePostData($this->input->post('comment_type'));
        $data1['date_added'] = date("Y-m-d H:i:s");
        $data1['comment_ip'] = SecurePostData($this->input->post('comment_ip'));
        $data1['parent_id'] = SecurePostData($this->input->post('comment_id'));

        $equity_id = $data1['equity_id'];
        $equity_data = GetOneEquity($equity_id);
        $equity_owner_id = $equity_data['user_id'];
        $company_name = $equity_data['company_name'];
        $equity_url = $equity_data['equity_url'];
        if ($equity_owner_id == $data1['user_id']) {
            $data1['status'] = 1;
        } else {
            $data1['status'] = 0;
        }
        $chk_user = 'false';
        setting_deletecache('spam_protectd');
        $spamer = $this->home_model->spam_protection();
        if ($spamer == 1 || $spamer == '1') {
            $chk_user = 'true';
        }
        $this->form_validation->set_rules('comment', COMMENT, 'required');
        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';
         $site_setting = site_setting();
         $captcha_result = '';
         require(base_path().'/application/libraries/ReCaptcha/src/autoload.php'); 
        $secret = $site_setting['captcha_private_key'];
        if ($_POST) {
            if ($site_setting['contact_us_captcha'] == 1) {
                $recaptcha = new \ReCaptcha\ReCaptcha($secret);
                $session_ip_address = $this->session->userdata('ip_address');
                $resp = $recaptcha->verify($_POST['g-recaptcha-response'], $session_ip_address);

                if ($resp->isSuccess()) {
                    $captcha_result = '';
                } else {
                   $captcha_result .= '<p>' . IMAGE_VERIFICATION_WRONG . '</p>';
                }
            }
        }


        if ($this->form_validation->run() == FALSE || $chk_user == 'true' || $captcha_result !='') {
            if (validation_errors() || $captcha_result) {
                $data["msg"]['error'] = validation_errors().$captcha_result;
            } else {
                $data["msg"]['error'] = "";
            }
            if ($chk_user == 'true') {
                $spam_message = "<p>" . YOUR_IP_HAS_BEEN_BAND_DUE_SPAM_YOU_CAN_NOT_POST_MORE_COMMENT . "</p>";
                $data["msg"]['error'] = $spam_message;
            }
        } else {
            $this->equity_model->AddUpdateComment('comment', $data1, array(
                'comment'
            ));

             project_other_deletecache('comment', $equity_id, $equity_url);
            user_deletecache('comments', $data1['user_id']);
            ///////// add latest activities
            project_activity('commented', $data1['user_id'], $equity_owner_id, $equity_id);
            ///////// end
            if ($equity_owner_id == $data1['user_id']) {


                $data["msg"]["success"] = '<span>' . COMMENT_POSTED_SUCCESSFULLY . '</span>';
                $data["msg"]["owner_cmt"] = 'yes';
            } else {
                $data["msg"]["success"] = '<span>' . SHOW_COMMENT_AFTER_APPROVED . '</span>';
            }
            $userdata = UserData(SecurePostData($this->input->post('comment_user_id')));
            $get_equity_user_detail = $this->equity_model->GetAllEquities(0, SecurePostData($this->input->post('equity_id')), $is_featured = 0, $is_status = '', $joinarr = array(
                'user'
            ), $limit = 10, $order = array(
                'equity_id' => 'desc'
            ));

            $company_name = $equity_data['company_name'];
            $taxonomy_setting = taxonomy_setting();
            $project_url = $taxonomy_setting['project_url'];
            $equity_page_link = site_url($project_url . '/' . $equity_url);
            $equity_title_anchor = '<a href="' . $equity_page_link . '">' . SecureShowData($company_name) . '</a>';

            $all_back_user_comment = UserData($this->session->userdata('user_id'));

            $profile_slug = $all_back_user_comment[0]['profile_slug'];

            $comment_profile_link = site_url('user/' . $profile_slug);

            $comment_user_name = $all_back_user_comment[0]['user_name'] . ' ' . $all_back_user_comment[0]['last_name'];
            $comment_name_anchor = '<a href="' . $comment_profile_link . '">' . $comment_user_name . '</a>';


            $user_not_own = $this->account_model->get_email_notification($get_equity_user_detail[0]['user_id']);

            if ($user_not_own != '0') {
                if ($user_not_own->creator_comment_alert == '1') {
                    $comment['user_name'] = $get_equity_user_detail[0]['user_name'] . ' ' . $get_equity_user_detail[0]['last_name'];
                    $comment['comment_user_name'] = $userdata[0]['user_name'] . ' ' . $userdata[0]['last_name'];
                    $comment['company_name'] = SecureShowData($get_equity_user_detail[0]['company_name']);
                    $comment['comment'] = SecurePostData($this->input->post('comment'));
                    $comment['email'] = $get_equity_user_detail[0]['email'];
                    $comment['user_id']=$get_equity_user_detail[0]['user_id'];
                    $comment['comment_name_anchor'] = $comment_name_anchor;
                    $comment['equity_title_anchor'] = $equity_title_anchor;
                    $comment['equity_page_link'] = $equity_page_link;
                    $comment['comment_profile_link'] = '<a href="' . site_url('equity/dashboard/' . $get_equity_user_detail[0]['equity_id'] . '#comments-tab') . '">' . SecureShowData($get_equity_user_detail[0]['company_name']) . '</a>';
                    $this->mailalerts('comment_alert', $comment, '', '', 'New Comment Owner Alert');
                    $this->mailalerts('comment_admin_alert', $comment, '', '', 'New Comment Admin Alert');
                }
            }

             /*Comment reply alert*/
            $type = SecurePostData($this->input->post('type'));
            if($type=='reply' && $data1['parent_id']!=''){
                
                $parent_user = $this->equity_model->get_parent_user($data1['parent_id']);
                if ($parent_user) {
                    $parent_user_id = $parent_user['user_id'];
                    $comment_user_name = $parent_user['user_name'];
                    $comment_last_name = $parent_user['last_name'];
                    $comment_email = $parent_user['email'];
                    if($parent_user_id!=$user_id){
                        $login_user_notification = $this->account_model->get_email_notification($parent_user_id);
                        if ($login_user_notification != '0') {
                            if ($login_user_notification->comment_reply_alert == '1') {

                                $reply_user_data = UserData($user_id);
                                $profile_slug = $reply_user_data[0]['profile_slug'];
                                $comment_profile_link = site_url('user/' . $profile_slug);
                                $reply_user_name = $reply_user_data[0]['user_name'] . ' ' . $reply_user_data[0]['last_name'];
                                $comment_name_anchor = '<a href="' . $comment_profile_link . '">' . $reply_user_name . '</a>';


                                $language_id = GetUserLangCode($user_id);
                                $email_template = $this->db->query("select * from `email_template` where task='You have reply on your comment on'  and language_id=" . $language_id);
                                $email_temp = $email_template->row();
                                $email_message = $email_temp->message;
                                $email_subject = $email_temp->subject;
                                $email_subject = str_replace('{project_name}', SecureShowData($get_equity_user_detail[0]['company_name']), $email_subject);
                                $email_address_from = $email_temp->from_address;
                                $email_address_reply = $email_temp->reply_address;
                                $email_to = $comment_email;

                                $email_message = str_replace('{break}', '<br/>', $email_message);
                                $email_message = str_replace('{user_name}', $comment_user_name, $email_message);
                                $email_message = str_replace('{last_name}', $comment_last_name, $email_message);
                                $email_message = str_replace('{project_name}', $equity_title_anchor, $email_message);
                                $email_message = str_replace('{comment_user_name}', $comment_name_anchor, $email_message);
                                $email_message = str_replace('{comment}', $data1['comments'], $email_message);
                                $email_message = str_replace('{comment_full_name}', $reply_user_name, $email_message);
                                $email_message = str_replace('{project_page_link}', $equity_page_link, $email_message);

                                $str = $email_message;

                                email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                            }
                        }
                    }
                }
                
            }


            // ///////////////============== Project you back notification================================

            $site_setting = site_setting();
            $site_name = $site_setting['site_name'];

            $taxonomy_setting = taxonomy_setting();
            $project_name = $taxonomy_setting['project_name'];
            $comments_plural = $taxonomy_setting['comments_plural'];
            $comments_past = $taxonomy_setting['comments_past'];
            $comment = $taxonomy_setting['comments'];
            $funds_past = $taxonomy_setting['funds_past'];
            $followers_past = $taxonomy_setting['followers_past'];

            $equity_back_comment = $this->db->query("SELECT un.comment_alert,un.user_id,u.email,u.user_name,u.last_name FROM `user_notification` un
			inner join user u on u.user_id=un.user_id
			inner join transaction tr on tr.user_id=u.user_id
			where  un.comment_alert=1 and tr.equity_id=" . $equity_id . "
			group by u.user_id");

            $all_back_user = $equity_back_comment->result_array();
            $comment_add = SecurePostData($this->input->post('comment'));

            if (is_array($all_back_user)) {
                foreach ($all_back_user as $back_user) {

                    $donated_user_name = $back_user['user_name'];
                    $donated_last_name = $back_user['last_name'];
                    $donated_email = $back_user['email'];
                     $language_id=GetUserLangCode( $back_user['user_id']);

                    $email_template = $this->db->query("select * from `email_template` where task='Someone comment on your backed equity' and language_id=".$language_id);
                    $email_temp = $email_template->row();
                    $email_message = $email_temp->message;
                    $email_subject = $email_temp->subject;
                    $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
                    $email_subject = str_replace('{comment}', $comment, $email_subject);
                    $email_subject = str_replace('{project_name}', $project_name, $email_subject);
                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_to = $donated_email;

                    $email_message = str_replace('{user_name}', $donated_user_name, $email_message);
                    $email_message = str_replace('{project_name}', SecureShowData($project_name), $email_message);
                    $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
                    $email_message = str_replace('{project}', $company_name, $email_message);
                    $email_message = str_replace('{comment_user_name}', $comment_name_anchor, $email_message);
                    $email_message = str_replace('{comment_full_name}', $comment_user_name, $email_message);
                    $email_message = str_replace('{comment}', $comment, $email_message);
                    $email_message = str_replace('{comments}', $comment_add, $email_message);
                    $email_message = str_replace('{comments_plural}', $comments_plural, $email_message);
                    $email_message = str_replace('{comment_past}', $comments_past, $email_message);
                    $email_message = str_replace('{funds_past}', $funds_past, $email_message);
                    $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);

                    $str = $email_message;

                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

                    # code...
                }
            }

            // ///////////////============== Project you follow notification================================


            $equity_you_follow = $this->db->query("SELECT un.new_comment_alert,un.user_id,u.email,u.user_name,u.last_name FROM `user_notification` un
						inner join user u on u.user_id=un.user_id
						inner join equity_follower ef on ef.equity_follow_user_id=u.user_id
						where  un.new_comment_alert=1 and ef.equity_id=" . $equity_id . "
						group by u.user_id");

            $all_equity_follow_user = $equity_you_follow->result_array();

            if (is_array($all_equity_follow_user)) {
                foreach ($all_equity_follow_user as $follower_user) {

                    $follower_user_name = $follower_user['user_name'];
                    $follower_last_name = $follower_user['last_name'];
                    $follower_email = $follower_user['email'];
                     $language_id=GetUserLangCode( $follower_user['user_id']);
                    $email_template = $this->db->query("select * from `email_template` where task='New comment on campaign you followed' and language_id=".$language_id);
                    $email_temp = $email_template->row();
                    $email_message = $email_temp->message;
                    $email_subject = $email_temp->subject;
                    $email_subject = str_replace('{company_name}', SecureShowData($company_name), $email_subject);
                    $email_subject = str_replace('{comment}', $comment, $email_subject);
                    $email_subject = str_replace('{project_name}', $project_name, $email_subject);
                    $email_subject = str_replace('{followers_past}', $followers_past, $email_subject);
                    $email_address_from = $email_temp->from_address;
                    $email_address_reply = $email_temp->reply_address;
                    $email_to = $follower_email;

                    $email_message = str_replace('{user_name}', $follower_user_name, $email_message);
                    $email_message = str_replace('{project_name}', $project_name, $email_message);
                    $email_message = str_replace('{company_name}', $equity_title_anchor, $email_message);
                    $email_message = str_replace('{comment_user_name}', $comment_name_anchor, $email_message);
                    $email_message = str_replace('{comment_full_name}', $comment_user_name, $email_message);
                    $email_message = str_replace('{comments_plural}', $comments_plural, $email_message);
                    $email_message = str_replace('{comment_past}', $comments_past, $email_message);
                    $email_message = str_replace('{comments}', $comment_add, $email_message);
                    $email_message = str_replace('{comment}', $comment, $email_message);
                    $email_message = str_replace('{followers_past}', $followers_past, $email_message);
                    $email_message = str_replace('{equity_page_link}', $equity_page_link, $email_message);
                    $email_message = str_replace('{site_name}', $site_name, $email_message);

                    $str = $email_message;

                    email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

                    # code...
                }
            }


        }
        echo json_encode($data);
    }
    // ============= equity detail ajax update comments=========
    /*
    Function name :ajax_update_comments()
    Parameter :none
    Return : none
    Use : Update comments data.
    */
    function ajax_update_comments()
    {
        $equity_id = SecurePostData($this->input->post('equity_id'));
        $parent_comment_id = SecurePostData($this->input->post('parent_comment_id'));

        if(!$_POST){
            exit();
        }

        $user_id = check_user_authentication();
        if(!$user_id){
            $equity = GetOneEquity($equity_id);
            $equity_url = $equity['equity_url'];
            $taxonomy_setting = taxonomy_setting();
            $project_url = $taxonomy_setting['project_url'];
            $equity_page_link = site_url($project_url . '/' . $equity_url);
            echo "<script>location.href=".$equity_page_link."</script>";
        }
        
        $data['one_parent_id'] = $parent_comment_id;
        
        $data['comment'] = $this->account_model->GetUpdateCommentGallery(0, $equity_id, '', $join = array(
            'comment',
            'user'
        ), $limit = 0, $group = array(
            'comment_id' => 'comment.comment_id'
        ), $order = array(
            'comment.comment_id' => 'desc'
        ), '1');

         $data['comment_count'] = count($data['comment']);
        $site_setting = site_setting();

        $data['site_setting'] = $site_setting;
         
        $this->load->view(THEME_LOCATION.'equity/ajax_updatecomments', $data);
    }

    /*
    Function name :invite_thankyou()
    Parameter :none
    Return : none
    Use : When user confirm invitation then he/she can see thank you page
    */

    function invite_thankyou($user_id = '', $equity_id = 0)
    {
        $site_setting = site_setting();
        $taxonomy_setting = taxonomy_setting();
        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity = $get_equity_user_detail[0];
        if ($user_id <= 0) $user_id = $equity['user_id'];
        $user_detail = $this->account_model->GetAllUsers($user_id);
        $user_detail = $user_detail[0];
        $data['email'] = $equity['email'];
        $data['user_email'] = $user_detail['email'];
        $company_name = $equity['company_name'];
        $equity_url = $equity['equity_url'];
        if ($equity_title == '') $equity_title = 'Untitled';
        $user_name = $equity['user_name'] . " " . $equity['last_name'];
        $invite_data_msg = sprintf(INVITE_MSGS, $user_name, $company_name, $site_setting['site_name']);
        $meta = meta_setting();
        $data['site_setting'] = $site_setting;
        $data['equity_url'] = $equity_url;
        $data['user_name'] = $user_name;
        $data['company_name'] = $company_name;
        $data['site_name'] = $site_setting['site_name'];
        $data['project_url'] = $taxonomy_setting['project_url'];
        $data['equity_id'] = $equity_id;
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'equity/thankyou', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
    Function name :equity_downlaod()
    Parameter :none
    Return : none
    Use : equity document download from here
    */

    function equity_downlaod($file_path = '')
    {

        $data = file_get_contents(base_url() . '/upload/doc/' . $file_path); // Read the file's contents
        $name = $file_path;
        force_download($name, $data);
        // echo $this->uri->segment(3);
    }


    /*
    Function name :invalid_page()
    Parameter :none
    Return : none
    Use :User used Wrong url then invalid page come.
    */
    function invalid_page()
    {
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'equity/404_page', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }
   

}

?>
