<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Company extends ROCKERS_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('company_model');
        $this->load->model('equity_model');
        $this->load->model('startequity_model');
        $this->load->model('follower_model');
        $this->load->model('following_model');
        $this->load->model('activity_model');
      
    }

    /*
    Function name :equity_detail()
    Parameter :$equity_url_title(equity url title),$msg (message string or equity id)
    Return : none
    Use : to show the equity detail
        this is used to show the equity information or details on equity detail page
    */

    function company_detail($company_url = '', $msg = '')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $user_id = check_user_authentication(false);

        $data['session_user_id'] = $user_id;
        if (is_numeric($msg)) {
            $id = $msg;
            $msg = '';
        }
        
        $meta = meta_setting();
        $site_setting = site_setting();
        $data['site_setting'] = $site_setting;
        $data['taxonomy_setting'] = taxonomy_setting();
        $data['msg'] = $msg;
        // not cached, do our things that need caching
        $get_company_user_detail = $this->company_model->GetAllCompanies( 0, $company_url,$joinarr = array(
            'user'

        ), $limit = 10, $order = array(
            'company_id' => 'desc'
        )); // store in cache
        // var_dump($get_company_user_detail);die;
        if(!$get_company_user_detail){
            redirect('home');
        }
        $user_data = UserData($user_id, array());
        $user_occupation = $user_data[0]['user_occupation'];
        $user_image = $user_data[0]['image'];
        $address = $user_data[0]['address'];
        $data['login_user_occupation'] = $user_occupation;
        $data['login_user_image'] = $user_image;
        $data['login_user_address'] = $address;
        $request_access_allow = 'no';
        if ($user_occupation != '' && $user_image != '' && $address != '') {
            $request_access_allow = 'yes';
        }
        $data['request_access_allow'] = $request_access_allow;

        $data['company_detail'] = $get_company_user_detail;
    
        $user_id = $get_company_user_detail[0]['user_id'];
        $company_id = $get_company_user_detail[0]['company_id'];

        $company_name = SecureShowData($get_company_user_detail[0]['company_name']);
        $company_overview = SecureShowData($get_company_user_detail[0]['company_overview']);

        $data['company_industry_data'] = $this->company_model->GetCompanyIndustry($company_id, $joinarr = array('company_industry', 'equity'), $limit = 10, $order = array('company_industry_id' => 'desc'));
        
        $data['company_projects'] =  $this->equity_model->GetCompanyEquitys($company_id);


        $login_user_data = UserData($this->session->userdata('user_id'), array());
        $data['result'] = $user_data;
        $data['login_user_data'] = $login_user_data;
        $data['follower'] = $this->follower_model->GetAllFollower($type = 'company_follow', 0, 0, $join = array(
                'user'
            ), $limit = 1000, $order = array(
                'company_follow_id' => 'desc'
            ),'',$company_id);

        // fetch data team member
        $data['company_team_member_data'] = $this->startequity_model->company_team_member_data($company_id, '', 1);
                // $pages_title='';
        $meta_keyword = '';
        $meta_description = '';
        if ($company_name != '') {
            $pages_title = $company_name . ' | ' . $meta['title'];
        } else {
            $pages_title = $meta['title'];
        }
        if ($company_name != '') $meta_keyword = $company_name;
        if ($company_overview != '') {
            $meta_description = $company_overview;
        } else {
            $meta_description = $meta['meta_description'];
        }
        $this->template->write('meta_title', $pages_title, TRUE);
        $this->template->write('meta_description', $meta_description, TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'] . "," . $meta_keyword, TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);

        $this->template->front_write_view('main_content', 'company/company_detail', $data, TRUE);
       
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
        // $this->output->enable_profiler(TRUE);
    }

    


}

?>
