<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Comment extends ROCKERS_Controller
{
    private $limit;

    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('account_model');
        $this->load->library('pagination');
        $this->limit=10;

    }

    /*
    Function name :index()
    Parameter :none
    Return : none
    Use : to show the user comment
    Description : this is used to show the user comment on comment page
    */
    function index()
    {
        $user_id = check_user_authentication(true);

        $data = array();

        $meta = meta_setting();
        $data['site_setting'] = site_setting();


        $usedata = UserData($user_id, $join = array(
            'user_notification'
        ));

        $data['user_id'] = $usedata[0]['user_id'];

        $data['user_comment_count'] = $this->account_model->GetUserComments($user_id,$user_id, array(
            'user',
            'equity'
        ), 0, array(
            'comment_id' => 'desc'
        ),'','','yes');

        $data['user_comment'] = $this->account_model->GetUserComments($user_id,$user_id, array(
            'user',
            'equity'
        ), $this->limit, array(
            'comment_id' => 'desc'
        ),'','','no');
        
        $config['base_url'] = site_url('comment/get_ajax_comments');
        $config['total_rows'] = $data['user_comment_count'];
        $config['per_page'] = $this->limit;
        $this->pagination->initialize($config);
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();
        $this->pagination->initialize_js_function($jsFunction);
        $data['base_url'] = $config['base_url'];
        $data['comment_pagination_link'] = $this->pagination->create_js_links();



        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'comment/index', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    function get_ajax_comments($offset=0){

        $user_id = check_user_authentication();

        if(!$user_id){
            $return_url = base64_encode('comment/index');
            echo "<script>window.location.href='".site_url('home/login/'.$return_url)."'</script>";
        }

        $data = array();
        $data['site_setting'] = site_setting();


        $usedata = UserData($user_id, $join = array(
            'user_notification'
        ));

        $data['user_id'] = $usedata[0]['user_id'];

        $data['user_comment_count'] = $this->account_model->GetUserComments($user_id,$user_id, array(
            'user',
            'equity'
        ), 0, array(
            'comment_id' => 'desc'
        ),'','','yes');

        $data['user_comment'] = $this->account_model->GetUserComments($user_id,$user_id, array(
            'user',
            'equity'
        ), $this->limit, array(
            'comment_id' => 'desc'
        ),'',$offset,'no');
        
        $config['base_url'] = site_url('comment/get_ajax_comments');
        $config['total_rows'] = $data['user_comment_count'];
        $config['per_page'] = $this->limit;
        $config["cur_page"] = $offset;
        $this->pagination->initialize($config);
        
        $jsFunction['name'] = 'show';
        $jsFunction['params'] = array();

        $this->pagination->initialize_js_function($jsFunction);
        $data['base_url'] = $config['base_url'];
        $data['comment_pagination_link'] = $this->pagination->create_js_links();

        $this->load->view(THEME_LOCATION.'comment/ajax_comments', $data);
    }

    /*
    Function name :delete_comment()
    Parameter :comment_id
    Return : none
    Use :Delete Particular comment

    */

    function delete_comment($comment_id = '')
    {
        $data['error']=false;
        $data['success']=false;

        if(!$comment_id){
            $data['error']=true;
            $return_url = base64_encode('comment/index');
            $data['redirect']=site_url('home/login/'.$return_url);
        }

        $user_id = check_user_authentication();
        if(!$user_id){
            $data['error']=true;
            $return_url = base64_encode('comment/index');
            $data['redirect']=site_url('home/login/'.$return_url);
        }
        $check_user_comment = $this->account_model->check_user_comment($comment_id,$user_id);
        if(!$check_user_comment){
            $data['error']=true;
            $return_url = base64_encode('comment/index');
            $data['redirect']=site_url('home/login/'.$return_url);
        }
        if($data['error']===false){
            $this->home_model->delete_comment($comment_id);
            $data['success']=true;
        }
        echo json_encode($data);
    }

}

/* end of file */
