<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 
/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Account extends ROCKERS_Controller

{
    /**
     *
     */
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('equity_model');

        $this->load->model('account_model');
        $this->load->library('securimage');
        $this->load->library('pagination');
    }

    /*
    Function name :index()
    Parameter :$msg (message string)
    Return : none
    Use : to show the user detail
    Description : this is used to show the user detail and notification on account page
    */
    /**
     * @param string $msg
     */
    function index($msg = '')
    {
        $user_id = check_user_authentication(true);

        $data = array();
        if (is_numeric($msg)) {
            $msg = '';
        }

        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $data['error'] = '';
        $data['msg'] = $msg;

        $usedata = UserData($user_id, $join = array('user_notification'));
        $data['error_pass'] = '';
        $data['user_id'] = $usedata[0]['user_id'];
        $data['user_name'] = $usedata[0]['user_name'];
        $data['last_name'] = $usedata[0]['last_name'];
        $data['email'] = $usedata[0]['email'];
        $data['address'] = $usedata[0]['address'];
        if (is_file('upload/user/user_medium_image/' . $usedata[0]['image'])) $data['image'] = $usedata[0]['image'];
        else $data['image'] = '';
        if (isset($usedata[0]['zip_code']) and $usedata[0]['zip_code'] != 0 or $usedata[0]['zip_code'] != '') $data['zip_code'] = $usedata[0]['zip_code'];
        else $data['zip_code'] = '';
        $data['user_about'] = $usedata[0]['user_about'];
        $data['user_occupation'] = $usedata[0]['user_occupation'];
        $data['user_interest'] = $usedata[0]['user_interest'];
        $data['user_skill'] = $usedata[0]['user_skill'];
        $data['id'] = $usedata[0]['id'];
        $data['profile_slug'] = $usedata[0]['profile_slug'];
        $data['phone'] = $usedata[0]['phone'];
        $data['update_alert'] = $usedata[0]['update_alert'];
        $data['user_alert'] = $usedata[0]['user_alert'];
        $data['add_fund'] = $usedata[0]['add_fund'];
        $data['project_alert'] = $usedata[0]['project_alert'];
        $data['comment_alert'] = $usedata[0]['comment_alert'];
        $data['creator_pledge_alert'] = $usedata[0]['creator_pledge_alert'];
        $data['creator_follow_alert'] = $usedata[0]['creator_follow_alert'];
        $data['creator_newup_alert'] = $usedata[0]['creator_newup_alert'];
        $data['creator_pledge_alert'] = $usedata[0]['creator_pledge_alert'];
        $data['new_follow_alert'] = $usedata[0]['new_follow_alert'];
        $data['new_updates_alert'] = $usedata[0]['new_updates_alert'];
        $data['new_comment_alert'] = $usedata[0]['new_comment_alert'];
        $data['new_pledge_alert'] = $usedata[0]['new_pledge_alert'];
        $data['creator_comment_alert'] = $usedata[0]['creator_comment_alert'];
        $data['social_notification_alert'] = $usedata[0]['social_notification_alert'];
        $data['you_back_alert'] = $usedata[0]['you_back_alert'];
        $data['you_follow_alert'] = $usedata[0]['you_follow_alert'];
        $data['comment_reply_alert'] = $usedata[0]['comment_reply_alert'];

        $data['facebook_url'] = $usedata[0]['facebook_url'];
        $data['twitter_url'] = $usedata[0]['twitter_url'];
        $data['user_website'] = $usedata[0]['user_website'];
        $data['linkedln_url'] = $usedata[0]['linkedln_url'];
        $data['googleplus_url'] = $usedata[0]['googleplus_url'];
        $data['bandcamp_url'] = $usedata[0]['bandcamp_url'];
        $data['youtube_url'] = $usedata[0]['youtube_url'];
        $data['myspace_url'] = $usedata[0]['myspace_url'];


        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'account/index', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
    Function name :commentdelete()
    Parameter :none
    Return : none
    Use :  Delete comment from equity
    */
    function commentdelete()
    {

        check_user_authentication(true);
        $comment_id = SecurePostData($this->input->post('comment_id'));
        $type = SecurePostData($this->input->post('type'));
        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';
        $data1['comment_delete'] = $this->equity_model->commentaction($comment_id, $type, 0, 0, '', '', '', '');
        $data["msg"]["success"] = '<span>' . RECORD_DELETED_SUCCESSFULLY . '</span>';

        echo json_encode($data);
    }

    /*
    Function name :validate_slug()
    Parameter :none
    Return : none
    Use :  Profile slug validation which used for profile page
    */
    function validate_slug()
    {

        check_user_authentication(true);
        $profile_slug = SecurePostData($this->input->post('profile_slug'));

        $data["msg"]['error'] = '';
        $data["msg"]['success'] = '';

        $profile_slug_check = $this->account_model->check_slug_exist($profile_slug);
        if ($profile_slug_check == "1") {
            $data["msg"]["error"] = '<span>' . THIS_SLUG_IS_ALREADY_EXIST_PLEASE_ENTER_NEW_SLUG . '</span>';
        }

        echo json_encode($data);

    }

    /*
    Function name :UserImageAjax()
    Parameter :id , type
    Return : none
    Use : Upload image using ajax for user;
    */
    /**
     * @param null $id
     * @param int $type
     */
    function UserImageAjax($id = null, $type = 0)
    {
        check_user_authentication(true);

        $this->load->library('form_validation');
        $data = array();
        $data["msg"]["error"] = '';
        $data["msg"]["success"] = '';
        $data["redirect"]["url"] = '';
        $data["image"]["path"] = '';
        $data["msg"]["image_media"] = '';
        $data["msg"]["video_media"] = '';


        if ($this->session->userdata('user_id') == '') {
            $data["redirect"]["url"] = 'home/login';
        } else
            if ($id == null || $id == '' || $id == '0') {
                $data["redirect"]["url"] = "account/index";
            } else {


                switch ($type) {
                    case 0:
                        $_FILES['userfile']['name'] = $_FILES['file1']['name'];
                        $_FILES['userfile']['type'] = $_FILES['file1']['type'];
                        $_FILES['userfile']['tmp_name'] = $_FILES['file1']['tmp_name'];
                        $_FILES['userfile']['error'] = $_FILES['file1']['error'];
                        $_FILES['userfile']['size'] = $_FILES['file1']['size'];

                        // image validation
                         $image_settings = get_image_setting_data();
                        if ($_FILES["userfile"]["type"] != "image/jpeg" and $_FILES["userfile"]["type"] != "image/pjpeg" and $_FILES["userfile"]["type"] != "image/png" and $_FILES["userfile"]["type"] != "image/x-png" and $_FILES["userfile"]["type"] != "image/gif") {
                            $data["msg"]["error"] = PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;
                        } else
                            if ($_FILES["userfile"]["size"] >  $image_settings['upload_limit']*1000000) {
                                 $data["msg"]["error"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_JPG_FILE_THAT_IS_LESS_THAN_MB_OR_TRY_RESIZING_IT_USING_A_PHOTO_EDITOR,$image_settings['upload_limit']);
                            } else {
                                $imagename = UserImageUpload($_FILES);
                                $data_gallery = array(
                                    'image' => $imagename
                                );

                                $new_img = $this->account_model->UpdateAccount('user_id', $id, 'user', $data_gallery);
                                user_deletecache('all', $this->session->userdata('user_id'));
                                if ($new_img) {
                                    setting_deletecache('user_detail_notification' . $this->session->userdata('user_id'));
                                    $data["image"]["path"] = base_url() . "upload/user/user_big_image/" . $imagename;
                                    $data["msg"]["success"] = '<span>' . IMAGE_UPLOADED_SUCCESSFULLY . '</span>';
                                } else {
                                    $data["msg"]["error"] = THERE_IS_SOME_PROBLEM_SITE_TRY_AFTER_SOMETIME;
                                }
                            }

                        $data["msg"]["successbox"] = 1;
                        break;
                }
            }

        echo json_encode($data);
    }

    /*
    Function name :validate_account()
    Parameter : None
    Return : none
    Use : to validate the user input.
    Description : to validate the user detail while user update their account
    */
    function validate_account()
    {
        if(!$_POST) redirect('account');
        check_user_authentication(true);
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $usedata = UserData($user_id, $join = array(
            'user_notification'
        ));
        $data['email'] = $usedata[0]['email'];
        $data['error_pass'] = '';
        $data['update_alert'] = $usedata[0]['update_alert'];
        $data['user_alert'] = $usedata[0]['user_alert'];
        $data['add_fund'] = $usedata[0]['add_fund'];
        $data['project_alert'] = $usedata[0]['project_alert'];
         $data['phone'] = $usedata[0]['phone'];
        $data['comment_alert'] = $usedata[0]['comment_alert'];
        $data['creator_pledge_alert'] = $usedata[0]['creator_pledge_alert'];
        $data['creator_follow_alert'] = $usedata[0]['creator_follow_alert'];
        $data['creator_newup_alert'] = $usedata[0]['creator_newup_alert'];
        $data['creator_pledge_alert'] = $usedata[0]['creator_pledge_alert'];
        $data['new_follow_alert'] = $usedata[0]['new_follow_alert'];
        $data['new_updates_alert'] = $usedata[0]['new_updates_alert'];
        $data['new_comment_alert'] = $usedata[0]['new_comment_alert'];
        $data['new_pledge_alert'] = $usedata[0]['new_pledge_alert'];
        $data['creator_comment_alert'] = $usedata[0]['creator_comment_alert'];
        $data['social_notification_alert'] = $usedata[0]['social_notification_alert'];
        $data['you_back_alert'] = $usedata[0]['you_back_alert'];
        $data['you_follow_alert'] = $usedata[0]['you_follow_alert'];
        $data['comment_reply_alert'] = $usedata[0]['comment_reply_alert'];

        $this->load->library('form_validation');
        $this->form_validation->set_rules('user_name', FIRST_NAME, 'required|trim|max_length[40]');
        $this->form_validation->set_rules('last_name', LAST_NAME, 'required|trim|max_length[40]');
       // $this->form_validation->set_rules('email', EMAIL, 'required|valid_email|trim|callback_email_check');
        $this->form_validation->set_rules('phone', PHONE, 'required|trim|numeric|max_length[15]');
        $this->form_validation->set_rules('address', ADDRESS, 'required|trim|at_least_one_letter');
        $this->form_validation->set_rules('profile_slug', 'profile Slug is required', 'required|trim');
        $this->form_validation->set_rules('zip_code', ZIPCODE, 'required');
        $this->form_validation->set_rules('user_about', ABOUT_YOURSELF, 'trim|at_least_one_letter');
        $this->form_validation->set_rules('user_interest', INTEREST, 'trim|at_least_one_letter');
        $this->form_validation->set_rules('user_skill', SKILLS, 'trim|at_least_one_letter');
        $this->form_validation->set_rules('user_occupation', OCCUPATION, 'trim|required|at_least_one_letter');
        
        
        if ($this->form_validation->run()) {

            $data['user_name'] = SecurePostData($this->input->post('user_name'));
            $data['last_name'] = SecurePostData($this->input->post('last_name'));
            $data['phone'] = SecurePostData($this->input->post('phone'));
             $data['profile_slug'] = slugify($this->input->post('profile_slug'));
            $data['address'] = SecurePostData($this->input->post('address'));
            $data['image'] = $usedata[0]['image'];
            $data['zip_code'] = SecurePostData($this->input->post('zip_code'));
            $data['user_about'] = SecurePostData($this->input->post('user_about'));
            $data['user_occupation'] = SecurePostData($this->input->post('user_occupation'));
            $data['user_interest'] = SecurePostData($this->input->post('user_interest'));
            $data['user_skill'] = SecurePostData($this->input->post('user_skill'));

            $data_user_update =
                array(
                    'user_name' => SecurePostData($this->input->post('user_name')),
                    'phone' => SecurePostData($this->input->post('phone')),
                    'last_name' => SecurePostData($this->input->post('last_name')),
                    'profile_slug' => slugify($this->input->post('profile_slug')),
                   
                    'address' => SecurePostData($this->input->post('address')),
                    'image' => $usedata[0]['image'],
                    'zip_code' => SecurePostData($this->input->post('zip_code')),

                    'user_about' => SecurePostData($this->input->post('user_about')),
                    'user_occupation' => SecurePostData($this->input->post('user_occupation')),
                    'user_interest' => SecurePostData($this->input->post('user_interest')),
                    'user_skill' => SecurePostData($this->input->post('user_skill')),
                );

            $profile_slug = slugify($this->input->post('profile_slug'));

            $result_profile_slug = $this->account_model->check_slug_exist($profile_slug);

            if ($result_profile_slug == "0") {
                $msg = 'slugexists';
                redirect('account/index/' . $msg);
            } else {
                if ($this->account_model->UpdateAccount('user_id', SecurePostData($this->session->userdata('user_id')), 'user', $data_user_update)) {
                    user_activity('update_account', $this->session->userdata('user_id'), 0, 0);
                    user_deletecache('all', $this->session->userdata('user_id'));
                    
                    $data_session = array(
                        'user_name' => $data['user_name'],
                        'last_name' => $data['last_name'],
                        'email' => $data['email'],
                    );
                    $this->session->set_userdata($data_session);
                    $msg = 'account_update_success';
                    redirect('account/index/' . $msg);
                }
            }
        } else {

            $data['error'] = '';
            $meta = meta_setting();
            $data['site_setting'] = site_setting();
            $data['msg'] = 'error_account';
            $data['user_id'] = SecurePostData($this->input->post('user_id'));
             $data['phone'] = SecurePostData($this->input->post('phone'));
            $data['user_name'] = SecurePostData($this->input->post('user_name'));
            $data['last_name'] = SecurePostData($this->input->post('last_name'));
            $data['profile_slug'] = slugify($this->input->post('profile_slug'));
            $data['email'] = $usedata[0]['email'];
            $data['address'] = SecurePostData($this->input->post('address'));
            $data['image'] = $usedata[0]['image'];
            $data['zip_code'] = SecurePostData($this->input->post('zip_code'));
            $data['user_about'] = SecurePostData($this->input->post('user_about'));
            $data['user_occupation'] = SecurePostData($this->input->post('user_occupation'));
            $data['user_interest'] = SecurePostData($this->input->post('user_interest'));
            $data['user_skill'] = SecurePostData($this->input->post('user_skill'));
            $data['id'] = $usedata[0]['id'];

            $data['facebook_url'] = $usedata[0]['facebook_url'];
            $data['twitter_url'] = $usedata[0]['twitter_url'];
            $data['linkedln_url'] = $usedata[0]['linkedln_url'];
            $data['googleplus_url'] = $usedata[0]['googleplus_url'];
            $data['bandcamp_url'] = $usedata[0]['bandcamp_url'];
            $data['youtube_url'] = $usedata[0]['youtube_url'];
            $data['myspace_url'] = $usedata[0]['myspace_url'];
            $data['user_website'] = $usedata[0]['user_website'];


            $this->template->write('meta_title', $meta['title'], TRUE);
            $this->template->write('meta_description', $meta['meta_description'], TRUE);
            $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
            $this->template->front_write_view('header', 'common/header', $data, TRUE);
            $this->template->front_write_view('main_content', 'account/index', $data, TRUE);
            $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
            $this->template->render();
        }
    }

    /*
    Function name :username_check()
    Parameter :none
    Return : none
    Use : This is a callback function which is use to check this user exist or not.
    */
    /**
     * @return bool
     */
    function email_check()
    {
        $data_check = SecurePostData($this->input->post('email'));
        $username = $this->home_model->email_validate($data_check, SecurePostData($this->input->post('user_id')));
        if ($username) {
            $this->form_validation->set_message('email_check', EXISTS_ACCOUNT_ASSOCIATE_WITHMAIL);
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /*
    Function name :notification()
    Parameter : None
    Return : none
    Use : to update user notification.
    Description : to update user notification in account page
    */
    function notification()
    {

        $user_id = check_user_authentication(true);
        $data = array();
        $data['user_id'] = $user_id;
        $data['add_fund'] = SecurePostData($this->input->post('add_fund'));
        $data['comment_alert'] = SecurePostData($this->input->post('comment_alert'));
        $data['update_alert'] = SecurePostData($this->input->post('update_alert'));
        $data['you_follow_alert'] = SecurePostData($this->input->post('you_follow_alert'));
        $data['new_pledge_alert'] = SecurePostData($this->input->post('new_pledge_alert'));
        $data['new_comment_alert'] = SecurePostData($this->input->post('new_comment_alert'));
        $data['new_follow_alert'] = SecurePostData($this->input->post('new_follow_alert'));
        $data['new_updates_alert'] = SecurePostData($this->input->post('new_updates_alert'));
        $data['social_notification_alert'] = SecurePostData($this->input->post('social_notification_alert'));
        $data['creator_pledge_alert'] = SecurePostData($this->input->post('creator_pledge_alert'));
        $data['creator_comment_alert'] = SecurePostData($this->input->post('creator_comment_alert'));
        $data['creator_follow_alert'] = SecurePostData($this->input->post('creator_follow_alert'));
        $data['creator_newup_alert'] = SecurePostData($this->input->post('creator_newup_alert'));
        $data['comment_reply_alert'] = SecurePostData($this->input->post('comment_reply_alert'));

        if ($this->account_model->UpdateAccount('id', SecurePostData($this->input->post('id')), 'user_notification', $data)) {
            $cache_file_name = 'user_detail' . $this->session->userdata('user_id');
            setting_deletecache($cache_file_name);
            $cache_file_name = 'user_detail_notification' . $this->session->userdata('user_id');
            setting_deletecache($cache_file_name);
            $msg = 'notification_success';
            redirect('account/index/' . $msg);
        }
    }

    /*
    Function name :changepassword()
    Parameter : None
    Return : none
    Use : to change password.
    Description : to update user password in account page
    */
    function changepassword()
    {
        $data = array();
        $user_id = check_user_authentication(true);
        $usedata = UserData($user_id, $join = array(
            'user_notification'
        ));
        $data['update_alert'] = $usedata[0]['update_alert'];
        $data['user_alert'] = $usedata[0]['user_alert'];
        $data['add_fund'] = $usedata[0]['add_fund'];
        $data['project_alert'] = $usedata[0]['project_alert'];
        $data['comment_alert'] = $usedata[0]['comment_alert'];
        $data['creator_pledge_alert'] = $usedata[0]['creator_pledge_alert'];
        $data['creator_follow_alert'] = $usedata[0]['creator_follow_alert'];
        $data['creator_newup_alert'] = $usedata[0]['creator_newup_alert'];
        $data['creator_pledge_alert'] = $usedata[0]['creator_pledge_alert'];
        $data['new_follow_alert'] = $usedata[0]['new_follow_alert'];
        $data['new_updates_alert'] = $usedata[0]['new_updates_alert'];
        $data['new_comment_alert'] = $usedata[0]['new_comment_alert'];
        $data['new_pledge_alert'] = $usedata[0]['new_pledge_alert'];
        $data['creator_comment_alert'] = $usedata[0]['creator_comment_alert'];
        $data['social_notification_alert'] = $usedata[0]['social_notification_alert'];
        $data['you_back_alert'] = $usedata[0]['you_back_alert'];
        $data['you_follow_alert'] = $usedata[0]['you_follow_alert'];
        $data['comment_reply_alert'] = $usedata[0]['comment_reply_alert'];
        $this->load->library('form_validation');
        $this->form_validation->set_rules('old_password', OLD_PASSWORD, 'required|trim|min_length[8]|max_length[20]');
        $this->form_validation->set_rules('password', PASSWORD, 'required|trim|valid_password');
        $this->form_validation->set_rules('confirm_password', CON_PASSWORD, 'required|trim|min_length[8]|max_length[20]|matches[password]');
        $match_pass = '';
        if ($_POST) {
            if ($this->account_model->PasswordMatches() == false) {
                $match_pass = OLD_PASSWORD_DOESNT_MATCH;
            }
            else if($this->input->post('old_password')==$this->input->post('password'))
            {
                 $match_pass = NEW_AND_OLD_PASSWORD_MATCH;
            }
        }

        if ($this->form_validation->run() == FALSE || $match_pass == '') {
            $user_data['password'] = SecurePostData(md5($this->input->post('password')));

            if ($this->account_model->UpdateAccount('user_id', SecurePostData($this->input->post('cp_user_id')), 'user', $user_data)) {
                $cache_file_name = 'user_detail' . $this->session->userdata('user_id');
                setting_deletecache($cache_file_name);
                $cache_file_name = 'user_detail_notification' . $this->session->userdata('user_id');
                setting_deletecache($cache_file_name);
                $language_id=GetUserLangCode($this->session->userdata('user_id'));
                $email_template = $this->db->query("select * from `email_template` where task='Change Password' and language_id=".$language_id);
                $email_temp = $email_template->row();
                $email_address_from = $email_temp->from_address;
                $email_address_reply = $email_temp->reply_address;
                $email_subject = $email_temp->subject;
                $email_message = $email_temp->message;
                $username = $usedata[0]['user_name'];
                $password = SecureShowData($this->input->post('password'));
                $email = $usedata[0]['email'];
                $email_to = $email;
                $email_message = str_replace('{break}', '<br/>', $email_message);
                $email_message = str_replace('{user_name}', $username, $email_message);
                $email_message = str_replace('{password}', $password, $email_message);
                $email_message = str_replace('{email}', $email, $email_message);
                $str = $email_message;
                email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);
                $msg = 'password_success';
                redirect('account/index/' . $msg);
            }
        } else {
            if (validation_errors() || $match_pass != '') {
                $data['error_pass'] = validation_errors() . $match_pass;
                $data['error'] = '';
                $this->session->set_flashdata('error_pass', $data['error_pass']);
            } else {
                $data['error_pass'] = '';
                $data['error'] = '';
            }

            redirect('account/#changepassword-tab');
            // $meta = meta_setting();
            // $data['site_setting'] = site_setting();
            // $data['msg'] = 'error_changepassword';
            // $data['user_id'] = $usedata[0]['user_id'];
            // $data['user_name'] = $usedata[0]['user_name'];
            // $data['last_name'] = $usedata[0]['last_name'];
            // $data['email'] = $usedata[0]['email'];
            // $data['address'] = $usedata[0]['address'];
            // $data['zip_code'] = $usedata[0]['zip_code'];
            // $data['user_about'] = $usedata[0]['user_about'];
            // $data['user_occupation'] = $usedata[0]['user_occupation'];
            // $data['user_interest'] = $usedata[0]['user_interest'];
            // $data['user_skill'] = $usedata[0]['user_skill'];
            // $data['id'] = $usedata[0]['id'];
            // $data['image'] = $usedata[0]['image'];


            // $data['profile_slug'] = $usedata[0]['profile_slug'];
            // $data['facebook_url'] = $usedata[0]['facebook_url'];
            // $data['twitter_url'] = $usedata[0]['twitter_url'];
            // $data['linkedln_url'] = $usedata[0]['linkedln_url'];
            // $data['googleplus_url'] = $usedata[0]['googleplus_url'];
            // $data['bandcamp_url'] = $usedata[0]['bandcamp_url'];
            // $data['youtube_url'] = $usedata[0]['youtube_url'];
            // $data['myspace_url'] = $usedata[0]['myspace_url'];
            // $data['user_website'] = $usedata[0]['user_website'];


            // $this->template->write('meta_title', $meta['title'], TRUE);
            // $this->template->write('meta_description', $meta['meta_description'], TRUE);
            // $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
            // $this->template->front_write_view('header', 'common/header', $data, TRUE);
            // $this->template->front_write_view('main_content', 'account/index', $data, TRUE);
            // $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
            // $this->template->render();
        }
    }

    /*
    Function name :password_matches()
    Parameter : None
    Return : TRUE or FALSE
    Use : to match the old password of particular client.
    Description : To match the old password in user table if it matched then returns TRUE otherwise returns FALSE.
    */
    /**
     * @return bool
     */
    function password_matches()
    {
        if ($this->account_model->PasswordMatches()) {
            return TRUE;
        } else {
            $this->form_validation->set_message('password_matches', OLD_PASSWORD_DOESNT_MATCH);
            return FALSE;
        }
    }

    /*
	Function name :validate_social()
	Parameter : None
	Return : none
	Use : to validate the user input.
	Description : to validate the user detail for social networking data while user update their account
	*/
    function validate_social()
    {

        $data = array();
        $user_id = check_user_authentication(true);
        $usedata = UserData($user_id, $join = array(
            'user_notification'
        ));
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        $this->load->library('form_validation');
        $this->form_validation->set_rules('user_website', WEBSITE_URL, 'valid_url');


        $data['update_alert'] = $usedata[0]['update_alert'];
        $data['user_alert'] = $usedata[0]['user_alert'];
        $data['add_fund'] = $usedata[0]['add_fund'];
        $data['project_alert'] = $usedata[0]['project_alert'];
        $data['comment_alert'] = $usedata[0]['comment_alert'];
        $data['creator_pledge_alert'] = $usedata[0]['creator_pledge_alert'];
        $data['creator_follow_alert'] = $usedata[0]['creator_follow_alert'];
        $data['creator_newup_alert'] = $usedata[0]['creator_newup_alert'];
        $data['creator_pledge_alert'] = $usedata[0]['creator_pledge_alert'];
        $data['new_follow_alert'] = $usedata[0]['new_follow_alert'];
        $data['new_updates_alert'] = $usedata[0]['new_updates_alert'];
        $data['new_comment_alert'] = $usedata[0]['new_comment_alert'];
        $data['new_pledge_alert'] = $usedata[0]['new_pledge_alert'];
        $data['creator_comment_alert'] = $usedata[0]['creator_comment_alert'];
        $data['social_notification_alert'] = $usedata[0]['social_notification_alert'];
        $data['you_back_alert'] = $usedata[0]['you_back_alert'];
        $data['you_follow_alert'] = $usedata[0]['you_follow_alert'];
        $data['comment_reply_alert'] = $usedata[0]['comment_reply_alert'];


        $data['facebook_url'] = $usedata[0]['facebook_url'];
        $data['twitter_url'] = $usedata[0]['twitter_url'];
        $data['user_website'] = $usedata[0]['user_website'];
        $data['linkedln_url'] = $usedata[0]['linkedln_url'];
        $data['googleplus_url'] = $usedata[0]['googleplus_url'];
        $data['bandcamp_url'] = $usedata[0]['bandcamp_url'];
        $data['youtube_url'] = $usedata[0]['youtube_url'];
        $data['myspace_url'] = $usedata[0]['myspace_url'];

        $facebook_link = SecurePostData($this->input->post('facebook_url'));
        $twitter_link = SecurePostData($this->input->post('twitter_url'));
        $linkedln_url = SecurePostData($this->input->post('linkedln_url'));
        $googleplus_url = SecurePostData($this->input->post('googleplus_url'));
        $bandcamp_url = SecurePostData($this->input->post('bandcamp_url'));
        $youtube_url = SecurePostData($this->input->post('youtube_url'));
        $myspace_url = SecurePostData($this->input->post('myspace_url'));

        $fb_error = '';
        $tw_error = '';
        $lin_error = '';
        $googleplus_error = '';
        $bandcamp_error = '';
        $youtube_error = '';
        $myspace_error = '';

        if ($facebook_link !== '') {
            if (!substr_count($facebook_link, 'facebook.com')) {
                $fb_error = INVALID_FACEBOOK_LINK . '<br/>';
            }
        }

        if ($twitter_link != '') {
            if (!substr_count($twitter_link, 'twitter.com')) {
                $tw_error = INVALID_TWITTER_LINK . '<br/>';
            }
        }

        if ($linkedln_url != '') {
            if (!substr_count($linkedln_url, 'linkedin.com')) {
                $lin_error = INVALID_LINKEDIN_LINK . '<br/>';
            }
        }

        if ($googleplus_url != '') {
            if (!substr_count($googleplus_url, 'plus.google.com')) {
                $googleplus_error = INVALID_GOOGLE_PLUS_LINK.'<br/>';
            }
        }

        if ($bandcamp_url != '') {
            if (!substr_count($bandcamp_url, 'bandcamp.com')) {
                $bandcamp_error = INVALID_BANDCAMP_LINK . '<br/>';
            }
        }

        if ($youtube_url != '') {
            if (!substr_count($youtube_url, 'youtube.com')) {
                $youtube_error = INVALID_YOUTUBE_LINK . '<br/>';
            }
        }

        if ($myspace_url != '') {
            if (!substr_count($myspace_url, 'myspace.com')) {
                $myspace_error = INVALID_MYSPACE_LINK . '<br/>';
            }
        }

        $facebook_link = SecurePostData($this->input->post('facebook_url'));
        $twitter_link = SecurePostData($this->input->post('twitter_url'));
        $linkedln_url = SecurePostData($this->input->post('linkedln_url'));
        $googleplus_url = SecurePostData($this->input->post('googleplus_url'));
        $bandcamp_url = SecurePostData($this->input->post('bandcamp_url'));
        $youtube_url = SecurePostData($this->input->post('youtube_url'));
        $myspace_url = SecurePostData($this->input->post('myspace_url'));
        $validate_form = 'no';
        if ($facebook_link != '' || $twitter_link != '' || $linkedln_url != '' || $googleplus_url != '' || $bandcamp_url != '' || $youtube_url != '' || $myspace_url != '' || SecurePostData($this->input->post('user_website')) != '') {
            $validate_form = 'yes';
        }


        if ($validate_form == 'yes') {

            if ($this->form_validation->run() == FALSE || $fb_error != '' || $tw_error != '' || $lin_error != '' || $googleplus_error != '' || $bandcamp_error != '' || $youtube_error != '' || $myspace_error != '') {


                $data["facebook_url"] = SecurePostData($this->input->post('facebook_url'));
                $data["twitter_url"] = SecurePostData($this->input->post('twitter_url'));
                $data["user_website"] = SecurePostData($this->input->post('user_website'));
                $data["linkedln_url"] = SecurePostData($this->input->post('linkedln_url'));
                $data["googleplus_url"] = SecurePostData($this->input->post('googleplus_url'));
                $data["bandcamp_url"] = SecurePostData($this->input->post('bandcamp_url'));
                $data["youtube_url"] = SecurePostData($this->input->post('youtube_url'));
                $data["myspace_url"] = SecurePostData($this->input->post('myspace_url'));
                $data['user_id'] = SecurePostData($this->input->post('user_id'));
                $data["error"] = validation_errors() . $fb_error . $tw_error . $lin_error . $googleplus_error . $bandcamp_error . $youtube_error . $myspace_error;
                $data["success"] = '';


                $data['msg'] = 'error_changepassword';
                $data['user_id'] = $usedata[0]['user_id'];
                $data['user_name'] = $usedata[0]['user_name'];
                $data['last_name'] = $usedata[0]['last_name'];
                $data['email'] = $usedata[0]['email'];
                $data['address'] = $usedata[0]['address'];
                if (is_file('upload/user/user_medium_image/' . $usedata[0]['image'])) $data['image'] = $usedata[0]['image'];
                else $data['image'] = '';
                if (isset($usedata[0]['zip_code']) and $usedata[0]['zip_code'] != 0) $data['zip_code'] = $usedata[0]['zip_code'];
                else $data['zip_code'] = '';
                $data['user_about'] = $usedata[0]['user_about'];
                $data['user_occupation'] = $usedata[0]['user_occupation'];
                $data['user_interest'] = $usedata[0]['user_interest'];
                $data['user_skill'] = $usedata[0]['user_skill'];
                $data['id'] = $usedata[0]['id'];
                $data['profile_slug'] = $usedata[0]['profile_slug'];


                $data['error_pass'] = '';

                $this->template->write('meta_title', $meta['title'], TRUE);
                $this->template->write('meta_description', $meta['meta_description'], TRUE);
                $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
                $this->template->front_write_view('header', 'common/header', $data, TRUE);
                $this->template->front_write_view('main_content', 'account/index', $data, TRUE);
                $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
                $this->template->render();

            } else {

                $data['error'] = '';
                $data_update = array(
                    'user_website' => SecurePostData($this->input->post('user_website')),
                    'facebook_url' => SecurePostData($this->input->post('facebook_url')),
                    'twitter_url' => SecurePostData($this->input->post('twitter_url')),
                    'linkedln_url' => SecurePostData($this->input->post('linkedln_url')),
                    'googleplus_url' => SecurePostData($this->input->post('googleplus_url')),
                    'bandcamp_url' => SecurePostData($this->input->post('bandcamp_url')),
                    'youtube_url' => SecurePostData($this->input->post('youtube_url')),
                    'myspace_url' => SecurePostData($this->input->post('myspace_url')),
                );

                $this->account_model->UpdateAccount('user_id', SecurePostData($this->input->post('user_id')), 'user', $data_update);
                $cache_file_name = 'user_detail' . $this->session->userdata('user_id');

                setting_deletecache($cache_file_name);

                $cache_file_name = 'user_detail_notification' . $this->session->userdata('user_id');

                setting_deletecache($cache_file_name);

                $msg = 'social_success';
                redirect('account/index/' . $msg);


            }

        } else {
            redirect('account/index');
        }
    }
}

/* end of file */
